/*   FILE: bistree.h --
 * AUTHOR: W. Michael Petullo <new@flyn.org>
 *   DATE: 10 Febuary 2000
 *   NOTE: From _Mastering Algorithms with C_ by Kyle Loudon.
 */

#ifndef _BISTREE_H
#define _BISTREE_H

#include <bintree.h>

#ifdef __cplusplus
extern "C" {
#endif
/* Define balance factors for AVL trees. */
#define            AVL_LFT_HEAVY         1
#define            AVL_BALANCED          0
#define            AVL_RGT_HEAVY        -1
/* =========================== avl_node_t ================================== */ typedef struct avl_node_t {
	void *data;
	int hidden;
	int factor;
    } avl_node_t;

/* ============================ bistree_t ================================== */
    typedef bintree_t bistree_t;

/* ============================ bistree_init () ============================ */
    void bistree_init(bistree_t * tree,
		      int (*compare) (const void *key1, const void *key2),
		      void (*destroy) (void *data));

/* ============================ bistree_destroy () ========================= */
    void bistree_destroy(bistree_t * tree);

/* ============================ bistree_insert () ========================== */
    int bistree_insert(bistree_t * tree, const void *data);

/* ============================ bistree_remove () ========================== */
    int bistree_remove(bistree_t * tree, const void *data);

/* ============================ bistree_lookup () ========================== */
    void *bistree_lookup(const bistree_t * tree, void *data);

#define bistree_size(tree) ((tree)->size)

#ifdef __cplusplus
}
#endif
#endif				/* _BISTREE_H */
