#   FILE: new.spec.new.in --
# AUTHOR: W. Michael Petullo <new@flyn.org>
#   DATE: 05 May 1999

%define rel	1
%define prefix	/usr

Summary: A simple template system.
Name: new
Requires: zlib
Version: 1.2.0
Release: %rel
Copyright: GPL
Group: Development/Tools
Source: %name-%{PACKAGE_VERSION}.tar.gz
BuildRoot: /home/mike/development/live
Packager: W. Michael Petullo <new@flyn.org>
Vendor: Flyn Computing
Distribution: Flyn Linux
URL: http://www.flyn.org

%description
   New is a template system, especially useful in conjunction with a
   simple text editor such as vi. The user maintains templates which may
   contain format strings. At run time, new replaces the format strings
   in a template with appropriate values to create a new file.
   
   For example, given the following template:
//   FILE: %(FILE)
// AUTHOR: %(FULLNAME)
//   DATE: %(DATE)
   
// Copyright (c) 1999 %(FULLNAME) %(EMAIL)
// All rights reserved.

   new will create:
//   FILE: foo.cpp
// AUTHOR: W. Michael Petullo
//   DATE: 11 September 1999
   
// Copyright (c) 1999 W. Michael Petullo new@flyn.org
// All rights reserved.

   on my computer.
   
   The program understands plaintext or gzip template files.
   
   Building new also creates a shared library, libtemplate, which allows
   the programmer access to new's functionality.


%changelog

%prep
%setup

%build
# FIXME CFLAGS="-g $RPM_OPT_FLAGS" ./configure --prefix=/usr
./configure --prefix=/usr --enable-zlib
make

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/usr/bin
mkdir -p $RPM_BUILD_ROOT/usr/man/man1
mkdir -p $RPM_BUILD_ROOT/usr/share/new/templates
for i in templates/*; do
	mkdir $RPM_BUILD_ROOT/usr/share/new/$i
done
gzip -9 AUTHORS COPYING ChangeLog INSTALL NEWS README

# NOTE: The following trick only works with a modified header-vars.am.
# Change the line ``DESTDIR ='' in this file to ``DESTDIR =
# ${ENV_DESTDIR}.''
export ENV_DESTDIR=$RPM_BUILD_ROOT
make install

%clean
#FIXMErm -rf $RPM_BUILD_ROOT

%pre

%post
ldconfig

%preun

%postun

%files
%defattr(-, root, root)
%{prefix}/bin/new
%{prefix}/bin/new_proj
%{prefix}/lib/libfmt_ptrn.so
%{prefix}/lib/libfmt_ptrn.so.1
%{prefix}/lib/libfmt_ptrn.so.%{PACKAGE_VERSION}
%{prefix}/include/fmt_ptrn.h
%{prefix}/lib/libtemplate.so
%{prefix}/lib/libtemplate.so.1
%{prefix}/lib/libtemplate.so.%{PACKAGE_VERSION}
%{prefix}/include/template.h
#%{prefix}/share/new/templates/*/*
%{prefix}/share/new
%{prefix}/man/man?/*

%doc AUTHORS.gz COPYING.gz ChangeLog.gz INSTALL.gz NEWS.gz README.gz

%config
