/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FontDialog
extends Dialog {
    FontData fontData;
    RGB rgb;

    public FontDialog(Shell parent) {
        this(parent, 32768);
    }

    public FontDialog(Shell parent, int style) {
        super(parent, style);
        this.checkSubclass();
    }

    public FontData getFontData() {
        return this.fontData;
    }

    public FontData[] getFontList() {
        if (this.fontData == null) {
            return null;
        }
        FontData[] result = new FontData[]{this.fontData};
        return result;
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public FontData open() {
        int response;
        boolean success;
        byte[] buffer;
        int length;
        int fontName;
        byte[] titleBytes = Converter.wcsToMbcs(null, this.title, true);
        int handle = OS.gtk_font_selection_dialog_new((byte[])titleBytes);
        if (this.parent != null) {
            OS.gtk_window_set_transient_for((int)handle, (int)this.parent.topHandle());
        }
        if (this.fontData != null) {
            Display display = this.parent != null ? this.parent.display : Display.getCurrent();
            Font font = new Font((Device)display, this.fontData);
            fontName = OS.pango_font_description_to_string((int)font.handle);
            length = OS.strlen((int)fontName);
            buffer = new byte[length + 1];
            OS.memmove((byte[])buffer, (int)fontName, (int)length);
            font.dispose();
            OS.g_free((int)fontName);
            OS.gtk_font_selection_dialog_set_font_name((int)handle, (byte[])buffer);
        }
        boolean bl = success = (response = OS.gtk_dialog_run((int)handle)) == -5;
        if (success) {
            fontName = OS.gtk_font_selection_dialog_get_font_name((int)handle);
            length = OS.strlen((int)fontName);
            buffer = new byte[length + 1];
            OS.memmove((byte[])buffer, (int)fontName, (int)length);
            int fontDesc = OS.pango_font_description_from_string((byte[])buffer);
            Display display = this.parent != null ? this.parent.display : Display.getCurrent();
            Font font = Font.gtk_new(display, fontDesc);
            this.fontData = font.getFontData()[0];
            OS.pango_font_description_free((int)fontDesc);
        }
        OS.gtk_widget_destroy((int)handle);
        if (!success) {
            return null;
        }
        return this.fontData;
    }

    public void setFontData(FontData fontData) {
        this.fontData = fontData;
    }

    public void setFontList(FontData[] fontData) {
        this.fontData = fontData != null && fontData.length > 0 ? fontData[0] : null;
    }

    public void setRGB(RGB rgb) {
        this.rgb = rgb;
    }
}

