/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.HashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.ContainerPlaceholder;
import org.eclipse.ui.internal.ILayoutContainer;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PartPlaceholder;
import org.eclipse.ui.internal.PartSashContainer;
import org.eclipse.ui.internal.PartTabFolder;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class RootLayoutContainer
extends PartSashContainer {
    public RootLayoutContainer(WorkbenchPage page) {
        super("root layout container", page);
    }

    protected void childAdded(LayoutPart child) {
    }

    public RootLayoutContainer getRootContainer() {
        return this;
    }

    protected void childRemoved(LayoutPart child) {
    }

    protected Composite createParent(Composite parentWidget) {
        return parentWidget;
    }

    protected void disposeParent() {
    }

    public Control getControl() {
        return this.parent;
    }

    public IStatus restoreState(IMemento memento) {
        MultiStatus result = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.getString("RootLayoutContainer.problemsRestoringPerspective"), null);
        IMemento[] children = memento.getChildren("info");
        HashMap<String, PartPlaceholder> mapIDtoPart = new HashMap<String, PartPlaceholder>(children.length);
        int i = 0;
        while (i < children.length) {
            IMemento childMem = children[i];
            String partID = childMem.getString("part");
            String relativeID = childMem.getString("relative");
            int relationship = 0;
            float ratio = 0.0f;
            if (relativeID != null) {
                relationship = childMem.getInteger("relationship");
                ratio = childMem.getFloat("ratio").floatValue();
            }
            String strFolder = childMem.getString("folder");
            PartPlaceholder part = null;
            if (strFolder == null) {
                part = new PartPlaceholder(partID);
            } else {
                PartTabFolder folder = new PartTabFolder(this.page);
                folder.setID(partID);
                result.add(folder.restoreState(childMem.getChild("folder")));
                ContainerPlaceholder placeholder = new ContainerPlaceholder(partID);
                placeholder.setRealContainer(folder);
                part = placeholder;
            }
            part.setContainer(this);
            if (relativeID == null) {
                this.add(part);
            } else {
                LayoutPart refPart = (LayoutPart)mapIDtoPart.get(relativeID);
                if (refPart != null) {
                    this.add(part, relationship, ratio, refPart);
                } else {
                    WorkbenchPlugin.log("Unable to find part for ID: " + relativeID);
                }
            }
            mapIDtoPart.put(partID, part);
            ++i;
        }
        return result;
    }

    public IStatus saveState(IMemento memento) {
        PartSashContainer.RelationshipInfo[] relationships = this.computeRelation();
        MultiStatus result = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.getString("RootLayoutContainer.problemsSavingPerspective"), null);
        int i = 0;
        while (i < relationships.length) {
            LayoutPart part;
            PartSashContainer.RelationshipInfo info = relationships[i];
            IMemento childMem = memento.createChild("info");
            childMem.putString("part", info.part.getID());
            if (info.relative != null) {
                childMem.putString("relative", info.relative.getID());
                childMem.putInteger("relationship", info.relationship);
                childMem.putFloat("ratio", info.ratio);
            }
            PartTabFolder folder = null;
            if (info.part instanceof PartTabFolder) {
                folder = (PartTabFolder)info.part;
            } else if (info.part instanceof ContainerPlaceholder && (part = ((ContainerPlaceholder)info.part).getRealContainer()) instanceof PartTabFolder) {
                folder = (PartTabFolder)part;
            }
            if (folder != null) {
                childMem.putString("folder", "true");
                IMemento folderMem = childMem.createChild("folder");
                result.add(folder.saveState(folderMem));
            }
            ++i;
        }
        return result;
    }

    public boolean allowsAutoFocus() {
        return true;
    }

    protected void dropObject(LayoutPart sourcePart, LayoutPart targetPart, int side) {
        super.dropObject(sourcePart, targetPart, side);
    }

    protected float getDockingRatio(LayoutPart dragged, LayoutPart target) {
        if (this.isStackType(target)) {
            return super.getDockingRatio(dragged, target);
        }
        return 0.25f;
    }

    public boolean isStackType(LayoutPart toTest) {
        if (!(toTest instanceof PartTabFolder)) {
            return false;
        }
        PartTabFolder folder = (PartTabFolder)toTest;
        return folder.getParent() == this.getParent();
    }

    public boolean isPaneType(LayoutPart toTest) {
        return toTest instanceof ViewPane;
    }

    protected LayoutPart createStack(LayoutPart sourcePart) {
        PartTabFolder result = new PartTabFolder(this.page);
        result.add(sourcePart);
        return result;
    }

    protected void setVisiblePart(ILayoutContainer container, LayoutPart visiblePart) {
        PartTabFolder tabFolder = (PartTabFolder)container;
        tabFolder.setSelection(visiblePart);
    }

    protected LayoutPart getVisiblePart(ILayoutContainer container) {
        return ((PartTabFolder)container).getVisiblePart();
    }

    protected void derefPart(LayoutPart sourcePart) {
        this.page.getActivePerspective().getPresentation().derefPart(sourcePart);
    }

    protected int getVisibleChildrenCount(ILayoutContainer container) {
        return ((PartTabFolder)container).getItemCount();
    }
}

