/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.internal.DefaultStackPresentationSite;
import org.eclipse.ui.internal.DragCursors;
import org.eclipse.ui.internal.EditorArea;
import org.eclipse.ui.internal.EditorPane;
import org.eclipse.ui.internal.EditorPresentation;
import org.eclipse.ui.internal.ILayoutContainer;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.LayoutTree;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartPlaceholder;
import org.eclipse.ui.internal.PartSashContainer;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.dnd.DragUtil;
import org.eclipse.ui.internal.dnd.IDragOverListener;
import org.eclipse.ui.internal.dnd.IDropTarget;
import org.eclipse.ui.internal.presentations.SystemMenuClose;
import org.eclipse.ui.internal.presentations.SystemMenuCloseAllEditors;
import org.eclipse.ui.internal.presentations.SystemMenuCloseOtherEditors;
import org.eclipse.ui.internal.presentations.SystemMenuMaximize;
import org.eclipse.ui.internal.presentations.SystemMenuMoveEditor;
import org.eclipse.ui.internal.presentations.SystemMenuPinEditor;
import org.eclipse.ui.internal.presentations.SystemMenuRestore;
import org.eclipse.ui.internal.presentations.SystemMenuSize;
import org.eclipse.ui.presentations.AbstractPresentationFactory;
import org.eclipse.ui.presentations.IPresentablePart;
import org.eclipse.ui.presentations.IStackPresentationSite;
import org.eclipse.ui.presentations.StackDropResult;
import org.eclipse.ui.presentations.StackPresentation;

public class EditorWorkbook
extends LayoutPart
implements ILayoutContainer {
    private EditorArea editorArea;
    private WorkbenchPage page;
    private DefaultStackPresentationSite presentationSite = new DefaultStackPresentationSite(){

        public void selectPart(IPresentablePart toSelect) {
            EditorWorkbook.this.presentationSelectionChanged(toSelect);
        }

        public void setPresentation(StackPresentation newPresentation) {
            super.setPresentation(newPresentation);
            EditorWorkbook.this.updateSystemMenu();
        }

        public void setState(int newState) {
            EditorWorkbook.this.setState(newState);
        }

        public void dragStart(IPresentablePart beingDragged, Point initialLocation, boolean keyboard) {
            LayoutPart pane = EditorWorkbook.this.getPaneFor(beingDragged);
            if (pane != null) {
                DragUtil.performDrag(pane, Geometry.toDisplay((Control)EditorWorkbook.this.getParent(), (Rectangle)this.getPresentation().getControl().getBounds()), initialLocation, !keyboard);
            }
        }

        public void dragStart(Point initialLocation, boolean keyboard) {
            DragUtil.performDrag(EditorWorkbook.this, Geometry.toDisplay((Control)EditorWorkbook.this.getParent(), (Rectangle)this.getPresentation().getControl().getBounds()), initialLocation, !keyboard);
        }

        public void close(IPresentablePart part) {
            EditorWorkbook.this.close(part);
        }

        public boolean isCloseable(IPresentablePart part) {
            return true;
        }

        public boolean isMoveable(IPresentablePart part) {
            return true;
        }
    };
    private LayoutPart current;
    private LayoutPart inactiveCurrent;
    private boolean active = false;
    private int flags;
    private List children = new ArrayList(3);
    private IContributionItem systemMenuContribution;

    public static EditorWorkbook newEditorWorkbook(EditorArea editorArea, WorkbenchPage page) {
        return new EditorWorkbook(editorArea, page);
    }

    public EditorWorkbook(EditorArea editorArea, WorkbenchPage page) {
        this(editorArea, page, 1024);
    }

    private void presentationSelectionChanged(IPresentablePart newSelection) {
        this.setSelection(this.getLayoutPart(newSelection));
        if (newSelection != null) {
            newSelection.setFocus();
        }
    }

    protected void close(IPresentablePart part) {
        if (!this.presentationSite.isCloseable(part)) {
            return;
        }
        LayoutPart layoutPart = this.getPaneFor(part);
        if (layoutPart != null && layoutPart instanceof EditorPane) {
            EditorPane editorPane = (EditorPane)layoutPart;
            editorPane.doHide();
        }
    }

    private LayoutPart getPaneFor(IPresentablePart part) {
        Iterator iter = this.children.iterator();
        while (iter.hasNext()) {
            LayoutPart next = (LayoutPart)iter.next();
            if (next.getPresentablePart() != part) continue;
            return next;
        }
        return null;
    }

    public EditorWorkbook(EditorArea editorArea, WorkbenchPage page, int flags) {
        super("editor workbook");
        this.editorArea = editorArea;
        this.setID(this.toString());
        this.page = page;
        this.flags = flags;
    }

    private void add(LayoutPart newChild, int idx) {
        IPresentablePart position = this.getPresentablePartAtIndex(idx);
        LayoutPart targetPart = this.getPaneFor(position);
        int childIdx = this.children.indexOf(targetPart);
        if (childIdx == -1) {
            this.children.add(newChild);
        } else {
            this.children.add(idx, newChild);
        }
        if (this.active) {
            this.showPart(newChild, position);
        }
        ((EditorPane)newChild).setWorkbook(this);
    }

    public void add(LayoutPart child) {
        this.children.add(child);
        if (this.active) {
            this.showPart(child, null);
        }
        ((EditorPane)child).setWorkbook(this);
    }

    public boolean allowsBorder() {
        return false;
    }

    private LayoutPart getLayoutPart(IPresentablePart toFind) {
        Iterator iter = this.children.iterator();
        while (iter.hasNext()) {
            LayoutPart next = (LayoutPart)iter.next();
            if (next.getPresentablePart() != toFind) continue;
            return next;
        }
        return null;
    }

    private IPresentablePart getPresentablePartAtIndex(int idx) {
        List presentableParts = this.getPresentableParts();
        if (idx >= 0 && idx < presentableParts.size()) {
            return (IPresentablePart)presentableParts.get(idx);
        }
        return null;
    }

    private List getPresentableParts() {
        ArrayList<IPresentablePart> result = new ArrayList<IPresentablePart>(this.children.size());
        Iterator iter = this.children.iterator();
        while (iter.hasNext()) {
            LayoutPart part = (LayoutPart)iter.next();
            IPresentablePart presentablePart = part.getPresentablePart();
            if (presentablePart == null) continue;
            result.add(presentablePart);
        }
        return result;
    }

    public void createControl(Composite parent) {
        if (this.presentationSite.getPresentation() != null) {
            return;
        }
        AbstractPresentationFactory factory = ((WorkbenchWindow)this.page.getWorkbenchWindow()).getWindowConfigurer().getPresentationFactory();
        this.presentationSite.setPresentation(factory.createPresentation(parent, this.presentationSite, 0, this.flags, this.page.getPerspective().getId(), this.getID()));
        this.active = true;
        Iterator iter = this.children.iterator();
        while (iter.hasNext()) {
            LayoutPart part = (LayoutPart)iter.next();
            this.showPart(part, null);
        }
        if (this.getItemCount() > 0) {
            int newPage = 0;
            if (this.current != null) {
                newPage = this.indexOf(this.current);
            }
            this.setSelection(newPage);
        }
        Control ctrl = this.getPresentation().getControl();
        DragUtil.addDragTarget(ctrl, new IDragOverListener(){

            public IDropTarget drag(Control currentControl, Object draggedObject, Point position, Rectangle dragRectangle) {
                if (!(draggedObject instanceof EditorPane)) {
                    return null;
                }
                EditorPane pane = (EditorPane)draggedObject;
                if (pane.getWorkbenchWindow() != EditorWorkbook.this.getWorkbenchWindow()) {
                    return null;
                }
                StackDropResult dropResult = EditorWorkbook.this.getPresentation().dragOver(currentControl, position);
                if (dropResult == null) {
                    return null;
                }
                IPresentablePart draggedControl = EditorWorkbook.this.getPresentablePartAtIndex(dropResult.getDropIndex());
                if (draggedControl == pane.getPresentablePart()) {
                    return null;
                }
                return new IDropTarget(this, pane, dropResult){
                    final /* synthetic */ 2 this$1;
                    private final /* synthetic */ EditorPane val$pane;
                    private final /* synthetic */ StackDropResult val$dropResult;
                    {
                        this.this$1 = var1_1;
                        this.val$pane = editorPane;
                        this.val$dropResult = stackDropResult;
                    }

                    public void drop() {
                        if (this.val$pane.getContainer() != 2.access$0(this.this$1)) {
                            EditorPresentation.derefPart(this.val$pane);
                            this.val$pane.reparent(2.access$0(this.this$1).getParent());
                        } else {
                            2.access$0(this.this$1).remove(this.val$pane);
                        }
                        EditorWorkbook.access$6(2.access$0(this.this$1), this.val$pane, this.val$dropResult.getDropIndex());
                        EditorWorkbook.access$7(2.access$0(this.this$1), this.val$pane);
                        this.val$pane.setFocus();
                    }

                    public Cursor getCursor() {
                        return DragCursors.getCursor(5);
                    }

                    public Rectangle getSnapRectangle() {
                        return this.val$dropResult.getSnapRectangle();
                    }
                };
            }

            static /* synthetic */ EditorWorkbook access$0(2 var0) {
                return var0.EditorWorkbook.this;
            }
        });
        ctrl.setData((Object)this);
    }

    private void showPart(LayoutPart part, IPresentablePart position) {
        part.setContainer(this);
        IPresentablePart presentablePart = part.getPresentablePart();
        if (presentablePart == null) {
            return;
        }
        part.createControl(this.getParent());
        part.setContainer(this);
        part.moveAbove(this.getPresentation().getControl());
        this.presentationSite.getPresentation().addPart(presentablePart, position);
        if (this.current == null) {
            this.setSelection(part);
        }
    }

    public void dispose() {
        if (!this.active) {
            return;
        }
        this.presentationSite.getPresentation();
        this.presentationSite.dispose();
        Iterator iter = this.children.iterator();
        while (iter.hasNext()) {
            LayoutPart next = (LayoutPart)iter.next();
            next.setContainer(null);
        }
        this.active = false;
        this.updateSystemMenu();
    }

    private StackPresentation getPresentation() {
        return this.presentationSite.getPresentation();
    }

    public void openTracker(LayoutPart part) {
        DragUtil.performDrag(part, DragUtil.getDisplayBounds(part.getControl()));
    }

    public Rectangle getBounds() {
        if (this.getPresentation() == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        return this.getPresentation().getControl().getBounds();
    }

    public int getMinimumHeight() {
        if (this.getPresentation() == null) {
            return 0;
        }
        return this.getPresentation().computeMinimumSize().y;
    }

    public LayoutPart[] getChildren() {
        return this.children.toArray(new LayoutPart[this.children.size()]);
    }

    public Control getControl() {
        StackPresentation presentation = this.getPresentation();
        if (presentation == null) {
            return null;
        }
        return presentation.getControl();
    }

    public int getItemCount() {
        if (this.active) {
            return this.getPresentableParts().size();
        }
        return this.children.size();
    }

    public Composite getParent() {
        return this.getControl().getParent();
    }

    public int getSelection() {
        if (!this.active) {
            return 0;
        }
        return this.indexOf(this.current);
    }

    public LayoutPart getVisiblePart() {
        if (this.current == null) {
            return this.inactiveCurrent;
        }
        return this.current;
    }

    public int indexOf(LayoutPart item) {
        return this.indexOf(item.getPresentablePart());
    }

    private int indexOf(IPresentablePart part) {
        int result = this.getPresentableParts().indexOf(part);
        if (result < 0) {
            result = 0;
        }
        return result;
    }

    public void remove(LayoutPart child) {
        StackPresentation presentation;
        IPresentablePart presentablePart = child.getPresentablePart();
        if (presentablePart != null && (presentation = this.presentationSite.getPresentation()) != null) {
            presentation.removePart(presentablePart);
        }
        this.children.remove(child);
        if (this.active) {
            child.setContainer(null);
        }
        this.updateContainerVisibleTab();
    }

    public void reparent(Composite newParent) {
        if (!newParent.isReparentable()) {
            return;
        }
        Control control = this.getControl();
        if (control == null || control.getParent() == newParent) {
            return;
        }
        super.reparent(newParent);
        Iterator iter = this.children.iterator();
        while (iter.hasNext()) {
            LayoutPart next = (LayoutPart)iter.next();
            next.reparent(newParent);
        }
    }

    public void replace(LayoutPart oldChild, LayoutPart newChild) {
        IPresentablePart oldPart = oldChild.getPresentablePart();
        newChild.getPresentablePart();
        int idx = this.children.indexOf(oldChild);
        this.children.add(idx, newChild);
        if (this.active) {
            this.showPart(newChild, oldPart);
        }
        if (oldChild == this.inactiveCurrent) {
            this.setSelection(newChild);
            this.inactiveCurrent = null;
        }
        this.remove(oldChild);
    }

    public IStatus restoreState(IMemento memento) {
        Integer expanded;
        String activeTabID = memento.getString("activePageID");
        IMemento[] children = memento.getChildren("page");
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                IMemento childMem = children[i];
                String partID = childMem.getString("content");
                childMem.getString("label");
                IEditorDescriptor descriptor = WorkbenchPlugin.getDefault().getEditorRegistry().findEditor(partID);
                if (descriptor != null) {
                    descriptor.getLabel();
                }
                PartPlaceholder part = new PartPlaceholder(partID);
                this.add(part);
                if (partID.equals(activeTabID)) {
                    this.inactiveCurrent = part;
                }
                ++i;
            }
        }
        this.setState((expanded = memento.getInteger("expanded")) == null || expanded != 0 ? 2 : 0);
        return new Status(0, "org.eclipse.ui", 0, "", null);
    }

    public IStatus saveState(IMemento memento) {
        if (this.current != null) {
            memento.putString("activePageID", this.current.getID());
        }
        Iterator iter = this.children.iterator();
        while (iter.hasNext()) {
            LayoutPart next = (LayoutPart)iter.next();
            IMemento childMem = memento.createChild("page");
            IPresentablePart part = next.getPresentablePart();
            String tabText = "LabelNotFound";
            if (part != null) {
                tabText = part.getName();
            }
            childMem.putString("label", tabText);
            childMem.putString("content", next.getID());
        }
        memento.putInteger("expanded", this.presentationSite.getState() == 0 ? 0 : 2);
        return new Status(0, "org.eclipse.ui", 0, "", null);
    }

    private void hidePart(LayoutPart part) {
        IPresentablePart presentablePart = part.getPresentablePart();
        if (presentablePart == null) {
            return;
        }
        this.getPresentation().removePart(presentablePart);
        if (this.active) {
            part.setContainer(null);
        }
    }

    public void setBounds(Rectangle r) {
        if (this.getPresentation() != null) {
            this.getPresentation().setBounds(r);
        }
    }

    public void setSelection(int index) {
        if (!this.active) {
            return;
        }
        this.setSelection(this.getLayoutPart((IPresentablePart)this.getPresentableParts().get(index)));
    }

    private void setSelection(LayoutPart part) {
        this.current = part;
        this.updateSystemMenu();
        if (part != null) {
            IPresentablePart presentablePart = part.getPresentablePart();
            StackPresentation presentation = this.getPresentation();
            if (presentablePart != null && presentation != null) {
                presentation.selectPart(presentablePart);
            }
        }
    }

    public boolean isDragAllowed(Point point) {
        return true;
    }

    public void setActive(boolean activeState) {
        if (activeState) {
            if (this.presentationSite.getState() == 0) {
                this.setState(2);
            }
            if (this.page.isZoomed()) {
                this.presentationSite.setPresentationState(1);
            }
        }
        this.getPresentation().setActive(activeState);
    }

    public void showBusy(PartPane partPane, boolean busy) {
    }

    public void setContainer(ILayoutContainer container) {
        super.setContainer(container);
        if (this.presentationSite.getState() == 1 && !this.page.isZoomed()) {
            this.setState(2);
        }
    }

    private void setState(int newState) {
        if (newState == this.presentationSite.getState()) {
            return;
        }
        int oldState = this.presentationSite.getState();
        if (this.current != null) {
            if (newState == 1) {
                ((PartPane)this.current).doZoom();
            } else {
                this.presentationSite.setPresentationState(newState);
                WorkbenchPage page = ((PartPane)this.current).getPage();
                if (page.isZoomed()) {
                    page.zoomOut();
                }
                this.updateControlBounds();
                if (oldState == 0) {
                    this.forceLayout();
                }
            }
        }
        if (this.presentationSite.getState() == 0) {
            this.page.refreshActiveView();
        }
    }

    public void setZoomed(boolean isZoomed) {
        super.setZoomed(isZoomed);
        if (isZoomed) {
            this.presentationSite.setPresentationState(1);
        } else if (this.presentationSite.getState() == 1) {
            this.presentationSite.setPresentationState(2);
        }
    }

    private void updateControlBounds() {
        StackPresentation presentation = this.getPresentation();
        if (presentation != null) {
            Rectangle bounds = presentation.getControl().getBounds();
            int minimumHeight = this.getMinimumHeight();
            if (this.presentationSite.getState() == 0 && bounds.height != minimumHeight) {
                bounds.width = this.getMinimumWidth();
                bounds.height = minimumHeight;
                this.getPresentation().setBounds(bounds);
                this.forceLayout();
            }
        }
    }

    private void forceLayout() {
        PartSashContainer cont = (PartSashContainer)this.getContainer();
        if (cont != null) {
            LayoutTree tree = cont.getLayoutTree();
            tree.setBounds(this.getParent().getClientArea());
        }
    }

    public void findSashes(LayoutPart part, PartPane.Sashes sashes) {
        ILayoutContainer container = this.getContainer();
        if (container != null) {
            container.findSashes(this, sashes);
        }
    }

    private void updateContainerVisibleTab() {
        LayoutPart[] parts = this.getChildren();
        if (parts.length < 1) {
            this.setSelection(null);
            return;
        }
        PartPane selPart = null;
        int topIndex = 0;
        IWorkbenchPartReference[] sortedPartsArray = this.page.getSortedParts();
        List<IWorkbenchPartReference> sortedParts = Arrays.asList(sortedPartsArray);
        int i = 0;
        while (i < parts.length) {
            IWorkbenchPartReference part;
            int index;
            if (parts[i] instanceof PartPane && (index = sortedParts.indexOf(part = ((PartPane)parts[i]).getPartReference())) >= topIndex) {
                topIndex = index;
                selPart = (PartPane)parts[i];
            }
            ++i;
        }
        this.setSelection(selPart);
    }

    public boolean resizesVertically() {
        return this.presentationSite.getState() != 0;
    }

    public boolean allowsAutoFocus() {
        if (this.presentationSite.getState() == 0) {
            return false;
        }
        ILayoutContainer parent = this.getContainer();
        return parent == null || parent.allowsAutoFocus();
    }

    private void updateSystemMenu() {
        StackPresentation presentation = this.getPresentation();
        if (presentation == null) {
            if (this.systemMenuContribution != null) {
                this.systemMenuContribution.dispose();
                this.systemMenuContribution = null;
            }
        } else {
            IMenuManager systemMenuManager = presentation.getSystemMenuManager();
            if (this.systemMenuContribution != null) {
                systemMenuManager.remove(this.systemMenuContribution);
                this.systemMenuContribution.dispose();
                this.systemMenuContribution = null;
            }
            if (this.current != null && this.current instanceof EditorPane) {
                this.systemMenuContribution = new SystemMenuContribution(this.presentationSite, (EditorPane)this.current);
                systemMenuManager.add(this.systemMenuContribution);
            }
        }
    }

    public void showSystemMenu() {
        this.getPresentation().showSystemMenu();
    }

    public Control[] getTabList() {
        LayoutPart part = this.getVisiblePart();
        if (part != null) {
            IPresentablePart presentablePart = part.getPresentablePart();
            StackPresentation presentation = this.getPresentation();
            if (presentablePart != null && presentation != null) {
                return presentation.getTabList(presentablePart);
            }
        }
        return new Control[0];
    }

    public void removeAll() {
        int i = 0;
        while (i < this.children.size()) {
            this.remove((EditorPane)this.children.get(i));
            ++i;
        }
    }

    public boolean isActiveWorkbook() {
        EditorArea area = this.getEditorArea();
        if (area != null) {
            return area.isActiveWorkbook(this);
        }
        return false;
    }

    public void becomeActiveWorkbook(boolean hasFocus) {
        EditorArea area = this.getEditorArea();
        if (area != null) {
            area.setActiveWorkbook(this, hasFocus);
        }
    }

    public void tabFocusHide() {
        if (this.getControl() == null) {
            return;
        }
        this.setActive(false);
    }

    public void tabFocusShow(boolean hasFocus) {
        if (this.getControl() == null) {
            return;
        }
        this.setActive(hasFocus);
    }

    public EditorPane[] getEditors() {
        return this.children.toArray(new EditorPane[this.children.size()]);
    }

    public EditorArea getEditorArea() {
        return this.editorArea;
    }

    public EditorPane getVisibleEditor() {
        return (EditorPane)this.getVisiblePart();
    }

    public void setVisibleEditor(EditorPane editorPane) {
        this.setSelection(editorPane);
    }

    public void showVisibleEditor() {
    }

    static /* synthetic */ void access$6(EditorWorkbook editorWorkbook, LayoutPart layoutPart, int n) {
        editorWorkbook.add(layoutPart, n);
    }

    static /* synthetic */ void access$7(EditorWorkbook editorWorkbook, LayoutPart layoutPart) {
        editorWorkbook.setSelection(layoutPart);
    }

    private class SystemMenuContribution
    extends ContributionItem {
        private SystemMenuClose systemMenuClose;
        private SystemMenuCloseAllEditors systemMenuCloseAllEditors;
        private SystemMenuCloseOtherEditors systemMenuCloseOtherEditors;
        private SystemMenuMaximize systemMenuMaximize;
        private SystemMenuMoveEditor systemMenuMoveEditor;
        private SystemMenuPinEditor systemMenuPinEditor;
        private SystemMenuRestore systemMenuRestore;
        private SystemMenuSize systemMenuSize;

        SystemMenuContribution(IStackPresentationSite stackPresentationSite, EditorPane editorPane) {
            this.systemMenuClose = new SystemMenuClose(editorPane.getPresentablePart(), stackPresentationSite);
            this.systemMenuCloseAllEditors = new SystemMenuCloseAllEditors(editorPane);
            this.systemMenuCloseOtherEditors = new SystemMenuCloseOtherEditors(editorPane);
            this.systemMenuMaximize = new SystemMenuMaximize(stackPresentationSite);
            this.systemMenuMoveEditor = new SystemMenuMoveEditor(editorPane.getPresentablePart(), stackPresentationSite);
            this.systemMenuPinEditor = new SystemMenuPinEditor(editorPane);
            this.systemMenuRestore = new SystemMenuRestore(stackPresentationSite);
            this.systemMenuSize = new SystemMenuSize(editorPane);
        }

        public void fill(Menu menu, int index) {
            this.systemMenuPinEditor.fill(menu, index);
            this.systemMenuRestore.fill(menu, index);
            this.systemMenuMoveEditor.fill(menu, index);
            this.systemMenuSize.fill(menu, index);
            this.systemMenuMaximize.fill(menu, index);
            new MenuItem(menu, 2);
            this.systemMenuClose.fill(menu, index);
            this.systemMenuCloseOtherEditors.fill(menu, index);
            this.systemMenuCloseAllEditors.fill(menu, index);
        }

        public void dispose() {
            this.systemMenuClose.dispose();
            this.systemMenuMaximize.dispose();
            this.systemMenuMoveEditor.dispose();
            this.systemMenuRestore.dispose();
            this.systemMenuSize.dispose();
        }
    }
}

