/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.internal.runtime.FindSupport;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.osgi.framework.Bundle;

public final class Platform {
    public static final String PI_RUNTIME = "org.eclipse.core.runtime";
    public static final String PI_BOOT = "org.eclipse.core.boot";
    public static final String PT_APPLICATIONS = "applications";
    public static final String PT_ADAPTERS = "adapters";
    public static final String PT_PRODUCT = "products";
    public static final String OPTION_STARTTIME = "org.eclipse.core.runtime/starttime";
    public static final String PREF_PLATFORM_PERFORMANCE = "runtime.performance";
    public static final int MIN_PERFORMANCE = 1;
    public static final int MAX_PERFORMANCE = 5;
    public static final int PARSE_PROBLEM = 1;
    public static final int PLUGIN_ERROR = 2;
    public static final int INTERNAL_ERROR = 3;
    public static final int FAILED_READ_METADATA = 4;
    public static final int FAILED_WRITE_METADATA = 5;
    public static final int FAILED_DELETE_METADATA = 6;

    private Platform() {
    }

    public static void addAuthorizationInfo(URL serverUrl, String realm, String authScheme, Map info) throws CoreException {
        InternalPlatform.getDefault().addAuthorizationInfo(serverUrl, realm, authScheme, info);
    }

    public static void addLogListener(ILogListener listener) {
        InternalPlatform.getDefault().addLogListener(listener);
    }

    public static void addProtectionSpace(URL resourceUrl, String realm) throws CoreException {
        InternalPlatform.getDefault().addProtectionSpace(resourceUrl, realm);
    }

    public static URL asLocalURL(URL url) throws IOException {
        return InternalPlatform.getDefault().asLocalURL(url);
    }

    public static void endSplash() {
        InternalPlatform.getDefault().endSplash();
    }

    public static void flushAuthorizationInfo(URL serverUrl, String realm, String authScheme) throws CoreException {
        InternalPlatform.getDefault().flushAuthorizationInfo(serverUrl, realm, authScheme);
    }

    public static IAdapterManager getAdapterManager() {
        return InternalPlatform.getDefault().getAdapterManager();
    }

    public static Map getAuthorizationInfo(URL serverUrl, String realm, String authScheme) {
        return InternalPlatform.getDefault().getAuthorizationInfo(serverUrl, realm, authScheme);
    }

    public static String[] getCommandLineArgs() {
        return InternalPlatform.getDefault().getCommandLineArgs();
    }

    public static IContentTypeManager getContentTypeManager() {
        return InternalPlatform.getDefault().getContentTypeManager();
    }

    public static String getDebugOption(String option) {
        return InternalPlatform.getDefault().getOption(option);
    }

    public static IPath getLocation() throws IllegalStateException {
        return InternalPlatform.getDefault().getLocation();
    }

    public static IPath getLogFileLocation() {
        return InternalPlatform.getDefault().getMetaArea().getLogLocation();
    }

    public static Plugin getPlugin(String id) {
        try {
            IPluginDescriptor pd = Platform.getPluginRegistry().getPluginDescriptor(id);
            if (pd == null) {
                return null;
            }
            return pd.getPlugin();
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static IPluginRegistry getPluginRegistry() {
        Bundle compatibility = InternalPlatform.getDefault().getBundle("org.eclipse.core.runtime.compatibility");
        if (compatibility == null) {
            return null;
        }
        Class oldInternalPlatform = null;
        try {
            oldInternalPlatform = compatibility.loadClass("org.eclipse.core.internal.plugins.InternalPlatform");
            Method getPluginRegistry = oldInternalPlatform.getMethod("getPluginRegistry", null);
            return (IPluginRegistry)getPluginRegistry.invoke((Object)oldInternalPlatform, null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static IPath getPluginStateLocation(Plugin plugin) {
        return plugin.getStateLocation();
    }

    public static String getProtectionSpace(URL resourceUrl) {
        return InternalPlatform.getDefault().getProtectionSpace(resourceUrl);
    }

    public static void removeLogListener(ILogListener listener) {
        InternalPlatform.getDefault().removeLogListener(listener);
    }

    public static URL resolve(URL url) throws IOException {
        return InternalPlatform.getDefault().resolve(url);
    }

    public static void run(ISafeRunnable runnable) {
        InternalPlatform.getDefault().run(runnable);
    }

    public static IJobManager getJobManager() {
        return InternalPlatform.getDefault().getJobManager();
    }

    public static IExtensionRegistry getExtensionRegistry() {
        return InternalPlatform.getDefault().getRegistry();
    }

    public static URL find(Bundle bundle, IPath path) {
        return FindSupport.find(bundle, path, null);
    }

    public static URL find(Bundle b, IPath path, Map override) {
        return FindSupport.find(b, path, override);
    }

    public static IPath getStateLocation(Bundle bundle) {
        return InternalPlatform.getDefault().getStateLocation(bundle);
    }

    public static ILog getLog(Bundle bundle) {
        return InternalPlatform.getDefault().getLog(bundle);
    }

    public static ResourceBundle getResourceBundle(Bundle bundle) throws MissingResourceException {
        return InternalPlatform.getDefault().getResourceBundle(bundle);
    }

    public static String getResourceString(Bundle bundle, String value) {
        return InternalPlatform.getDefault().getResourceString(bundle, value);
    }

    public static String getResourceString(Bundle bundle, String value, ResourceBundle resourceBundle) {
        return InternalPlatform.getDefault().getResourceString(bundle, value, resourceBundle);
    }

    public static String getOSArch() {
        return InternalPlatform.getDefault().getOSArch();
    }

    public static String getNL() {
        return InternalPlatform.getDefault().getNL();
    }

    public static String getOS() {
        return InternalPlatform.getDefault().getOS();
    }

    public static String getWS() {
        return InternalPlatform.getDefault().getWS();
    }

    public static String[] getApplicationArgs() {
        return InternalPlatform.getDefault().getApplicationArgs();
    }

    public static PlatformAdmin getPlatformAdmin() {
        return InternalPlatform.getDefault().getPlatformAdmin();
    }

    public static Location getInstanceLocation() {
        return InternalPlatform.getDefault().getInstanceLocation();
    }

    public static IBundleGroupProvider[] getBundleGroupProviders() {
        return InternalPlatform.getDefault().getBundleGroupProviders();
    }

    public static IPreferencesService getPreferencesService() {
        return InternalPlatform.getDefault().getPreferencesService();
    }

    public static IProduct getProduct() {
        return InternalPlatform.getDefault().getProduct();
    }

    public static void registerBundleGroupProvider(IBundleGroupProvider provider) {
        InternalPlatform.getDefault().registerBundleGroupProvider(provider);
    }

    public static void unregisterBundleGroupProvider(IBundleGroupProvider provider) {
        InternalPlatform.getDefault().unregisterBundleGroupProvider(provider);
    }

    public static Location getConfigurationLocation() {
        return InternalPlatform.getDefault().getConfigurationLocation();
    }

    public static Location getUserLocation() {
        return InternalPlatform.getDefault().getConfigurationLocation();
    }

    public static Location getInstallLocation() {
        return InternalPlatform.getDefault().getInstallLocation();
    }

    public static boolean isFragment(Bundle bundle) {
        return InternalPlatform.getDefault().isFragment(bundle);
    }

    public static Bundle[] getFragments(Bundle bundle) {
        return InternalPlatform.getDefault().getFragments(bundle);
    }

    public static Bundle getBundle(String symbolicName) {
        return InternalPlatform.getDefault().getBundle(symbolicName);
    }

    public static Bundle[] getHosts(Bundle bundle) {
        return InternalPlatform.getDefault().getHosts(bundle);
    }

    public static boolean isRunning() {
        return InternalPlatform.getDefault().isRunning();
    }
}

