/*
 * Decompiled with CFR 0.152.
 */
package swingwt.awt;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import swingwtx.swing.SwingUtilities;
import swingwtx.swing.SwingWTUtils;

public class Font {
    private org.eclipse.swt.graphics.Font peer = null;
    protected boolean disposeOnFinalize = true;
    public static final int PLAIN = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int ROMAN_BASELINE = 0;
    public static final int CENTER_BASELINE = 1;
    public static final int HANGING_BASELINE = 2;
    public static final int TRUETYPE_FONT = 0;
    protected String name = "Dialog";
    protected int style = 0;
    protected int size = 12;

    public Font(String name, int style, int size) {
        this.name = name;
        this.style = style;
        this.size = size;
        this.createPeer();
    }

    public Font(String name, int style, int size, boolean f) {
        this.name = name;
        this.style = style;
        this.size = size;
        this.createPeer();
    }

    public Font(Map attributes) {
        this.setAttributes(attributes);
        this.createPeer();
    }

    public Font(org.eclipse.swt.graphics.Font swtfont) {
        this.populateFromSWTFont(swtfont);
    }

    public static Font getFont(Map attributes) {
        return new Font(attributes);
    }

    protected void createPeer() {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                int swtStyle = 0;
                if ((Font.this.style & 1) > 0) {
                    swtStyle |= 1;
                }
                if ((Font.this.style & 2) > 0) {
                    swtStyle |= 2;
                }
                Font.this.peer = new org.eclipse.swt.graphics.Font((Device)SwingWTUtils.getDisplay(), Font.this.name, Font.this.size, swtStyle);
                Font.this.disposeOnFinalize = true;
            }
        });
    }

    protected void populateFromSWTFont(org.eclipse.swt.graphics.Font swtfont) {
        this.peer = swtfont;
        this.disposeOnFinalize = false;
        FontData[] fd = this.peer.getFontData();
        if (fd != null && fd.length > 0) {
            this.name = fd[0].getName();
            this.style = 0;
            if ((fd[0].getStyle() & 1) > 0) {
                this.style |= 1;
            }
            if ((fd[0].getStyle() & 2) > 0) {
                this.style |= 2;
            }
            this.size = fd[0].getHeight();
        }
    }

    public void setAttributes(Map attributes) {
        if (attributes != null) {
            String ast;
            String as;
            String af = attributes.get("family").toString();
            if (af != null) {
                this.name = attributes.get("family").toString();
            }
            if ((as = attributes.get("size").toString()) != null) {
                this.size = Integer.parseInt(attributes.get("size").toString());
            }
            if ((ast = attributes.get("style").toString()) != null) {
                this.style = Integer.parseInt(attributes.get("style").toString());
            }
        }
    }

    public Map getAttributes() {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("family", this.name);
        ht.put("size", new Integer(this.size));
        ht.put("style", new Integer(this.style));
        return ht;
    }

    public String getName() {
        return this.name;
    }

    public int getStyle() {
        return this.style;
    }

    public int getSize() {
        return this.size;
    }

    public float getSize2D() {
        return this.size;
    }

    public boolean isBold() {
        return (this.style & 1) > 0;
    }

    public boolean isPlain() {
        return this.style == 0;
    }

    public boolean isItalic() {
        return (this.style & 2) > 0;
    }

    public Font deriveFont(int style) {
        return new Font(this.name, style, this.size);
    }

    public org.eclipse.swt.graphics.Font getSWTFont() {
        return this.peer;
    }

    public void dispose() {
        this.peer.dispose();
    }

    protected void finalize() throws Throwable {
        if (this.disposeOnFinalize) {
            this.dispose();
        }
    }
}

