class Node {
    Node          father;
    Node            root;
    string          name;
    string          data;
    mapping   attributes;
    array(Node)  sibling;
    
    void create(string tag, mapping attr, void|object root_node, void|object father_node) 
    {
	name = tag;
	if ( mappingp(attr) )
	  attributes = attr;
	else
	  attributes = ([ ]);
	father = father_node;
	root = root_node;
	sibling = ({ });
	data = "";
	if ( objectp(father) )
	    father->add_child(this_object());
    }
    mapping get_pi() { return root->get_pi(); }
    void add_child(Node child) {
	sibling += ({ child });
    }
    void add_children(array childs) {
      foreach(childs, object child)
	child->set_parent(this_object());
      sibling += childs;
    }
    void replace_children(array childs) {
	sibling = childs;
	foreach(sibling, object child)
	  child->set_parent(this_object());
    }
    void replace_child(Node child, array(Node) childs) {
      array new_childs = ({ });
      foreach(sibling, object s) {
	if ( s == child )
	  new_childs += childs;
	else
	  new_childs += ({ s });
      }
      sibling = new_childs;
      foreach(sibling, object child)
	child->set_parent(this_object());
    }
    void set_parent(object f) { father = f; }
    Node get_first_child() {
      if ( sizeof(sibling) == 0 )
	return 0;
      return sibling[0];
    }
    Node get_last_child() {
      if ( sizeof(sibling) == 0 )
	return 0;
      return sibling[sizeof(sibling)-1];
    }
    array(Node) get_leafs() {
      array nodes = ({ });
      foreach( sibling, object child ) {
	if ( !objectp(sibling->get_first_child()) )
	  nodes += ({ child });
	else
	  nodes += child->get_leafs();
      }
      return nodes;
    }
    Node get_root() {
      if ( objectp(father) )
	return father->get_root();
      return this_object();
    }

    string get_data() { return data; }
    string get_name() { return name; }
    array(Node) get_sibling() { return sibling; }
    Node get_parent() { return father; }

    void set_data(string str) { data = str; }
    void add_data(string str) { data += str; }

    // xpath
    array(Node) get_nodes(string element) {
        if ( element[0] == '/' )
	  return root->get_nodes(element[1..]);
	array(Node) nodes = ({ });
	string rest_xpath;

	sscanf(element, "%s/%s", element, rest_xpath);
	array matches = match_sibling(element);
	
	foreach(matches, object child) {
	  if ( stringp(rest_xpath) && strlen(rest_xpath) > 0 )
	    nodes += child->get_nodes(rest_xpath);
	  else
	    nodes += ({ child });
	}
	return nodes;
    }
    
    Node get_node(string xpath) {
	string element, req;
	int         req_num; 
	mapping    req_attr;

	if ( !stringp(xpath) || strlen(xpath) == 0 )
	    return this_object();

	if ( xpath[0] == '/' ) 
	  return get_root()->get_node(xpath[1..]);

	if ( sscanf(xpath, "%s/%s", element, xpath) != 2 ) {
	    element = xpath;
	    xpath = "";
	}


	array nodes = match_sibling(element);

	foreach(nodes, object child) {
	  object res = child->get_node(xpath);
	  // only one path must match!
	  if ( objectp(res) )
	    return res;
	}
	return 0;
    }

    static array(Node) match_sibling(string single_xpath) {
      string element, constrain, attr, val;
      int req_num = -1;
      if ( !sscanf(single_xpath, "%s[%s]", element, constrain) )
	element = single_xpath;
      else {
	sscanf(constrain, "%d", req_num);
	sscanf(constrain, "@%s=%s", attr, val);
      }
	
      array matches = ({ });
      int cnt = 0;
      foreach(sibling, object child) {
	// match
	if ( element == "*" || child->name == element ) {
	  if ( !stringp(attr) || child->attributes[attr] == val ) {
	    cnt++;
	    if ( req_num == -1 || req_num == cnt )
	      matches += ({ child });
	  }
	}
      }
      return matches;
    }

    array(Node) replace_node(string|Node|array(Node) data, void|string xpath) {
	// parse data and replace...
        // remove ?xml at beginning of data;
      array(Node) replacements;

      if ( arrayp(data) )
	replacements = data;
      if ( objectp(data) )
	replacements = ({ data });
      else {
	Node node = parse(data);
	if ( !objectp(node) )
	  error("Cannot replace node- unparseable data !");
	if ( xpath )
	  replacements = node->get_nodes(xpath);
	else
	  replacements = ({ node });
      }
      
      father->replace_child(this_object(), replacements);
      return replacements;
    }
  
    string get_xml() {
      return xml.utf8_to_html(dump());
  }
    string string_attributes() {
      string a = "";
      foreach(indices(attributes), string attr)
	a += attr + "='" + attributes[attr]+ "' ";
      return a;
    }
    string dump() {
      string xml = "";
      xml += "<"+name+" " + string_attributes()+">\n";
      xml += get_data()+"\n";
      foreach( sibling, object child)
	xml+= child->get_data();
      xml += "</"+name+">\n";
      return xml;
    }
    string describe() { return _sprintf(); }
    string _sprintf() { return "Node("+name+"," + sizeof(sibling())+ " childs, "+
			    (strlen(data) > 0 ? "data": "null")+")"; }
}

class RootNode {
  inherit Node;
  
  mapping pi = ([ ]);
  void add_pi(string name, string data) { pi[name] = data; }
  mixed get_pi() {
    return pi; 
  }
}


class saxHandler
{
    inherit "AbstractCallbacks";

    RootNode root;
    array arr_errors = ({ });
    static ADT.Stack NodeQueue     = ADT.Stack();

    Node get_root() { return root; }

    void create() {
	root = RootNode("root", ([ ]));
	NodeQueue->push(root);
    }

    int store_data(string data) {
      Node active = NodeQueue->pop();
      active->add_data(data);
      NodeQueue->push(active);
      return 1;
    }
    
    string errorSAX(object parser, string err, void|mixed userData) 
    {
      arr_errors += ({ err });
    }

    array get_errors() 
    {
      return arr_errors;
    }
    string get_first_error() 
    {
      if ( sizeof(arr_errors) > 0 )
	return arr_errors[0];
      return 0;
    }

    void startElementSAX(object parser, string name, 
			 mapping(string:string) attrs, void|mixed userData) 
    {
	Node father;
	// connect nodes;
	father = NodeQueue->pop();
	Node active = Node(name, attrs, root, father);
	NodeQueue->push(father);

	NodeQueue->push(active);
	// new element on data queue
    }
    
    
    void endElementSAX(object parser, string name, void|mixed userData)
    {
      Node old = NodeQueue->pop(); // remove old node from queue...
      if ( old->attributes->name == "NAVIGATIONTAB2_CONTENT" )
	werror("Parsed language term: %O\n", old->attributes);
    }
    void cdataBlockSAX(object parser, string value, void|mixed userData)
    {
      store_data(value);
    }
    void charactersSAX(object parser, string chars, void|mixed userData)
    {
	if ( !store_data(chars) )
	    error("Unable to store characters in Node...");
    }
    void commentSAX(object parser, string value, void|mixed userData) 
    {
      store_data("<!--"+value+"-->");
    }
    void referenceSAX(object parser, string name, void|mixed userData)
    {
      werror("referenceSAX(%s)\n", name);
    }
    void entityDeclSAX(object parser, string name, int type, string publicId,
		       string systemId, string content, void|mixed userData)
    {
      werror("entityDecl(%s)\n", name);
    }
    void notationDeclSAX(object parser, string name, string publicId, 
			 string systemId, void|mixed userData) 
    {
        werror("notationDecl(%s)\n", name);
    }
    void unparsedEntityDeclSAX(object parser, string name, string publicId, 
			       string systemId, string notationName, 
			       void|mixed userData) 
    {
        werror("unparsedEntityDecl(%s)\n", name);
    }
    string getEntitySAX(object parser, string name, void|mixed userData)
    {
        werror("getEntitySax(%s)\n", name);
    }
  string processingInstructionSAX(object parser, string name, string data, void|mixed userData)
    {
      root->add_pi(name, data);
    } 
    void attributeDeclSAX(object parser, string elem, string fullname, 
			  int type, int def, void|mixed userData)
    {
        werror("attributeDeclSAX(%s, %s)\n", elem, fullname);
    }
    void internalSubsetSAX(object parser, string name, string externalID, 
			   string systemID, void|mixed uData)
    {
      werror("internalSubset(%s)\n", name);
    }
    void ignorableWhitespaceSAX(object parser, string chars, void|mixed uData)
    {
    }
};

/**
 * Create a mapping from an XML Tree.
 *  
 * @param NodeXML n - the root-node to transform to a mapping.
 * @return converted mapping.
 */
mapping xmlMap(Node n)
{
  mapping res = ([ ]);
  foreach ( n->sibling, Node sibling) {
    if ( sibling->name == "member" ) {
      mixed key,value;
      foreach(sibling->sibling, object o) {

	if ( o->name == "key" )
	  key = unserialize(o->sibling[0]);
	else if ( o->name == "value" )
	  value = unserialize(o->sibling[0]);
      }
      res[key] = value;
    }
  }
  return res;
}

/**
 * Create an array with the siblings of the given Node.
 *  
 * @param NodeXML n - the current node to unserialize.
 * @return Array with unserialized siblings.
 */
array xmlArray(Node n)
{
    array res = ({ });
    foreach ( n->sibling, Node sibling) {
	res += ({ unserialize(sibling) });
    }
    return res;
}

/**
 * Create some data structure from an XML Tree.
 *  
 * @param NodeXML n - the root-node of the XML Tree to unserialize.
 * @return some data structure describing the tree.
 */
mixed unserialize(Node n) 
{
    switch ( n->name ) {
    case "struct":
	return xmlMap(n);
	break;
    case "array":
	return xmlArray(n);
	break;
    case "int":
	return (int)n->data;
	break;
    case "float":
	return (float)n->data;
	break;
    case "string":
	return n->data;
	break;
    }
    return -1;
}

Node parse(string|object html)
{
    object cb = saxHandler();
    
    object sax = xml.SAX(html, cb, ([ ]), 0, stringp(html));
    mixed err = catch(sax->parse());
    if ( err != 0 || stringp(cb->get_first_error()) ) 
      throw(({"Error parsing: " + (cb->get_errors()*"\n")+"\n", backtrace()}));
    
    Node root =  cb->get_root();
    return root->get_first_child();
}

void test()
{
  string xml = "<?steam config='xmlfile'?><a><b>bb</b><b text='3'>bbb</b><b/><x/><b/><b/></a>";
  string rpl = "<xml><b>xxx&#160;zzz</b><b><![CDATA[yyy&amp;zzz&nbsp;]]></b>"+
    "<b><![CDATA[<img src='test'>IMG</img>]]></b></xml>";
  Node a = parse(xml);
  write("Parsed: " + a->dump()+"\n");
  Node x = a->get_node("x");
  x->replace_node(rpl);
  array nodes = a->get_nodes("b");
  write("Nodes: %O\n", nodes);
  nodes = a->get_nodes("b[@text=3]");
  write("Nodes with text 3: %O\n", nodes);
  nodes = a->get_nodes("/a");
  write("From root = %O\n", nodes);
  write("PI=%O\n", a->get_pi());
}
