// StarPlot - A program for interactively viewing 3D maps of stellar positions.
// Copyright (C) 2000  Kevin B. McCarty
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


#ifndef _XPM_DATA_H
#define _XPM_DATA_H

/* This file holds data for the xpm images used in the StarPlot button bar. */

static const char * xpmdata[9][25] = {

  /* file open dialog */
  {
    "16 16 4 1",
    "       c None",
    ".      c #000000000000",
    "X      c #FFFFFFFF8000",
    "x      c #C000C0008000",
    ",      c #800080008000",
    "                ",
    "                ",
    " ,....,         ",
    " .XXXX......    ",
    " .XXXXXXXXX.    ",
    " .XXXXXXXXX.    ",
    " .XX,..........,",
    " .XX.xxxxxxxxx. ",
    " .Xx.xxxxxxxx., ",
    " .X.xxxxxxxxx.  ",
    " .x.xxxxxxxx.,  ",
    " ..xxxxxxxxx.   ",
    " ..xxxxxxxx.,   ",
    " ...........    ",
    "                ",
    "                ",
  },

  /* magnifying glass for zoom in */
  {
    "16 16 4 1",
    "       c None",
    ".      c #000000000000",
    "X      c #FFFFFFFFFFFF",
    ",      c #800080008000",
    "                ",
    "       ,....,   ",
    "      ..XXXX..  ",
    "     ,.XX..XX., ",
    "     .XXX..XXX. ",
    "     .X......X. ",
    "     .X......X. ",
    "     .XXX..XXX. ",
    "     ,.XX..XX., ",
    "     ...XXXX..  ",
    "    ........,   ",
    "   ....         ",
    "  ....          ",
    " ....           ",
    " ...            ",
    "  .             ",
  },

  /* unmagnifying glass for zoom out */
  {
    "16 16 4 1",
    "       c None",
    ".      c #000000000000",
    "X      c #FFFFFFFFFFFF",
    ",      c #800080008000",
    "                ",
    "       ,....,   ",
    "      ..XXXX..  ",
    "     ,.XXXXXX., ",
    "     .XXXXXXXX. ",
    "     .X......X. ",
    "     .X......X. ",
    "     .XXXXXXXX. ",
    "     ,.XXXXXX., ",
    "     ...XXXX..  ",
    "    ........,   ",
    "   ....         ",
    "  ....          ",
    " ....           ",
    " ...            ",
    "  .             ",
  },

  /* arrows for changing the chart orientation */
  {
    "16 16 3 1",
    "       c None",
    ".      c #000000000000",
    ",      c #800080008000",
    "                ",
    "   ,.......,    ",
    "  ...........   ",
    " ...,     ,...  ",
    ",..         .., ",
    "..          ... ",
    "..      .   ... ",
    "..     ..   ... ",
    "..    ...  .... ",
    " .,  .......... ",
    "  . ..........  ",
    "     .......,   ",
    "      ...       ",
    "       ..       ",
    "        .       ",
    "                "
  },
  {
    "16 16 3 1",
    "       c None",
    ".      c #000000000000",
    ",      c #800080008000",
    "                ",
    "   ,.......,    ",
    "  ...........   ",
    " ...,     ,...  ",
    ",..         .., ",
    "...          .. ",
    "...   .      .. ",
    "...   ..     .. ",
    "....  ...    .. ",
    "..........  ,.  ",
    " .......... .   ",
    "  ,.......      ",
    "      ...       ",
    "      ..        ",
    "      .         ",
    "                "
  },
  {
    "16 16 4 1",
    "       c None",
    ".      c #000000000000",
    ",      c #500050005000",
    ":      c #a000a000a000",
    "                ",
    "       .        ",
    "      ...       ",
    "     .....      ",
    "    .......     ",
    "   .........    ",
    "      ...       ",
    "      ...       ",
    "      ...       ",
    "     :...:      ",
    "     :...:      ",
    "     ,...,      ",
    "     ,...,      ",
    "     .....      ",
    "     .....      ",
    "                "
  },
  {
    "16 16 4 1",
    "       c None",
    ".      c #000000000000",
    ",      c #500050005000",
    ":      c #a000a000a000",
    "                ",
    "     .....      ",
    "     .....      ",
    "     ,...,      ",
    "     ,...,      ",
    "     :...:      ",
    "     :...:      ",
    "      ...       ",
    "      ...       ",
    "      ...       ",
    "   .........    ",
    "    .......     ",
    "     .....      ",
    "      ...       ",
    "       .        ",
    "                "
  },

  /* a couple bright stars for the magnitude decrease button */
  {
    "16 16 4 1",
    "       c None",
    ".      c #000000000000",
    "X      c #0000C000FFFF",
    "O      c #8000E000E000",
    "............... ",
    "............... ",
    "...XXX......... ",
    "..XXXXX........ ",
    "..XXXXX........ ",
    "...XXX......... ",
    "............... ",
    "............... ",
    "............... ",
    "............... ",
    "..........OO... ",
    ".........OOOO.. ",
    ".........OOOO.. ",
    "..........OO... ",
    "............... ",
    "                "
  },

  /* lots of dim stars for the magnitude increase button */
  {
    "16 16 7 1",
    "       c None",
    ".      c #000000000000",
    "X      c #0000C000FFFF",
    "O      c #8000E000E000",
    "o      c #F000F0000000",
    "e      c #F000A0000000",
    "c      c #FFFF20000000",
    "............... ",
    "...........ee.. ",
    "...XXX.....ee.. ",
    "..XXXXX........ ",
    "..XXXXX........ ",
    "...XXX.oo...... ",
    ".......oo...... ",
    "............cc. ",
    "......ee....cc. ",
    "..cc..ee....... ",
    "..cc......OO... ",
    ".........OOOO.. ",
    "....cc...OOOO.. ",
    "....cc....OO... ",
    "............... ",
    "                "
  },
};      


#endif // #ifndef _XPM_DATA_H
