// sportowal: Marek Majchrowski <majherek@pc-4.chomiczowka.waw.pl>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <regex.h>
#include "vsprintf.h"
#include "request.h"
#include "headers.h"
#include "sms.h"

int
WyslijSMS_IDEA_mBox(SMS_packet * sms)
{
    char *telefon = sms->telefon;
    char *wiadomosc = sms->wiadomosc;
    char *ok = sms->potwierdzenie;
    int ret_val;
    const char *body;
    string cookies, cookie;
    char buf[200], formularz[200], loginSuccessURL[200];
    regex_t preg;
    regmatch_t reg;
    int wynik;
    Headers *h, *form;

    while (1) {
        HTTP_Request *s = new HTTP_Request("www.idea.pl", 80,
                                           konfig.w3cache_host,
                                           konfig.w3cache_port);
	
        h = s->GetData("/", 1);
	cookie = h->AllHeader("Set-Cookie");	
        s->AddHeader("Cookie", cookie.c_str());
	cookies = cookie;
	delete h;
	
        s->AddHeader("Host", "www.idea.pl");
        s->AddHeader("Accept", "*/*");
	// w podziekowaniu Qbicowi
        s->AddHeader("User-Agent", "QBic's SMSGate/0.1 adapted by Majherek");

        body = s->GetBody();

        regcomp(&preg,
                "<form action=\"https://www.idea.pl/.*\" method=\"POST\">",
                REG_EXTENDED);
/*        regcomp(&preg,
                "<form .* action=\"https://www.idea.pl/.*\" method=\"POST\">",
                REG_EXTENDED);*/
        wynik = !regexec(&preg, body, 1, &reg, 0);
        regfree(&preg);

        if (wynik) {
            strncpy(buf, &body[reg.rm_so], reg.rm_eo - reg.rm_so);
            strncat(buf, "\0", 1);

            regcomp(&preg, "/portal/.[^\" ]*", REG_EXTENDED);
            wynik = !regexec(&preg, buf, 1, &reg, 0);
            regfree(&preg);
            if (wynik) {
                strncpy(formularz, &buf[reg.rm_so], reg.rm_eo - reg.rm_so);
                strncat(formularz, "\0", 1);
            } else
                break;

        } else
            break;

        regcomp(&preg,
                "loginSuccessURL\" type=\"hidden\" value=\"(http://www.idea.pl/[^\"]*)\">",
                REG_EXTENDED);
        wynik = !regexec(&preg, body, 1, &reg, 0);
        regfree(&preg);

        if (wynik) {
            strncpy(buf, &body[reg.rm_so], reg.rm_eo - reg.rm_so);
            strncat(buf, "\0", 1);

            regcomp(&preg, "http://www.idea.pl/.[^\" ]*", REG_EXTENDED);
            wynik = !regexec(&preg, buf, 1, &reg, 0);
            regfree(&preg);
            if (wynik) {
                strncpy(loginSuccessURL, &buf[reg.rm_so], reg.rm_eo - reg.rm_so);
                strncat(loginSuccessURL, "\0", 1);
            } else
                break;

        } else
            break;

        form = new Headers();

        form->Add("_DARGS", "/portal/layoutTemplates/html/header_files/login.jsp");
        form->Add("_D:/amg/ptk/map/core/formhandlers/AdvancedProfileFormHandler.loginSuccessURL", " ");
        form->Add("/amg/ptk/map/core/formhandlers/AdvancedProfileFormHandler.loginSuccessURL", loginSuccessURL);
        form->Add("_D:/amg/ptk/map/core/formhandlers/AdvancedProfileFormHandler.extractDefaultValuesFromProfile", " ");
        form->Add("/amg/ptk/map/core/formhandlers/AdvancedProfileFormHandler.extractDefaultValuesFromProfile", "false");
        form->Add("_D:/amg/ptk/map/core/formhandlers/AdvancedProfileFormHandler.login", "");
        form->Add("/amg/ptk/map/core/formhandlers/AdvancedProfileFormHandler.login", "login");
//        form->Add("_D:password", " ");
//        form->Add("password", konfig.ideambox_pass);
//        form->Add("_D:login", " ");
//        form->Add("login", konfig.ideambox_login);
        form->Add("_D:/amg/ptk/map/core/formhandlers/AdvancedProfileFormHandler.value.password", "");
        form->Add("/amg/ptk/map/core/formhandlers/AdvancedProfileFormHandler.value.password", konfig.ideambox_pass);
        form->Add("_D:/amg/ptk/map/core/formhandlers/AdvancedProfileFormHandler.value.login", "");
        form->Add("/amg/ptk/map/core/formhandlers/AdvancedProfileFormHandler.value.login", konfig.ideambox_login);
        form->Add("_dyncharset", "ISO8859_2");

        h = s->PostData(formularz, *form);
        delete form;

	cookie = h->AllHeader("Set-Cookie");
	if (cookie != "") {
	    cookies += "; ";
	    cookies += cookie;
	}
	delete h;

	s->ReplaceHeader("Cookie", cookies.c_str());

        delete s->GetData("http://www.idea.pl/portal/map/map/message_box?mbox_view=newsms&mbox_edit=new", 1);

        regcomp(&preg, "Nowa wiadomo SMS", REG_EXTENDED);
        wynik = !regexec(&preg, s->GetBody(), 1, &reg, 0);
        regfree(&preg);

        if (!wynik) break;

        form = new Headers();
        form->Add("_DARGS","/gear/mapmessagebox/smsform.jsp");
        form->Add("_D:/amg/ptk/map/messagebox/formhandlers/MessageFormHandler.create","");
        form->Add("/amg/ptk/map/messagebox/formhandlers/MessageFormHandler.create","Wylij");
        form->Add("counter", 640 - strlen(wiadomosc));
        form->Add("/amg/ptk/map/messagebox/formhandlers/MessageFormHandler.body", wiadomosc);
        form->Add("_D:/amg/ptk/map/messagebox/formhandlers/MessageFormHandler.body","");
        form->Add("_D:/amg/ptk/map/messagebox/formhandlers/MessageFormHandler.to","");
        form->Add("/amg/ptk/map/messagebox/formhandlers/MessageFormHandler.to", telefon);
        form->Add("_D:/amg/ptk/map/messagebox/formhandlers/MessageFormHandler.successURL","");
        form->Add("/amg/ptk/map/messagebox/formhandlers/MessageFormHandler.successURL","/portal/map/map/message_box?mbox_view=messageslist");
        form->Add("_D:/amg/ptk/map/messagebox/formhandlers/MessageFormHandler.errorURL","");
        form->Add("/amg/ptk/map/messagebox/formhandlers/MessageFormHandler.errorURL","/portal/map/map/message_box?mbox_view=newsms");
        form->Add("_D:/amg/ptk/map/messagebox/formhandlers/MessageFormHandler.type","");
        form->Add("/amg/ptk/map/messagebox/formhandlers/MessageFormHandler.type","sms");
        form->Add("_dyncharset","ISO8859_2");
	
        delete s->PostData("http://www.idea.pl/portal/map/map/message_box?_DARGS=/gear/mapmessagebox/smsform.jsp", *form);
	delete form;
	
        ret_val = poprawna_odpowiedz(ok, telefon, s->GetBody());

        delete s;

        return ret_val;
    }
    throw new Exception("Blad obslugi strony www.idea.pl");
    return 0;
}
