#ifndef __cgdbm_h_
#define __cgdbm_h_

#include <gdbm.h>

// typy danych rozpoznawane przez klase Cdatum - takich typow mozna uzywac
// bezposrednio w konstruktorach
typedef enum {
        CD_VOID,
        CD_STRING,
        CD_LONG,
        CD_FLOAT
} data_type_t;

class Cdatum
{
protected:
   data_type_t data_type;
   datum dat;
public:
   Cdatum();            // tworzy pusty obiekt, bez zadnej wartosci
   Cdatum(const Cdatum &cd);  // konstruktor kopiujacy
   Cdatum(const datum &d);    // inny kopiujacy
   Cdatum(const void *ptr, int size);
   Cdatum(const char *str);
   Cdatum(long val);
   Cdatum(float val);
   virtual ~Cdatum();

   const void *Data();
   int IsNull() { return !dat.dsize; };

   operator datum&();
   operator const char*();
};    

class Cgdbm
{
protected:
   char *filename;     // jesli != NULL to znaczy, ze baza jest otwarta
   GDBM_FILE db;
public:
   Cgdbm();
   Cgdbm(const char *_filename, int block_size, int read_write, int mode = 0600);
   virtual ~Cgdbm();

   int Open(const char *_filename, int block_size, int read_write, int mode = 0600);
   void Close();
   
   int Store(Cdatum &key, Cdatum &content, int flag);
   int Insert(Cdatum &key, Cdatum &content);
   int Replace(Cdatum &key, Cdatum &content);

   Cdatum &Fetch(Cdatum &key);
   Cdatum &FirstKey();
   Cdatum &NextKey(Cdatum &key);

   int Exists(Cdatum &key);

   int Delete(Cdatum &key);

   int Reorganize();
   void Sync();
   int SetOpt(int option, int *value, int size);

   const char *StrError(gdbm_error err = (gdbm_error)-1);
   const char *Version();
   const int Status();
};

#endif
