%{

#include <stdio.h>
#include <stdlib.h>
#include "symbol.h"
#include "intern.h"
#include "parser.h"
#include "scanner.h"

/* For error reporting... */

static int lineno = 1;

%}

letter          [A-Za-z]
digit           [0-9]
ID              {letter}({letter}|{digit}|_)*

%%
[ \t\f]+	{ /* delete whitespace */ }
"\n"            { lineno++; }
#[^\n]*		{ lineno++; /* delete comments */ }
COMMON |
common		{ return(COMMON); }
CLASS |
class		{ return(CLASS); }
ALIAS |
alias		{ return(ALIAS); }
SENSITIVITY |
sensitivity	{ return(SENSITIVITY); }
DOMINANCE |
dominance	{ return(DOMINANCE); }
CATEGORY |
category	{ return(CATEGORY); }
LEVEL |
level		{ return(LEVEL); }
{ID}		{ yylval.id = intern(yytext); return IDENTIFIER; }
"," |
":" |
";" |
"(" | 
")" |
"{" | 
"}" |
"[" |
"-" |
"." |
"]" |
"~" |
"*"		{ return(yytext[0]); } 
.               { return UNUSED; }


%%

static const char *filename = "-";

int 
setfile(const char *path)
{
  if (!path) {
    yyin = stdin;
    return 0;
  }
  filename = path;
  yyin = fopen(path, "r");
  return yyin ? 0 : -1;
}

int
yyerror(const char *msg) 
{
  return fprintf(stderr, "%s:%d: %s at token %s\n", 
                 filename, lineno, msg, yytext);
}
