<?php
/******************************************************************************
 *  SiteBar 3 - The Bookmark Server for Personal and Team Use.                *
 *  Copyright (C) 2004  Ondrej Brablc <http://brablc.com/mailto?o>            *
 *                                                                            *
 *  This program is free software; you can redistribute it and/or modify      *
 *  it under the terms of the GNU General Public License as published by      *
 *  the Free Software Foundation; either version 2 of the License, or         *
 *  (at your option) any later version.                                       *
 *                                                                            *
 *  This program is distributed in the hope that it will be useful,           *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 *  GNU General Public License for more details.                              *
 *                                                                            *
 *  You should have received a copy of the GNU General Public License         *
 *  along with this program; if not, write to the Free Software               *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
 ******************************************************************************/

// This module must run without ErrorHandler!

class Localizer
{
    var $text;
    var $para;
    var $paraDefault;
    var $lang;
    var $langDefault = 'en_US';
    var $plugins = array();

    function Localizer()
    {
        $this->lang = $this->langDefault;
        $this->loadDefault();
    }


    function & getInstance()
    {
        // Funny we can see this althought it is not yer defined
        global $_Localizer;
        return $_Localizer;
    }

    function getLanguages()
    {
        static $langs = null;

        if ($langs)
        {
            return $langs;
        }

        $langs = array();

        if ($dir = opendir("./locale"))
        {
            while (($dirname = readdir($dir)) !== false)
            {
                $infofile = './locale/'.$dirname.'/info.inc.php';
                if (!is_dir('./locale/'.$dirname) || !is_file($infofile)) continue;

                include($infofile);
                $info['dir']=$dirname;
                $langs[] = $info;
            }
            closedir($dir);

            function _lclangCmp(&$a, $b)
            {
                return (strcmp($a['dir'], $b['dir']));
            }

            uasort($langs, '_lclangCmp');
            reset($langs);
        }

        return $langs;
    }

    function getBrowserLang()
    {
        if (!empty($_SERVER['HTTP_ACCEPT_LANGUAGE']))
        {
            $str = $_SERVER['HTTP_ACCEPT_LANGUAGE'];

            foreach ($this->getLanguages() as $lang)
            {
                $dir = str_replace('_','-',$lang['dir']);

                if (preg_match('/^(' . $dir . ').*?(;q=[0-9]\\.[0-9])?$/i', $str))
                {
                    return $lang['dir'];
                }
            }

            foreach ($this->getLanguages() as $lang)
            {
                list($ln,$country) = explode('_',$lang['dir']);

                if (preg_match('/^(' . $ln . ').*?(;q=[0-9]\\.[0-9])?$/i', $str))
                {
                    return $lang['dir'];
                }
            }
        }

        if (!empty($_SERVER['HTTP_USER_AGENT']))
        {
            $str = $_SERVER['HTTP_USER_AGENT'];

            foreach ($this->getLanguages() as $lang)
            {
                $dir = str_replace('_','-',$lang['dir']);

                if (eregi('(\(|\[|;[[:space:]])(' . $dir . ')(;|\]|\))', $str))
                {
                    return $lang['dir'];
                }
            }

            foreach ($this->getLanguages() as $lang)
            {
                list($ln,$country) = explode('_',$lang['dir']);

                if (eregi('(\(|\[|;[[:space:]])(' . $ln . ')(;|\]|\))', $str))
                {
                    return $lang['dir'];
                }
            }
        }

        return null;
    }

    function setPlugins(&$plugins)
    {
        $this->plugins =& $plugins;
        $this->loadDefault();
    }

    function loadDefault()
    {
        if (require("./locale/".$this->langDefault."/para.inc.php"))
        {
            $this->text = array();

            foreach ($this->plugins as $plugin)
            {
                require("./plugins/locale/".$this->langDefault."/para.".$plugin);
            }

            $this->para = $para;
            $this->paraDefault = $para;
        }
    }

    function getText($msg, $params=null)
    {
        $lmsg = '';
        if ($this->isDefault())
        {
            $lmsg = $msg;
        }
        else
        {
            if (isset($this->text[$msg]))
            {
                $lmsg = $this->text[$msg];
            }
            else
            {
                $lmsg = $msg;
            }
        }

        if ($params)
        {
            $lmsg = vsprintf($lmsg, $params);
        }

        return $lmsg;
    }

    function getPara($id, $params=null)
    {
        $lmsg = '';

        if (isset($this->para[$id]))
        {
            $lmsg = $this->para[$id];
            if (substr($lmsg,0,3) == '<@>')
            {
                $lmsg = substr($lmsg,3);
            }
        }
        else
        {
            $lmsg = $this->paraDefault[$id];
        }

        if ($params)
        {
            $lmsg = vsprintf($lmsg, $params);
        }

        return $lmsg;
    }

    function isDefault()
    {
        return $this->lang==$this->langDefault;
    }

    function setLang($lang)
    {
        $this->lang=$lang;

        if (!$this->isDefault() && include("./locale/".$this->lang."/text.inc.php"))
        {
            foreach ($this->plugins as $plugin)
            {
                $file = "./plugins/locale/".$this->lang."/text.".$plugin;
                if (is_file($file))
                {
                    include($file);
                }
            }

            $this->text = $text;
        }

        if (include("./locale/".$this->lang."/para.inc.php"))
        {
            foreach ($this->plugins as $plugin)
            {
                $file = "./plugins/locale/".$this->lang."/para.".$plugin;
                if (is_file($file))
                {
                    include($file);
                }
            }

            $this->para = $para;
        }
    }

    function getHelpTopics()
    {
        include("./locale/".$this->langDefault."/topic.inc.php");
        $defaultTopic = $topic;
        include("./locale/".$this->lang."/topic.inc.php");

        foreach ($defaultTopic as $id => $label)
        {
            if (!isset($topic[$id]))
            {
                $topic[$id] = $defaultTopic[$id];
            }
        }

        return $topic;
    }

    function getHelp($id)
    {
        include("./locale/".$this->langDefault."/help.inc.php");
        $defaultHelp = $help;
        include("./locale/".$this->lang."/help.inc.php");

        echo $help[$id]?$help[$id]:$defaultHelp[$id];
    }
}

$_Localizer = new Localizer();

function T($msg, $params=null)
{
    if (trim($msg)=='')
    {
        return $msg;
    }
    global $_Localizer;
    return $_Localizer->getText($msg, $params);
}

function P($id, $params=null)
{
    global $_Localizer;
    return $_Localizer->getPara($id, $params);
}

function A($id, $pairs, $open='{', $close='}')
{
    global $_Localizer;
    $para = $_Localizer->getPara($id);

    foreach ($pairs as $key => $value)
    {
        $para = str_replace($open.$key.$close, $value, $para);
    }

    return $para;
}

function SetLanguage($lang)
{
    global $_Localizer;
    return $_Localizer->setLang($lang);
}

function GetHelpTopics()
{
    global $_Localizer;
    return $_Localizer->getHelpTopics();
}

function GetHelp($params)
{
    global $_Localizer;
    return $_Localizer->getHelp($params["topic"]);
}

?>
