/* $Id: misc.c,v 1.3 2003/05/30 00:42:40 cgd Exp $ */

/*
 * Copyright 2001, 2003
 * Broadcom Corporation. All rights reserved.
 *
 * This software is furnished under license and may be used and copied only
 * in accordance with the following terms and conditions.  Subject to these
 * conditions, you may download, copy, install, use, modify and distribute
 * modified or unmodified copies of this software in source and/or binary
 * form. No title or ownership is transferred hereby.
 *
 * 1) Any source code used, modified or distributed must reproduce and
 *    retain this copyright notice and list of conditions as they appear in
 *    the source file.
 *
 * 2) No right is granted to use any trade name, trademark, or logo of
 *    Broadcom Corporation.  The "Broadcom Corporation" name may not be
 *    used to endorse or promote products derived from this software
 *    without the prior written permission of Broadcom Corporation.
 *
 * 3) THIS SOFTWARE IS PROVIDED "AS-IS" AND ANY EXPRESS OR IMPLIED
 *    WARRANTIES, INCLUDING BUT NOT LIMITED TO, ANY IMPLIED WARRANTIES OF
 *    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR
 *    NON-INFRINGEMENT ARE DISCLAIMED. IN NO EVENT SHALL BROADCOM BE LIABLE
 *    FOR ANY DAMAGES WHATSOEVER, AND IN PARTICULAR, BROADCOM SHALL NOT BE
 *    LIABLE FOR DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *    CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 *    SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 *    BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *    WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 *    OR OTHERWISE), EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "misc.h"

/* 
 * Semantics of these are described in the header
 */

void dump_hex(void *ptr, int length)
{
	int i;

	for (i = 0; i < length; i++) {
		if (i && !(i & 0xf)) {
			lib_printf("\n");
		}
		lib_printf("%.02X ", ((unsigned char *)ptr)[i]);
	}
	lib_printf("\n");
}

void dump_eth_addr(uint64_t addr)
{
	lib_printf("%.02X:%.02X:%.02X:%.02X:%.02X:%.02X",
		   (int)((addr >> 40) & 0xff),
		   (int)((addr >> 32) & 0xff),
		   (int)((addr >> 24) & 0xff),
		   (int)((addr >> 16) & 0xff),
		   (int)((addr >>  8) & 0xff),
		   (int)(addr & 0xff));
}

void set_uint16_field(uint8_t *field, uint16_t val)
{
	field[0] = val >> 8;
	field[1] = val & 0xff;
}

void set_uint32_field(uint8_t *field, uint32_t val)
{
	field[0] = val >> 24;
	field[1] = (val >> 16) & 0xff;
	field[2] = (val >> 8 ) & 0xff;
	field[3] = val         & 0xff;
}

uint16_t get_uint16_field(uint8_t *field)
{
	return (((uint16_t)field[0]) << 8) | field[1];
}

uint32_t get_uint32_field(uint8_t *field)
{
	return (((uint32_t)field[0]) << 24) 
		| (((uint32_t)field[1]) << 16)
		| (((uint32_t)field[2]) << 8 )
		| field[3];
}

uint64_t get_uint48_field(uint8_t *field)
{
	return (((uint64_t)field[0])<<40)
		| (((uint64_t)field[1]) << 32)
		| (((uint64_t)field[2]) << 24)
		| (((uint64_t)field[3]) << 16)
		| (((uint64_t)field[4]) <<  8)
		| field[5];
}

void set_uint48_field(uint8_t *field, uint64_t val)
{
	field[0] = (val >> 40) & 0xff;
	field[1] = (val >> 32) & 0xff;
	field[2] = (val >> 24) & 0xff;
	field[3] = (val >> 16) & 0xff;
	field[4] = (val >>  8) & 0xff;
	field[5] = val & 0xff;
	
}
