/***************************************************************************
                          player_effect.h  -  description
                             -------------------
    begin                : Sun Feb 18 2001
    copyright            : (C) 2001 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PLAYER_EFFECT_H
#define PLAYER_EFFECT_H

#include "typedefs.h"

/**base class for a tracker effect
  *@author Juan Sebastian Linietsky
  */

class Player_Effect {
protected:

	int *tempo_value_ptr;
	bool update_once;
	bool do_stop_event;
	bool processing;
public:

	virtual void set_parameter(Uint8 parameter) {};
	virtual void process(int time) {};
	virtual void get_event_variables(int &type,int &parameter_1,int &parameter_2) {};
	virtual void start() { processing=true; };
	virtual void stop() { processing=false; };


	void link_tempo(int *tempo_ptr) { tempo_value_ptr=tempo_ptr; };
	bool do_update_once() { return update_once; };
	bool do_event_on_stop() { return do_stop_event; };

	Player_Effect() {

		do_stop_event=false;
		processing=false;
		tempo_value_ptr=NULL;
		update_once=false;

	}

	virtual ~Player_Effect();
};

#endif
