/***************************************************************************
                          tracker.cpp  -  description
                             -------------------
    begin                : Wed Sep 27 2000
    copyright            : (C) 2000 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "tracker.h"

int Tracker::Tracker_Colors[] = {

	10, 20, 30,
	100, 200, 100,
	250, 250, 250,
	60, 70, 80,
	80, 90, 100,
	10, 50, 10,
	15, 80, 15,
	250, 250, 250,
	150, 150, 150,
	210, 210, 210,
	250, 100, 100,
	70, 110, 70,
};

void Tracker::allocate_colormap () {

	Gdk_Color tmpcolor;
	int i;

	for (i=0;i<Tracker_max_Colors*3;i+=3) {

                //tmpcolor=colors[i/3];
		//tmpcolor=colors[i/3];

		colors[i/3].red = Tracker_Colors[i] * 0xFFFF / 0xFF;
		colors[i/3].green = Tracker_Colors[i+1] * 0xFFFF / 0xFF;
		colors[i/3].blue = Tracker_Colors[i+2] * 0xFFFF / 0xFF;
	        get_colormap().alloc(colors[i/3]);
	}

}

gint Tracker::do_expose_event(GdkEventExpose* p0) {

	if (editor.song==NULL) {

		return 0;
	}


	editor.set_flag_redraw_all();

	queue_draw();

/*	if (song==NULL) {

		return 0;
	}

	adjust_editor();
	print_rows();
                 */
	return 0;

}

void Tracker::realize_impl() {

	Gdk_WindowAttr attributes,bs_attributes;
        int attributes_mask;

	set_flags(GTK_REALIZED);

//	attributes.x = widget->allocation.x;
//	attributes.y = widget->allocation.y;

	attributes->x=gtkobj()->allocation.x;
	attributes->y=gtkobj()->allocation.y;
	attributes->width = width();
	attributes->height = height();
	attributes->wclass = GDK_INPUT_OUTPUT;
	attributes->window_type = GDK_WINDOW_CHILD;
	attributes->event_mask = get_events () | GDK_EXPOSURE_MASK;
	attributes->visual = get_visual ();
	attributes->colormap = get_colormap ();	
	bs_attributes=attributes;
		

	attributes_mask = GDK_WA_X | GDK_WA_Y | GDK_WA_VISUAL | GDK_WA_COLORMAP;

//       widget->window = gdk_window_new (widget->parent->window, &attributes, attributes_mask);

	window.create(get_parent_window(), attributes, attributes_mask);
	gtkobj()->window=window;

	expose_event.connect(slot(this,&Tracker::do_expose_event));
//	draw.connect(slot(this,&Tracker::do_draw));

	allocate_colormap();

        bgcol.create(get_window());
	fgcol.create(get_window());
	cursorcol.create(get_window());
	sepcol.create(get_window());
	hlmajcol.create(get_window());
	hlmincol.create(get_window());
	bgselcol.create(get_window());
	fgselcol.create(get_window());
	hlselcol.create(get_window());
	sepcolnew.create(get_window());
	maskcol.create(get_window());
	fgcolinact.create(get_window());

	bgcol.set_foreground(colors[Col_BackGround]);
	fgcol.set_foreground(colors[Col_ForeGround]);
	cursorcol.set_foreground(colors[Col_Cursor]);
	sepcol.set_foreground(colors[Col_SepChannels]);
	sepcolnew.set_foreground(colors[Col_SepNewChannels]);
	hlmajcol.set_foreground(colors[Col_Row_Hilite_Major]);
	hlmincol.set_foreground(colors[Col_Row_Hilite_Minor]);
	bgselcol.set_foreground(colors[Col_BackGround_Selected]);
        fgselcol.set_foreground(colors[Col_ForeGround_Selected]);
	hlselcol.set_foreground(colors[Col_Row_Hilite_Selected]);
	maskcol.set_foreground(colors[Col_Mask]);
	fgcolinact.set_foreground(colors[Col_ForeGround_Inactive]);

	bgcol.set_exposures(1);
	window.set_user_data(gtkobj());
	window.set_background(colors[Col_BackGround]);
	
	backing_store=false;

	if (backing_store) {

		adjust_screen();
	} else {

		(Gdk_Drawable*)c_window=(Gdk_Drawable*)&window;
		font_draw.set_window((Gdk_Drawable*)c_window);	
	}



}

/*****************************************************
 *****************************************************
		DRAWING STUFF
 *****************************************************
 ****************************************************/
void Tracker::adjust_editor() {

	//editor.set_row_offset(50);
	editor.set_window_width(width());
	editor.set_window_height(height());
	editor.adjust_view_to_cursor();
}

void Tracker::print_top() {

	char column_string[12]={' ',' ','C','o','l','u','m','n',' ','0','0',0};
	char octave_string[4]={'O',':',' ',0};
	char mask_string[4]={'V','c','C',0};
	

	char pepe3[10]={'L','o','c','k',':',' ','X','X','X',0};

	char *tmpinstrname;
	int tmpinstrnamelength;
	int tmppasteinstrnamelength;
	int i,j,tmpint;

	c_window->draw_rectangle(bgcol ,TRUE ,0,0,editor.get_window_width(),editor.get_row_height()*2);

//	font_draw.do_string(&sepcolnew,0,editor.get_row_height(),"Edit Mask");	
	
	if (!editor.get_volume_mask()) mask_string[0]=' ';
	if (!editor.get_command_parameter_mask()) mask_string[1]=' ';
	if (!editor.get_controller_mask()) mask_string[2]=' ';

	octave_string[2]='0'+editor.get_default_octave();

	font_draw.do_string(&maskcol,0,editor.get_row_height(),octave_string);	
	font_draw.do_string(&maskcol,0,editor.get_row_height()*2,mask_string);	

	if (editor.is_locked_to_pattern()) {

		pepe3[6]='P';
		pepe3[7]='a';
		pepe3[8]='t';

	} else {

		pepe3[6]='A';
		pepe3[7]='l';
		pepe3[8]='l';
	}

	font_draw.do_string(&sepcolnew,editor.get_window_width()-editor.get_font_width()*3,editor.get_row_height()*2,"Pat");	
	
	font_draw.do_string(&maskcol,editor.get_window_width()-editor.get_font_width()*9,editor.get_row_height(),pepe3);	
	

	for (i=0;i<editor.get_visible_columns();i++) {

		char mute_string[18]={' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ','[','M',']',' ',' ',0};
		char pos_string[18]={' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',0};

		tmpint=editor.song->get_abs_column(editor.get_column_offset()+i);

		if ((editor.get_column_offset()>0) && (i==0)) {

			pos_string[0]='<';
			pos_string[1]='.';
		}

		if ( (i==editor.get_visible_columns()-1) && ( (editor.get_column_offset()+i)<(editor.song->get_abs_width()-1) ) ) {

			pos_string[16]='>';
			pos_string[15]='.';
		}

		if (!editor.song->get_instrument(editor.song->get_abs_track(editor.get_column_offset()+i))->mute) {

			mute_string[12]=' ';
			mute_string[13]=' ';
			mute_string[14]=' ';
		}



                column_string[9]='0'+tmpint / 10;
                column_string[10]='0'+tmpint % 10;
	
		font_draw.do_string(&sepcol,editor.left_numbers_width()+i*editor.get_column_width(),editor.get_row_height()*2,column_string);
		font_draw.do_string(&maskcol,editor.left_numbers_width()+i*editor.get_column_width(),editor.get_row_height()*2,mute_string);
		font_draw.do_string(&sepcolnew,editor.left_numbers_width()+i*editor.get_column_width(),editor.get_row_height()*2,pos_string);

		if (editor.song->get_abs_column(editor.get_column_offset()+i)==0) {

			c_window->draw_rectangle(sepcolnew , TRUE,editor.left_numbers_width()+i*editor.get_column_width()-5,0, 2 ,editor.get_row_height()*2);

			//draw insturment name in top of column                	
			tmpinstrnamelength=editor.song->get_instrument(editor.song->get_abs_track(editor.get_column_offset()+i))->name.length();
			(void*)tmpinstrname=malloc(tmpinstrnamelength+1);
			for (j=0;j<tmpinstrnamelength;j++)  tmpinstrname[j]=editor.song->get_instrument(editor.song->get_abs_track(editor.get_column_offset()+i))->name[j];

			tmppasteinstrnamelength=editor.song->get_track_width(editor.song->get_abs_track(editor.get_column_offset()+i))*CHARACTERS_PER_COLUMN-1;

                        if (tmpinstrnamelength>tmppasteinstrnamelength) {

				tmpinstrnamelength=tmppasteinstrnamelength;
			}

			tmpinstrname[tmpinstrnamelength]=0;

			font_draw.do_string(&sepcolnew,editor.left_numbers_width()+i*editor.get_column_width(),editor.get_font_height(),tmpinstrname);			
		
			free(tmpinstrname);

			
			
		}
	}
}

void Tracker::print_number(int rowofs,bool hilite_number) {

	string number_str;
	number_str=editor.get_number_string(rowofs);

	if ((rowofs<0) || rowofs>=editor.get_visible_rows()) return;

	if (hilite_number) {

		font_draw.do_string(&fgselcol,0,editor.top_data_height()+rowofs*editor.get_row_height()+editor.get_font_height(),number_str);
	} else {

		font_draw.do_string(&fgcol,0,editor.top_data_height()+rowofs*editor.get_row_height()+editor.get_font_height(),number_str);
        }

}

void Tracker::print_single_row(int rowofs) {
	
	int i;
        char pepe[19];
	int tmpnum;
	int current_row,real_row,real_pattern,y_offset;
	bool row_is_inactive;

	pepe[18]=0;

	if (rowofs<0) return;

        // CLEAR row

	current_row=(editor.get_row_offset()+rowofs);
        real_row=editor.song->get_abs_row(current_row);
        real_pattern=editor.song->get_abs_pattern(current_row);
	y_offset=editor.top_data_height()+rowofs*editor.get_row_height();

 	if ((real_row % editor.song->get_pattern_hl_major(real_pattern))==0) {

		c_window->draw_rectangle(hlmajcol ,TRUE ,0,y_offset,editor.get_window_width(),editor.get_row_height());

	} else if ((real_row % editor.song->get_pattern_hl_minor(real_pattern))==0)  {

		c_window->draw_rectangle(hlmincol ,TRUE ,0,y_offset,editor.get_window_width(),editor.get_row_height());

	} else {

		c_window->draw_rectangle(bgcol ,TRUE ,0,y_offset,editor.get_window_width(),editor.get_row_height());
	}

	// Draw notes and Vlines



	row_is_inactive=((current_row<editor.GetLowerLimit()) || (current_row>editor.GetUpperLimit()));

	for (i=0;i<editor.get_visible_columns();i++) {

		string note_str;
		note_str=editor.get_note_string(editor.get_column_offset()+i,current_row);
		
		if ( (editor.is_selection_active())
                     && (editor.get_column_offset()+i>=editor.get_selection_begin_x())
                     && (editor.get_column_offset()+i<=editor.get_selection_end_x())
                     && (editor.get_row_offset()+rowofs>=editor.get_selection_begin_y())
                     && (editor.get_row_offset()+rowofs<=editor.get_selection_end_y())
		    ) {	


			if ((editor.song->get_abs_row(editor.get_row_offset()+rowofs) % editor.song->get_pattern_hl_minor(editor.song->get_abs_pattern(editor.get_row_offset()+rowofs)))==0) {

				c_window->draw_rectangle(hlselcol , TRUE,editor.left_numbers_width()+i*editor.get_column_width(),editor.top_data_height()+rowofs*editor.get_row_height(),editor.get_column_width()-editor.get_font_width(),editor.get_row_height());
                        } else {

				c_window->draw_rectangle(bgselcol , TRUE,editor.left_numbers_width()+i*editor.get_column_width(),editor.top_data_height()+rowofs*editor.get_row_height(),editor.get_column_width()-editor.get_font_width(),editor.get_row_height());
			}

	                font_draw.do_string(&fgselcol,editor.left_numbers_width()+i*editor.get_column_width(),editor.top_data_height()+rowofs*editor.get_row_height()+editor.get_font_height(),note_str);
			
		} else 	{


			if (row_is_inactive) font_draw.do_string(&fgcolinact,editor.left_numbers_width()+i*editor.get_column_width(),editor.top_data_height()+rowofs*editor.get_row_height()+editor.get_font_height(),note_str);
			else font_draw.do_string(&fgcol,editor.left_numbers_width()+i*editor.get_column_width(),editor.top_data_height()+rowofs*editor.get_row_height()+editor.get_font_height(),note_str);		

		}

		if (editor.song->get_abs_column(editor.get_column_offset()+i)==0) {

			c_window->draw_rectangle(sepcolnew , TRUE,editor.left_numbers_width()+i*editor.get_column_width()-5,editor.top_data_height()+rowofs*editor.get_row_height(), 2 ,editor.get_row_height());
	
		} else {

	                c_window->draw_rectangle(sepcol , TRUE,editor.left_numbers_width()+i*editor.get_column_width()-5,editor.top_data_height()+rowofs*editor.get_row_height(), 1 ,editor.get_row_height());
		}
	}

	// Draw Numbers and Hlines
	      	
        if (!editor.song->get_abs_row(editor.get_row_offset()+rowofs)) {

        	tmpnum=editor.song->get_abs_pattern(editor.get_row_offset()+rowofs);
		if (tmpnum>99) pepe[0]='0'+(tmpnum/100) % 10; else pepe[0]=' ';
		if (tmpnum>9) pepe[1]='0'+(tmpnum/10) % 10; else pepe[1]=' ';
		pepe[2]='0'+(tmpnum) % 10;
		pepe[3]=0;


		c_window->draw_rectangle(sepcol,TRUE ,0,editor.top_data_height()+rowofs*editor.get_row_height(),editor.get_window_width()-editor.get_font_width()*3,1);
		c_window->draw_rectangle(sepcolnew,TRUE ,0,1+editor.top_data_height()+rowofs*editor.get_row_height(),editor.get_window_width()-editor.get_font_width()*3,1);

		font_draw.do_string(&sepcolnew,editor.get_window_width()-editor.get_font_width()*4,editor.top_data_height()+rowofs*editor.get_row_height()+editor.get_font_height(),(char*)&pepe);

	} else if (rowofs==0)  {

        	tmpnum=editor.song->get_abs_pattern(editor.get_row_offset());
		if (tmpnum>99) pepe[0]='0'+(tmpnum/100) % 10; else pepe[0]=' ';
		if (tmpnum>9) pepe[1]='0'+(tmpnum/10) % 10; else pepe[1]=' ';
		pepe[2]='0'+(tmpnum) % 10;
		pepe[3]=0;
		font_draw.do_string(&sepcolnew,editor.get_window_width()-editor.get_font_width()*4,editor.top_data_height()+rowofs*editor.get_row_height()+editor.get_font_height(),(char*)&pepe);
	}

	if (editor.is_player_active() && current_row==editor.get_playing_row()) {

		print_number(rowofs,true);
	} else {

		print_number(rowofs,false);
	}

}

void Tracker::print_rows() {

	int i;

	for (i=0;i<editor.get_visible_rows();i++) print_single_row (i);

}

void Tracker::print_cursor() {

	int xinit,yinit;
	
	const char cursor_spacing[] = {

		0 , //note
		2 , //octave
		4 , //volume 1
		5 , //volume 2
		7 , //command
		8 , //parameter 1
		9 , //parameter 2
		11, //controller 1
		12, //controller 2
		13, //controller 3
		15, //control param 1
		16 //control param 2
	};

	xinit=editor.left_numbers_width()+(editor.get_cursor_x()-editor.get_column_offset())*editor.get_column_width()+cursor_spacing[editor.get_cursor_field()]*editor.get_font_width();
 	yinit=editor.top_data_height()+(editor.get_cursor_y()-editor.get_row_offset())*editor.get_row_height();

	c_window->draw_rectangle(cursorcol,FALSE, xinit-2, yinit,editor.get_font_width()+4,editor.get_font_height()+3);
}


void Tracker::draw_impl(GdkRectangle* p0){

	int cursor_y_ofs_to_clear;
	if (!is_drawable()) return;
///	cout << "draw try!" << endl;

      	if (editor.song==NULL) return;

	if (editor.song->get_tracks()==0) {

		print_no_tracks();

		return ;

	}

	adjust_editor();
	adjust_screen();


	if (editor.flag_redraw_all()) {


		print_top();
		print_rows();
		print_cursor();

	} else {
		
		if (editor.flag_redraw_row()) {

			cursor_y_ofs_to_clear=editor.previous_cursor_y-editor.get_row_offset();

	                print_single_row(cursor_y_ofs_to_clear-1);
	                print_single_row(cursor_y_ofs_to_clear);
	                print_single_row(cursor_y_ofs_to_clear+1);

	                print_single_row(editor.get_cursor_y()-editor.get_row_offset());			
			print_cursor();
		}

		if (editor.flag_redraw_top()) {

                        print_top();
		}

	}
        update_playing_row();

	editor.previous_cursor_y=editor.get_cursor_y();
	editor.previous_cursor_x=editor.get_cursor_x();
	editor.clear_redraw_flags();

	redraw_screen();	
}

void Tracker::update_playing_row() {

	if (editor.flag_redraw_playing_row()) {

                if (!is_drawable()) return;

		adjust_screen();
		print_number(editor.get_playing_row()-editor.get_row_offset(),true);
		print_number(editor.get_old_playing_row()-editor.get_row_offset(),false);
                editor.clear_redraw_flags();
		redraw_screen();

	}

}

void Tracker::print_no_tracks() {

	c_window->draw_rectangle(bgcol,TRUE,0,0,width(),height());
	font_draw.do_string(&fgcol,width()/2-(strlen("[No Tracks Created]")/2)*editor.get_font_width(),height()/2,"[No Tracks Created]");
}


void Tracker::adjust_screen() {

	if (backing_store) {

		if ((old_width!=width()) || (old_height!=height())) {


			GdkPixmap *aux_pixmap;

			if (c_window!=NULL) delete c_window;


			int nwidth,nheight;
			nwidth=width();
			nheight=height();

			aux_pixmap=gdk_pixmap_new(window,width(),height(),-1);
			c_window=new(aux_pixmap) Gdk_Pixmap(window,nwidth,nheight,-1);

			old_width=nwidth;
			old_height=nheight;
			font_draw.set_window((Gdk_Drawable*)c_window);	
		}
	}
}

void Tracker::redraw_screen() {

	if (backing_store) {

		window.draw_pixmap(bgcol,*c_window,0,0,0,0);
	}
}

Tracker::Tracker(){

	old_width=-1;
	old_height=-1;
	c_window=NULL;	
}


void Tracker::link_to_song(Song *songptr) {

	editor.link_to_song(songptr);
#ifdef WIN32_ENABLED


	font.load("fixedsys");	
#else
        font.load("-adobe-courier-bold-r-normal--*-100-*-*-*-*-*-*");


#endif
	font_draw.set_font(&font);
	editor.set_font_width(font_draw.get_width());
	editor.set_font_height(font.ascent()+font.descent());
	

}
Tracker::~Tracker(){

	if (backing_store) {

		delete c_window;
	}
}


