/***************************************************************************
                          interface_keys.cpp  -  description
                             -------------------
    begin                : Sat Oct 7 2000
    copyright            : (C) 2000 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "interface.h"

bool previous_shift = false;

gint Interface::key_press_callback(GdkEventKey* event) {


	int tmpres;	
	bool alt,shift;
	int previous_cursor_x,previous_cursor_y;
	int current_pattern;
	bool capture_key_event=false;

	alt=event->state & GDK_MOD1_MASK;
	shift=event->state & GDK_SHIFT_MASK;

	if (shift && !previous_shift) tracker.editor.shift_selection_begin();
	if (!shift && previous_shift) tracker.editor.shift_selection_end();
        if (event->keyval>='a' && event->keyval<='z') event->keyval-=('a'-'A');

	/** GLOBAL KEYS! **/

	switch (event->keyval) {

                 case GDK_F1: {

                        if (main_notebook_current_page==0) show_help(0);
                        main_notebook.set_page(main_notebook_Help);

                 } break;

                 case GDK_F2: {

                        if (main_notebook_current_page==main_notebook_Patterns) break;
                        main_notebook.set_page(main_notebook_Patterns);
                        capture_key_event=true;
                } break;
                case GDK_F3: {

                        main_notebook.set_page(main_notebook_Track_Properties);

                } break;
		/*
                case GDK_F9: {

                        main_notebook.set_page(main_notebook_Order_List);

	        } break;
                case GDK_F10: {

                        main_notebook.set_page(main_notebook_Variables_and_Info);

                } break;
		*/
                case GDK_F11: {


                        main_notebook.set_page(main_notebook_Order_List);

                } break;
                case GDK_F12: {

                        main_notebook.set_page(main_notebook_Virtual_Devices);

                } break;

		case GDK_Escape: {

			popup_window_file();
		} break;
		case GDK_F5: {

			player->play(Player::PLAY_SONG);					
		} break;
		case GDK_F6: {

			player->play(Player::PLAY_PATTERN,tracker.editor.get_cursor_pattern());
		} break;
		case GDK_F7: {

			int current_order=song->find_order(tracker.editor.get_cursor_pattern());
			if (current_order!=-1) {

				player->play(Player::PLAY_SONG,tracker.editor.get_cursor_pattern(),tracker.editor.get_cursor_row(),current_order);
			} else {

				player->play(Player::PLAY_PATTERN,tracker.editor.get_cursor_pattern(),tracker.editor.get_cursor_row());
			}
		} break;
		case GDK_F8: {

			if (shift) {

				player->reset();
				
			} else {

				player->stop();					
			}

		} break;
		case GDK_KP_Divide: {
		
			tracker.editor.default_octave_lower();
			tracker.queue_draw();
		} break;
		case GDK_KP_Multiply: {
	
			tracker.editor.default_octave_raise();;
			tracker.queue_draw();
		} break;
		case GDK_Scroll_Lock: {
	
			tracker.editor.set_follow_song(!tracker.editor.is_following_song());
			tracker.queue_draw();
		} break;

	}

	if ((main_notebook_current_page==main_notebook_Patterns) && (song->get_tracks()>0)) {

	
		if (alt) {
	
			
			switch (event->keyval) {
	
				case 'B': {
	
					tracker.editor.mark_block_begining();
					tracker.queue_draw();
				} break;
	
				case 'E': {
	
					tracker.editor.mark_block_end();
					tracker.queue_draw();
				} break;
	
				case 'U': {
	
					tracker.editor.selection_release();
					tracker.queue_draw();
				} break;
	
	 			case 'L': {
	
					tracker.editor.mark_column_all();
					tracker.queue_draw();
				} break;
	 			case 'Q': {
	
					tracker.editor.selection_raise();
					tracker.queue_draw();
				} break;
	 			case 'A': {
	
					tracker.editor.selection_lower();
					tracker.queue_draw();
				} break;
	 			case 'F': {
	
					tracker.editor.pattern_expand();
					tracker.queue_draw();
				} break;
	 			case 'G': {
	
					tracker.editor.pattern_shrink();
					tracker.queue_draw();
				} break;
	 			case 'J': {
	                               		 popup_volume_scale = new Popup_Scale_Volume(tracker.editor.get_last_volume_scale());					
					 popup_volume_scale->button_ok.clicked.connect(slot(this,&Interface::popup_scale_volume_confirm));
				} break;
	 			case 'Z': {
	
					tracker.editor.selection_copy();
					tracker.editor.selection_zap();
					tracker.queue_draw();
				} break;
	 			case 'S': {
	
					tracker.editor.selection_controller_ramp();
					tracker.queue_draw();
				} break;
	 			case 'X': {
	
					tracker.editor.selection_parameter_ramp();
					tracker.queue_draw();
				} break;
	 			case 'K': {
	
					tracker.editor.selection_volume_ramp();
					tracker.queue_draw();
				} break;
	 			case 'C': {
	
					tracker.editor.selection_copy();
					tracker.queue_draw();
				} break;
	 			case 'O': {
	
					tracker.editor.selection_paste_overwrite();
					tracker.queue_draw();
				} break;
	 			case 'P': {
	
					tracker.editor.selection_paste_insert();
					tracker.queue_draw();
				} break;
	 			case 'M': {
	
					tracker.editor.selection_paste_mix();
					tracker.queue_draw();
				} break;
	 			case 'V': {
	
					tracker.editor.selection_set_volume_mask();
					tracker.queue_draw();
				} break;
	 			case 'W': {
	
					tracker.editor.selection_wipe_stray_volumes();
					tracker.queue_draw();
				} break;


				case ']': {

					player->stop();
					tracker.editor.add_column_to_current_track();
					tracker.queue_draw();
					player->reset();
				} break;
				case '{': {

					player->stop();
					tmpres=tracker.editor.remove_column_to_current_track();
					player->reset();
	
					tracker.queue_draw();
				} break;
	
			}
	
	
	
		} else {
	
	
			switch (event->keyval) {
				case GDK_F1: {
	
				} break;
				case GDK_F2: {

					if (capture_key_event) break;

					popup_pattern_properties= new PopUp_Pattern_Properties;
					current_pattern=song->get_abs_pattern(tracker.editor.get_cursor_y());
				
					popup_pattern_properties->spinbutton_highlight_major->set_value(song->get_pattern_hl_major(current_pattern));
					popup_pattern_properties->spinbutton_highlight_minor->set_value(song->get_pattern_hl_minor(current_pattern));
					popup_pattern_properties->spinbutton_pattern_length->set_value(song->get_pattern_length(current_pattern));
					popup_pattern_properties->spinbutton_pattern_extra->set_value(0);
					popup_pattern_properties->spinbutton_highlight_extra->set_value(0);
					popup_pattern_properties->button_apply.clicked.connect(slot(this,&Interface::popup_pattern_properties_confirm));


					//tracker.editor.set_cursor_mode(CURSOR_LOCKED_TO_PATTERN);	
					//tracker.queue_draw();

					} break;
				//case GDK_F3: {

				//	tracker.editor.set_editor_lock_mode(EDITOR_LOCK_MODE_PATTERN);
				//	tracker.queue_draw();
	
				//} break;
				case GDK_F4: {

					tracker.editor.lock_to_pattern(!tracker.editor.is_locked_to_pattern());
					tracker.queue_draw();
	
				} break;
				case GDK_F9: {

					if (song->get_instrument(tracker.editor.get_cursor_track())->mute) {

						player->unmute_track(tracker.editor.get_cursor_track());

					} else {
	
						player->mute_track(tracker.editor.get_cursor_track());

					}

				
					tracker.queue_draw();
				} break;
				case GDK_F10: {

					player->solo_track(tracker.editor.get_cursor_track());
					tracker.queue_draw();
				} break;
				case GDK_Up: {
					tracker.editor.cursor_step_up();
					tracker.queue_draw();
				} break;
				case GDK_Down: {
		
					tracker.editor.cursor_step_down();
					tracker.queue_draw();
				} break;
				case GDK_Left: {

					if (shift || alt) {
		
						tracker.editor.cursor_move_left(1);
					} else {
			
						tracker.editor.cursor_move_field_left();	
					}

					tracker.queue_draw();
				} break;
				case GDK_Right: {
					if (shift || alt) {
						tracker.editor.cursor_move_right(1);
					} else {
			
						tracker.editor.cursor_move_field_right();	
					}
					tracker.queue_draw();
				} break;
				case GDK_Page_Up: {
		
					tracker.editor.cursor_page_up();
					tracker.queue_draw();
				} break;
				case GDK_Page_Down: {
		
					tracker.editor.cursor_page_down();
					tracker.queue_draw();
				} break;
				case GDK_Home: {
		
					tracker.editor.cursor_home();
					tracker.queue_draw();
				} break;
				case GDK_End: {
		
					tracker.editor.cursor_end();
					tracker.queue_draw();
				} break;
				case GDK_Tab: {
		
					tracker.editor.cursor_tab();
					tracker.queue_draw();
				} break;
				case GDK_ISO_Left_Tab: {
		
					tracker.editor.cursor_back_tab();
					tracker.queue_draw();
				} break;
				case GDK_Insert: {
		
					tracker.editor.cursor_insert();
					tracker.queue_draw();
				} break;
				case GDK_Delete: {
		
					tracker.editor.cursor_delete();
					tracker.queue_draw();
				} break;
				case '+':
				case GDK_KP_Add: {
		
					tracker.editor.cursor_next_pattern();
					tracker.queue_draw();
				} break;
				case '-':
				case GDK_KP_Subtract: {
		
					tracker.editor.cursor_prev_pattern();;
					tracker.queue_draw();
				} break;
        			case ',':{
		
					tracker.editor.toggle_mask_at_cursor();
					tracker.queue_draw();
				} break;
				case '.':{
		
					tracker.editor.clear_field_at_cursor();
					tracker.queue_draw();
				} break;
				case '`':{
		
					tracker.editor.press_note_off_at_cursor();
					tracker.queue_draw();
				} break;
		
			}
		
		
			if ((event->keyval>='0' && event->keyval<='9') || (event->keyval>='A' && event->keyval<='Z')) {



				if ((tracker.editor.get_cursor_field()==0) && (event->keyval=='4')) {

					player->play_note_realtime(tracker.editor.get_cursor_track(),tracker.editor.get_cursor_pattern(),tracker.editor.get_cursor_column(),tracker.editor.get_cursor_row());
					tracker.editor.cursor_step_down();

				} else if ((tracker.editor.get_cursor_field()==0) && (event->keyval=='8')) {

					player->play_row_realtime(tracker.editor.get_cursor_pattern(),tracker.editor.get_cursor_row());
					tracker.editor.cursor_step_down();


                                } else {

					previous_cursor_x=tracker.editor.get_cursor_x();
					previous_cursor_y=tracker.editor.get_cursor_y();
	
					if (tracker.editor.press_key_at_cursor(event->keyval)) {
	
						if (event->keyval!='`') {

							player->play_note_realtime(
								song->get_abs_track(previous_cursor_x),
								song->get_abs_pattern(previous_cursor_y),
                                                                song->get_abs_column(previous_cursor_x),
                                                                song->get_abs_row(previous_cursor_y)
							);

						}
					}

				}

				tracker.queue_draw();
			}
	

		}

	capture_key_event=true;

	} else if (main_notebook_current_page==main_notebook_Order_List) {

		switch (event->keyval) {

			case GDK_Up: {

				tracker.editor.orderlist_move_up();
			} break;
			case GDK_Down: {

				tracker.editor.orderlist_move_down();
			} break;
			case GDK_Left: {

				tracker.editor.orderlist_move_left();
			} break;
			case GDK_Right: {

				tracker.editor.orderlist_move_right();
			} break;
			case '0'...'9': {

				tracker.editor.orderlist_insert_value(event->keyval-'0');
			} break;
			case GDK_KP_Add:
			case '+': {

				tracker.editor.orderlist_add_separator();
			} break;
			case '.': {

				tracker.editor.orderlist_clear_order();
			} break;
			case GDK_Page_Up: {

				tracker.editor.orderlist_page_up();
			} break;
			case GDK_Page_Down: {

				tracker.editor.orderlist_page_down();
			} break;
			case GDK_Insert: {

				tracker.editor.orderlist_insert();
			} break;
			case GDK_Delete: {

				tracker.editor.orderlist_delete();
			} break;
			case 'N': {

				tracker.editor.orderlist_increase_order();
			} break;
			case 'R': {

//				orderlist.InsertRepeat();
			} break;


		}
	
		orderlist.queue_draw();

		capture_key_event=true;
	}

	previous_shift=shift;

	if (capture_key_event) {

		gtk_signal_emit_stop_by_name(GTK_OBJECT(this->gtkobj()),"key_press_event");
		return TRUE;
	} else {

		return FALSE;
	}
	


}


gint Interface::patch_key_press_callback(GdkEventKey* event,bool release) {

	if (release && key_is_pressed(event->keyval)) {

		return 0;
	}

	if (!release && pressed_keys[event->keyval&0xFF]) {

		return 0;
	} else {

		pressed_keys[event->keyval&0xFF]=!release;
	}

        if (main_notebook_current_page!=main_notebook_Track_Properties) return 0;
	if (GTK_WINDOW(this->gtkobj())->focus_widget==NULL) return 0;

        string type_name=gtk_type_name(GTK_OBJECT_TYPE(GTK_WINDOW(this->gtkobj())->focus_widget));
	int pressed_note;

        if (! ((event->keyval>='a' && event->keyval<='z') ||
            (event->keyval>='A' && event->keyval<='Z') ||
            (event->keyval>='0' && event->keyval<='9')) ) return 0;


        if (event->keyval>='a' && event->keyval<='z') event->keyval-=('a'-'A');

        if (type_name=="Gtk__Entry") return 0; // dont bully the entries
        if (type_name=="Gtk__SpinButton") {

		if ((event->keyval>='0' || event->keyval<='9')) return 0; // spinbuttons dont want non-numbers
	}

        pressed_note=tracker.editor.get_note_from_key(event->keyval);

	if ((selected_track<0) || (selected_track>song->get_tracks())) return 0;

        if (release) {

		player->send_direct_note_off(selected_track,pressed_note,64);

	} else {

		player->send_direct_note_on(selected_track,pressed_note,song->get_instrument(selected_track)->def_volume.get());

	}


        return 0;
}

void Interface::main_notebook_page_switched(Gtk::Notebook_Helpers::Page *page,unsigned int page_number) {

	if (page_number==main_notebook_Help) {
	
		show_help(main_notebook_current_page);
	}
	
	main_notebook_current_page=page_number;
	
	if (page_number==main_notebook_Patterns) {

		tracker.editor.set_flag_redraw_all();
		tracker.queue_draw();
	}

	if (page_number==main_notebook_System) {

		update_system_status_box();
	}

}
