/* ScummVM - Scumm Interpreter
 * Copyright (C) 2002-2004 The ScummVM project
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Header: /cvsroot/scummvm/scummvm/scumm/smush/codec1.cpp,v 1.14 2004/01/30 02:14:29 sev Exp $
 *
 */

#include "stdafx.h"
#include "common/scummsys.h"

namespace Scumm {

void smush_decode_codec1(byte *dst, byte *src, int left, int top, int height, int width, int dstWidth) {
	byte val, code;
	int32 length;
	int h = height, size_line;

	dst += top * dstWidth;
	for (h = 0; h < height; h++) {
		size_line = READ_LE_UINT16(src);
		src += 2;
		dst += left;
		while (size_line > 0) {
			code = *src++;
			size_line--;
			length = (code >> 1) + 1;
			if (code & 1) {
				val = *src++;
				size_line--;
				if (val)
					memset(dst, val, length);
				dst += length;
			} else {
				size_line -= length;
				while (length--) {
					val = *src++;
					if (val)
						*dst = val;
					dst++;
				}
			}
		}
		dst += dstWidth - left - width;
	}
}

} // End of namespace Scumm
