/* Tiger: A Fast New Hash Function
 *
 * Ross Anderson and Eli Biham
 *
 * From the homepage (http://www.cs.technion.ac.il/~biham/Reports/Tiger/):
 *
 * Tiger has no usage restrictions nor patents. It can be used freely, 
 * with the reference implementation, with other implementations or with 
 * a modification to the reference implementation (as long as it still 
 * implements Tiger). We only ask you to let us know about your 
 * implementation and to cite the origin of Tiger and of the reference 
 * implementation. 
 *
 *
 * The authors' home pages can be found both in 
 * http://www.cs.technion.ac.il/~biham/ and in 
 * http://www.cl.cam.ac.uk/users/rja14/.
 * The authors' email addresses are biham@cs.technion.ac.il 
 * and rja14@cl.cam.ac.uk.
 */

#include "config_xor.h"


#ifndef HAVE_LONG_LONG


/* sboxes32.c: Tiger S boxes for 32-bit-only compilers */
typedef unsigned long word32;
word32 tiger_table[4*256][2] = {
  { 0xF7E90C5E, 0x02AAB17C /*    0 */},  {  0xE243A8EC, 0xAC424B03 /*    1 */},
  { 0x0DD5FCD3, 0x72CD5BE3 /*    2 */},  {  0xF6F97F3A, 0x6D019B93 /*    3 */},
  { 0xD21F9193, 0xCD9978FF /*    4 */},  {  0x708029E2, 0x7573A1C9 /*    5 */},
  { 0x922A83C3, 0xB164326B /*    6 */},  {  0x04915870, 0x46883EEE /*    7 */},
  { 0x7103ECE6, 0xEAACE305 /*    8 */},  {  0x08A3535C, 0xC54169B8 /*    9 */},
  { 0x8DDEC47C, 0x4CE75491 /*   10 */},  {  0xDC0DF40C, 0x0AA2F4DF /*   11 */},
  { 0xA74DBEFA, 0x10B76F18 /*   12 */},  {  0x5AD1AB6A, 0xC6CCB623 /*   13 */},
  { 0x572FE2FF, 0x13726121 /*   14 */},  {  0x199D921E, 0x1A488C6F /*   15 */},
  { 0xDA0007CA, 0x4BC9F9F4 /*   16 */},  {  0xE85241C7, 0x26F5E6F6 /*   17 */},
  { 0xEA5947B6, 0x859079DB /*   18 */},  {  0xC99E8C92, 0x4F1885C5 /*   19 */},
  { 0xA96F864B, 0xD78E761E /*   20 */},  {  0x52B5C17D, 0x8E36428C /*   21 */},
  { 0x373063C1, 0x69CF6827 /*   22 */},  {  0x9BB4C56E, 0xB607C93D /*   23 */},
  { 0x0E76B5EA, 0x7D820E76 /*   24 */},  {  0xF07FDC42, 0x645C9CC6 /*   25 */},
  { 0x243342E0, 0xBF38A078 /*   26 */},  {  0x9D2E7D04, 0x5F6B343C /*   27 */},
  { 0x600B0EC6, 0xF2C28AEB /*   28 */},  {  0x7254BCAC, 0x6C0ED85F /*   29 */},
  { 0xA4DB4FE5, 0x71592281 /*   30 */},  {  0xCE0FED9F, 0x1967FA69 /*   31 */},
  { 0xB96545DB, 0xFD5293F8 /*   32 */},  {  0xF2A7600B, 0xC879E9D7 /*   33 */},
  { 0x0193194E, 0x86024892 /*   34 */},  {  0x2D9CC0B3, 0xA4F9533B /*   35 */},
  { 0x15957613, 0x9053836C /*   36 */},  {  0xFC357BF1, 0xDB6DCF8A /*   37 */},
  { 0x7A370F57, 0x18BEEA7A /*   38 */},  {  0x50B99066, 0x037117CA /*   39 */},
  { 0x74424A35, 0x6AB30A97 /*   40 */},  {  0xE325249B, 0xF4E92F02 /*   41 */},
  { 0x061CCAE1, 0x7739DB07 /*   42 */},  {  0xECA42A05, 0xD8F3B49C /*   43 */},
  { 0x51382F73, 0xBD56BE3F /*   44 */},  {  0x43B0BB28, 0x45FAED58 /*   45 */},
  { 0x11BF1F83, 0x1C813D5C /*   46 */},  {  0xD75FA169, 0x8AF0E4B6 /*   47 */},
  { 0x87AD9999, 0x33EE18A4 /*   48 */},  {  0xB1C94410, 0x3C26E8EA /*   49 */},
  { 0xC0A822F9, 0xB510102B /*   50 */},  {  0x0CE6123B, 0x141EEF31 /*   51 */},
  { 0x59DDB154, 0xFC65B900 /*   52 */},  {  0xC5E0E607, 0xE0158640 /*   53 */},
  { 0x26C3A3CF, 0x884E0798 /*   54 */},  {  0x23C535FD, 0x930D0D95 /*   55 */},
  { 0x4E9A2B00, 0x35638D75 /*   56 */},  {  0x40469DD5, 0x4085FCCF /*   57 */},
  { 0x8BE23A4C, 0xC4B17AD2 /*   58 */},  {  0x6A3E6A2E, 0xCAB2F0FC /*   59 */},
  { 0x6B943FCD, 0x2860971A /*   60 */},  {  0x12E30446, 0x3DDE6EE2 /*   61 */},
  { 0xE01765AE, 0x6222F32A /*   62 */},  {  0x478308FE, 0x5D550BB5 /*   63 */},
  { 0xA0EDA22A, 0xA9EFA98D /*   64 */},  {  0x86C40DA7, 0xC351A716 /*   65 */},
  { 0x9C867C84, 0x1105586D /*   66 */},  {  0xFDA22853, 0xDCFFEE85 /*   67 */},
  { 0x2C5EEF76, 0xCCFBD026 /*   68 */},  {  0x8990D201, 0xBAF294CB /*   69 */},
  { 0x2AFAD975, 0xE69464F5 /*   70 */},  {  0xDF133E14, 0x94B013AF /*   71 */},
  { 0x2823C958, 0x06A7D1A3 /*   72 */},  {  0x30F61119, 0x6F95FE51 /*   73 */},
  { 0x462C06C0, 0xD92AB34E /*   74 */},  {  0x887C71D2, 0xED7BDE33 /*   75 */},
  { 0x6518393E, 0x79746D6E /*   76 */},  {  0x5D713329, 0x5BA41938 /*   77 */},
  { 0x48A97564, 0x7C1BA6B9 /*   78 */},  {  0x7BFDAC67, 0x31987C19 /*   79 */},
  { 0x4B053D02, 0xDE6C23C4 /*   80 */},  {  0xD002D64D, 0x581C49FE /*   81 */},
  { 0x38261571, 0xDD474D63 /*   82 */},  {  0xE473D062, 0xAA4546C3 /*   83 */},
  { 0x9455F860, 0x928FCE34 /*   84 */},  {  0xCAAB94D9, 0x48161BBA /*   85 */},
  { 0x770E6F68, 0x63912430 /*   86 */},  {  0x02C6641C, 0x6EC8A5E6 /*   87 */},
  { 0x337DDD2B, 0x87282515 /*   88 */},  {  0x034B701B, 0x2CDA6B42 /*   89 */},
  { 0x81CB096D, 0xB03D37C1 /*   90 */},  {  0x66C71C6F, 0xE1084382 /*   91 */},
  { 0xEB51B255, 0x2B3180C7 /*   92 */},  {  0x96C08BBC, 0xDF92B82F /*   93 */},
  { 0xA632F3BA, 0x5C68C8C0 /*   94 */},  {  0x1C3D0556, 0x5504CC86 /*   95 */},
  { 0x5FB26B8F, 0xABBFA4E5 /*   96 */},  {  0xB3BACEB4, 0x41848B0A /*   97 */},
  { 0xAA445D32, 0xB334A273 /*   98 */},  {  0xA85AD881, 0xBCA696F0 /*   99 */},
  { 0xB528D56C, 0x24F6EC65 /*  100 */},  {  0x90F4524A, 0x0CE1512E /*  101 */},
  { 0x5506D35A, 0x4E9DD79D /*  102 */},  {  0xC6CE9779, 0x258905FA /*  103 */},
  { 0x3E109B33, 0x2019295B /*  104 */},  {  0x73A054CC, 0xF8A9478B /*  105 */},
  { 0x34417EB0, 0x2924F2F9 /*  106 */},  {  0x536D1BC4, 0x3993357D /*  107 */},
  { 0x1DB6FF8B, 0x38A81AC2 /*  108 */},  {  0x7D6016BF, 0x47C4FBF1 /*  109 */},
  { 0x7667E3F5, 0x1E0FAADD /*  110 */},  {  0x938BEB96, 0x7ABCFF62 /*  111 */},
  { 0x8FC179C9, 0xA78DAD94 /*  112 */},  {  0x2911E50D, 0x8F1F98B7 /*  113 */},
  { 0x27121A91, 0x61E48EAE /*  114 */},  {  0x31859808, 0x4D62F7AD /*  115 */},
  { 0xEF5CEAEB, 0xECEBA345 /*  116 */},  {  0xBC9684CE, 0xF5CEB25E /*  117 */},
  { 0xB7F76221, 0xF633E20C /*  118 */},  {  0xAB8293E4, 0xA32CDF06 /*  119 */},
  { 0xA5EE2CA4, 0x985A202C /*  120 */},  {  0xCC8A8FB1, 0xCF0B8447 /*  121 */},
  { 0x979859A3, 0x9F765244 /*  122 */},  {  0xA1240017, 0xA8D516B1 /*  123 */},
  { 0xBB5DC726, 0x0BD7BA3E /*  124 */},  {  0xB86ADB39, 0xE54BCA55 /*  125 */},
  { 0x6C478063, 0x1D7A3AFD /*  126 */},  {  0xE7669EDD, 0x519EC608 /*  127 */},
  { 0xD149AA23, 0x0E5715A2 /*  128 */},  {  0x848FF194, 0x177D4571 /*  129 */},
  { 0x41014C22, 0xEEB55F32 /*  130 */},  {  0x3A6E2EC2, 0x0F5E5CA1 /*  131 */},
  { 0x75F5C361, 0x8029927B /*  132 */},  {  0xC3D6E436, 0xAD139FAB /*  133 */},
  { 0x4CCF402F, 0x0D5DF1A9 /*  134 */},  {  0xBEA5DFC8, 0x3E8BD948 /*  135 */},
  { 0xBD3FF77E, 0xA5A0D357 /*  136 */},  {  0x1F74F645, 0xA2D12E25 /*  137 */},
  { 0x5E81A082, 0x66FD9E52 /*  138 */},  {  0x7F687A49, 0x2E0C90CE /*  139 */},
  { 0xBA973BC5, 0xC2E8BCBE /*  140 */},  {  0xE509745F, 0x000001BC /*  141 */},
  { 0xE6DAB3D6, 0x423777BB /*  142 */},  {  0xAEF06EB5, 0xD1661C7E /*  143 */},
  { 0x4DAACFD8, 0xA1781F35 /*  144 */},  {  0x2B16AFFC, 0x2D11284A /*  145 */},
  { 0xFA891D1F, 0xF1FC4F67 /*  146 */},  {  0xCB920ADA, 0x73ECC25D /*  147 */},
  { 0xC2A12651, 0xAE610C22 /*  148 */},  {  0xD356B78A, 0x96E0A810 /*  149 */},
  { 0x2FE7870F, 0x5A9A381F /*  150 */},  {  0xE94E5530, 0xD5AD62ED /*  151 */},
  { 0x368D1427, 0xD225E5E8 /*  152 */},  {  0xC7AF4631, 0x65977B70 /*  153 */},
  { 0xDE39D74F, 0x99F889B2 /*  154 */},  {  0x54E1D143, 0x233F30BF /*  155 */},
  { 0xD9A63C97, 0x9A9675D3 /*  156 */},  {  0xF334F9A8, 0x5470554F /*  157 */},
  { 0x4A4F5688, 0x166ACB74 /*  158 */},  {  0xB2E4AEAD, 0x70C74CAA /*  159 */},
  { 0x6F294D12, 0xF0D09164 /*  160 */},  {  0x684031D1, 0x57B82A89 /*  161 */},
  { 0x61BE0B6B, 0xEFD95A5A /*  162 */},  {  0x69F2F29A, 0x2FBD12E9 /*  163 */},
  { 0xFEFF9FE8, 0x9BD37013 /*  164 */},  {  0xD6085A06, 0x3F9B0404 /*  165 */},
  { 0x166CFE15, 0x4940C1F3 /*  166 */},  {  0xCDF3DEFB, 0x09542C4D /*  167 */},
  { 0x85CD5CE3, 0xB4C52183 /*  168 */},  {  0x4462A641, 0xC935B7DC /*  169 */},
  { 0x8ED3B63F, 0x3417F8A6 /*  170 */},  {  0x5B215B40, 0xB8095929 /*  171 */},
  { 0x3B8C8572, 0xF99CDAEF /*  172 */},  {  0xF8FCB95D, 0x018C0614 /*  173 */},
  { 0x1A3ACDF3, 0x1B14ACCD /*  174 */},  {  0x00BB732D, 0x84D471F2 /*  175 */},
  { 0x95E8DA16, 0xC1A3110E /*  176 */},  {  0xBF1A82B8, 0x430A7220 /*  177 */},
  { 0x39DF210E, 0xB77E090D /*  178 */},  {  0x3CD05E9D, 0x5EF4BD9F /*  179 */},
  { 0x7E57A444, 0x9D4FF6DA /*  180 */},  {  0x83D4A5F8, 0xDA1D60E1 /*  181 */},
  { 0x17998E47, 0xB287C384 /*  182 */},  {  0x1BB31886, 0xFE3EDC12 /*  183 */},
  { 0x980CCBEF, 0xC7FE3CCC /*  184 */},  {  0x189BFD03, 0xE46FB590 /*  185 */},
  { 0x9A4C57DC, 0x3732FD46 /*  186 */},  {  0x7CF1AD65, 0x7EF700A0 /*  187 */},
  { 0xA31D8859, 0x59C64468 /*  188 */},  {  0xD45B61F6, 0x762FB0B4 /*  189 */},
  { 0x99047718, 0x155BAED0 /*  190 */},  {  0x3D50BAA6, 0x68755E4C /*  191 */},
  { 0x22D8B4DF, 0xE9214E7F /*  192 */},  {  0x2EAC95F4, 0x2ADDBF53 /*  193 */},
  { 0xB4BD0109, 0x32AE3909 /*  194 */},  {  0xB08E3450, 0x834DF537 /*  195 */},
  { 0x4220728D, 0xFA209DA8 /*  196 */},  {  0x9EFE23F7, 0x9E691D9B /*  197 */},
  { 0xC4AE8D7F, 0x0446D288 /*  198 */},  {  0xE169785B, 0x7B4CC524 /*  199 */},
  { 0x35CA1385, 0x21D87F01 /*  200 */},  {  0x137B8AA5, 0xCEBB400F /*  201 */},
  { 0x580796BE, 0x272E2B66 /*  202 */},  {  0x25C2B0DE, 0x36122641 /*  203 */},
  { 0xAD1EFBB2, 0x057702BD /*  204 */},  {  0xACF84BE9, 0xD4BABB8E /*  205 */},
  { 0x641BC67B, 0x91583139 /*  206 */},  {  0x8036E024, 0x8BDC2DE0 /*  207 */},
  { 0xF49F68ED, 0x603C8156 /*  208 */},  {  0xDBEF5111, 0xF7D236F7 /*  209 */},
  { 0x8AD21E80, 0x9727C459 /*  210 */},  {  0x670A5FD7, 0xA08A0896 /*  211 */},
  { 0x09EBA9CB, 0xCB4A8F43 /*  212 */},  {  0x0F7036A1, 0x81AF564B /*  213 */},
  { 0x78199ABD, 0xC0B99AA7 /*  214 */},  {  0x3FC8E952, 0x959F1EC8 /*  215 */},
  { 0x794A81B9, 0x8C505077 /*  216 */},  {  0x056338F0, 0x3ACAAF8F /*  217 */},
  { 0x627A6778, 0x07B43F50 /*  218 */},  {  0xF5ECCC77, 0x4A44AB49 /*  219 */},
  { 0xB679EE98, 0x3BC3D6E4 /*  220 */},  {  0xCF14108C, 0x9CC0D4D1 /*  221 */},
  { 0x206BC8A0, 0x4406C00B /*  222 */},  {  0xC8D72D89, 0x82A18854 /*  223 */},
  { 0x5C3C432C, 0x67E366B3 /*  224 */},  {  0x102B37F2, 0xB923DD61 /*  225 */},
  { 0xD884271D, 0x56AB2779 /*  226 */},  {  0xFF1525AF, 0xBE83E1B0 /*  227 */},
  { 0x217E49A9, 0xFB7C65D4 /*  228 */},  {  0x6D48E7D4, 0x6BDBE0E7 /*  229 */},
  { 0x45D9179E, 0x08DF8287 /*  230 */},  {  0xDD53BD34, 0x22EA6A9A /*  231 */},
  { 0x5622200A, 0xE36E141C /*  232 */},  {  0x8CB750EE, 0x7F805D1B /*  233 */},
  { 0x9F58E837, 0xAFE5C7A5 /*  234 */},  {  0x4FB1C23C, 0xE27F996A /*  235 */},
  { 0x0775F0D0, 0xD3867DFB /*  236 */},  {  0x6E88891A, 0xD0E673DE /*  237 */},
  { 0xAFB86C25, 0x123AEB9E /*  238 */},  {  0xC145B895, 0x30F1D5D5 /*  239 */},
  { 0xEE7269E7, 0xBB434A2D /*  240 */},  {  0xF931FA38, 0x78CB67EC /*  241 */},
  { 0x323BBF9C, 0xF33B0372 /*  242 */},  {  0xFB279C74, 0x52D66336 /*  243 */},
  { 0x0AFB4EAA, 0x505F33AC /*  244 */},  {  0xA2CCE187, 0xE8A5CD99 /*  245 */},
  { 0x1E2D30BB, 0x53497480 /*  246 */},  {  0xD5876D90, 0x8D2D5711 /*  247 */},
  { 0x91BC038E, 0x1F1A4128 /*  248 */},  {  0x82E56648, 0xD6E2E71D /*  249 */},
  { 0x497732B7, 0x74036C3A /*  250 */},  {  0x6361F5AB, 0x89B67ED9 /*  251 */},
  { 0xF1EA02A2, 0xFFED95D8 /*  252 */},  {  0x1464D43D, 0xE72B3BD6 /*  253 */},
  { 0x0BDC4820, 0xA6300F17 /*  254 */},  {  0xED78A77A, 0xEBC18760 /*  255 */},
  { 0x05A12138, 0xE6A6BE5A /*  256 */},  {  0xB4F87C98, 0xB5A122A5 /*  257 */},
  { 0x140B6990, 0x563C6089 /*  258 */},  {  0x391F5DD5, 0x4C46CB2E /*  259 */},
  { 0xC9B79434, 0xD932ADDB /*  260 */},  {  0x2015AFF5, 0x08EA70E4 /*  261 */},
  { 0x3E478CF1, 0xD765A667 /*  262 */},  {  0xAB278D99, 0xC4FB757E /*  263 */},
  { 0x2D6E0692, 0xDF11C686 /*  264 */},  {  0x0D7F3B16, 0xDDEB84F1 /*  265 */},
  { 0xA665EA04, 0x6F2EF604 /*  266 */},  {  0xF0E0DFB3, 0x4A8E0F0F /*  267 */},
  { 0x3DBCBA51, 0xA5EDEEF8 /*  268 */},  {  0x0EA4371E, 0xFC4F0A2A /*  269 */},
  { 0x5CB38429, 0xE83E1DA8 /*  270 */},  {  0xBA1B1CE2, 0xDC8FF882 /*  271 */},
  { 0x8353E80D, 0xCD45505E /*  272 */},  {  0xD4DB0717, 0x18D19A00 /*  273 */},
  { 0xA5F38101, 0x34A0CFED /*  274 */},  {  0x8887CAF2, 0x0BE77E51 /*  275 */},
  { 0xB3C45136, 0x1E341438 /*  276 */},  {  0x9089CCF9, 0xE05797F4 /*  277 */},
  { 0xF2591D14, 0xFFD23F9D /*  278 */},  {  0x8595C5CD, 0x543DDA22 /*  279 */},
  { 0x99052A33, 0x661F81FD /*  280 */},  {  0xDB0F7B76, 0x8736E641 /*  281 */},
  { 0x418E5307, 0x15227725 /*  282 */},  {  0x162EB2FA, 0xE25F7F46 /*  283 */},
  { 0x6C13D9FE, 0x48A8B212 /*  284 */},  {  0x92E76EEA, 0xAFDC5417 /*  285 */},
  { 0xC6D1898F, 0x03D912BF /*  286 */},  {  0x1B83F51B, 0x31B1AAFA /*  287 */},
  { 0xE42AB7D9, 0xF1AC2796 /*  288 */},  {  0xFCD2EBAC, 0x40A3A7D7 /*  289 */},
  { 0x0AFBBCC5, 0x1056136D /*  290 */},  {  0x9A6D0C85, 0x7889E1DD /*  291 */},
  { 0x2A7974AA, 0xD3352578 /*  292 */},  {  0x078AC09B, 0xA7E25D09 /*  293 */},
  { 0xEAC6EDD0, 0xBD4138B3 /*  294 */},  {  0x71EB9E70, 0x920ABFBE /*  295 */},
  { 0x4FC2625C, 0xA2A5D0F5 /*  296 */},  {  0x0B1290A3, 0xC054E36B /*  297 */},
  { 0x62FE932B, 0xF6DD59FF /*  298 */},  {  0x11A8AC7D, 0x35373545 /*  299 */},
  { 0x72FADCD4, 0xCA845E91 /*  300 */},  {  0x329D20DC, 0x84F82B60 /*  301 */},
  { 0xCD672F18, 0x79C62CE1 /*  302 */},  {  0xD124642C, 0x8B09A2AD /*  303 */},
  { 0x19D9E726, 0xD0C1E96A /*  304 */},  {  0x4BA9500C, 0x5A786A9B /*  305 */},
  { 0x634C43F3, 0x0E020336 /*  306 */},  {  0xEB66D822, 0xC17B474A /*  307 */},
  { 0xEC9BAAC2, 0x6A731AE3 /*  308 */},  {  0xE0840258, 0x8226667A /*  309 */},
  { 0x91CAECA5, 0x67D45676 /*  310 */},  {  0x4875ADB5, 0x1D94155C /*  311 */},
  { 0x5B813FDF, 0x6D00FD98 /*  312 */},  {  0xB774CD06, 0x51286EFC /*  313 */},
  { 0x1FA744AF, 0x5E883447 /*  314 */},  {  0xE761AE2E, 0xF72CA0AE /*  315 */},
  { 0xAEE8E09A, 0xBE40E4CD /*  316 */},  {  0x5118F665, 0xE9970BBB /*  317 */},
  { 0x33DF1964, 0x726E4BEB /*  318 */},  {  0x29199762, 0x703B0007 /*  319 */},
  { 0xF5EF30A7, 0x4631D816 /*  320 */},  {  0x1504A6BE, 0xB880B5B5 /*  321 */},
  { 0x7ED84B6C, 0x641793C3 /*  322 */},  {  0xF6E97D96, 0x7B21ED77 /*  323 */},
  { 0x2EF96B73, 0x77630631 /*  324 */},  {  0xE86FF3F4, 0xAE528948 /*  325 */},
  { 0x86A3F8F8, 0x53DBD7F2 /*  326 */},  {  0x4CFC1063, 0x16CADCE7 /*  327 */},
  { 0xFA52C6DD, 0x005C19BD /*  328 */},  {  0x64D46AD3, 0x68868F5D /*  329 */},
  { 0xCF1E186A, 0x3A9D512C /*  330 */},  {  0x385660AE, 0x367E62C2 /*  331 */},
  { 0x77DCB1D7, 0xE359E7EA /*  332 */},  {  0x749ABE6E, 0x526C0773 /*  333 */},
  { 0xD09F734B, 0x735AE5F9 /*  334 */},  {  0x8A558BA8, 0x493FC7CC /*  335 */},
  { 0x3041AB45, 0xB0B9C153 /*  336 */},  {  0x470A59BD, 0x321958BA /*  337 */},
  { 0x5F46C393, 0x852DB00B /*  338 */},  {  0xD336B0E5, 0x91209B2B /*  339 */},
  { 0x659EF19F, 0x6E604F7D /*  340 */},  {  0x782CCB24, 0xB99A8AE2 /*  341 */},
  { 0xC814C4C7, 0xCCF52AB6 /*  342 */},  {  0xBE11727B, 0x4727D9AF /*  343 */},
  { 0x0121B34D, 0x7E950D0C /*  344 */},  {  0x70AD471F, 0x756F4356 /*  345 */},
  { 0x615A6849, 0xF5ADD442 /*  346 */},  {  0x80B9957A, 0x4E87E099 /*  347 */},
  { 0x50AEE355, 0x2ACFA1DF /*  348 */},  {  0xFD2FD556, 0xD898263A /*  349 */},
  { 0xD80C8FD6, 0xC8F4924D /*  350 */},  {  0x754A173A, 0xCF99CA3D /*  351 */},
  { 0xAF91BF3C, 0xFE477BAC /*  352 */},  {  0xD690C12D, 0xED5371F6 /*  353 */},
  { 0x5E687094, 0x831A5C28 /*  354 */},  {  0x3708A0A4, 0xC5D3C90A /*  355 */},
  { 0x17D06580, 0x0F7F9037 /*  356 */},  {  0xB8FDF27F, 0x19F9BB13 /*  357 */},
  { 0x4D502843, 0xB1BD6F1B /*  358 */},  {  0x8FFF4012, 0x1C761BA3 /*  359 */},
  { 0xE2E21F3B, 0x0D1530C4 /*  360 */},  {  0xA7372C8A, 0x8943CE69 /*  361 */},
  { 0xFEB5CE66, 0xE5184E11 /*  362 */},  {  0xBD736621, 0x618BDB80 /*  363 */},
  { 0x8B574D0B, 0x7D29BAD6 /*  364 */},  {  0x25E6FE5B, 0x81BB613E /*  365 */},
  { 0xBC07913F, 0x071C9C10 /*  366 */},  {  0x09AC2D97, 0xC7BEEB79 /*  367 */},
  { 0x3BC5D757, 0xC3E58D35 /*  368 */},  {  0xF38F61E8, 0xEB017892 /*  369 */},
  { 0x9B1CC21A, 0xD4EFFB9C /*  370 */},  {  0xF494F7AB, 0x99727D26 /*  371 */},
  { 0x956B3E03, 0xA3E063A2 /*  372 */},  {  0x4AA09C30, 0x9D4A8B9A /*  373 */},
  { 0x00090FB4, 0x3F6AB7D5 /*  374 */},  {  0x57268AC0, 0x9CC0F2A0 /*  375 */},
  { 0xEDBF42D1, 0x3DEE9D2D /*  376 */},  {  0x7960A972, 0x330F49C8 /*  377 */},
  { 0x87421B41, 0xC6B27202 /*  378 */},  {  0x7C00369C, 0x0AC59EC0 /*  379 */},
  { 0xCB353425, 0xEF4EAC49 /*  380 */},  {  0xEF0129D8, 0xF450244E /*  381 */},
  { 0xCAF4DEB6, 0x8ACC46E5 /*  382 */},  {  0x989263F7, 0x2FFEAB63 /*  383 */},
  { 0x5D7A4578, 0x8F7CB9FE /*  384 */},  {  0x4E634635, 0x5BD8F764 /*  385 */},
  { 0xBF2DC900, 0x427A7315 /*  386 */},  {  0x2125261C, 0x17D0C4AA /*  387 */},
  { 0x93518E50, 0x3992486C /*  388 */},  {  0xA2D7D4C3, 0xB4CBFEE0 /*  389 */},
  { 0x2C5DDD8D, 0x7C75D620 /*  390 */},  {  0xE35B6C61, 0xDBC295D8 /*  391 */},
  { 0x02032B19, 0x60B369D3 /*  392 */},  {  0xDCE44132, 0xCE42685F /*  393 */},
  { 0xDDF65610, 0x06F3DDB9 /*  394 */},  {  0xB5E148F0, 0x8EA4D21D /*  395 */},
  { 0x2FCD496F, 0x20B0FCE6 /*  396 */},  {  0x58B0EE31, 0x2C1B9123 /*  397 */},
  { 0x18F5A308, 0xB28317B8 /*  398 */},  {  0x9CA6D2CF, 0xA89C1E18 /*  399 */},
  { 0x6AAADBC8, 0x0C6B1857 /*  400 */},  {  0x1299FAE3, 0xB65DEAA9 /*  401 */},
  { 0x7F1027E7, 0xFB2B794B /*  402 */},  {  0x443B5BEB, 0x04E4317F /*  403 */},
  { 0x5939D0A6, 0x4B852D32 /*  404 */},  {  0xFB207FFC, 0xD5AE6BEE /*  405 */},
  { 0x81C7D374, 0x309682B2 /*  406 */},  {  0x94C3B475, 0xBAE309A1 /*  407 */},
  { 0x13B49F05, 0x8CC3F97B /*  408 */},  {  0xF8293967, 0x98A9422F /*  409 */},
  { 0x1076FF7C, 0x244B16B0 /*  410 */},  {  0x663D67EE, 0xF8BF571C /*  411 */},
  { 0xEEE30DA1, 0x1F0D6758 /*  412 */},  {  0x7ADEB9B7, 0xC9B611D9 /*  413 */},
  { 0x7B6C57A2, 0xB7AFD588 /*  414 */},  {  0x6B984FE1, 0x6290AE84 /*  415 */},
  { 0xACC1A5FD, 0x94DF4CDE /*  416 */},  {  0xC5483AFF, 0x058A5BD1 /*  417 */},
  { 0x42BA3C37, 0x63166CC1 /*  418 */},  {  0xB2F76F40, 0x8DB8526E /*  419 */},
  { 0x6F0D6D4E, 0xE1088003 /*  420 */},  {  0x971D311D, 0x9E0523C9 /*  421 */},
  { 0xCC7CD691, 0x45EC2824 /*  422 */},  {  0xE62382C9, 0x575B8359 /*  423 */},
  { 0xC4889995, 0xFA9E400D /*  424 */},  {  0x45721568, 0xD1823ECB /*  425 */},
  { 0x8206082F, 0xDAFD983B /*  426 */},  {  0x2386A8CB, 0xAA7D2908 /*  427 */},
  { 0x03B87588, 0x269FCD44 /*  428 */},  {  0x28BDD1E0, 0x1B91F5F7 /*  429 */},
  { 0x040201F6, 0xE4669F39 /*  430 */},  {  0x8CF04ADE, 0x7A1D7C21 /*  431 */},
  { 0xD79CE5CE, 0x65623C29 /*  432 */},  {  0x96C00BB1, 0x23684490 /*  433 */},
  { 0x9DA503BA, 0xAB9BF187 /*  434 */},  {  0xA458058E, 0xBC23ECB1 /*  435 */},
  { 0xBB401ECC, 0x9A58DF01 /*  436 */},  {  0xA85F143D, 0xA070E868 /*  437 */},
  { 0x7DF2239E, 0x4FF18830 /*  438 */},  {  0x1A641183, 0x14D565B4 /*  439 */},
  { 0x52701602, 0xEE133374 /*  440 */},  {  0x3F285E09, 0x950E3DCF /*  441 */},
  { 0xB9C80953, 0x59930254 /*  442 */},  {  0x8930DA6D, 0x3BF29940 /*  443 */},
  { 0x53691387, 0xA955943F /*  444 */},  {  0xA9CB8784, 0xA15EDECA /*  445 */},
  { 0x352BE9A0, 0x29142127 /*  446 */},  {  0xFF4E7AFB, 0x76F0371F /*  447 */},
  { 0x274F2228, 0x0239F450 /*  448 */},  {  0x1D5E868B, 0xBB073AF0 /*  449 */},
  { 0xC10E96C1, 0xBFC80571 /*  450 */},  {  0x68222E23, 0xD2670885 /*  451 */},
  { 0x8E80B5B0, 0x9671A3D4 /*  452 */},  {  0xE193BB81, 0x55B5D38A /*  453 */},
  { 0xA18B04B8, 0x693AE2D0 /*  454 */},  {  0xADD5335F, 0x5C48B4EC /*  455 */},
  { 0x4916A1CA, 0xFD743B19 /*  456 */},  {  0x34BE98C4, 0x25770181 /*  457 */},
  { 0x3C54A4AD, 0xE77987E8 /*  458 */},  {  0xDA33E1B9, 0x28E11014 /*  459 */},
  { 0x226AA213, 0x270CC59E /*  460 */},  {  0x6D1A5F60, 0x71495F75 /*  461 */},
  { 0x60AFEF77, 0x9BE853FB /*  462 */},  {  0xF7443DBF, 0xADC786A7 /*  463 */},
  { 0x73B29A82, 0x09044561 /*  464 */},  {  0xC232BD5E, 0x58BC7A66 /*  465 */},
  { 0x673AC8B2, 0xF306558C /*  466 */},  {  0xB6C9772A, 0x41F639C6 /*  467 */},
  { 0x9FDA35DA, 0x216DEFE9 /*  468 */},  {  0x1C7BE615, 0x11640CC7 /*  469 */},
  { 0x565C5527, 0x93C43694 /*  470 */},  {  0x46777839, 0xEA038E62 /*  471 */},
  { 0x5A3E2469, 0xF9ABF3CE /*  472 */},  {  0x0FD312D2, 0x741E768D /*  473 */},
  { 0xCED652C6, 0x0144B883 /*  474 */},  {  0xA33F8552, 0xC20B5A5B /*  475 */},
  { 0xC3435A9D, 0x1AE69633 /*  476 */},  {  0x088CFDEC, 0x97A28CA4 /*  477 */},
  { 0x1E96F420, 0x8824A43C /*  478 */},  {  0x6EEEA746, 0x37612FA6 /*  479 */},
  { 0xF9CF0E5A, 0x6B4CB165 /*  480 */},  {  0xA0ABFB4A, 0x43AA1C06 /*  481 */},
  { 0xF162796B, 0x7F4DC26F /*  482 */},  {  0x54ED9B0F, 0x6CBACC8E /*  483 */},
  { 0xD2BB253E, 0xA6B7FFEF /*  484 */},  {  0xB0A29D4F, 0x2E25BC95 /*  485 */},
  { 0xDEF1388C, 0x86D6A58B /*  486 */},  {  0x76B6F054, 0xDED74AC5 /*  487 */},
  { 0x2B45805D, 0x8030BDBC /*  488 */},  {  0xE94D9289, 0x3C81AF70 /*  489 */},
  { 0x9E3100DB, 0x3EFF6DDA /*  490 */},  {  0xDFCC8847, 0xB38DC39F /*  491 */},
  { 0x8D17B87E, 0x12388552 /*  492 */},  {  0x40B1B642, 0xF2DA0ED2 /*  493 */},
  { 0xD54BF9A9, 0x44CEFADC /*  494 */},  {  0x433C7EE6, 0x1312200E /*  495 */},
  { 0x3A78C748, 0x9FFCC84F /*  496 */},  {  0x248576BB, 0xF0CD1F72 /*  497 */},
  { 0x3638CFE4, 0xEC697405 /*  498 */},  {  0x0CEC4E4C, 0x2BA7B67C /*  499 */},
  { 0xE5CE32ED, 0xAC2F4DF3 /*  500 */},  {  0x26EA4C11, 0xCB33D143 /*  501 */},
  { 0xC77E58BC, 0xA4E9044C /*  502 */},  {  0xD934FCEF, 0x5F513293 /*  503 */},
  { 0x06E55444, 0x5DC96455 /*  504 */},  {  0x317DE40A, 0x50DE418F /*  505 */},
  { 0x69DDE259, 0x388CB31A /*  506 */},  {  0x55820A86, 0x2DB4A834 /*  507 */},
  { 0x84711AE9, 0x9010A91E /*  508 */},  {  0xB1498371, 0x4DF7F0B7 /*  509 */},
  { 0xC0977179, 0xD62A2EAB /*  510 */},  {  0xAA8D5C0E, 0x22FAC097 /*  511 */},
  { 0xF1DAF39B, 0xF49FCC2F /*  512 */},  {  0x6FF29281, 0x487FD5C6 /*  513 */},
  { 0xFCDCA83F, 0xE8A30667 /*  514 */},  {  0xD2FCCE63, 0x2C9B4BE3 /*  515 */},
  { 0x93FBBBC2, 0xDA3FF74B /*  516 */},  {  0xFE70BA66, 0x2FA165D2 /*  517 */},
  { 0x970E93D4, 0xA103E279 /*  518 */},  {  0xB0E45E71, 0xBECDEC77 /*  519 */},
  { 0x3985E497, 0xCFB41E72 /*  520 */},  {  0x5EF75017, 0xB70AAA02 /*  521 */},
  { 0x3840B8E0, 0xD42309F0 /*  522 */},  {  0x35898579, 0x8EFC1AD0 /*  523 */},
  { 0xE2B2ABC5, 0x96C6920B /*  524 */},  {  0x375A9172, 0x66AF4163 /*  525 */},
  { 0xCA7127FB, 0x2174ABDC /*  526 */},  {  0x4A72FF41, 0xB33CCEA6 /*  527 */},
  { 0x083066A5, 0xF04A4933 /*  528 */},  {  0xD7289AF5, 0x8D970ACD /*  529 */},
  { 0x31C8C25E, 0x8F96E8E0 /*  530 */},  {  0x76875D47, 0xF3FEC022 /*  531 */},
  { 0x056190DD, 0xEC7BF310 /*  532 */},  {  0xBB0F1491, 0xF5ADB0AE /*  533 */},
  { 0x0FD58892, 0x9B50F885 /*  534 */},  {  0x58B74DE8, 0x49754883 /*  535 */},
  { 0x91531C61, 0xA3354FF6 /*  536 */},  {  0x81D2C6EE, 0x0702BBE4 /*  537 */},
  { 0x7DEDED98, 0x89FB2405 /*  538 */},  {  0x8596E902, 0xAC307513 /*  539 */},
  { 0x172772ED, 0x1D2D3580 /*  540 */},  {  0x8E6BC30D, 0xEB738FC2 /*  541 */},
  { 0x63044326, 0x5854EF8F /*  542 */},  {  0x5ADD3BBE, 0x9E5C5232 /*  543 */},
  { 0x325C4623, 0x90AA53CF /*  544 */},  {  0x349DD067, 0xC1D24D51 /*  545 */},
  { 0xA69EA624, 0x2051CFEE /*  546 */},  {  0x862E7E4F, 0x13220F0A /*  547 */},
  { 0x04E04864, 0xCE393994 /*  548 */},  {  0x7086FCB7, 0xD9C42CA4 /*  549 */},
  { 0x8A03E7CC, 0x685AD223 /*  550 */},  {  0xAB2FF1DB, 0x066484B2 /*  551 */},
  { 0xEFBF79EC, 0xFE9D5D70 /*  552 */},  {  0x9C481854, 0x5B13B9DD /*  553 */},
  { 0xED1509AD, 0x15F0D475 /*  554 */},  {  0x0EC79851, 0x0BEBCD06 /*  555 */},
  { 0x183AB7F8, 0xD58C6791 /*  556 */},  {  0x52F3EEE4, 0xD1187C50 /*  557 */},
  { 0xE54E82FF, 0xC95D1192 /*  558 */},  {  0xB9AC6CA2, 0x86EEA14C /*  559 */},
  { 0x53677D5D, 0x3485BEB1 /*  560 */},  {  0x1F8C492A, 0xDD191D78 /*  561 */},
  { 0xA784EBF9, 0xF60866BA /*  562 */},  {  0xA2D08C74, 0x518F643B /*  563 */},
  { 0xE1087C22, 0x8852E956 /*  564 */},  {  0xC410AE8D, 0xA768CB8D /*  565 */},
  { 0xBFEC8E1A, 0x38047726 /*  566 */},  {  0xCD3B45AA, 0xA67738B4 /*  567 */},
  { 0xEC0DDE19, 0xAD16691C /*  568 */},  {  0x80462E07, 0xC6D43193 /*  569 */},
  { 0x0BA61938, 0xC5A5876D /*  570 */},  {  0xA58FD840, 0x16B9FA1F /*  571 */},
  { 0x3CA74F18, 0x188AB117 /*  572 */},  {  0xC99C021F, 0xABDA2F98 /*  573 */},
  { 0x134AE816, 0x3E0580AB /*  574 */},  {  0x73645ABB, 0x5F3B05B7 /*  575 */},
  { 0x5575F2F6, 0x2501A2BE /*  576 */},  {  0x4E7E8BA9, 0x1B2F7400 /*  577 */},
  { 0x71E8D953, 0x1CD75803 /*  578 */},  {  0x62764E30, 0x7F6ED895 /*  579 */},
  { 0x596F003D, 0xB15926FF /*  580 */},  {  0xA8C5D6B9, 0x9F65293D /*  581 */},
  { 0xD690F84C, 0x6ECEF04D /*  582 */},  {  0xFF33AF88, 0x4782275F /*  583 */},
  { 0x3F820801, 0xE4143308 /*  584 */},  {  0x9A1AF9B5, 0xFD0DFE40 /*  585 */},
  { 0x2CDB396B, 0x4325A334 /*  586 */},  {  0xB301B252, 0x8AE77E62 /*  587 */},
  { 0x6655615A, 0xC36F9E9F /*  588 */},  {  0x92D32C09, 0x85455A2D /*  589 */},
  { 0x49477485, 0xF2C7DEA9 /*  590 */},  {  0x33A39EBA, 0x63CFB4C1 /*  591 */},
  { 0x6EBC5462, 0x83B040CC /*  592 */},  {  0xFDB326B0, 0x3B9454C8 /*  593 */},
  { 0x87FFD78C, 0x56F56A9E /*  594 */},  {  0x99F42BC6, 0x2DC2940D /*  595 */},
  { 0x6B096E2D, 0x98F7DF09 /*  596 */},  {  0x3AD852BF, 0x19A6E01E /*  597 */},
  { 0xDBD4B40B, 0x42A99CCB /*  598 */},  {  0x45E9C559, 0xA59998AF /*  599 */},
  { 0x07D93186, 0x366295E8 /*  600 */},  {  0xFAA1F773, 0x6B48181B /*  601 */},
  { 0x157A0A1D, 0x1FEC57E2 /*  602 */},  {  0xF6201AD5, 0x4667446A /*  603 */},
  { 0xCFB0F075, 0xE615EBCA /*  604 */},  {  0x68290778, 0xB8F31F4F /*  605 */},
  { 0xCE22D11E, 0x22713ED6 /*  606 */},  {  0x2EC3C93B, 0x3057C1A7 /*  607 */},
  { 0x7C3F1F2F, 0xCB46ACC3 /*  608 */},  {  0x02AAF50E, 0xDBB893FD /*  609 */},
  { 0x600B9FCF, 0x331FD92E /*  610 */},  {  0x48EA3AD6, 0xA498F961 /*  611 */},
  { 0x8B6A83EA, 0xA8D8426E /*  612 */},  {  0xB7735CDC, 0xA089B274 /*  613 */},
  { 0x1E524A11, 0x87F6B373 /*  614 */},  {  0xCBC96749, 0x118808E5 /*  615 */},
  { 0xB19BD394, 0x9906E4C7 /*  616 */},  {  0x9B24A20C, 0xAFED7F7E /*  617 */},
  { 0xEB3644A7, 0x6509EADE /*  618 */},  {  0xE8EF0EDE, 0x6C1EF1D3 /*  619 */},
  { 0xE9798FB4, 0xB9C97D43 /*  620 */},  {  0x740C28A3, 0xA2F2D784 /*  621 */},
  { 0x6197566F, 0x7B849647 /*  622 */},  {  0xB65F069D, 0x7A5BE3E6 /*  623 */},
  { 0x78BE6F10, 0xF96330ED /*  624 */},  {  0x7A076A15, 0xEEE60DE7 /*  625 */},
  { 0xA08B9BD0, 0x2B4BEE4A /*  626 */},  {  0xC7B8894E, 0x6A56A63E /*  627 */},
  { 0xBA34FEF4, 0x02121359 /*  628 */},  {  0x283703FC, 0x4CBF99F8 /*  629 */},
  { 0x0CAF30C8, 0x39807135 /*  630 */},  {  0xF017687A, 0xD0A77A89 /*  631 */},
  { 0x9E423569, 0xF1C1A9EB /*  632 */},  {  0x2DEE8199, 0x8C797628 /*  633 */},
  { 0xDD1F7ABD, 0x5D1737A5 /*  634 */},  {  0x09A9FA80, 0x4F53433C /*  635 */},
  { 0xDF7CA1D9, 0xFA8B0C53 /*  636 */},  {  0x886CCB77, 0x3FD9DCBC /*  637 */},
  { 0xA91B4720, 0xC040917C /*  638 */},  {  0xF9D1DCDF, 0x7DD00142 /*  639 */},
  { 0x4F387B58, 0x8476FC1D /*  640 */},  {  0xF3316503, 0x23F8E7C5 /*  641 */},
  { 0xE7E37339, 0x032A2244 /*  642 */},  {  0x50F5A74B, 0x5C87A5D7 /*  643 */},
  { 0x3698992E, 0x082B4CC4 /*  644 */},  {  0xB858F63C, 0xDF917BEC /*  645 */},
  { 0x5BF86DDA, 0x3270B8FC /*  646 */},  {  0x29B5DD76, 0x10AE72BB /*  647 */},
  { 0x7700362B, 0x576AC94E /*  648 */},  {  0xC61EFB8F, 0x1AD112DA /*  649 */},
  { 0xC5FAA427, 0x691BC30E /*  650 */},  {  0xCC327143, 0xFF246311 /*  651 */},
  { 0x30E53206, 0x3142368E /*  652 */},  {  0xE02CA396, 0x71380E31 /*  653 */},
  { 0x0AAD76F1, 0x958D5C96 /*  654 */},  {  0xC16DA536, 0xF8D6F430 /*  655 */},
  { 0x1BE7E1D2, 0xC8FFD13F /*  656 */},  {  0x004DDBE1, 0x7578AE66 /*  657 */},
  { 0x067BE646, 0x05833F01 /*  658 */},  {  0x3BFE586D, 0xBB34B5AD /*  659 */},
  { 0xA12B97F0, 0x095F34C9 /*  660 */},  {  0x25D60CA8, 0x247AB645 /*  661 */},
  { 0x017477D1, 0xDCDBC6F3 /*  662 */},  {  0xDECAD24D, 0x4A2E14D4 /*  663 */},
  { 0xBE0A1EEB, 0xBDB5E6D9 /*  664 */},  {  0x794301AB, 0x2A7E70F7 /*  665 */},
  { 0x270540FD, 0xDEF42D8A /*  666 */},  {  0xA34C22C1, 0x01078EC0 /*  667 */},
  { 0xF4C16387, 0xE5DE511A /*  668 */},  {  0xBD9A330A, 0x7EBB3A52 /*  669 */},
  { 0xAA7D6435, 0x77697857 /*  670 */},  {  0x03AE4C32, 0x004E8316 /*  671 */},
  { 0xAD78E312, 0xE7A21020 /*  672 */},  {  0x6AB420F2, 0x9D41A70C /*  673 */},
  { 0xEA1141E6, 0x28E06C18 /*  674 */},  {  0x984F6B28, 0xD2B28CBD /*  675 */},
  { 0x446E9D83, 0x26B75F6C /*  676 */},  {  0x4D418D7F, 0xBA47568C /*  677 */},
  { 0xE6183D8E, 0xD80BADBF /*  678 */},  {  0x5F166044, 0x0E206D7F /*  679 */},
  { 0x11CBCA3E, 0xE258A439 /*  680 */},  {  0xB21DC0BC, 0x723A1746 /*  681 */},
  { 0xF5D7CDD3, 0xC7CAA854 /*  682 */},  {  0x3D261D9C, 0x7CAC3288 /*  683 */},
  { 0x23BA942C, 0x7690C264 /*  684 */},  {  0x478042B8, 0x17E55524 /*  685 */},
  { 0x56A2389F, 0xE0BE4776 /*  686 */},  {  0x67AB2DA0, 0x4D289B5E /*  687 */},
  { 0x8FBBFD31, 0x44862B9C /*  688 */},  {  0x9D141365, 0xB47CC804 /*  689 */},
  { 0x2B91C793, 0x822C1B36 /*  690 */},  {  0xFB13DFD8, 0x4EB14655 /*  691 */},
  { 0x14E2A97B, 0x1ECBBA07 /*  692 */},  {  0x5CDE5F14, 0x6143459D /*  693 */},
  { 0xD5F0AC89, 0x53A8FBF1 /*  694 */},  {  0x1C5E5B00, 0x97EA04D8 /*  695 */},
  { 0xD4FDB3F3, 0x622181A8 /*  696 */},  {  0x572A1208, 0xE9BCD341 /*  697 */},
  { 0x43CCE58A, 0x14112586 /*  698 */},  {  0xA4C6E0A4, 0x9144C5FE /*  699 */},
  { 0x65CF620F, 0x0D33D065 /*  700 */},  {  0x9F219CA1, 0x54A48D48 /*  701 */},
  { 0x6D63C821, 0xC43E5EAC /*  702 */},  {  0x72770DAF, 0xA9728B3A /*  703 */},
  { 0x20DF87EF, 0xD7934E7B /*  704 */},  {  0x1A3E86E5, 0xE35503B6 /*  705 */},
  { 0xC819D504, 0xCAE321FB /*  706 */},  {  0xAC60BFA6, 0x129A50B3 /*  707 */},
  { 0x7E9FB6C3, 0xCD5E68EA /*  708 */},  {  0x9483B1C7, 0xB01C9019 /*  709 */},
  { 0xC295376C, 0x3DE93CD5 /*  710 */},  {  0x2AB9AD13, 0xAED52EDF /*  711 */},
  { 0xC0A07884, 0x2E60F512 /*  712 */},  {  0xE36210C9, 0xBC3D86A3 /*  713 */},
  { 0x163951CE, 0x35269D9B /*  714 */},  {  0xD0CDB5FA, 0x0C7D6E2A /*  715 */},
  { 0xD87F5733, 0x59E86297 /*  716 */},  {  0x898DB0E7, 0x298EF221 /*  717 */},
  { 0xD1A5AA7E, 0x55000029 /*  718 */},  {  0xB5061B45, 0x8BC08AE1 /*  719 */},
  { 0x6C92703A, 0xC2C31C2B /*  720 */},  {  0xAF25EF42, 0x94CC596B /*  721 */},
  { 0x22540456, 0x0A1D73DB /*  722 */},  {  0xD9C4179A, 0x04B6A0F9 /*  723 */},
  { 0xAE3D3C60, 0xEFFDAFA2 /*  724 */},  {  0xB49496C4, 0xF7C8075B /*  725 */},
  { 0x1D1CD4E3, 0x9CC5C714 /*  726 */},  {  0x218E5534, 0x78BD1638 /*  727 */},
  { 0xF850246A, 0xB2F11568 /*  728 */},  {  0x9502BC29, 0xEDFABCFA /*  729 */},
  { 0xDA23051B, 0x796CE5F2 /*  730 */},  {  0xDC93537C, 0xAAE128B0 /*  731 */},
  { 0xEE4B29AE, 0x3A493DA0 /*  732 */},  {  0x416895D7, 0xB5DF6B2C /*  733 */},
  { 0x122D7F37, 0xFCABBD25 /*  734 */},  {  0x105DC4B1, 0x70810B58 /*  735 */},
  { 0xF7882A90, 0xE10FDD37 /*  736 */},  {  0x518A3F5C, 0x524DCAB5 /*  737 */},
  { 0x8451255B, 0x3C9E8587 /*  738 */},  {  0x19BD34E2, 0x40298281 /*  739 */},
  { 0x5D3CECCB, 0x74A05B6F /*  740 */},  {  0x42E13ECA, 0xB6100215 /*  741 */},
  { 0x2F59E2AC, 0x0FF979D1 /*  742 */},  {  0xE4F9CC50, 0x6037DA27 /*  743 */},
  { 0x0DF1847D, 0x5E92975A /*  744 */},  {  0xD3E623FE, 0xD66DE190 /*  745 */},
  { 0x7B568048, 0x5032D6B8 /*  746 */},  {  0x8235216E, 0x9A36B7CE /*  747 */},
  { 0x24F64B4A, 0x80272A7A /*  748 */},  {  0x8C6916F7, 0x93EFED8B /*  749 */},
  { 0x4CCE1555, 0x37DDBFF4 /*  750 */},  {  0x4B99BD25, 0x4B95DB5D /*  751 */},
  { 0x69812FC0, 0x92D3FDA1 /*  752 */},  {  0x90660BB6, 0xFB1A4A9A /*  753 */},
  { 0x46A4B9B2, 0x730C1969 /*  754 */},  {  0x7F49DA68, 0x81E289AA /*  755 */},
  { 0x83B1A05F, 0x64669A0F /*  756 */},  {  0x9644F48B, 0x27B3FF7D /*  757 */},
  { 0x8DB675B3, 0xCC6B615C /*  758 */},  {  0xBCEBBE95, 0x674F20B9 /*  759 */},
  { 0x75655982, 0x6F312382 /*  760 */},  {  0x3E45CF05, 0x5AE48871 /*  761 */},
  { 0x54C21157, 0xBF619F99 /*  762 */},  {  0x40A8EAE9, 0xEABAC460 /*  763 */},
  { 0xF2C0C1CD, 0x454C6FE9 /*  764 */},  {  0x6412691C, 0x419CF649 /*  765 */},
  { 0x265B0F70, 0xD3DC3BEF /*  766 */},  {  0xC3578A9E, 0x6D0E60F5 /*  767 */},
  { 0x26323C55, 0x5B0E6085 /*  768 */},  {  0xFA1B59F5, 0x1A46C1A9 /*  769 */},
  { 0x7C4C8FFA, 0xA9E245A1 /*  770 */},  {  0xDB2955D7, 0x65CA5159 /*  771 */},
  { 0xCE35AFC2, 0x05DB0A76 /*  772 */},  {  0xA9113D45, 0x81EAC77E /*  773 */},
  { 0xB6AC0A0D, 0x528EF88A /*  774 */},  {  0x597BE3FF, 0xA09EA253 /*  775 */},
  { 0xAC48CD56, 0x430DDFB3 /*  776 */},  {  0xF45CE46F, 0xC4B3A67A /*  777 */},
  { 0xFBE2D05E, 0x4ECECFD8 /*  778 */},  {  0xB39935F0, 0x3EF56F10 /*  779 */},
  { 0x9CD619C6, 0x0B22D682 /*  780 */},  {  0x74DF2069, 0x17FD460A /*  781 */},
  { 0x8510ED40, 0x6CF8CC8E /*  782 */},  {  0x3A6ECAA7, 0xD6C824BF /*  783 */},
  { 0x1A817049, 0x61243D58 /*  784 */},  {  0xBBC163A2, 0x048BACB6 /*  785 */},
  { 0x7D44CC32, 0xD9A38AC2 /*  786 */},  {  0xAAF410AB, 0x7FDDFF5B /*  787 */},
  { 0xA804824B, 0xAD6D495A /*  788 */},  {  0x2D8C9F94, 0xE1A6A74F /*  789 */},
  { 0x35DEE8E3, 0xD4F78512 /*  790 */},  {  0x6540D893, 0xFD4B7F88 /*  791 */},
  { 0x2AA4BFDA, 0x247C2004 /*  792 */},  {  0x17D1327C, 0x096EA1C5 /*  793 */},
  { 0x361A6685, 0xD56966B4 /*  794 */},  {  0x1221057D, 0x277DA5C3 /*  795 */},
  { 0xA43ACFF7, 0x94D59893 /*  796 */},  {  0xCDC02281, 0x64F0C51C /*  797 */},
  { 0xFF6189DB, 0x3D33BCC4 /*  798 */},  {  0x4CE66AF1, 0xE005CB18 /*  799 */},
  { 0x1DB99BEA, 0xFF5CCD1D /*  800 */},  {  0xFE42980F, 0xB0B854A7 /*  801 */},
  { 0x718D4B9F, 0x7BD46A6A /*  802 */},  {  0x22A5FD8C, 0xD10FA8CC /*  803 */},
  { 0x2BE4BD31, 0xD3148495 /*  804 */},  {  0xCB243847, 0xC7FA975F /*  805 */},
  { 0x5846C407, 0x4886ED1E /*  806 */},  {  0x1EB70B04, 0x28CDDB79 /*  807 */},
  { 0xF573417F, 0xC2B00BE2 /*  808 */},  {  0x2180F877, 0x5C959045 /*  809 */},
  { 0xF370EB00, 0x7A6BDDFF /*  810 */},  {  0xD6D9D6A4, 0xCE509E38 /*  811 */},
  { 0x647FA702, 0xEBEB0F00 /*  812 */},  {  0x76606F06, 0x1DCC06CF /*  813 */},
  { 0xA286FF0A, 0xE4D9F28B /*  814 */},  {  0xC918C262, 0xD85A305D /*  815 */},
  { 0x32225F54, 0x475B1D87 /*  816 */},  {  0x68CCB5FE, 0x2D4FB516 /*  817 */},
  { 0xD72BBA20, 0xA679B9D9 /*  818 */},  {  0x912D43A5, 0x53841C0D /*  819 */},
  { 0xBF12A4E8, 0x3B7EAA48 /*  820 */},  {  0xF22F1DDF, 0x781E0E47 /*  821 */},
  { 0x0AB50973, 0xEFF20CE6 /*  822 */},  {  0x9DFFB742, 0x20D261D1 /*  823 */},
  { 0x062A2E39, 0x16A12B03 /*  824 */},  {  0x39650495, 0x1960EB22 /*  825 */},
  { 0xD50EB8B8, 0x251C16FE /*  826 */},  {  0xF826016E, 0x9AC0C330 /*  827 */},
  { 0x953E7671, 0xED152665 /*  828 */},  {  0xA6369570, 0x02D63194 /*  829 */},
  { 0x94B1C987, 0x5074F083 /*  830 */},  {  0x90B25CE1, 0x70BA598C /*  831 */},
  { 0x0B9742F6, 0x794A1581 /*  832 */},  {  0xFCAF8C6C, 0x0D5925E9 /*  833 */},
  { 0xD868744E, 0x3067716C /*  834 */},  {  0xE8D7731B, 0x910AB077 /*  835 */},
  { 0x5AC42F61, 0x6A61BBDB /*  836 */},  {  0xF0851567, 0x93513EFB /*  837 */},
  { 0x9E83E9D5, 0xF494724B /*  838 */},  {  0x5C09648D, 0xE887E198 /*  839 */},
  { 0x75370CFD, 0x34B1D3C6 /*  840 */},  {  0xBC0D255D, 0xDC35E433 /*  841 */},
  { 0x34131BE0, 0xD0AAB842 /*  842 */},  {  0xB48B7EAF, 0x08042A50 /*  843 */},
  { 0x44A3AB35, 0x9997C4EE /*  844 */},  {  0x201799D0, 0x829A7B49 /*  845 */},
  { 0xB7C54441, 0x263B8307 /*  846 */},  {  0xFD6A6CA6, 0x752F95F4 /*  847 */},
  { 0x2C08C6E5, 0x92721740 /*  848 */},  {  0xA795D9EE, 0x2A8AB754 /*  849 */},
  { 0x2F72943D, 0xA442F755 /*  850 */},  {  0x19781208, 0x2C31334E /*  851 */},
  { 0xEAEE6291, 0x4FA98D7C /*  852 */},  {  0x665DB309, 0x55C3862F /*  853 */},
  { 0x5D53B1F3, 0xBD061017 /*  854 */},  {  0x40413F27, 0x46FE6CB8 /*  855 */},
  { 0xDF0CFA59, 0x3FE03792 /*  856 */},  {  0x2EB85E8F, 0xCFE70037 /*  857 */},
  { 0xADBCE118, 0xA7BE29E7 /*  858 */},  {  0xDE8431DD, 0xE544EE5C /*  859 */},
  { 0x41F1873E, 0x8A781B1B /*  860 */},  {  0xA0D2F0E7, 0xA5C94C78 /*  861 */},
  { 0x77B60728, 0x39412E28 /*  862 */},  {  0xAFC9A62C, 0xA1265EF3 /*  863 */},
  { 0x6A2506C5, 0xBCC2770C /*  864 */},  {  0xDCE1CE12, 0x3AB66DD5 /*  865 */},
  { 0x4A675B37, 0xE65499D0 /*  866 */},  {  0x81BFD216, 0x7D8F5234 /*  867 */},
  { 0xEC15F389, 0x0F6F64FC /*  868 */},  {  0x8B5B13C8, 0x74EFBE61 /*  869 */},
  { 0x14273E1D, 0xACDC82B7 /*  870 */},  {  0x03199D17, 0xDD40BFE0 /*  871 */},
  { 0xE7E061F8, 0x37E99257 /*  872 */},  {  0x04775AAA, 0xFA526269 /*  873 */},
  { 0x463D56F9, 0x8BBBF63A /*  874 */},  {  0x43A26E64, 0xF0013F15 /*  875 */},
  { 0x879EC898, 0xA8307E9F /*  876 */},  {  0x150177CC, 0xCC4C27A4 /*  877 */},
  { 0xCA1D3348, 0x1B432F2C /*  878 */},  {  0x9F6FA013, 0xDE1D1F8F /*  879 */},
  { 0x47A7DDD6, 0x606602A0 /*  880 */},  {  0xCC1CB2C7, 0xD237AB64 /*  881 */},
  { 0x25FCD1D3, 0x9B938E72 /*  882 */},  {  0x8E0FF476, 0xEC4E0370 /*  883 */},
  { 0x3D03C12D, 0xFEB2FBDA /*  884 */},  {  0xEE43889A, 0xAE0BCED2 /*  885 */},
  { 0xEBFB4F43, 0x22CB8923 /*  886 */},  {  0x3CF7396D, 0x69360D01 /*  887 */},
  { 0xD2D4E022, 0x855E3602 /*  888 */},  {  0xD01F784C, 0x073805BA /*  889 */},
  { 0x3852F546, 0x33E17A13 /*  890 */},  {  0x8AC7B638, 0xDF487405 /*  891 */},
  { 0x678AA14A, 0xBA92B29C /*  892 */},  {  0x6CFAADCD, 0x0CE89FC7 /*  893 */},
  { 0x08339E34, 0x5F9D4E09 /*  894 */},  {  0x1F5923B9, 0xF1AFE929 /*  895 */},
  { 0x0F4A265F, 0x6E3480F6 /*  896 */},  {  0xB29B841C, 0xEEBF3A2A /*  897 */},
  { 0x8F91B4AD, 0xE21938A8 /*  898 */},  {  0x45C6D3C3, 0x57DFEFF8 /*  899 */},
  { 0xF62CAAF2, 0x2F006B0B /*  900 */},  {  0x6F75EE78, 0x62F479EF /*  901 */},
  { 0x1C8916A9, 0x11A55AD4 /*  902 */},  {  0x84FED453, 0xF229D290 /*  903 */},
  { 0x16B000E6, 0x42F1C27B /*  904 */},  {  0x9823C074, 0x2B1F7674 /*  905 */},
  { 0xC2745360, 0x4B76ECA3 /*  906 */},  {  0xB91691BD, 0x8C98F463 /*  907 */},
  { 0xF1ADE66A, 0x14BCC93C /*  908 */},  {  0x6D458397, 0x8885213E /*  909 */},
  { 0x274D4711, 0x8E177DF0 /*  910 */},  {  0x503F2951, 0xB49B73B5 /*  911 */},
  { 0xC3F96B6B, 0x10168168 /*  912 */},  {  0x63CAB0AE, 0x0E3D963B /*  913 */},
  { 0x55A1DB14, 0x8DFC4B56 /*  914 */},  {  0x6E14DE5C, 0xF789F135 /*  915 */},
  { 0x4E51DAC1, 0x683E68AF /*  916 */},  {  0x8D4B0FD9, 0xC9A84F9D /*  917 */},
  { 0x52A0F9D1, 0x3691E03F /*  918 */},  {  0xE1878E80, 0x5ED86E46 /*  919 */},
  { 0x99D07150, 0x3C711A0E /*  920 */},  {  0x0C4E9310, 0x5A0865B2 /*  921 */},
  { 0xE4F0682E, 0x56FBFC1F /*  922 */},  {  0x105EDF9B, 0xEA8D5DE3 /*  923 */},
  { 0x2379187A, 0x71ABFDB1 /*  924 */},  {  0xBEE77B9C, 0x2EB99DE1 /*  925 */},
  { 0x33CF4523, 0x21ECC0EA /*  926 */},  {  0x1805C7A1, 0x59A4D752 /*  927 */},
  { 0x56AE7C72, 0x3896F5EB /*  928 */},  {  0xB18F75DC, 0xAA638F3D /*  929 */},
  { 0xABE9808E, 0x9F39358D /*  930 */},  {  0xC00B72AC, 0xB7DEFA91 /*  931 */},
  { 0x62492D92, 0x6B5541FD /*  932 */},  {  0xF92E4D5B, 0x6DC6DEE8 /*  933 */},
  { 0xC4BEEA7E, 0x353F57AB /*  934 */},  {  0xDA5690CE, 0x735769D6 /*  935 */},
  { 0x42391484, 0x0A234AA6 /*  936 */},  {  0x28F80D9D, 0xF6F95080 /*  937 */},
  { 0x7AB3F215, 0xB8E319A2 /*  938 */},  {  0x51341A4D, 0x31AD9C11 /*  939 */},
  { 0x7BEF5805, 0x773C22A5 /*  940 */},  {  0x07968633, 0x45C7561A /*  941 */},
  { 0x249DBE36, 0xF913DA9E /*  942 */},  {  0x78A64C68, 0xDA652D9B /*  943 */},
  { 0x3BC334EF, 0x4C27A97F /*  944 */},  {  0xE66B17F4, 0x76621220 /*  945 */},
  { 0x9ACD7D0B, 0x96774389 /*  946 */},  {  0xE0ED6782, 0xF3EE5BCA /*  947 */},
  { 0x00C879FC, 0x409F7536 /*  948 */},  {  0xB5926DB6, 0x06D09A39 /*  949 */},
  { 0x317AC588, 0x6F83AEB0 /*  950 */},  {  0x86381F21, 0x01E6CA4A /*  951 */},
  { 0xD19F3025, 0x66FF3462 /*  952 */},  {  0xDDFD3BFB, 0x72207C24 /*  953 */},
  { 0xE2ECE2EB, 0x4AF6B6D3 /*  954 */},  {  0xC7EA08DE, 0x9C994DBE /*  955 */},
  { 0xB09A8BC4, 0x49ACE597 /*  956 */},  {  0xCF0797BA, 0xB38C4766 /*  957 */},
  { 0xC57C2A75, 0x131B9373 /*  958 */},  {  0x61931E58, 0xB1822CCE /*  959 */},
  { 0x09BA1C0C, 0x9D7555B9 /*  960 */},  {  0x937D11D2, 0x127FAFDD /*  961 */},
  { 0xC66D92E4, 0x29DA3BAD /*  962 */},  {  0x54C2ECBC, 0xA2C1D571 /*  963 */},
  { 0x82F6FE24, 0x58C5134D /*  964 */},  {  0x5B62274F, 0x1C3AE351 /*  965 */},
  { 0x01CB8126, 0xE907C82E /*  966 */},  {  0x13E37FCB, 0xF8ED0919 /*  967 */},
  { 0xC80046C9, 0x3249D8F9 /*  968 */},  {  0xE388FB63, 0x80CF9BED /*  969 */},
  { 0x116CF19E, 0x1881539A /*  970 */},  {  0x6BD52457, 0x5103F3F7 /*  971 */},
  { 0xAE47F7A8, 0x15B7E6F5 /*  972 */},  {  0xD47E9CCF, 0xDBD7C6DE /*  973 */},
  { 0x0228BB1A, 0x44E55C41 /*  974 */},  {  0x5EDB4E99, 0xB647D425 /*  975 */},
  { 0xB8AAFC30, 0x5D11882B /*  976 */},  {  0x29D3212A, 0xF5098BBB /*  977 */},
  { 0xE90296B3, 0x8FB5EA14 /*  978 */},  {  0x57DD025A, 0x677B9421 /*  979 */},
  { 0xA390ACB5, 0xFB58E7C0 /*  980 */},  {  0x83BD4A01, 0x89D3674C /*  981 */},
  { 0x4BF3B93B, 0x9E2DA4DF /*  982 */},  {  0x8CAB4829, 0xFCC41E32 /*  983 */},
  { 0xBA582C52, 0x03F38C96 /*  984 */},  {  0x7FD85DB2, 0xCAD1BDBD /*  985 */},
  { 0x6082AE83, 0xBBB442C1 /*  986 */},  {  0xA5DA9AB0, 0xB95FE86B /*  987 */},
  { 0x3771A93F, 0xB22E0467 /*  988 */},  {  0x493152D8, 0x845358C9 /*  989 */},
  { 0x97B4541E, 0xBE2A4886 /*  990 */},  {  0xD38E6966, 0x95A2DC2D /*  991 */},
  { 0x923C852B, 0xC02C11AC /*  992 */},  {  0x0DF2A87B, 0x2388B199 /*  993 */},
  { 0x1B4F37BE, 0x7C8008FA /*  994 */},  {  0x4D54E503, 0x1F70D0C8 /*  995 */},
  { 0x7ECE57D4, 0x5490ADEC /*  996 */},  {  0xD9063A3A, 0x002B3C27 /*  997 */},
  { 0x8030A2BF, 0x7EAEA384 /*  998 */},  {  0xED2003C0, 0xC602326D /*  999 */},
  { 0x69A94086, 0x83A7287D /* 1000 */},  {  0x30F57A8A, 0xC57A5FCB /* 1001 */},
  { 0x79EBE779, 0xB56844E4 /* 1002 */},  {  0x05DCBCE9, 0xA373B40F /* 1003 */},
  { 0x88570EE2, 0xD71A786E /* 1004 */},  {  0xBDE8F6A0, 0x879CBACD /* 1005 */},
  { 0xC164A32F, 0x976AD1BC /* 1006 */},  {  0x9666D78B, 0xAB21E25E /* 1007 */},
  { 0xE5E5C33C, 0x901063AA /* 1008 */},  {  0x48698D90, 0x9818B344 /* 1009 */},
  { 0x3E1E8ABB, 0xE36487AE /* 1010 */},  {  0x893BDCB4, 0xAFBDF931 /* 1011 */},
  { 0x5FBBD519, 0x6345A0DC /* 1012 */},  {  0x9B9465CA, 0x8628FE26 /* 1013 */},
  { 0x3F9C51EC, 0x1E5D0160 /* 1014 */},  {  0xA15049B7, 0x4DE44006 /* 1015 */},
  { 0xF776CBB1, 0xBF6C70E5 /* 1016 */},  {  0xEF552BED, 0x411218F2 /* 1017 */},
  { 0x705A36A3, 0xCB0C0708 /* 1018 */},  {  0x4F986044, 0xE74D1475 /* 1019 */},
  { 0x0EA8280E, 0xCD56D943 /* 1020 */},  {  0x535F5065, 0xC12591D7 /* 1021 */},
  { 0x720AEF96, 0xC83223F1 /* 1022 */},  {  0x7363A51F, 0xC3A0396F /* 1023 */}
  };

#else
void dummy_2 (int a)
{
  (void) a;
  return;
}
#endif
