/* Following definitions are needed to avoid 
 * including kernel header files
 */


/* copied from linux-2.4.19/include/linux/if.h */

struct ifmap 
{
	unsigned long mem_start;
	unsigned long mem_end;
	unsigned short base_addr; 
	unsigned char irq;
	unsigned char dma;
	unsigned char port;
	/* 3 bytes spare */
};

struct ifreq 
{
#define IFHWADDRLEN	6
#define	IFNAMSIZ	16
	union {
		char	ifrn_name[IFNAMSIZ];	/* if name, e.g. "en0" */
	} ifr_ifrn;
	
	union {
		struct	sockaddr ifru_addr;
		struct	sockaddr ifru_dstaddr;
		struct	sockaddr ifru_broadaddr;
		struct	sockaddr ifru_netmask;
		struct  sockaddr ifru_hwaddr;
		short	ifru_flags;
		int	ifru_ivalue;
		int	ifru_mtu;
		struct  ifmap ifru_map;
		char	ifru_slave[IFNAMSIZ];	/* Just fits the size */
		char	ifru_newname[IFNAMSIZ];
		char *	ifru_data;
	} ifr_ifru;
};

#define ifr_name	ifr_ifrn.ifrn_name	/* interface name 	*/
#define ifr_hwaddr	ifr_ifru.ifru_hwaddr	/* MAC address 		*/
#define	ifr_addr	ifr_ifru.ifru_addr	/* address		*/
#define	ifr_dstaddr	ifr_ifru.ifru_dstaddr	/* other end of p-p lnk	*/
#define	ifr_broadaddr	ifr_ifru.ifru_broadaddr	/* broadcast address	*/
#define	ifr_netmask	ifr_ifru.ifru_netmask	/* interface net mask	*/
#define	ifr_flags	ifr_ifru.ifru_flags	/* flags		*/
#define	ifr_metric	ifr_ifru.ifru_ivalue	/* metric		*/
#define	ifr_mtu		ifr_ifru.ifru_mtu	/* mtu			*/
#define ifr_map		ifr_ifru.ifru_map	/* device map		*/
#define ifr_slave	ifr_ifru.ifru_slave	/* slave device		*/
#define	ifr_data	ifr_ifru.ifru_data	/* for use by interface	*/
#define ifr_ifindex	ifr_ifru.ifru_ivalue	/* interface index	*/
#define ifr_bandwidth	ifr_ifru.ifru_ivalue    /* link bandwidth	*/
#define ifr_qlen	ifr_ifru.ifru_ivalue	/* Queue length 	*/
#define ifr_newname	ifr_ifru.ifru_newname	/* New name		*/


/*****************************************************
 *    Declarations for OSA Relevant Things           *
 *****************************************************/


#define DATA_SIZE 20000
#define ARP_PURGE  (SIOCDEVPRIVATE + 4)
#define ARP_QUERY  (SIOCDEVPRIVATE + 1)
#define ARP_ADD    (SIOCDEVPRIVATE + 2)
#define ARP_DELETE (SIOCDEVPRIVATE + 3)
#define IS_HIPERSOCKET_DEVICE  5
#define IS_OSACARD_DEVICE      7

#define MAC_LENGTH             6
#define IPV4_LENGTH            4
#define IPV6_LENGTH            16
#define IP_VERSION_4           1

#define ARP_NEXT_REPLY_CONSTANT 3968
#define HSI_ENTRIES_IN_ONE_REPLY 96

typedef struct osa_queryarp_data_t {
	unsigned char media_spec_info[32];   
	unsigned char mac_type;
	unsigned char ip_type;               
	unsigned char mac[6];
} osa_queryarp_data_t;

typedef struct hsi_queryarp_data_t {
	unsigned char media_spec_info[32];   
	unsigned char mac_type;
	unsigned char ip_type;               
} hsi_queryarp_data_t;

typedef struct osa_addarp_data_t {
	unsigned char mac[8];
	unsigned char ip[16];
	unsigned char reserved[32];
} osa_addarp_data_t;

typedef struct osa_delarp_data_t {
	unsigned char mac[8];
	unsigned char ip[16];
} osa_delarp_data_t;

/*****************************************************
 *            Declarations for parsing options       *
 *****************************************************/

#define QETHARP_GETOPT_STRING "p:q:a:d:i:m:nchv"

#define OPTION_INFO_QUERY              1
#define OPTION_INFO_PURGE              1
#define OPTION_INFO_HOST_RESOLUTION    1
#define OPTION_INFO_COMPACT_OUTPUT     1
#define OPTION_INFO_ADD                1
#define OPTION_INFO_DELETE             1
#define OPTION_INFO_IP                 1
#define OPTION_INFO_MAC                1


static struct option qetharp_options[]=
{
	{ "query",        1, 0, 'q'},  
	{ "purge",        1, 0, 'p'},
	{ "numeric",      0, 0, 'n'},
	{ "compact",      0, 0, 'c'},
	{ "add",          1, 0, 'a'},
	{ "delete",       1, 0, 'd'},
	{ "ip",           1, 0, 'i'},
	{ "mac",          1, 0, 'm'},
	{ "help",         0, 0, 'h'},
	{ "version",      0, 0, 'v'},
	{0,0,0,0}
};

typedef struct option_info {
	int purge_flag;
	int query_flag;
	int host_resolution;
	int compact_output;
	int add_flag;
	int delete_flag;
	int ip_flag;
	int mac_flag;
	char *dev_name;
	char *ip_addr;
	char *mac_addr;
} option_info_t;
