
/*
 * Copyright (C) 1999-2001, Ian Main <imain@stemwinder.org>.
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject
 * to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 */

#include <roy.h>

/* Return a string value of a socket error */

#ifndef USE_WINSOCK

char *
socketstrerror (void)
{
    return (strerror (errno));
}

int
rmisc_winsock_check_init (void)
{
    return (0);
}


#else

char *
socketstrerror (void)
{
    int errcode;
    char *errstr;

    
    errcode = WSAGetLastError ();
    
    switch (errcode) {
    
        case 10000:
            errstr = "[0] No Error";
            break;

        case 10004:
            errstr = "WSAEINTR: Interrupted system call";
            break;

        case 10009:
            errstr = "WSAEBADF: Bad file number";
            break;

        case 10013:
            errstr = "WSACCESS: Permission denied";
            break;

        case 10014:
            errstr = "WSAEFAULT: Bad address";
            break;

        case 10022:
            errstr = "WSAEINVAL: Invalid argument";
            break;

        case 10024:
            errstr = "WSAEMFILE: Too many open files";
            break;

        case 10035:
            errstr = "WSAEWOULDBLOCK: Operation would block";
            break;

        case 10036:
            errstr = "WSAEINPROGRESS: Operation now in progress";
            break;

        case 10037:
            errstr = "WSAEALREADY: Operation already in progress";
            break;

        case 10038:
            errstr = "WSAENOTSOCK: Socket operation on non-socket";
            break;

        case 10039:
            errstr = "WSAEDESTADDRREQ: Destination address required";
            break;

        case 10040:
            errstr = "WSAEMSGSIZE: Message too long";
            break;

        case 10041:
            errstr = "WSAEPROTOTYPE: Protocol wrong type for socket";
            break;

        case 10042:
            errstr = "WSAENOPROTOOPT: Bad protocol option";
            break;

        case 10043:
            errstr = "WSAEPROTONOSUPPORT: Protocol not supported";
            break;

        case 10044:
            errstr = "WSAESOCKTNOSUPPORT: Socket type not supported";
            break;

        case 10045:
            errstr = "WSAEOPNOTSUPP: Operation not supported on socket";
            break;

        case 10046:
            errstr = "WSAEPFNNOSUPPORT: Protocol family not supported";
            break;

        case 10047:
            errstr = "WSAEAFNNOSUPPORT: Address family not supported by protocol family";
            break;

        case 10048:
            errstr = "WSAEADDRINUSE: Address already in use";
            break;

        case 10049:
            errstr = "WSAEADDRNOTAVAIL: Can't assign requested address";
            break;

        case 10050:
            errstr = "WSAENETDOWN: Network is down";
            break;

        case 10051:
            errstr = "WSAENETUNREACH: Network is unreachable";
            break;

        case 10052:
            errstr = "WSAENETRESET: Net dropped connection or reset";
            break;

        case 10053:
            errstr = "WSAECONNABORTED: Software caused connection abort";
            break;

        case 10054:
            errstr = "WSAECONNRESET: Connection reset by peer";
            break;

        case 10055:
            errstr = "WSAENOBUFS: No buffer space available";
            break;

        case 10056:
            errstr = "WSAEISCONN: Socket is already connected";
            break;

        case 10057:
            errstr = "WSAENOTCONN: Socket is not connected";
            break;

        case 10058:
            errstr = "WSAESHUTDOWN: Can't send after socket shutdown";
            break;

        case 10059:
            errstr = "WSAETOOMANYREFS: Too many references, can't splice";
            break;

        case 10060:
            errstr = "WSAETIMEDOUT: Connection timed out";
            break;

        case 10061:
            errstr = "WSAECONNREFUSED: Connection refused";
            break;

        case 10062:
            errstr = "WSAELOOP: Too many levels of symbolic links";
            break;

        case 10063:
            errstr = "WSAENAMETOOLONG: File name too long";
            break;

        case 10064:
            errstr = "WSAEHOSTDOWN: Host is down";
            break;

        case 10065:
            errstr = "WSAEHOSTUNREACH: No Route to Host";
            break;

        case 10066:
            errstr = "WSAENOTEMPTY: Directory not empty";
            break;

        case 10067:
            errstr = "WSAEPROCLIM: Too many processes";
            break;

        case 10068:
            errstr = "WSAEUSERS: Too many users";
            break;

        case 10069:
            errstr = "WSAEDQUOT: Disc Quota Exceeded";
            break;

        case 10070:
            errstr = "WSAESTALE: Stale NFS file handle";
            break;

        case 10071:
            errstr = "WSAEREMOTE: Too many levels of remote in path";
            break;

        case 10091:
            errstr = "WSASYSNOTREADY: Network SubSystem is unavailable";
            break;

        case 10092:
            errstr = "WSAVERNOTSUPPORTED: WINSOCK DLL Version out of range";
            break;

        case 10093:
            errstr = "WSANOTINITIALISED: Successful WSASTARTUP not yet performed";
            break;

        case 11001:
            errstr = "WSAHOST_NOT_FOUND: Host not found";
            break;

        case 11002:
            errstr = "WSATRY_AGAIN: Non-Authoritative Host not found";
            break;

        case 11003:
            errstr = "WSANO_RECOVERY: Non-Recoverable errors: FORMERR, REFUSED, NOTIMP";
            break;

        case 11004:
            errstr = "WSANO_DATA: Valid name, no data record of requested type";
            break;

        default:
            errstr = "Unknown Error";
            break;
    }

    return (errstr);
}


int
rmisc_winsock_check_init (void)
{
    WORD wVersionRequested;
    WSADATA wsaData;
    int err;
    static int initialized = FALSE;

    if (!initialized) {
        wVersionRequested = MAKEWORD (1, 1);
        err = WSAStartup (wVersionRequested, &wsaData);
        if (err != 0) {
            return (-1);
        }

        initialized = TRUE;
    }

    return (0);
}

#endif /* USE_WINSOCK */

