# Automatically generated....
raise 'Must be invoked by installation process' unless $opfile

# -----------------------------------------
aClass = ClassModule.new("String", "Object", "class")
aClass.addFragment(Paragraph.new("A <code>String</code> object holds and manipulates an arbitrary sequence of bytes, typically representing characters. String objects may be created using <code>String::new</code> or as literals (see page 204).\n"))
aClass.addFragment(Paragraph.new("Because of aliasing issues, users of strings should be aware of the methods that modify the contents of a <code>String</code> object. Typically, methods with names ending in ``!'' modify their receiver, while those without a ``!'' return a new <code>String</code>. However, there are exceptions, such as <code>String\#[]=</code>.\n"))
m0002 = MethodDesc.new("new", "class", "String.new( <i>aString</i> ) -> <i>aNewString</i>")
m0002.addFragment(Paragraph.new("Returns a new string object containing a copy of <i>aString</i>.\n"))
aClass.addMethod(m0002)
m0003 = MethodDesc.new("%", "instance", "<i>str</i> % <i>arg</i> -> <i>aString</i>")
m0003.addFragment(Paragraph.new("Format---Uses <i>str</i> as a format specification, and returns the result of applying it to <i>arg</i>. If the format specification contains more than one substitution, then <i>arg</i> must be an <code>Array</code> containing the values to be substituted. See <code>Kernel::sprintf</code> on page 427 for details of the format string.\n"))
m0003.addFragment(Verbatim.new("\"%05d\" % 123                       \#=> \"00123\"\n\"%-5s: %08x\" % [ \"ID\", self.id ]   \#=> \"ID   : 200cd648\"\n"))
aClass.addMethod(m0003)
m0004 = MethodDesc.new("*", "instance", "<i>str</i> * <i>anInteger</i> -> <i>aString</i>")
m0004.addFragment(Paragraph.new("Copy---Returns a new <code>String</code> containing <i>anInteger</i> copies of the receiver.\n"))
m0004.addFragment(Verbatim.new("\"Ho! \" * 3   \#=> \"Ho! Ho! Ho! \"\n"))
aClass.addMethod(m0004)
m0005 = MethodDesc.new("+", "instance", "<i>str</i> + <i>aString</i> -> <i>aNewString</i>")
m0005.addFragment(Paragraph.new("Concatenation---Returns a new <code>String</code> containing <i>aString</i> concatenated to <i>str</i>.\n"))
m0005.addFragment(Verbatim.new("\"Hello from \" + self.to_s   \#=> \"Hello from main\"\n"))
aClass.addMethod(m0005)
m0006 = MethodDesc.new("<<", "instance", "<i>str</i> << <i>aFixnum</i> -> <i>str</i><br></br><i>str</i> << <i>anObject</i> -> <i>str</i>")
m0006.addFragment(Paragraph.new("Append---Concatenates the given object to <i>str</i>. If the object is a <code>Fixnum</code> between 0 and 255, it is converted to a character before concatenation.\n"))
m0006.addFragment(Verbatim.new("a = \"hello \"\na << \"world\"   \#=> \"hello world\"\na << 33        \#=> \"hello world!\"\na              \#=> \"hello world!\"\n"))
aClass.addMethod(m0006)
m0007 = MethodDesc.new("<=>", "instance", "<i>str</i> <=> <i>aString</i> -> -1, 0, +1")
m0007.addFragment(Paragraph.new("Comparison---Returns -1 if <i>str</i> is less than, 0 if <i>str</i> is equal to, and +1 if <i>str</i> is greater than <i>aString</i>. If the strings are of different lengths, and the strings are equal when compared up to the shortest length, then the longer string is considered greater than the shorter one. If the variable <code>$=</code> is <code>false</code>, the comparison is based on comparing the binary values of each character in the string. If <code>$=</code> is not <code>false</code>, then the comparison is case insensitive.<em>[The locale is ignored when case-insensitive comparisons are performed, so ``\\\"o'' will not match ``\\\"O''.]</em>\n"))
m0007.addFragment(Paragraph.new("<code><=></code> is the basis for the methods <code><</code>, <code><=</code>, <code>></code>, <code>>=</code>, and <code>between?</code>, included from module <code>Comparable</code>. The method <code>String\#==</code> does not use <code>Comparable\#==</code>.\n"))
m0007.addFragment(Verbatim.new("\"abcdef\" <=> \"abcde\"     \#=> 1\n\"abcdef\" <=> \"abcdef\"    \#=> 0\n\"abcdef\" <=> \"abcdefg\"   \#=> -1\n\"abcdef\" <=> \"ABCDEF\"    \#=> 1\n$= = true\n\"abcdef\" <=> \"ABCDEF\"    \#=> 0\n"))
aClass.addMethod(m0007)
m0008 = MethodDesc.new("==", "instance", "<i>str</i> == <i>anObject</i> -> <code>true</code> or <code>false</code>")
m0008.addFragment(Paragraph.new("Equality---If <i>anObject</i> is not a <code>String</code>, returns <code>false</code>. Otherwise, returns <code>true</code> if <i>str</i> <code><=></code> <i>anObject</i> returns zero.\n"))
aClass.addMethod(m0008)
m0009 = MethodDesc.new("===", "instance", "<i>str</i> === <i>anObject</i> -> <code>true</code> or <code>false</code>")
m0009.addFragment(Paragraph.new("Case Equality---Synonym for <code>String\#==</code>.\n"))
aClass.addMethod(m0009)
m0010 = MethodDesc.new("=~", "instance", "<i>str</i> =~ <i>anObject</i> -> <i>aFixnum</i> or <code>nil</code>")
m0010.addFragment(Paragraph.new("Match---If <i>anObject</i> is a <code>Regexp</code> or a <code>String</code>, uses it as a pattern to match against <i>str</i>. Returns the position the match starts, or <code>nil</code> if there is no match. Otherwise, invokes <i>anObject.=~</i>, passing <i>str</i> as an argument. The default <code>=~</code> in <code>Object</code> returns <code>false</code>.\n"))
m0010.addFragment(Verbatim.new("\"cat o' 9 tails\" =~ \"\\\\d\"   \#=> 7\n\"cat o' 9 tails\" =~ /\\d/    \#=> 7\n\"cat o' 9 tails\" =~ 9       \#=> false\n"))
aClass.addMethod(m0010)
m0011 = MethodDesc.new("[]", "instance", "<i>str</i>[ <i>aFixnum</i> ] -> <i>aFixnum</i> or <code>nil</code><br></br><i>str</i>[ <i>aFixnum</i>, <i>aFixnum</i> ] -> <i>aString</i> or <code>nil</code><br></br><i>str</i>[ <i>aRange</i> ] -> <i>aString</i> or <code>nil</code><br></br><i>str</i>[ <i>aRegexp</i> ] -> <i>aString</i> or <code>nil</code><br></br><i>str</i>[ <i>aString</i> ] -> <i>aString</i> or <code>nil</code>")
m0011.addFragment(Paragraph.new("Element Reference---If passed a single <code>Fixnum</code>, returns the code of the character at that position. If passed two <code>Fixnum</code> objects, returns a substring starting at the offset given by the first, and a length given by the second. If given a range, a substring containing characters at offsets given by the range is returned. In all three cases, if an offset is negative, it is counted from the end of <i>str</i>. Returns <code>nil</code> if the initial offset falls outside the string, the length is negative, or the beginning of the range is greater than the end.\n"))
m0011.addFragment(Paragraph.new("If a <code>Regexp</code> is supplied, the matching portion of <i>str</i> is returned. If a <code>String</code> is given, that string is returned if it occurs in <i>str</i>. In both cases, <code>nil</code> is returned if there is no match.\n"))
m0011.addFragment(Verbatim.new("a = \"hello there\"\na[1]             \#=> 101\na[1,3]           \#=> \"ell\"\na[1..3]          \#=> \"ell\"\na[-3,2]          \#=> \"er\"\na[-4..-2]        \#=> \"her\"\na[-2..-4]        \#=> nil\na[/th[aeiou]/]   \#=> \"the\"\na[\"lo\"]          \#=> \"lo\"\na[\"bye\"]         \#=> nil\n"))
aClass.addMethod(m0011)
m0012 = MethodDesc.new("[]=", "instance", "<i>str</i>[ <i>aFixnum</i> ] = <i>aFixnum</i><br></br><i>str</i>[ <i>aFixnum</i> ] = <i>aString</i><br></br><i>str</i>[ <i>aFixnum</i>, <i>aFixnum</i> ] = <i>aString</i><br></br><i>str</i>[ <i>aRange</i> ] = <i>aString</i><br></br><i>str</i>[ <i>aRegexp</i> ] = <i>aString</i><br></br><i>str</i>[ <i>aString</i> ] = <i>aString</i>")
m0012.addFragment(Paragraph.new("Element Assignment---Replaces some or all of the content of <i>str</i>. The portion of the string affected is determined using the same criteria as <code>String\#[]</code>. If the replacement string is not the same length as the text it is replacing, the string will be adjusted accordingly. The forms that take a <code>Fixnum</code> will raise an <code>IndexError</code> if the value is out of range; the <code>Range</code> form will raise a <code>RangeError</code>, and the <code>Regexp</code> and <code>String</code> forms will silently ignore the assignment.\n"))
m0012.addFragment(Verbatim.new("a = \"hello\"; a[2]       = 96;    a   \#=> \"he`lo\"\na = \"hello\"; a[2, 4]    = \"xyz\"; a   \#=> \"hexyz\"\na = \"hello\"; a[-4, 2]   = \"xyz\"; a   \#=> \"hxyzlo\"\na = \"hello\"; a[2..4]    = \"xyz\"; a   \#=> \"hexyz\"\na = \"hello\"; a[-4..-2]  = \"xyz\"; a   \#=> \"hxyzo\"\na = \"hello\"; a[/[el]+/] = \"xyz\"; a   \#=> \"hxyzo\"\na = \"hello\"; a[\"l\"]     = \"xyz\"; a   \#=> \"hexyzlo\"\na = \"hello\"; a[\"ll\"]    = \"xyz\"; a   \#=> \"hexyzo\"\na = \"hello\"; a[\"bad\"]   = \"xyz\"; a   \#=> \"hello\"\na = \"hello\"; a[2, 0]    = \"xyz\"; a   \#=> \"hexyzllo\"\n"))
aClass.addMethod(m0012)
m0013 = MethodDesc.new("~", "instance", "~<i>str</i> -> <i>aFixnum</i> or <code>nil</code>")
m0013.addFragment(Paragraph.new("Equivalent to <code>$_</code><code>=~ <i>str</i></code>.\n"))
aClass.addMethod(m0013)
m0014 = MethodDesc.new("capitalize", "instance", "<i>str</i>.capitalize -> <i>aString</i>")
m0014.addFragment(Paragraph.new("Returns a copy of <i>str</i> with the first character converted to uppercase and the remainder to lowercase.\n"))
m0014.addFragment(Verbatim.new("\"hello\".capitalize    \#=> \"Hello\"\n\"HELLO\".capitalize    \#=> \"Hello\"\n\"123ABC\".capitalize   \#=> \"123abc\"\n"))
aClass.addMethod(m0014)
m0015 = MethodDesc.new("capitalize!", "instance", "<i>str</i>.capitalize! -> <i>str</i> or <code>nil</code>")
m0015.addFragment(Paragraph.new("Modifies <i>str</i> by converting the first character to uppercase and the remainder to lowercase. Returns <code>nil</code> if no changes are made.\n"))
m0015.addFragment(Verbatim.new("a = \"hello\"\na.capitalize!   \#=> \"Hello\"\na               \#=> \"Hello\"\na.capitalize!   \#=> nil\n"))
aClass.addMethod(m0015)
m0016 = MethodDesc.new("center", "instance", "<i>str</i>.center( <i>anInteger</i> ) -> <i>aString</i>")
m0016.addFragment(Paragraph.new("If <i>anInteger</i> is greater than the length of <i>str</i>, returns a new <code>String</code> of length <i>anInteger</i> with <i>str</i> centered between spaces; otherwise, returns <i>str</i>.\n"))
m0016.addFragment(Verbatim.new("\"hello\".center(4)    \#=> \"hello\"\n\"hello\".center(20)   \#=> \"       hello        \"\n"))
aClass.addMethod(m0016)
m0017 = MethodDesc.new("chomp", "instance", "<i>str</i>.chomp( <i>aString</i>=<code>$/</code> ) -> <i>aString</i>")
m0017.addFragment(Paragraph.new("Returns a new <code>String</code> with the given record separator removed from the end of <i>str</i> (if present).\n"))
m0017.addFragment(Verbatim.new("\"hello\".chomp            \#=> \"hello\"\n\"hello\\n\".chomp          \#=> \"hello\"\n\"hello \\n there\".chomp   \#=> \"hello \\n there\"\n\"hello\".chomp(\"llo\")     \#=> \"he\"\n"))
aClass.addMethod(m0017)
m0018 = MethodDesc.new("chomp!", "instance", "<i>str</i>.chomp!( <i>aString</i>=<code>$/</code> ) -> <i>str</i> or <code>nil</code>")
m0018.addFragment(Paragraph.new("Modifies <i>str</i> in place as described for <code>String\#chomp</code>, returning <i>str</i>, or <code>nil</code> if no modifications were made.\n"))
aClass.addMethod(m0018)
m0019 = MethodDesc.new("chop", "instance", "<i>str</i>.chop -> <i>aString</i>")
m0019.addFragment(Paragraph.new("Returns a new <code>String</code> with the last character removed. If the string ends with <code>\\r\\n</code>, both characters are removed. Applying <code>chop</code> to an empty string returns an empty string. <code>String\#chomp</code> is often a safer alternative, as it leaves the string unchanged if it doesn't end in a record separator.\n"))
m0019.addFragment(Verbatim.new("\"string\\r\\n\".chop   \#=> \"string\"\n\"string\\n\\r\".chop   \#=> \"string\\n\"\n\"string\\n\".chop     \#=> \"string\"\n\"string\".chop       \#=> \"strin\"\n\"x\".chop.chop       \#=> \"\"\n"))
aClass.addMethod(m0019)
m0020 = MethodDesc.new("chop!", "instance", "<i>str</i>.chop! -> <i>str</i> or <code>nil</code>")
m0020.addFragment(Paragraph.new("Processes <i>str</i> as for <code>String\#chop</code>, returning <i>str</i>, or <code>nil</code> if <i>str</i> is the empty string. See also <code>String\#chomp!</code>.\n"))
aClass.addMethod(m0020)
m0021 = MethodDesc.new("concat", "instance", "<i>str</i>.concat( <i>aFixnum</i> ) -> <i>str</i><br></br><i>str</i>.concat( <i>anObject</i> ) -> <i>str</i>")
m0021.addFragment(Paragraph.new("Synonym for <code>String\#<<</code>.\n"))
aClass.addMethod(m0021)
m0022 = MethodDesc.new("count", "instance", "<i>str</i>.count( <i>[</i><i>aString</i><i>]+></i> ) -> <i>aFixnum</i>")
m0022.addFragment(Paragraph.new("Each <i>aString</i> parameter defines a set of characters to count. The intersection of these sets defines the characters to count in <i>str</i>. Any <i>aString</i> that starts with a caret (^) is negated. The sequence c1--c2 means all characters between c1 and c2.\n"))
m0022.addFragment(Verbatim.new("a = \"hello world\"\na.count \"lo\"            \#=> 5\na.count \"lo\", \"o\"       \#=> 2\na.count \"hello\", \"^l\"   \#=> 4\na.count \"ej-m\"          \#=> 4\n"))
aClass.addMethod(m0022)
m0023 = MethodDesc.new("crypt", "instance", "<i>str</i>.crypt( <i>aString</i> ) -> <i>aString</i>")
m0023.addFragment(Paragraph.new("Applies a one-way cryptographic hash to <i>str</i> by invoking the standard library function <code>crypt</code>. The argument is the salt string, which should be two characters long, each character drawn from <code>[a-zA-Z0-9./]</code>.\n"))
aClass.addMethod(m0023)
m0024 = MethodDesc.new("delete", "instance", "<i>str</i>.delete( <i>[</i><i>aString</i><i>]+></i> ) -> <i>aString</i>")
m0024.addFragment(Paragraph.new("Returns a copy of <i>str</i> with all characters in the intersection of its arguments deleted. Uses the same rules for building the set of characters as <code>String\#count</code>.\n"))
m0024.addFragment(Verbatim.new("\"hello\".delete \"l\",\"lo\"        \#=> \"heo\"\n\"hello\".delete \"lo\"            \#=> \"he\"\n\"hello\".delete \"aeiou\", \"^e\"   \#=> \"hell\"\n\"hello\".delete \"ej-m\"          \#=> \"ho\"\n"))
aClass.addMethod(m0024)
m0025 = MethodDesc.new("delete!", "instance", "<i>str</i>.delete!( <i>[</i><i>aString</i><i>]+></i> ) -> <i>str</i> or <code>nil</code>")
m0025.addFragment(Paragraph.new("Performs a <code>delete</code> operation in place, returning <i>str</i>, or <code>nil</code> if <i>str</i> was not modified.\n"))
aClass.addMethod(m0025)
m0026 = MethodDesc.new("downcase", "instance", "<i>str</i>.downcase -> <i>aString</i>")
m0026.addFragment(Paragraph.new("Returns a copy of <i>str</i> with all uppercase letters replaced with their lowercase counterparts. The operation is locale insensitive---only characters ``A'' to ``Z'' are affected.\n"))
m0026.addFragment(Verbatim.new("\"hEllO\".downcase   \#=> \"hello\"\n"))
aClass.addMethod(m0026)
m0027 = MethodDesc.new("downcase!", "instance", "<i>str</i>.downcase! -> <i>str</i> or <code>nil</code>")
m0027.addFragment(Paragraph.new("Downcases the contents of <i>str</i>, returning <code>nil</code> if no changes were made.\n"))
aClass.addMethod(m0027)
m0028 = MethodDesc.new("dump", "instance", "<i>str</i>.dump -> <i>aString</i>")
m0028.addFragment(Paragraph.new("Produces a version of <i>str</i> with all nonprinting characters replaced by <code>\\nnn</code> notation and all special characters escaped.\n"))
aClass.addMethod(m0028)
m0029 = MethodDesc.new("each", "instance", "<i>str</i>.each( <i>aString</i>=<code>$/</code> ) {| substr | block } -> <i>str</i>")
m0029.addFragment(Paragraph.new("Splits <i>str</i> using the supplied parameter as the record separator (<code>$/</code> by default), passing each substring in turn to the supplied block. If a zero-length record separator is supplied, the string is split on <code>\\n</code> characters, except that multiple successive newlines are appended together.\n"))
m0029.addFragment(Verbatim.new("print \"Example one\\n\"\n\"hello\\nworld\".each {|s| p s}\nprint \"Example two\\n\"\n\"hello\\nworld\".each('l') {|s| p s}\nprint \"Example three\\n\"\n\"hello\\n\\n\\nworld\".each('') {|s| p s}"))
m0029.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0029.addFragment(Verbatim.new("Example one\n\"hello\\n\"\n\"world\"\nExample two\n\"hel\"\n\"l\"\n\"o\\nworl\"\n\"d\"\nExample three\n\"hello\\n\\n\\n\"\n\"world\""))
aClass.addMethod(m0029)
m0030 = MethodDesc.new("each_byte", "instance", "<i>str</i>.each_byte {| aFixnum | block } <p></p> -> <i>str</i>")
m0030.addFragment(Paragraph.new("Passes each byte in <i>str</i> to the given block.\n"))
m0030.addFragment(Verbatim.new("\"hello\".each_byte {|c| print c, ' ' }"))
m0030.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0030.addFragment(Verbatim.new("104 101 108 108 111"))
aClass.addMethod(m0030)
m0031 = MethodDesc.new("each_line", "instance", "<i>str</i>.each_line( <i>aString</i>=<code>$/</code> ) {| substr | block } -> <i>str</i>")
m0031.addFragment(Paragraph.new("Synonym for <code>String\#each</code>.\n"))
aClass.addMethod(m0031)
m0032 = MethodDesc.new("empty?", "instance", "<i>str</i>.empty? -> <code>true</code> or <code>false</code>")
m0032.addFragment(Paragraph.new("Returns <code>true</code> if <i>str</i> has a length of zero.\n"))
m0032.addFragment(Verbatim.new("\"hello\".empty?   \#=> false\n\"\".empty?        \#=> true\n"))
aClass.addMethod(m0032)
m0033 = MethodDesc.new("gsub", "instance", "<i>str</i>.gsub( <i>pattern</i>, <i>replacement</i> ) -> <i>aString</i><br></br><i>str</i>.gsub( <i>pattern</i> ) {| match | block } <p></p> -> <i>aString</i>")
m0033.addFragment(Paragraph.new("Returns a copy of <i>str</i> with <em>all</em> occurrences of <i>pattern</i> replaced with either <i>replacement</i> or the value of the block. If a string is used as the replacement, special variables from the match (such as <code>$&</code> and <code>$1</code>) cannot be substituted into it, as substitution into the string occurs before the pattern match starts. However, the sequences <code>\\1</code>, <code>\\2</code>, and so on may be used to interpolate successive groups in the match. These sequences are shown in Table 22.7 on page 376.\n"))
m0033.addFragment(Paragraph.new("In the block form, the current match is passed in as a parameter, and variables such as <code>$1</code>, <code>$2</code>, <code>$`</code>, <code>$&</code>, and <code>$'</code> will be set appropriately. The value returned by the block will be substituted for the match on each call.\n"))
m0033.addFragment(Paragraph.new("The result inherits any tainting in the original string or any supplied replacement string.\n"))
m0033.addFragment(Verbatim.new("\"hello\".gsub(/[aeiou]/, '*')              \#=> \"h*ll*\"\n\"hello\".gsub(/([aeiou])/, '<\\1>')         \#=> \"h<e>ll<o>\"\n\"hello\".gsub('.') {|s| s[0].to_s + ' '}   \#=> \"104 101 108 108 111 \"\n"))
aClass.addMethod(m0033)
m0034 = MethodDesc.new("gsub!", "instance", "<i>str</i>.gsub!( <i>pattern</i>, <i>replacement</i> ) -> <i>str</i> or <code>nil</code><br></br><i>str</i>.gsub!( <i>pattern</i> ) {| match | block } <p></p> -> <i>str</i> or <code>nil</code>")
m0034.addFragment(Paragraph.new("Performs the substitutions of <code>String\#gsub</code> in place, returning <i>str</i>, or <code>nil</code> if no substitutions were performed.\n"))
aClass.addMethod(m0034)
m0035 = MethodDesc.new("hash", "instance", "<i>str</i>.hash -> <i>aFixnum</i>")
m0035.addFragment(Paragraph.new("Generates a <code>Fixnum</code> hash value for <i>str</i>. If <code>$=</code> is <code>true</code>, the hash will be case insensitive.\n"))
m0035.addFragment(Verbatim.new("$= = true\nhash = { 'cat' => 'Feline', 'dog' => 'canine' }\nhash['cat']                                  \#=> \"Feline\"\nhash['cAt']                                  \#=> \"Feline\"\n$= = false\nhash.rehash     \# re-calculate hash values   \#=> {\"dog\"=>\"canine\", \"cat\"=>\"Feline\"}\nhash['cat']                                  \#=> \"Feline\"\nhash['cAt']                                  \#=> nil\n"))
aClass.addMethod(m0035)
m0036 = MethodDesc.new("hex", "instance", "<i>str</i>.hex -> <i>anInteger</i>")
m0036.addFragment(Paragraph.new("Treats leading characters from <i>str</i> as a string of hexadecimal digits (with an optional sign and an optional <code>0x</code>) and returns the corresponding number. Zero is returned on error.\n"))
m0036.addFragment(Verbatim.new("\"0x0a\".hex     \#=> 10\n\"-1234\".hex    \#=> -4660\n\"0\".hex        \#=> 0\n\"wombat\".hex   \#=> 0\n"))
aClass.addMethod(m0036)
m0037 = MethodDesc.new("include?", "instance", "<i>str</i>.include? <i>aString</i> -> <code>true</code> or <code>false</code><br></br><i>str</i>.include? <i>aFixnum</i> -> <code>true</code> or <code>false</code>")
m0037.addFragment(Paragraph.new("Returns <code>true</code> if <i>str</i> contains the given string or character.\n"))
m0037.addFragment(Verbatim.new("\"hello\".include? \"lo\"   \#=> true\n\"hello\".include? \"ol\"   \#=> false\n\"hello\".include? ?h     \#=> true\n"))
aClass.addMethod(m0037)
m0038 = MethodDesc.new("index", "instance", "<i>str</i>.index( <i>aString</i> <i>[</i>, <i>anOffset</i><i>]</i> ) -> <i>aFixnum</i> or <code>nil</code><br></br><i>str</i>.index( <i>aFixnum</i> <i>[</i>, <i>anOffset</i><i>]</i> ) -> <i>aFixnum</i> or <code>nil</code><br></br><i>str</i>.index( <i>aRegexp</i> <i>[</i>, <i>anOffset</i><i>]</i> ) -> <i>aFixnum</i> or <code>nil</code>")
m0038.addFragment(Paragraph.new("Returns the index of the first occurrence of the given substring, character, or pattern in <i>str</i>. Returns <code>nil</code> if not found. If the second parameter is present, it specifies the position in the string to begin the search.\n"))
m0038.addFragment(Verbatim.new("\"hello\".index('e')             \#=> 1\n\"hello\".index('lo')            \#=> 3\n\"hello\".index('a')             \#=> nil\n\"hello\".index(101)             \#=> 1\n\"hello\".index(/[aeiou]/, -3)   \#=> 4\n"))
aClass.addMethod(m0038)
m0039 = MethodDesc.new("intern", "instance", "<i>str</i>.intern -> <i>aSymbol</i>")
m0039.addFragment(Paragraph.new("Returns the <code>Symbol</code> corresponding to <i>str</i>, creating the symbol if it did not previously exist. See <code>Symbol\#id2name</code> on page 389.\n"))
m0039.addFragment(Verbatim.new("\"Koala\".intern   \#=> :Koala\n"))
aClass.addMethod(m0039)
m0040 = MethodDesc.new("length", "instance", "<i>str</i>.length -> <i>anInteger</i>")
m0040.addFragment(Paragraph.new("Returns the length of <i>str</i>.\n"))
aClass.addMethod(m0040)
m0041 = MethodDesc.new("ljust", "instance", "<i>str</i>.ljust( <i>anInteger</i> ) -> <i>aString</i>")
m0041.addFragment(Paragraph.new("If <i>anInteger</i> is greater than the length of <i>str</i>, returns a new <code>String</code> of length <i>anInteger</i> with <i>str</i> left justified and space padded; otherwise, returns <i>str</i>.\n"))
m0041.addFragment(Verbatim.new("\"hello\".ljust(4)    \#=> \"hello\"\n\"hello\".ljust(20)   \#=> \"hello               \"\n"))
aClass.addMethod(m0041)
m0042 = MethodDesc.new("next", "instance", "<i>str</i>.next -> <i>aString</i>")
m0042.addFragment(Paragraph.new("Synonym for <code>String\#succ</code>.\n"))
aClass.addMethod(m0042)
m0043 = MethodDesc.new("next!", "instance", "<i>str</i>.next! -> <i>str</i>")
m0043.addFragment(Paragraph.new("Synonym for <code>String\#succ!</code>.\n"))
aClass.addMethod(m0043)
m0044 = MethodDesc.new("oct", "instance", "<i>str</i>.oct -> <i>anInteger</i>")
m0044.addFragment(Paragraph.new("Treats <i>str</i> as a string of octal digits (with an optional sign) and returns the corresponding number. Returns 0 if the conversion fails.\n"))
m0044.addFragment(Verbatim.new("\"123\".oct       \#=> 83\n\"-377\".oct      \#=> -255\n\"bad\".oct       \#=> 0\n\"0377bad\".oct   \#=> 255\n"))
aClass.addMethod(m0044)
m0045 = MethodDesc.new("replace", "instance", "<i>str</i>.replace( <i>aString</i> ) -> <i>str</i>")
m0045.addFragment(Paragraph.new("Replaces the contents and taintedness of <i>str</i> with the corresponding values in <i>aString</i>.\n"))
m0045.addFragment(Verbatim.new("s = \"hello\"         \#=> \"hello\"\ns.replace \"world\"   \#=> \"world\"\n"))
aClass.addMethod(m0045)
m0046 = MethodDesc.new("reverse", "instance", "<i>str</i>.reverse -> <i>aString</i>")
m0046.addFragment(Paragraph.new("Returns a new string with the characters from <i>str</i> in reverse order.\n"))
m0046.addFragment(Verbatim.new("\"stressed\".reverse   \#=> \"desserts\"\n"))
aClass.addMethod(m0046)
m0047 = MethodDesc.new("reverse!", "instance", "<i>str</i>.reverse! -> <i>str</i>")
m0047.addFragment(Paragraph.new("Reverses <i>str</i> in place.\n"))
aClass.addMethod(m0047)
m0048 = MethodDesc.new("rindex", "instance", "<i>str</i>.rindex( <i>aString</i> <i>[</i>, <i>aFixnum</i><i>]</i> ) -> <i>aFixnum</i> or <code>nil</code><br></br><i>str</i>.rindex( <i>aFixnum</i> <i>[</i>, <i>aFixnum</i><i>]</i> ) -> <i>aFixnum</i> or <code>nil</code><br></br><i>str</i>.rindex( <i>aRegexp</i> <i>[</i>, <i>aFixnum</i><i>]</i> ) -> <i>aFixnum</i> or <code>nil</code>")
m0048.addFragment(Paragraph.new("Returns the index of the last occurrence of the given substring, character, or pattern in <i>str</i>. Returns <code>nil</code> if not found. If the second parameter is present, it specifies the position in the string to end the search---characters beyond this point will not be considered.\n"))
m0048.addFragment(Verbatim.new("\"hello\".rindex('e')             \#=> 1\n\"hello\".rindex('l')             \#=> 3\n\"hello\".rindex('a')             \#=> nil\n\"hello\".rindex(101)             \#=> 1\n\"hello\".rindex(/[aeiou]/, -2)   \#=> 1\n"))
aClass.addMethod(m0048)
m0049 = MethodDesc.new("rjust", "instance", "<i>str</i>.rjust( <i>anInteger</i> ) -> <i>aString</i>")
m0049.addFragment(Paragraph.new("If <i>anInteger</i> is greater than the length of <i>str</i>, returns a new <code>String</code> of length <i>anInteger</i> with <i>str</i> right justified and space padded; otherwise, returns <i>str</i>.\n"))
m0049.addFragment(Verbatim.new("\"hello\".rjust(4)    \#=> \"hello\"\n\"hello\".rjust(20)   \#=> \"               hello\"\n"))
aClass.addMethod(m0049)
m0050 = MethodDesc.new("scan", "instance", "<i>str</i>.scan( <i>pattern</i> ) -> <i>anArray</i><br></br><i>str</i>.scan( <i>pattern</i> ) {| match, ...| block } -> <i>str</i>")
m0050.addFragment(Paragraph.new("Both forms iterate through <i>str</i>, matching the pattern (which may be a <code>Regexp</code> or a <code>String</code>). For each match, a result is generated and either added to the result array or passed to the block. If the pattern contains no groups, each individual result consists of the matched string, <code>$&</code>. If the pattern contains groups, each individual result is itself an array containing one entry per group.\n"))
m0050.addFragment(Verbatim.new("a = \"cruel world\"\na.scan(/\\w+/)        \#=> [\"cruel\", \"world\"]\na.scan(/.../)        \#=> [\"cru\", \"el \", \"wor\"]\na.scan(/(...)/)      \#=> [[\"cru\"], [\"el \"], [\"wor\"]]\na.scan(/(..)(..)/)   \#=> [[\"cr\", \"ue\"], [\"l \", \"wo\"]]\n"))
m0050.addFragment(Paragraph.new("And the block form:\n"))
m0050.addFragment(Verbatim.new("a.scan(/\\w+/) {|w| print \"<<\#{w}>> \" }\nprint \"\\n\"\na.scan(/(.)(.)/) {|a,b| print b, a }\nprint \"\\n\""))
m0050.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0050.addFragment(Verbatim.new("<<cruel>> <<world>>\nrceu lowlr"))
aClass.addMethod(m0050)
m0051 = MethodDesc.new("size", "instance", "<i>str</i>.size -> <i>anInteger</i>")
m0051.addFragment(Paragraph.new("Synonym for <code>String\#length</code>.\n"))
aClass.addMethod(m0051)
m0052 = MethodDesc.new("slice", "instance", "<i>str</i>.slice( <i>aFixnum</i> ) -> <i>aFixnum</i> or <code>nil</code><br></br><i>str</i>.slice( <i>aFixnum</i>, <i>aFixnum</i> ) -> <i>aString</i> or <code>nil</code><br></br><i>str</i>.slice( <i>aRange</i> ) -> <i>aString</i> or <code>nil</code><br></br><i>str</i>.slice( <i>aRegexp</i> ) -> <i>aString</i> or <code>nil</code><br></br><i>str</i>.slice( <i>aString</i> ) -> <i>aString</i> or <code>nil</code>")
m0052.addFragment(Paragraph.new("Synonym for <code>String\#[ ]</code>.\n"))
m0052.addFragment(Verbatim.new("a = \"hello there\"\na.slice(1)        \#=> 101\na.slice(1,3)      \#=> \"ell\"\na.slice(1..3)     \#=> \"ell\"\na.slice(-3,2)     \#=> \"er\"\na.slice(-4..-2)   \#=> \"her\"\n"))
m0052.addFragment(Verbatim.new("a.slice(-2..-4)        \#=> nil\na.slice(/th[aeiou]/)   \#=> \"the\"\na.slice(\"lo\")          \#=> \"lo\"\na.slice(\"bye\")         \#=> nil\n"))
aClass.addMethod(m0052)
m0053 = MethodDesc.new("slice!", "instance", "<i>str</i>.slice!( <i>aFixnum</i> ) -> <i>aFixnum</i> or <code>nil</code><br></br><i>str</i>.slice!( <i>aFixnum</i>, <i>aFixnum</i> ) -> <i>aString</i> or <code>nil</code><br></br><i>str</i>.slice!( <i>aRange</i> ) -> <i>aString</i> or <code>nil</code><br></br><i>str</i>.slice!( <i>aRegexp</i> ) -> <i>aString</i> or <code>nil</code><br></br><i>str</i>.slice!( <i>aString</i> ) -> <i>aString</i> or <code>nil</code>")
m0053.addFragment(Paragraph.new("Deletes the specified portion from <i>str</i>, and returns the portion deleted. The forms that take a <code>Fixnum</code> will raise an <code>IndexError</code> if the value is out of range; the <code>Range</code> form will raise a <code>RangeError</code>, and the <code>Regexp</code> and <code>String</code> forms will silently ignore the assignment.\n"))
m0053.addFragment(Verbatim.new("string = \"this is a string\"\nstring.slice!(2)        \#=> 105\nstring.slice!(3..6)     \#=> \" is \"\nstring.slice!(/s.*t/)   \#=> \"sa st\"\nstring.slice!(\"r\")      \#=> \"r\"\nstring                  \#=> \"thing\"\n"))
aClass.addMethod(m0053)
m0054 = MethodDesc.new("split", "instance", "<i>str</i>.split( <i>pattern</i>=<code>$;</code>, <i>[</i><i>limit</i><i>]</i> ) -> <i>anArray</i>")
m0054.addFragment(Paragraph.new("Divides <i>str</i> into substrings based on a delimiter, returning an array of these substrings.\n"))
m0054.addFragment(Paragraph.new("If <i>pattern</i> is a <code>String</code>, then its contents are used as the delimiter when splitting <i>str</i>. If <i>pattern</i> is a single space, <i>str</i> is split on whitespace, with leading whitespace and runs of contiguous whitespace characters ignored.\n"))
m0054.addFragment(Paragraph.new("If <i>pattern</i> is a <code>Regexp</code>, <i>str</i> is divided where the pattern matches. Whenever the pattern matches a zero-length string, <i>str</i> is split into individual characters.\n"))
m0054.addFragment(Paragraph.new("If <i>pattern</i> is omitted, the value of <code>$;</code> is used. If <code>$;</code> is <code>nil</code> (which is the default), <i>str</i> is split on whitespace as if ` ' were specified.\n"))
m0054.addFragment(Paragraph.new("If the <i>limit</i> parameter is omitted, trailing null fields are supressed. If <i>limit</i> is a positive number, at most that number of fields will be returned (if <i>limit</i> is <code>1</code>, the entire string is returned as the only entry in an array). If negative, there is no limit to the number of fields returned, and trailing null fields are not supressed.\n"))
m0054.addFragment(Verbatim.new("\" now's  the time\".split        \#=> [\"now's\", \"the\", \"time\"]\n\" now's  the time\".split(' ')   \#=> [\"now's\", \"the\", \"time\"]\n\" now's  the time\".split(/ /)   \#=> [\"\", \"now's\", \"\", \"the\", \"time\"]\n\"1, 2.34,56, 7\".split(/,\\s*/)   \#=> [\"1\", \"2.34\", \"56\", \"7\"]\n\"hello\".split(//)               \#=> [\"h\", \"e\", \"l\", \"l\", \"o\"]\n\"hello\".split(//, 3)            \#=> [\"h\", \"e\", \"llo\"]\n\"hi mom\".split(/\\s*/)           \#=> [\"h\", \"i\", \"m\", \"o\", \"m\"]\n"))
m0054.addFragment(Verbatim.new("\"mellow yellow\".split(\"ello\")   \#=> [\"m\", \"w y\", \"w\"]\n\"1,2,,3,4,,\".split(',')         \#=> [\"1\", \"2\", \"\", \"3\", \"4\"]\n\"1,2,,3,4,,\".split(',', 4)      \#=> [\"1\", \"2\", \"\", \"3,4,,\"]\n\"1,2,,3,4,,\".split(',', -4)     \#=> [\"1\", \"2\", \"\", \"3\", \"4\", \"\", \"\"]\n"))
aClass.addMethod(m0054)
m0055 = MethodDesc.new("squeeze", "instance", "<i>str</i>.squeeze( <i>[</i><i>aString</i><i>]*</i> ) -> <i>aNewString</i>")
m0055.addFragment(Paragraph.new("Builds a set of characters from the <i>aString</i> parameter(s) using the procedure described for <code>String\#count</code> on page 373. Returns a new string where runs of the same character that occur in this set are replaced by a single character. If no arguments are given, all runs of identical characters are replaced by a single character.\n"))
m0055.addFragment(Verbatim.new("\"yellow moon\".squeeze                  \#=> \"yelow mon\"\n\"  now   is  the\".squeeze(\" \")         \#=> \" now is the\"\n\"putters shoot balls\".squeeze(\"m-z\")   \#=> \"puters shot balls\"\n"))
aClass.addMethod(m0055)
m0056 = MethodDesc.new("squeeze!", "instance", "<i>str</i>.squeeze!( <i>[</i><i>aString</i><i>]*</i> ) -> <i>str</i> or <code>nil</code>")
m0056.addFragment(Paragraph.new("Squeezes <i>str</i> in place, returning either <i>str</i>, or <code>nil</code> if no changes were made.\n"))
aClass.addMethod(m0056)
m0057 = MethodDesc.new("strip", "instance", "<i>str</i>.strip -> <i>aString</i>")
m0057.addFragment(Paragraph.new("Returns a copy of <i>str</i> with leading and trailing whitespace removed.\n"))
m0057.addFragment(Verbatim.new("\"    hello    \".strip   \#=> \"hello\"\n\"\\tgoodbye\\r\\n\".strip   \#=> \"goodbye\"\n"))
aClass.addMethod(m0057)
m0058 = MethodDesc.new("strip!", "instance", "<i>str</i>.strip! -> <i>str</i> or <code>nil</code>")
m0058.addFragment(Paragraph.new("Removes leading and trailing whitespace from <i>str</i>. Returns <code>nil</code> if <i>str</i> was not altered.\n"))
aClass.addMethod(m0058)
m0059 = MethodDesc.new("sub", "instance", "<i>str</i>.sub( <i>pattern</i>, <i>replacement</i> ) -> <i>aString</i><br></br><i>str</i>.sub( <i>pattern</i> ) {| match | block } -> <i>aString</i>")
m0059.addFragment(Paragraph.new("Returns a copy of <i>str</i> with the <em>first</em> occurrence of <i>pattern</i> replaced with either <i>replacement</i> or the value of the block. If the string form of the method is used, special variables such as <code>$&</code> will not be useful, as substitution into the string occurs before the pattern match starts. However, the sequences <code>\\1</code>, <code>\\2</code>, listed in Table 22.7 on page 376 may be used.\n"))
m0059.addFragment(Paragraph.new("In the block form, the current match is passed in as a parameter, and variables such as <code>$1</code>, <code>$2</code>, <code>$`</code>, <code>$&</code>, and <code>$'</code> will be set appropriately. The value returned by the block will be substituted for the match on each call.\n"))
m0059.addFragment(Verbatim.new("\"hello\".sub(/[aeiou]/, '*')               \#=> \"h*llo\"\n\"hello\".sub(/([aeiou])/, '<\\1>')          \#=> \"h<e>llo\"\n\"hello\".sub('.') {|s| s[0].to_s + ' ' }   \#=> \"104 ello\"\n"))
aClass.addMethod(m0059)
m0060 = MethodDesc.new("sub!", "instance", "<i>str</i>.sub!( <i>pattern</i>, <i>replacement</i> ) -> <i>str</i> or <code>nil</code><br></br><i>str</i>.sub!( <i>pattern</i> ) {| match | block } <p></p> -> <i>str</i> or <code>nil</code>")
m0060.addFragment(Paragraph.new("Performs the substitutions of <code>String\#sub</code> in place, returning <i>str</i>, or <code>nil</code> if no substitutions were performed.\n"))
aClass.addMethod(m0060)
m0061 = MethodDesc.new("succ", "instance", "<i>str</i>.succ -> <i>aString</i>")
m0061.addFragment(Paragraph.new("Returns the successor to <i>str</i>. The successor is calculated by incrementing characters starting from the rightmost alphanumeric (or the rightmost character if there are no alphanumerics) in the string. Incrementing a digit always results in another digit, and incrementing a letter results in another letter of the same case. Incrementing nonalphanumerics uses the underlying character set's collating sequence.\n"))
m0061.addFragment(Paragraph.new("If the increment generates a ``carry,'' the character to the left of it is incremented. This process repeats until there is no carry, adding an additional character if necessary.\n"))
m0061.addFragment(Verbatim.new("\"abcd\".succ        \#=> \"abce\"\n\"THX1138\".succ     \#=> \"THX1139\"\n\"<<koala>>\".succ   \#=> \"<<koalb>>\"\n\"1999zzz\".succ     \#=> \"2000aaa\"\n\"ZZZ9999\".succ     \#=> \"AAAA0000\"\n\"***\".succ         \#=> \"**+\"\n"))
aClass.addMethod(m0061)
m0062 = MethodDesc.new("succ!", "instance", "<i>str</i>.succ! -> <i>str</i>")
m0062.addFragment(Paragraph.new("Equivalent to <code>String\#succ</code>, but modifies the receiver in place.\n"))
aClass.addMethod(m0062)
m0063 = MethodDesc.new("sum", "instance", "<i>str</i>.sum( <i>aFixnum</i>=16 ) -> <i>anInteger</i>")
m0063.addFragment(Paragraph.new("Returns a basic <em>n</em>-bit checksum of the characters in <i>str</i>, where <em>n</em> is the optional parameter, defaulting to 16. The result is simply the sum of the binary value of each character in <i>str</i> modulo 2n - 1. This is not a particularly good checksum.\n"))
aClass.addMethod(m0063)
m0064 = MethodDesc.new("swapcase", "instance", "<i>str</i>.swapcase -> <i>aString</i>")
m0064.addFragment(Paragraph.new("Returns a copy of <i>str</i> with uppercase alphabetic characters converted to lowercase and lowercase characters converted to uppercase.\n"))
m0064.addFragment(Verbatim.new("\"Hello\".swapcase          \#=> \"hELLO\"\n\"cYbEr_PuNk11\".swapcase   \#=> \"CyBeR_pUnK11\"\n"))
aClass.addMethod(m0064)
m0065 = MethodDesc.new("swapcase!", "instance", "<i>str</i>.swapcase! -> <i>str</i> or <code>nil</code>")
m0065.addFragment(Paragraph.new("Equivalent to <code>String\#swapcase</code>, but modifies the receiver in place, returning <i>str</i>, or <code>nil</code> if no changes were made.\n"))
aClass.addMethod(m0065)
m0066 = MethodDesc.new("to_f", "instance", "<i>str</i>.to_f -> <i>aFloat</i>")
m0066.addFragment(Paragraph.new("Returns the result of interpreting leading characters in <i>str</i> as a floating point number. Extraneous characters past the end of a valid number are ignored. If there is not a valid number at the start of <i>str</i>, <code>0.0</code> is returned. The method never raises an exception.\n"))
m0066.addFragment(Verbatim.new("\"123.45e1\".to_f        \#=> 1234.5\n\"45.67 degrees\".to_f   \#=> 45.67\n\"thx1138\".to_f         \#=> 0.0\n"))
aClass.addMethod(m0066)
m0067 = MethodDesc.new("to_i", "instance", "<i>str</i>.to_i -> <i>anInteger</i>")
m0067.addFragment(Paragraph.new("Returns the result of interpreting leading characters in <i>str</i> as a decimal integer. Extraneous characters past the end of a valid number are ignored. If there is not a valid number at the start of <i>str</i>, <code>0</code> is returned. The method never raises an exception.\n"))
m0067.addFragment(Verbatim.new("\"12345\".to_i             \#=> 12345\n\"99 red balloons\".to_i   \#=> 99\n\"0x0a\".to_i              \#=> 0\n\"hello\".to_i             \#=> 0\n"))
aClass.addMethod(m0067)
m0068 = MethodDesc.new("to_s", "instance", "<i>str</i>.to_s -> <i>str</i>")
m0068.addFragment(Paragraph.new("Returns the receiver.\n"))
aClass.addMethod(m0068)
m0069 = MethodDesc.new("to_str", "instance", "<i>str</i>.to_str -> <i>str</i>")
m0069.addFragment(Paragraph.new("Synonym for <code>String\#to_s</code>. <code>to_str</code> is used by methods such as <code>String\#concat</code> to convert their arguments to a string. Unlike <code>to_s</code>, which is supported by almost all classes, <code>to_str</code> is normally implemented only by those classes that act like strings. Of the built-in classes, only <code>Exception</code> and <code>String</code> implement <code>to_str</code>.\n"))
aClass.addMethod(m0069)
m0070 = MethodDesc.new("tr", "instance", "<i>str</i>.tr( <i>fromString</i>, <i>toString</i> ) -> <i>aString</i>")
m0070.addFragment(Paragraph.new("Returns a copy of <i>str</i> with the characters in <i>fromString</i> replaced by the corresponding characters in <i>toString</i>. If <i>toString</i> is shorter than <i>fromString</i>, it is padded with its last character. Both strings may use the c1--c2 notation to denote ranges of characters, and <i>fromString</i> may start with a <code>^</code>, which denotes all characters except those listed.\n"))
m0070.addFragment(Verbatim.new("\"hello\".tr('aeiou', '*')    \#=> \"h*ll*\"\n\"hello\".tr('^aeiou', '*')   \#=> \"*e**o\"\n\"hello\".tr('el', 'ip')      \#=> \"hippo\"\n\"hello\".tr('a-y', 'b-z')    \#=> \"ifmmp\"\n"))
aClass.addMethod(m0070)
m0071 = MethodDesc.new("tr!", "instance", "<i>str</i>.tr!( <i>fromString</i>, <i>toString</i> ) -> <i>str</i> or <code>nil</code>")
m0071.addFragment(Paragraph.new("Translates <i>str</i> in place, using the same rules as <code>String\#tr</code>. Returns <i>str</i>, or <code>nil</code> if no changes were made.\n"))
aClass.addMethod(m0071)
m0072 = MethodDesc.new("tr_s", "instance", "<i>str</i>.tr_s( <i>fromString</i>, <i>toString</i> ) -> <i>aString</i>")
m0072.addFragment(Paragraph.new("Processes a copy of <i>str</i> as described under <code>String\#tr</code>, then removes duplicate characters in regions that were affected by the translation.\n"))
m0072.addFragment(Verbatim.new("\"hello\".tr_s('l', 'r')     \#=> \"hero\"\n\"hello\".tr_s('el', '*')    \#=> \"h*o\"\n\"hello\".tr_s('el', 'hx')   \#=> \"hhxo\"\n"))
aClass.addMethod(m0072)
m0073 = MethodDesc.new("tr_s!", "instance", "<i>str</i>.tr_s!( <i>fromString</i>, <i>toString</i> ) -> <i>str</i> or <code>nil</code>")
m0073.addFragment(Paragraph.new("Performs <code>String\#tr_s</code> processing on <i>str</i> in place, returning <i>str</i>, or <code>nil</code> if no changes were made.\n"))
aClass.addMethod(m0073)
m0074 = MethodDesc.new("unpack", "instance", "<i>str</i>.unpack( <i>format</i> ) -> <i>anArray</i>")
m0074.addFragment(Paragraph.new("Decodes <i>str</i> (which may contain binary data) according to the format string, returning an array of each value extracted. The format string consists of a sequence of single-character directives, summarized in Table 22.8 on page 384. Each directive may be followed by a number, indicating the number of times to repeat with this directive. An asterisk (``<code>*</code>'') will use up all remaining elements. The directives <code>sSiIlL</code> may each be followed by an underscore (``<code>_</code>'') to use the underlying platform's native size for the specified type; otherwise, it uses a platform-independent consistent size. Spaces are ignored in the format string. See also <code>Array\#pack</code> on page 290.\n"))
m0074.addFragment(Verbatim.new("\"abc \\0\\0abc \\0\\0\".unpack('A6Z6')   \#=> [\"abc\", \"abc \"]\n\"abc \\0\\0\".unpack('a3a3')           \#=> [\"abc\", \" \\000\\000\"]\n\"aa\".unpack('b8B8')                 \#=> [\"10000110\", \"01100001\"]\n\"aaa\".unpack('h2H2c')               \#=> [\"16\", \"61\", 97]\n\"\\xfe\\xff\\xfe\\xff\".unpack('sS')     \#=> [-2, 65534]\n\"now=20is\".unpack('M*')             \#=> [\"now is\"]\n\"whole\".unpack('xax2aX2aX1aX2a')    \#=> [\"h\", \"e\", \"l\", \"l\", \"o\"]\n"))
aClass.addMethod(m0074)
m0075 = MethodDesc.new("upcase", "instance", "<i>str</i>.upcase -> <i>aString</i>")
m0075.addFragment(Paragraph.new("Returns a copy of <i>str</i> with all lowercase letters replaced with their uppercase counterparts. The operation is locale insensitive---only characters ``a'' to ``z'' are affected.\n"))
m0075.addFragment(Verbatim.new("\"hEllO\".upcase   \#=> \"HELLO\"\n"))
aClass.addMethod(m0075)
m0076 = MethodDesc.new("upcase!", "instance", "<i>str</i>.upcase! -> <i>str</i> or <code>nil</code>")
m0076.addFragment(Paragraph.new("Upcases the contents of <i>str</i>, returning <code>nil</code> if no changes were made.\n"))
aClass.addMethod(m0076)
m0077 = MethodDesc.new("upto", "instance", "<i>str</i>.upto( <i>aString</i> ) {| s | block } -> <i>str</i>")
m0077.addFragment(Paragraph.new("Iterates through successive values, starting at <i>str</i> and ending at <i>aString</i> inclusive, passing each value in turn to the block. The <code>String\#succ</code> method is used to generate each value.\n"))
m0077.addFragment(Verbatim.new("\"a8\".upto(\"b6\") {|s| print s, ' ' }\nfor s in \"a8\"..\"b6\"\n  print s, ' '\nend"))
m0077.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0077.addFragment(Verbatim.new("a8 a9 b0 b1 b2 b3 b4 b5 b6\na8 a9 b0 b1 b2 b3 b4 b5 b6"))
aClass.addMethod(m0077)

File.open($opfile, "w") {|f| Marshal.dump(aClass, f) }
