\name{loadDepends}
\alias{loadDepends}
\title{A function to load package/vignette dependencies}
\description{
  Given a package or a vignette, will determine any dependencies and
  load the required packages - as well as alerting the user to any
  unresolved dependencies.
}
\usage{
loadDepends(x, force = FALSE, recursive = TRUE, local = TRUE)
}
\arguments{
  \item{x}{The object to check}
  \item{force}{If TRUE, will continue even if not all dependencies are
    installed}
  \item{recursive}{Whether or not to look at indirect dependencies}
  \item{local}{Whether or not to only search locally or to use the
    internet to find unresolved dependencies}
}
\details{
    This function will first determine if the object is an installed
    package or a vignette.  In either case, it will extract a listing of
    all dependencies (both the names and any versioning requirements).
    If not all of the dependencies are met, the function will halt with
    an error and report which packages were not met - unless the
    \code{force} option is set to \code{TRUE}.  Otherwise, all of the
    installed dependencies will be loaded.
}
\value{
  A character vector listing the loaded packages.  If there were no
  installed dependencies to load, an empty vector is returned.
}
\author{ Jeff Gentry }
\examples{
## Using 'local==TRUE' in case the user doesn't have an internet
## connection available. 
   loadDepends("reposTools", local=TRUE)
}
\keyword{ utilities }
