/***************************************************************************
                          configfile.h  -  QZLog
                             -------------------
    begin                : Oct 12 13:46:56 CET 2003
    copyright            : (C) 2001 by Johan Maes - ON4QZ(ex-ON1MH)
    email                : on4qz@pandora.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef CONFIGFILE_H
#define CONFIGFILE_H
#include <qlist.h>
#include <qstring.h>
#include <qdir.h>
#include <qfileinfo.h>
#include "configtable.h"
#include <qlineedit.h>

  


#define OPTIONNAMELEN 20
#define OPTIONVALLEN  100




/**Options for use in configurationfile
  *@author johan maes - on4qz


  */
class configOption
{
public:
  configOption (const char *name, const char *defaultvalue="")
	{
	n=name;
	s=defaultvalue;
	Stored=FALSE;
	}
  const char *name() const
	{
	return n;
	}
   const char *getvalstr()
	  {
	    return s;
	  }
   int getvali(bool * ok=NULL)
     {
       return( s.toInt(ok));  // if ok!=NULL then ok =TRUE if no errors 
     }
   float getvalf(bool * ok=NULL)
     {
       return( s.toFloat(ok));  // if ok!=NULL then ok =TRUE if no errors 
     }
    double getvald(bool * ok=NULL)
     {
       return( s.toDouble(ok));  // if ok!=NULL then ok =TRUE if no errors
     }

   void setvalstr(const char *str)
	  {
	    s=str;
	  }
   void setval(int i)
     {
       s.setNum(i);
     }
   void setstored(bool st)
     {
       Stored=st;
     }
   bool IsStored()
     {
       return Stored;
     }
private:
	QString n;
	QString s;
	bool Stored;
};


/**Saves and Restores program configuration
  *@author johan maes - on4qz \n
  
Modules to support config files\n
Features:\n
Users can edit and comment the config files.
This functions will leave the comment strings intact and
only update the values.
The configfile will first be searched in the HOME directory, then in the local directory
Text after '#' is seen as a comment.\n
layout: Optionname = Optionvalue [# comment] \n
Maximum length (including comment): 255 characters\n


Use:
-# Register the Options to be used\n
 RegisterOption(const char *OptionName,const char *OptionValue);
-# Read the configfile\n
 ReadFile(const char *name, const char *path="")
 only options that are registered will be used and updated
-# SaveFile\n
 Will save the Options in the same file that was indicated in the ReadFile.
 Options that are registered but that are not in the configfile, are added.
 Options in the configfile that are not registered are flagged as invalid (commented out).
\sa configOption
  
  */

class configurationFile
{
public:
  
  configurationFile();
    /**
  	\param OptionName string 
    \param OptionValue string containing the value of the option\n
    		e.g. "homedirectory" or "1.0" or "1"
    
    */
  void registerOption(const char *OptionName,const char *OptionValue);
  /**
  	\param name Filename
    \param path Optional pathname
    \param create If TRUE create the configurationfile if it does not exist
    \return return TRUE if succesfull
  */
  bool readFile(const char *name, const char *path=NULL,bool create=FALSE);
  bool saveFile (sConfigEntry *table);
  bool readOption(const char * s,int &i);
  bool readOption(const char * s,short int &i);
  bool readOption(const char * s,float &i);
  bool readOption(const char * s,double &i);
  bool readOption(const char * s,bool &b);
  bool readOption(const char * s,int *i,int &size);
  
  const char *readOption(const char *);
	void setConfigFilename(const char *t)
		{
		   configFileName=QFileInfo(t);
		}

  bool hasChanged()
    {
      return changed;
    }

  //  void setOption(const char *s);
  void setOption(const char *s,const char *t);
  void setOption(const char *s,int t);
  void setOption(const char *s,short int t);
  void setOption(const char *s,float t);
  void setOption(const char *s,double t);
  void setOption(const char *s,bool b);
  void setOption(const char * s,int *i,int &size);
	void initOptions(sConfigEntry *tableconst, const char *name=0,const char *path=0);

 
private:
	QList<configOption> optionList;
	bool changed;
  int processLine( QString &s, QString &OptN, QString &OptV);
  configOption *optionCheck(QString OptN, QString OptV, bool Update);
  QFileInfo configFileName;
  QDir configDir;
  void saveActiveOptions(sConfigEntry *table);
};

void getVal(QLineEdit *l,unsigned int &v);
void getVal(QLineEdit *l,double &v);
#endif









