########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Server/SCore/XPathDocumentDefinitionImp.py,v 1.15 2003/03/22 17:38:30 uogbuji Exp $
"""
DocumentDefinition repository resource class

Copyright 2003 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

import cStringIO
from types import ListType

import DocumentDefinitionImp

from Ft.Server import FTSERVER_NAMESPACE
from Ft.Server.Common import ResourceTypes, Schema, DocumentDefinitionSerialization, CreationParams, XmlLib
from Ft.Server.Server import FtServerServerException,Error
from Ft.Xml import XPath, Domlette
from Ft.Xml.XLink import XLINK_NAMESPACE
from Ft.Xml.Domlette import Print

class XPathDocumentDefinitionImp(DocumentDefinitionImp.DocumentDefinitionImp):
    resourceType = ResourceTypes.ResourceType.XPATH_DOCUMENT_DEFINITION
    """
    An XPath-based document definition document
    """

    def getNsMap(self):
        """
        Get the namespace mapping for this document definition
        """
        self._verifyTx()
        context = self.toXPathContext()
        nsMap =  DocumentDefinitionSerialization._DeserializeNsMaps(context)
        return nsMap

    def getRdfMaps(self):
        """
        Get all of the RDF mappings for this document definition
        """
        self._verifyTx()
        context = self.toXPathContext()
        rdfMap =  DocumentDefinitionSerialization._DeserializeRdfMaps(context)
        return rdfMap

    def setNsMap(self,newNss):
        """
        Set the namespace mappings of this document definition
        """
        doc = self.asDom()
        DocumentDefinitionSerialization._SerializeNsMap(doc, newNss)
        st = cStringIO.StringIO()
        Print(doc, stream=st)
        self._driver.updateResourceContent(self._path, st.getvalue())
        self._update()
        return

    def setRdfMaps(self,newMaps):
        """
        Set the RDF mappings for this document definition
        """
        self._verifyTx()

        doc = Domlette.implementation.createDocument(None, None, None)
        rm = DocumentDefinitionSerialization._SerializeRdfMaps(doc, newMaps)

        st = cStringIO.StringIO()
        Print(rm, stream=st)
        xu = XmlLib.MakeString(SET_RDF_MAPS_XUPDATE%(FTSERVER_NAMESPACE, XLINK_NAMESPACE, st.getvalue()))

        self._driver.xupdateContent(self._path,xu)
        self._update()
        return


def NewDocumentDefinitionXml(driver, path, acl, owner, imt, src, docDef):
    return DocumentDefinitionImp.NewDocumentDefinitionXml(
        driver, path, acl, owner, imt, src, docDef,
        ResourceTypes.ResourceType.XPATH_DOCUMENT_DEFINITION
        )


SET_RDF_MAPS_XUPDATE="""<xupdate:modifications
  version="1.0"
  xmlns:xupdate="http://www.xmldb.org/xupdate"
  xmlns:ftss="%s"
  xmlns:xlink="%s"
>
  <xupdate:remove select="/ftss:DocDef/ftss:RdfMappings"/>
  <xupdate:append select="/ftss:DocDef" child="last()">
    %s
  </xupdate:append>
</xupdate:modifications>
"""

