
try:
    # For Pythons w/distutils pybsddb
    from bsddb3.db import *
except ImportError:
    # For Python 2.3
    from bsddb.db import *
    
try:
    from dbxml import *
except:
    pass

import os

from Ft import GetConfigVar
DATABASE_DIR = os.path.join(GetConfigVar('LOCALSTATEDIR'), 'BsdDb')
DATABASE_DIR = os.environ.get('FT_DATABASE_DIR', DATABASE_DIR)
BerkeleyDBFlags    = DB_CREATE|DB_INIT_LOCK|DB_INIT_LOG|DB_INIT_MPOOL|DB_INIT_TXN

def GetContainer(name,root,environment,txn=None):
    mgr = XmlManager(environment, 0)
    if not txn:
        txn = mgr.createTransaction()
        
    return txn,mgr.openContainer(txn,name)

def GetDB(name,environment,txn=None):
    _db = DB(environment)
    if not txn:
        txn = environment.txn_begin()
        
    _db.open(name,
             DB_HASH,
             DB_CREATE,txn=txn)
    return txn,_db
