#A* -------------------------------------------------------------------
#B* This file contains source code for the PyMOL computer program
#C* copyright 1998-2000 by Warren Lyford Delano of DeLano Scientific. 
#D* -------------------------------------------------------------------
#E* It is unlawful to modify or remove this copyright notice.
#F* -------------------------------------------------------------------
#G* Please see the accompanying LICENSE file for further information. 
#H* -------------------------------------------------------------------
#I* Additional authors of this source file include:
#-* 
#-* 
#-*
#Z* -------------------------------------------------------------------

# bond lengths and other information useful for simply building atoms
#
# compatible with parm94, 96, or 99 

length = {
   ( 'OW', 'HW' ) : 0.9572,
   ( 'HW', 'HW' ) : 1.5136,
   ( 'C',  'C'  ) : 1.525 ,
   ( 'C',  'CA' ) : 1.409 ,
   ( 'C',  'CB' ) : 1.419 ,
   ( 'C',  'CM' ) : 1.444 ,
   ( 'C',  'CT' ) : 1.522 ,
   ( 'C',  'N' ) :  1.335 ,
   ( 'C',  'N*' ) : 1.383 ,
   ( 'C',  'NA' ) : 1.388 ,
   ( 'C',  'NC' ) : 1.358 ,
   ( 'C',  'O' ) :  1.229 ,
   ( 'C',  'O2' ) : 1.250 ,
   ( 'C',  'OH' ) : 1.364 ,
   ( 'C',  'OS' ) : 1.323 ,
   ( 'C',  'H4' ) : 1.080 ,
   ( 'C',  'H5' ) : 1.080 ,
   ( 'CA', 'CA' ) : 1.400 ,
   ( 'CA', 'CB' ) : 1.404 ,
   ( 'CA', 'CM' ) : 1.433 ,
   ( 'CA', 'CN' ) : 1.400 ,
   ( 'CA', 'CT' ) : 1.510 ,
   ( 'CA', 'HA' ) : 1.080 ,
   ( 'CA', 'H4' ) : 1.080 ,
   ( 'CA', 'N2' ) : 1.340 ,
   ( 'CA', 'NA' ) : 1.381 ,
   ( 'CA', 'NC' ) : 1.339 ,
   ( 'CA', 'OH' ) : 1.364 ,
   ( 'CB', 'CB' ) : 1.370 ,
   ( 'CB', 'N*' ) : 1.374 ,
   ( 'CB', 'NB' ) : 1.391 ,
   ( 'CB', 'NC' ) : 1.354 ,
   ( 'CD', 'HA' ) : 1.080 ,
   ( 'CD', 'CD' ) : 1.400 ,
   ( 'CD', 'CM' ) : 1.350 ,
   ( 'CD', 'CT' ) : 1.510 ,
   ( 'CK', 'H5' ) : 1.080 ,
   ( 'CK', 'N*' ) : 1.371 ,
   ( 'CK', 'NB' ) : 1.304 ,
   ( 'CM', 'CM' ) : 1.350 ,
   ( 'CM', 'CT' ) : 1.510 ,
   ( 'CM', 'HA' ) : 1.080 ,
   ( 'CM', 'H4' ) : 1.080 ,
   ( 'CM', 'H5' ) : 1.080 ,
   ( 'CM', 'N*' ) : 1.365 ,
   ( 'CM', 'OS' ) : 1.240 ,
   ( 'CQ', 'H5' ) : 1.080 ,
   ( 'CQ', 'NC' ) : 1.324 ,
   ( 'CT', 'CT' ) : 1.526 ,
   ( 'CT', 'HC' ) : 1.090 ,
   ( 'CT', 'H1' ) : 1.090 ,
   ( 'CT', 'H2' ) : 1.090 ,
   ( 'CT', 'H3' ) : 1.090 ,
   ( 'CT', 'HP' ) : 1.090 ,
   ( 'CT', 'N*' ) : 1.475 ,
   ( 'CT', 'N2' ) : 1.463 ,
   ( 'CT', 'OH' ) : 1.410 ,
   ( 'CT', 'OS' ) : 1.410 ,
   ( 'C*', 'HC' ) : 1.080 ,
   ( 'C*', 'CB' ) : 1.459 ,
   ( 'C*', 'CT' ) : 1.495 ,
   ( 'C*', 'CW' ) : 1.352 ,
   ( 'CB', 'CN' ) : 1.419 ,
   ( 'CC', 'CT' ) : 1.504 ,
   ( 'CC', 'CV' ) : 1.375 ,
   ( 'CC', 'CW' ) : 1.371 ,
   ( 'CC', 'NA' ) : 1.385 ,
   ( 'CC', 'NB' ) : 1.394 ,
   ( 'CN', 'NA' ) : 1.380 ,
   ( 'CR', 'H5' ) : 1.080 ,
   ( 'CR', 'NA' ) : 1.343 ,
   ( 'CR', 'NB' ) : 1.335 ,
   ( 'CT', 'N'  ) : 1.449 ,
   ( 'CT', 'N3' ) : 1.471 ,
   ( 'CT', 'NT' ) : 1.471 ,
   ( 'CT', 'S'  ) : 1.810 ,
   ( 'CT', 'SH' ) : 1.810 ,
   ( 'CT', 'CY' ) : 1.458 ,
   ( 'CT', 'CZ' ) : 1.459 ,
   ( 'CV', 'H4' ) : 1.080 ,
   ( 'CV', 'NB' ) : 1.394 ,
   ( 'CW', 'H4' ) : 1.080 ,
   ( 'CW', 'NA' ) : 1.381 ,
   ( 'CY', 'NY' ) : 1.150 ,
   ( 'CZ', 'CZ' ) : 1.206 ,
   ( 'CZ', 'HZ' ) : 1.056 ,
   ( 'O2', 'P'  ) : 1.480 ,
   ( 'OH', 'P'  ) : 1.610 ,
   ( 'OS', 'P'  ) : 1.610 ,
   ( 'H',  'N2' ) : 1.010 ,
   ( 'H',  'N*' ) : 1.010 ,
   ( 'H',  'NA' ) : 1.010 ,
   ( 'H',  'N'  ) : 1.010 ,
   ( 'H',  'N3' ) : 1.010 ,
   ( 'H',  'NT' ) : 1.010 ,
   ( 'HO', 'OH' ) : 0.960 ,
   ( 'HO', 'OS' ) : 0.960 ,
   ( 'HS', 'SH' ) : 1.336 ,
   ( 'S',  'S'  ) : 2.038 ,
   ( 'F',  'CT' ) : 1.380 ,
   ( 'Cl', 'CT' ) : 1.766 ,
   ( 'Br', 'CT' ) : 1.944 ,
   ( 'I',  'CT' ) : 2.166 ,
   ( 'F',  'CA' ) : 1.359 ,
   ( 'Cl', 'CA' ) : 1.727 ,
   ( 'I',  'CA' ) : 2.075 ,
   ( 'Br', 'CA' ) : 1.890 ,
   ( 'LP', 'O'  ) : 0.200 ,
   ( 'LP', 'OH' ) : 0.200 ,
   ( 'LP', 'OS' ) : 0.200 ,
   ( 'LP', 'N3' ) : 0.200 ,
   ( 'LP', 'NT' ) : 0.200 ,
   ( 'LP', 'NB' ) : 0.200 ,
   ( 'LP', 'NC' ) : 0.200 ,
   ( 'LP', 'S'  ) : 0.700 ,
   ( 'LP', 'SH' ) : 0.700,
}

for a in length.keys():
   length[(a[1],a[0])]=length[a]
          
nonlinear = {
   'OW' : 1 ,
   'OH' : 1 ,
   'OS' : 1 ,
   'P'  : 1 ,   
   'S'  : 1 ,
   'SH' : 1 ,
}

tetrahedral = {
   'CT' : 1 ,
   'N3' : 1 ,
   'NT' : 1 ,   
   }

planer = {
   'C'  : 1 ,
   'C*' : 1 ,
   'CA' : 1 ,
   'CB' : 1 ,
   'CC' : 1 ,
   'CD' : 1 ,
   'CK' : 1 ,
   'CM' : 1 ,
   'CN' : 1 ,
   'CQ' : 1 ,
   'CR' : 1 ,
   'CV' : 1 ,
   'CW' : 1 ,
   'N'  : 1 ,
   'N*' : 1 ,
   'N2' : 1 ,   
   'NA' : 1 ,
   'NB' : 1 ,
   'NC' : 1 ,
   'O'  : 1 ,
   'O2' : 1 ,
}
