#if HAVE_CONFIG_H
#  include <config.h>
#endif

#include <malloc.h>
#include <alloca.h>
#include <string.h>
#include <assert.h>
#include <limits.h>
#include <errno.h>
#include "main.h"
#include "savefile.h"
#include "download_win.h"
#include "dl_win.h"


void create_savefile(Fl_Browser *browser)
{
  FILE *fp;
  char file_name[PATH_MAX];
  snprintf(file_name, PATH_MAX, "%s/%s", rt.config_dir, "urls");
  int num_dls=browser->size();

  if ((fp = fopen(file_name, "wt")) == NULL)
  {
    perror("Could not save the list of URLS's");
    proz_debug("Could not save the list of URLS's :- %s", strerror(errno));
    return;
  }


  fprintf(fp, "%d\n", num_dls);

  if(num_dls>0)
    {
      for(int i=0; i<num_dls;i++)
	{
	  fprintf(fp, "%s\n", browser->text(i+1));
	}
    }
  fclose(fp);
  return;
}


void load_savefile(Fl_Browser *browser)
{
  FILE *fp;
  char file_name[PATH_MAX];
  snprintf(file_name, PATH_MAX, "%s/%s", rt.config_dir, "urls");
  int num_dls=0;

  if ((fp = fopen(file_name, "rt")) == NULL)
  {
    perror("Could not open the list of URLS's");
    proz_debug("Could not open the list of URLS's :- %s", strerror(errno));
    return;
  }


  fscanf(fp, "%d\n", &num_dls);

char *line=(char *)malloc (20000);
if(line==0)
{
	printf("Could not allocalte memory");  
	proz_debug("Could not allocalte memory"); 
	exit(EXIT_FAILURE);
}

  if(num_dls>0)
    {
      for(int i=0; i<num_dls;i++)
	{
	  // fgets(line, sizeof(line) - 1, fp);
	  if(fscanf(fp,"%s\n", line)==EOF)
	    {
	      fclose(fp);
	      free(line);
	      proz_debug("Could not read the list of URLS from file!!");
	      return;
	    }
	  browser->add(line);
	}
    }
 fclose(fp);
 free(line);
  return;

}
