#ifndef PROKYON_H
#define PROKYON_H

#define PROKYON_HOME (QString(PREFIX) + QString("/share/prokyon3"))
// #define MP3_PATH     "/MP3"

// #define HOST     "localhost"
// #define DATABASE "prokyon"
// #define USER     "prokyon"
// #define PASS     "prokyon"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <libintl.h>
#define _(String) gettext (String)

#ifndef QT_THREAD_SUPPORT
#define QT_THREAD_SUPPORT
#endif
#include <qthread.h>

#include <qapplication.h>
#include <qdatetime.h>
#include <qlistview.h>

#include <stdlib.h>

#define MIMETYPE_MP3 1
#define MIMETYPE_OGG 2

const int QUERY_BY_ARTIST		 = 1;
const int QUERY_BY_MEDIUM		 = 2;
const int QUERY_BY_PHRASE		 = 3;
const int QUERY_BY_PLAYLIST     = 4;
const int QUERY_BY_ARTIST_ALBUM = 5;
const int QUERY_BY_ALBUM        = 6;

#define JOB_CONNECT_TO_DATABASE         1
#define JOB_DISCONNECT_FROM_DATABASE    2
#define JOB_MODIFY_FAVOURITE            3
#define JOB_SYNCHRONIZE_WITH_DATABASE   4
#define JOB_QUERY_DATABASE              5
#define JOB_MODIFY_TRACKS_IN_DATABASE   6
#define JOB_COMPUTE_CDROM_ID            7
#define JOB_APPEND_CDROM_TO_DATABASE    8
#define JOB_DELETE_MEDIUM_FROM_DATABASE 9
#define JOB_APPEND_SMB_TO_DATABASE      10
#define JOB_DELETE_TRACK_PHYSICALLY     11
#define JOB_APPEND_NFS_TO_DATABASE      12
#define JOB_MODIFY_PLAYLISTS            13
#define JOB_MODIFY_PLAYLIST_TRACKS      14
#define JOB_QUERY_PLAYLIST_TRACKS       15
#define JOB_COUNT_DATA                  16
#define JOB_GENERATE_PLAYLIST           17

#define MEDIUM_HARDDISK 0
#define MEDIUM_CDROM    1
#define MEDIUM_SMB  	2
#define MEDIUM_EXTERN   3
#define MEDIUM_NFS      4

#define NORMAL     "Normal"
#define SAMPLER    "Sampler"
#define SOUNDTRACK "Soundtrack"

class ALBUMINFO
{
 public:
  ALBUMINFO(int a =0, int b=0, QString n =NULL) {total = a; local = b; name = n;}
  int local, total;
  QString name;
};

class DELTAINFO
{
public:
  DELTAINFO(int a, int b, QString c ) { total = a; local = b; name = c; deltaalbum = new QMap<QString, ALBUMINFO>;} 
  int total, local;
  QString name;
  QMap<QString, ALBUMINFO> *deltaalbum;
  ~DELTAINFO() {delete deltaalbum;}
};

struct ARTIST {
  int     id;
  QString name;
  int     total;
  int     local;
  bool    isFavourite;
};

struct ARTISTALBUM {
  QString artist;
  QString album;
  int     total;
  int     local;
  bool    isFavourite;
  int     artistId;
  int     medium;
};

struct TRACK {
  int       id;
  QString   path;
  QString   filename;
  int       medium;
  QDateTime lastModified;
  bool      hasChanged;
  bool      isRequested;
  QDateTime lastUpdated;
  int       mimetype;
  int       version;
  int       layer;
  int       mode;
  int       bitrate;
  int       samplerate;
  int       length;
  int       size;
  QString   artist;
  QString   title;
  QString   album;
  int       tracknumber;
  QString   year;
  int       genre;
  QString   comment;
};

struct MEDIUM {
  int     id;
  int     type;
  QString label;
  QString path;
  uint     checksum;
};

struct PLAYLIST {
  int     id;
  QString name;
};

struct PLAYLIST_TRACK {
  int id;
  int track_id;
  int medium_id;
  int playlist_id;
  int position_in_playlist;
  QString artist;
  QString title;
  QString path;
  QString filename;
};

class GUI;
class JobManager;
class DataBase;
class Configuration;
class DataDispatcher;
class DirWatcher;

extern GUI *gui;
extern JobManager *jobman;
extern DataBase *database;
extern Configuration *config;
extern DataDispatcher *datadispatcher;
extern DirWatcher *dirwatcher;
extern QApplication *app;
extern int verbose;

void dumpdeltamap( QMap<int, QMap<int, DELTAINFO*> >* );
void dumpSelectedItems( QList<QListViewItem>*);
void dumpListTracks( QList<TRACK>* );
void dumpBaseList( QMap<int, int> * );  
void dumpArtistToID( QMap<QString, int> * );  
#endif
