/***************************************************************************
                          jobbase.cpp  -  description
                             -------------------
    begin                : Thu May 3 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "jobbase.h"

#include "tagger.h"

#include <qqueue.h>

#include <iostream>
#include <qprogressdialog.h>
#include <qtextedit.h>

using namespace std;

class QProgressDialogScroll : public QProgressDialog
/* A progress dialog with a textedit. */
{
public:
   QProgressDialogScroll( const QString& labelText, const QString &cancelButtonText,
		     int totalSteps, QWidget* parent=0, const char* name=0,
		     bool modal=FALSE, WFlags f=0 ):
                      QProgressDialog( labelText, cancelButtonText,
		     totalSteps, parent, name,
		     modal, f)
                     {  TextEdit = new QTextEdit( this, "TextEdit" );
		        setMinimumHeight( 200 ); 
		        setMinimumWidth( 500 );}
   void QProgressDialogScroll::resizeEvent( QResizeEvent *ev ) {
                     QProgressDialog::resizeEvent( ev );
		     QRect rct = static_cast<QWidget*>(this->child("label","QLabel"))->geometry();
                     rct.setTop(2);
                     TextEdit->setGeometry(rct);}
   QTextEdit *TextEdit;
};


// ##############################################
// # get list of all relevant files in dir
// ##############################################
QList<TRACK> *JobBase::getFileList(QDir *directory, bool append, QList<TRACK> *files)
{
  QList<TRACK> *musiclist;
  
  if(append) musiclist = files; else musiclist = new QList<TRACK>;
  
  QQueue<QDir> queue;
  if(directory->exists()) queue.enqueue(directory);
  
  while(!queue.isEmpty()) {
    QDir *d = queue.dequeue();
    d->setFilter(QDir::Files | QDir::Dirs | QDir::NoSymLinks);
    const QFileInfoList *list = d->entryInfoList();
    QFileInfoListIterator it(*list);
    QFileInfo *fi;
    while((fi = it.current())) {
      if(!(fi->fileName() == ".") && !(fi->fileName() == "..")) {
	if(fi->isDir() && fi->isReadable()) {
	  QDir *const newdir = new QDir(fi->absFilePath());
	  queue.enqueue(newdir);
	} else if(fi->size() > 10000) {
	  if(Tagger::isKnownFile(fi) && fi->isReadable()) {

	    TRACK *item = new TRACK;
	    item->id 		= 0;
	    item->medium	= 0;
	    item->hasChanged	= false;
	    item->filename	= fi->fileName();
	    item->path		= fi->dirPath();
	    item->lastModified	= fi->lastModified();
	    item->size		= fi->size();
	    
	    musiclist->append(item);
	  }
	}
      }
      ++it;
    }
    if(d != directory) delete d;
  }
  return musiclist;
}

// ##############################################
// # read tags from files in list
// ##############################################
QList<TRACK> *JobBase::readTags(QList<TRACK> *files, bool lazyRead)
{
 
  qApp->lock();
  QProgressDialogScroll *wdial = new QProgressDialogScroll("", _("Hide"), files->count()-1, 0 , "progress" ); 
  int count = 0;
  qApp->unlock();

  TRACK *curr = files->first();
  while(curr != 0) {
    QFileInfo fi(curr->path + '/' + curr->filename);
 
    qApp->lock();
    if ( !wdial->wasCancelled() ) {
      wdial->setProgress( count );
      count++;
      wdial->TextEdit->append( QString("%1/%2").arg(curr->path).arg(curr->filename) );
    };
    qApp->unlock();
    

    if (verbose)  qWarning("Readtags:%s/%s",curr->path.latin1() ,curr->filename.latin1());
    if(curr->id != 0 && fi.lastModified() == curr->lastModified) { // File is known and unchanged
      if(curr == files->getLast()) {
	files->remove();
	delete curr;
	curr = 0;
      } else {
	files->remove();
	delete curr;
	curr = files->current();
      }
    } else { // Files is not known or have been changed
	if(Tagger::getInfo(curr, lazyRead)) {
    	    QFileInfo fi(curr->path + '/' + curr->filename);
    	    curr->lastModified = fi.lastModified();
    	    curr->hasChanged = false;
    	    curr->size = fi.size();
    	    curr = files->next();
	} else {
    	    if(curr == files->getLast()) {
		files->remove();
		delete curr;
		curr = 0;
    	    } else {
		files->remove();
		delete curr;
		curr = files->current();
    	    }
	}
    }
  }
  delete wdial;
  return files;
}

// ##############################################
// # read tags from files in list
// ##############################################
QList<TRACK> *JobBase::readTagsOnly(QList<TRACK> *files)
{

  qApp->lock();
  QProgressDialogScroll *wdial = new QProgressDialogScroll("", _("Hide"), files->count()-1, 0 , "progress" ); 
  int count = 0;
  qApp->unlock();

  TRACK *curr = files->first();
  while(curr != 0) {
    QFileInfo fi(curr->path + '/' + curr->filename);
    
    qApp->lock();
    if ( !wdial->wasCancelled() ) 
      wdial->setProgress( count );
    count++;
    wdial->TextEdit->append( QString("%1/%2").arg(curr->path).arg(curr->filename) );
    qApp->unlock();
    
    if((curr->id == 0 || fi.lastModified() != curr->lastModified) && !Tagger::getTagOnly(curr)) {
      if(curr == files->getLast()) {
	files->remove();
	delete curr;
	curr = 0;
      } else {
	files->remove();
	delete curr;
	curr = files->current();
      }
    } else {
      QFileInfo fi(curr->path + '/' + curr->filename);
      curr->lastModified = fi.lastModified();
      curr->hasChanged = false;
      curr->size = fi.size();
      curr = files->next();
    }
  }
  delete wdial;
  return files;
}

// ##############################################
// # write tags from list to files
// ##############################################
QList<TRACK> *JobBase::writeTags(QList<TRACK> *files)
{
  
  qApp->lock();
  QProgressDialogScroll *wdial = new QProgressDialogScroll("", _("Hide"), files->count()-1, 0 , "progress" ); 
  int count = 0;
  qApp->unlock();
  
  TRACK *curr = files->first();
  while(curr != 0) {
    if(Tagger::writeInfo(curr)) {
      QFileInfo fi(curr->path + '/' + curr->filename);
      
      qApp->lock();
      if ( !wdial->wasCancelled() ) 
	wdial->setProgress( count );
      count++;
      wdial->TextEdit->append( QString("%1/%2").arg(curr->path).arg(curr->filename) );
      qApp->unlock();
      
      if (verbose)  qWarning("Writetags:%s/%s",curr->path.latin1() ,curr->filename.latin1());

      if(curr->lastModified != fi.lastModified()) { // did we really changed it ?! --- strange SMB behaviour
	curr->lastModified = fi.lastModified();
	curr->hasChanged = false;
	curr->size = fi.size();
      }
    }
    curr = files->next();
  }
  delete wdial;
  return files;
}
