/***************************************************************************
                          database_mysql.h  -  description
                             -------------------
    begin                : Thu May 3 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DATABASE_MYSQL_H
#define DATABASE_MYSQL_H

#include "prokyon.h"

#include "database.h"

#include <qsqldatabase.h>

#include <qmap.h>

#include <string>

using namespace std;

class DataBase_MySQL : public DataBase {
 public: 
  DataBase_MySQL();
  
  void establishConnection(QString host, QString db, QString user, QString pass);
  
    QString createNewDatabase(QString host, QString db, QString user, QString pass, QString su, QString su_pass);

  QList<ARTISTALBUM> *getSamplerBasis();
  QList<ARTISTALBUM> *getFavouritesBasis();
  QList<ARTISTALBUM> *getArtistAlbumBasis();
  QList<MEDIUM> *getMediumBasis();
  QList<PLAYLIST> *getPlaylistBasis();
  QList<PLAYLIST_TRACK> *getPlaylistTracksBasis(int playlistID);

  void generatePlaylist(int, int, int, int, bool);
  
  QMap<int, QMap<int, DELTAINFO*> > *getArtistDelta();

  QMap<int, QMap<int, int> > *getLocalDeltaBasis();
  QMap<int, QMap<QString, int> > *getLocalAlbumDeltaBasis();
  QMap<int, int> getLocalDelta(int id);
  QMap<QString, int> getLocalAlbumDelta(int id);
  
  bool checkIndex(const QString& table, const QString& indexname);
  bool checkExtra(const QString& table, const QString& column, const QString& extra);
  bool checkVersion();

  int appendTracks(QList<TRACK> *tracklist, int mediumtype, QString mediumlabel, QString mediumpath, unsigned mediumchecksum, bool createNewMedium, int mediumID);
  void updateTracks(QList<TRACK> *tracklist);
  void deleteTracks(QList<TRACK> *tracklist);

  int appendPlaylist(QString listname);
  void renamePlaylist(int id, QString newname);
  void deletePlaylist(int id);

  int appendPlaylistTracks(QList<TRACK> *tracklist, int playlistID, int *position);
  void deletePlaylistTracks(QList<TRACK> *tracklist);
  void deletePlaylistTracks(QList<PLAYLIST_TRACK> *playlist_tracklist);
  void updatePlaylistTrack(int playlistID, int trackID, int new_pos);
  
  void deleteMedium(int id);

  void modifyFavouriteArtist(int, bool);

  int getCountFromTable(QString);
  int getCountColumnDistinctFromTable(QString, QString);
  
  QList<TRACK> *getTracksByMedium(int id);
  
  QList<TRACK> *queryTracksByMedium(int id);
  QList<TRACK> *queryTracksByArtist(int id);
  QList<TRACK> *queryTracksByArtistAlbum(QString artist, QString album); 
  QList<TRACK> *queryTracksByAlbum(QString sampler, QString album); 
  QList<TRACK> *queryTracksByPlaylist(int id);
  QList<TRACK> *queryTracksByPhrase(QString phrase, bool byFilename, bool byArtist, bool byTitle, bool byAlbum, bool byComment);
  
  QList<TRACK> *getLastQuery();

  void disconnect();
  
  ~DataBase_MySQL();
  
 private:
  QSqlDatabase *db;
  bool	isConnected;
  int maxID_artists, maxID_tracks, maxID_mediums;
  int maxID_playlists; // maxID_playlist_tracks;

  string lastquery;
  
  int getMaxIDFromTable(QString);
  QList<ARTISTALBUM> *getArtistAlbumBasisByQuery(QString);  
  QList<TRACK> *applySelectTracksQuery(string sqlquery);
  QString adjustString(QString s);
  QDateTime stringToDatetime(QString s);
  QString dateTimeToString(QDateTime d);
  
  QMap<int, QMap<int, DELTAINFO*> > *deltamap;
  QMap<int, int> baselist;
  QMap<QString, int> artistToID;
};

#endif
