#ifndef	_PPXP_OPTION_H
#define	_PPXP_OPTION_H

typedef	enum {
    RUN_PASSIVE,
    RUN_ACTIVE,
    RUN_KICK,
    RUN_DIRECT,
    RUN_GETTY,
    RUN_MAX
} runmode_t;

typedef enum {
    AUTH_SERVER_NONE,   /* is not a auth server!! */
    AUTH_SERVER_FILE,
    AUTH_SERVER_UNIX,
    AUTH_SERVER_RADIUS
} authserver_t;

#define	AUTH_MAX	3

struct pppopt_s {
    char **line;			/* Device name */
    char *name;				/* Target|Entry Name */
    char *chat;				/* Chat script file */
    char *a_entry;			/* passwd file entry */
    char *l_file;			/* log file name */
    u_long r_count;			/* Retry count */
    time_t r_to;			/* Retry timeout */
    time_t i_to;			/* Idle timeout */
    u_int32_t hbo_accm;			/* Async control character map(HBO) */
    u_int32_t l_level;			/* Log level */
    u_int32_t l_size;			/* Log size */
    runmode_t mode;			/* Running mode */
    authserver_t a_server;		/* I'm an Authenticator */
    bool_t p_open;			/* Passive Open */
    bool_t id_check;			/* Check ID and ignore if wrong */
    u_int16_t hbo_qual_period;		/* Quality Period */
    u_int16_t nbo_qual_type;		/* Quality Protocol */
    u_int16_t hbo_mru;			/* MTU(HBO) */
    u_int16_t hbo_a_order[AUTH_MAX];	/* Authentication type order */
    u_int8_t a_algorithm[AUTH_MAX];	/* Authentication algorithm */
};

extern struct pppopt_s pppOpt;
extern const char *SetLoadFilePath();
extern FILE *OpenFile();
extern int LoadScriptFile();
extern int LoadFile(FILE *, int (*)(), int, void *);

#endif	/* _PPXP_OPTION_H */
