#include <stdio.h>
#include <unistd.h>
#include <syslog.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>

#include <config.h>

#include <support.h>
#include <xcio.h>

static void
PostExtract(unsigned char *dst, unsigned char *src, int max)
{
    int i=0;

    while (i < max && *src) {
	if (*src == '%') {
	    int dg;

	    src ++;
	    sscanf(src, "%2X", &dg);
	    src ++;
	    *dst = dg;
	} else if (*src == '+') *dst = ' ';
	else *dst = *src;
	dst ++;
	src ++;
	i ++;
    }
    *dst = '\0';
}

void
PostRead(unsigned char *src)
{
    int n, fd=HttpdFd();
    char *p, *label, *data;
    unsigned char dst[100];
    struct xcio_s xc;

    if ((p = strpbrk(src, "\r\n")) != NULL) *p = '\0';
    while ((p = index(src, '=')) != NULL) {
	*p = '\0';
	label = src;
	data = p + 1;
	if ((p = index(data, '&')) != NULL) *p = '\0';
	if (p) src = p + 1;
	PostExtract(dst, data, sizeof(dst));
	syslog(LOG_PPXP|LOG_DEBUG, dst);
	PPxPCommandv(fd, XCMD_SET, label, dst, NULL);
	while ((n = XcioRead(fd, &xc)) >= 0 && n != XCIO_RETURN);
    }
}
