#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/fcntl.h>
#include <utmpx.h>

#include <config.h>

int
SysWtmp(char *line, char *user, char *host)
{
    struct utmpx utmp;
    int fd;

    memset((char *)&utmp, 0, sizeof(utmp));

    strncpy(utmp.ut_line, line, sizeof(utmp.ut_line));
    time(&(utmp.ut_xtime));
    if (user) {
	/* start */
	strncpy(utmp.ut_name, user, sizeof(utmp.ut_name));
	if (host) strncpy(utmp.ut_host, host, sizeof(utmp.ut_host));
    } else {
	/* stop */
    }
    fd = open(WTMPX_FILE, O_APPEND|O_WRONLY|O_CREAT, 0644);
    if (fd < 0) {
	LogError(WTMP_FILE);
	return(-1);
    }
    write(fd, (char *)&utmp, sizeof(utmp));
    close(fd);
    return(0);
}
