/* vinv.c */
/* Fortran interface file */

/*
* This file was generated automatically by bfort from the C source
* file.  
 */

#ifdef PETSC_USE_POINTER_CONVERSION
#if defined(__cplusplus)
extern "C" { 
#endif 
extern void *PetscToPointer(void *);
extern int PetscFromPointer(void *);
extern void PetscRmPointer(void *);
#if defined(__cplusplus)
} 
#endif 

#else

#define PetscToPointer(a) (*(long *)(a))
#define PetscFromPointer(a) (long)(a)
#define PetscRmPointer(a)
#endif

#include "petscfix.h"
#include "petscvec.h"
#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecstridemax_ PVECSTRIDEMAX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecstridemax_ pvecstridemax
#else
#define vecstridemax_ pvecstridemax_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecstridemax_ VECSTRIDEMAX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecstridemax_ vecstridemax
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecstridegatherall_ PVECSTRIDEGATHERALL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecstridegatherall_ pvecstridegatherall
#else
#define vecstridegatherall_ pvecstridegatherall_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecstridegatherall_ VECSTRIDEGATHERALL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecstridegatherall_ vecstridegatherall
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecstridescatterall_ PVECSTRIDESCATTERALL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecstridescatterall_ pvecstridescatterall
#else
#define vecstridescatterall_ pvecstridescatterall_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecstridescatterall_ VECSTRIDESCATTERALL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecstridescatterall_ vecstridescatterall
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecstridegather_ PVECSTRIDEGATHER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecstridegather_ pvecstridegather
#else
#define vecstridegather_ pvecstridegather_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecstridegather_ VECSTRIDEGATHER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecstridegather_ vecstridegather
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecstridescatter_ PVECSTRIDESCATTER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecstridescatter_ pvecstridescatter
#else
#define vecstridescatter_ pvecstridescatter_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecstridescatter_ VECSTRIDESCATTER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecstridescatter_ vecstridescatter
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecsqrt_ PVECSQRT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecsqrt_ pvecsqrt
#else
#define vecsqrt_ pvecsqrt_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecsqrt_ VECSQRT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecsqrt_ vecsqrt
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecsum_ PVECSUM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecsum_ pvecsum
#else
#define vecsum_ pvecsum_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecsum_ VECSUM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecsum_ vecsum
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecshift_ PVECSHIFT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecshift_ pvecshift
#else
#define vecshift_ pvecshift_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecshift_ VECSHIFT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecshift_ vecshift
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecabs_ PVECABS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecabs_ pvecabs
#else
#define vecabs_ pvecabs_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecabs_ VECABS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecabs_ vecabs
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecpermute_ PVECPERMUTE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecpermute_ pvecpermute
#else
#define vecpermute_ pvecpermute_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecpermute_ VECPERMUTE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecpermute_ vecpermute
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecequal_ PVECEQUAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecequal_ pvecequal
#else
#define vecequal_ pvecequal_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecequal_ VECEQUAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecequal_ vecequal
#endif
#endif



/* Definitions of Fortran Wrapper routines */
#if defined(__cplusplus)
extern "C" {
#endif
void PETSC_STDCALL vecstridemax_(Vec v,int *start,int *idex,PetscReal *nrm, int *ierr ){
*ierr = VecStrideMax(
	(Vec)PetscToPointer( (v) ),*start,idex,nrm);
}
void PETSC_STDCALL vecstridegatherall_(Vec v,Vec *s,InsertMode *addv, int *ierr ){
*ierr = VecStrideGatherAll(
	(Vec)PetscToPointer( (v) ),s,*addv);
}
void PETSC_STDCALL vecstridescatterall_(Vec *s,Vec v,InsertMode *addv, int *ierr ){
*ierr = VecStrideScatterAll(s,
	(Vec)PetscToPointer( (v) ),*addv);
}
void PETSC_STDCALL vecstridegather_(Vec v,int *start,Vec s,InsertMode *addv, int *ierr ){
*ierr = VecStrideGather(
	(Vec)PetscToPointer( (v) ),*start,
	(Vec)PetscToPointer( (s) ),*addv);
}
void PETSC_STDCALL vecstridescatter_(Vec s,int *start,Vec v,InsertMode *addv, int *ierr ){
*ierr = VecStrideScatter(
	(Vec)PetscToPointer( (s) ),*start,
	(Vec)PetscToPointer( (v) ),*addv);
}
void PETSC_STDCALL vecsqrt_(Vec v, int *ierr ){
*ierr = VecSqrt(
	(Vec)PetscToPointer( (v) ));
}
void PETSC_STDCALL vecsum_(Vec v,PetscScalar *sum, int *ierr ){
*ierr = VecSum(
	(Vec)PetscToPointer( (v) ),sum);
}
void PETSC_STDCALL vecshift_( PetscScalar *shift,Vec v, int *ierr ){
*ierr = VecShift(shift,
	(Vec)PetscToPointer( (v) ));
}
void PETSC_STDCALL vecabs_(Vec v, int *ierr ){
*ierr = VecAbs(
	(Vec)PetscToPointer( (v) ));
}
void PETSC_STDCALL vecpermute_(Vec x,IS row,PetscTruth *inv, int *ierr ){
*ierr = VecPermute(
	(Vec)PetscToPointer( (x) ),
	(IS)PetscToPointer( (row) ),*inv);
}
void PETSC_STDCALL vecequal_(Vec vec1,Vec vec2,PetscTruth *flg, int *ierr ){
*ierr = VecEqual(
	(Vec)PetscToPointer( (vec1) ),
	(Vec)PetscToPointer( (vec2) ),flg);
}
#if defined(__cplusplus)
}
#endif
