/* ----------------------------------------------- */
/* company : pentamedia
 * author  : elcomski 
 * file    : pentasn.c 
 * date    : 2000-03-15
 * modify  : 2001-12-13 by elcomski
 */
/* ----------------------------------------------- */
#if 0 /* if you want to debug, set to 1 */
#define PENTASN_DEBUG
#endif

#include <linux/modversions.h> /* to avoid unresolved symbol */
#include <linux/module.h>
#include <linux/version.h>

#include <linux/pci.h>
#include <linux/netdevice.h>   /* struct device,other headers */
#include <linux/etherdevice.h> /* eth_type_trans */
#include <asm/uaccess.h>       /* copy_from_user( ) */ 

#include "debug.h"
#include "version.h"
#include "pridef.h"
#include "pentadrv.h"
#include "pentaio.h"
#include "pentasnc.h"

#include "hwapi.h"
#include "share/pentadef.h"
#include "../share/xptype.h"
#include "../share/ifdef.h"


/*--------------------------------*/
/* Function prototype definitions */
/*--------------------------------*/
static void PentaNet_interrupt( int irq, void* dev_instance, struct pt_regs* reg );
static void PentaNet_timer( unsigned long data );
static void PentaNet_short_bh( void *data );


/*--------------------------------*/
/* Constant definitions */
/*--------------------------------*/
#define MULTICAST_FILTER_LIMIT 100 


/*--------------------------------*/
/* Variable definitions */
/*--------------------------------*/
struct pentanet_private *g_priv;
int g_index = 0;
unsigned long volatile *if_jiffies; /* System variables */
static unsigned long g_data_rate_ga[MAX_CARD] = { 0,0,0,0,0,0,0,0,0,0 };


/*--------------------------------*/
/* Macro definitions */
/*--------------------------------*/
#define RUN_AT(x) (jiffies + (x))
#define DATA_RATE(x) g_data_rate_ga[x]
#define g_data_rate g_data_rate_ga[g_index]


/*--------------------------------*/
/* Function definitions */
/*--------------------------------*/
/* 
 * Func : PentaNet_open  
 * Context :
 */
int PentaNet_open(struct net_device *dev)
{
	struct pentanet_private *tp = (struct pentanet_private *)dev->priv;
	struct net_device *next_ndev;
	unsigned char baddr[8];
	int i,retval;
	int next_tick;

	MOD_INC_USE_COUNT;

	dbgPrintk("%s: Starting up Pent@NET card ( card idx = %d)\n",dev->name, tp->index);
	
	retval = request_irq( dev->irq, PentaNet_interrupt, SA_SHIRQ, dev->name, dev );
	if(retval){
		printk(KERN_ERR "EXIT, returning %d\n",retval);
		MOD_DEC_USE_COUNT;
		return retval;
	}

	if_jiffies = &jiffies;
	g_dev_base = dev_base;
	g_priv = dev->priv;
	g_index = g_priv->index;
	
	/* Set next_tick : 10ms */
	next_tick = (HZ / 100); 
	if( next_tick == 0){
		next_tick = 1;
	}

	/* initialize H/W */
	HWP_InitCard( (unsigned long)tp->mmio0_vaddr, (unsigned long)tp->mmio2_vaddr );

	/* get MAC address */
	HWP_GetMacAddress( baddr );
	for(i = 0;i < 6; i++){
		dev->dev_addr[i] = baddr[i];
		tp->mac_addr[i] = baddr[i];
	}
	
	FpgaInit( );
	
	/* install the timer service */
	init_timer(&g_priv->timer);

	/* register short task */
	g_priv->short_task.sync = 0;
	g_priv->short_task.routine = PentaNet_short_bh;
	g_priv->short_task.data = (void*)dev;

	/* set the timer service */
	g_priv->timer.function = &PentaNet_timer; 
	g_priv->timer.expires = RUN_AT( next_tick ); /* tick */
	g_priv->timer.data = (unsigned long)dev; 
	add_timer(&g_priv->timer); 

	sub_open( dev );

	/* replace 'dev->interrupt = 0' */
	/* replace 'dev->tbusy = 0' */
	/* replace 'dev->start = 1' */
	netif_start_queue( dev );
	
	tp->interrupt_status = 1;

	/* ip change code */
	next_ndev = dev->next;
		
	return 0;
}


/* 
 * Func : PentaNet_close  
 * Context :
 */
int PentaNet_close(struct net_device *dev)
{
	struct pentanet_private *tp = (struct pentanet_private *)dev->priv;

	dbgPrintk("%s: Shutting down Pent@NET card (card_idx=%d)\n",dev->name,tp->index );
	g_priv = dev->priv;
	g_index = g_priv->index;

	if( tp->interrupt_status == 1 ){
		DmxDeinit( );
	}

	sub_release( dev );

	/* replace 'dev->tbusy = 1' */
	netif_stop_queue( dev );

	/* Free resources */
	del_timer(&tp->timer);
	synchronize_irq( );
	free_irq(dev->irq, dev);
	
	MOD_DEC_USE_COUNT;
	return 0;
}


/* 
 * Func : PentaNet_config  
 * Context :
 */
int PentaNet_config(struct net_device *dev, struct ifmap *map )
{
	struct pentanet_private *tp = (struct pentanet_private*)dev->priv;

	/* can't act on a running interface */
	if(dev->flags & IFF_UP){
		return -EBUSY;
	}

	/* can't allow changing the I/O address */
	if(map->base_addr != (unsigned long)tp->mmio0_vaddr){
		return -EOPNOTSUPP;
	}

	/* allow changing the irq */
	if(map->irq != dev->irq){
		dev->irq = map->irq;
	}

	/* ignore other field */
	return 0;
}


/* 
 * Func : PentaNet_start_xmit  
 * Context :
 *	Nothing to do
 */
int PentaNet_start_xmit(struct sk_buff *skb, struct net_device *dev)
{
	return 0;
}


/* 
 * Func : PentaNet_ioctl  
 * Context :
 */
int PentaNet_ioctl( struct net_device *dev, struct ifreq *rq, int cmd )
{
	struct pentanet_private *tp = (struct pentanet_private*)dev->priv;
	char tmp_dev_name[50];
	str_io_data sio,*str_data;
	int icode,i,j,iret;

	str_data = (str_io_data *)rq->ifr_data;

	g_priv = dev->priv;
	g_index = g_priv->index;

	switch( cmd ){
		/*--------------------------------------*/
		/* Route Control */
		/*--------------------------------------*/
		case SM_ROUTE_FUNC: 
		{
			copy_from_user((void*)&sio.base_data, (void*)&str_data->base_data, sizeof(sio.base_data));
			icode = sio.base_data.code;
			switch(icode)
			{
				case CM_SET_ROUTE_DEVICE:
				{
					if( sio.base_data.length > 0){
						copy_from_user((void*)sio.spec.byte_buf, (void*)&str_data->spec.byte_buf, sio.base_data.length );
					}
					for( i = 0 ; i < sio.base_data.length ; i++){
						tmp_dev_name[i] = sio.spec.byte_buf[i];
					}
					tmp_dev_name[i] = 0;
					sm_multi_route_device( tmp_dev_name );

					if(sio.base_data.length > 0){
						copy_to_user((void*)&str_data->spec.byte_buf, (void*)&sio.spec.byte_buf, sio.base_data.length );
					}
				}
				break;

				case CM_SET_IP_ALL:
				{
					sm_multi_ip_all(sio.base_data.para0);
				}
				break;

				case CM_ADD_IP:
				{
					sm_multi_ip_add(sio.base_data.para0);
				}
				break;

				case CM_DEL_IP:
				{
					sm_multi_ip_del(sio.base_data.para0);
				}
				break;
				
				case CM_CLEAR_IP:
				{
					sm_multi_ip_clear( );
				}
				break;

				case CM_GET_MIP:
				{
					if( sio.base_data.para0 ){
						if( sio.base_data.length > 0 ){
							copy_from_user((void*)&sio.spec.mac_data, &str_data->spec.mac_data, sizeof(sio.spec.mac_data));
						}

						for( i = 0; i < sio.base_data.para1; i++){
							for( j = 0 ; j < 6; j++){
								 str_data->spec.mac_data.mac[i][j] = psPentanetspinfo.oMmacinfo[g_index][i][j+2];
								 sio.spec.mac_data.mac[i][j] = str_data->spec.mac_data.mac[i][j];
							}
						}

						if( sio.base_data.length > 0 ){
							copy_to_user((void*)&str_data->spec.mac_data, (void*)&sio.spec.mac_data, sizeof(sio.spec.mac_data));
						}
					}else{
						sio.base_data.para1 = psPentanetspinfo.uiMipcount[g_index];
						sio.base_data.para2 = psPentanetspinfo.iFilterflag[g_index];
					}
				}
				break;
			}
			copy_to_user((void*)&str_data->base_data, (void*)&sio.base_data, sizeof(sio.base_data));
		}
		break;

		/*--------------------------------------*/
		/* The other Control */
		/*--------------------------------------*/
		case SM_IO_CONTROL:
		{
			copy_from_user((void*)&sio.base_data, (void*)&str_data->base_data, sizeof(sio.base_data));
			icode = sio.base_data.code;
			switch(icode)
			{
				case CM_GET_DEVICE_STATUS:
				{
					sio.base_data.para0 = tp->interrupt_status;
				}
				break;
				
				case CM_GET_RECEIVED_PACKETS:
				{
					/* # of Packets received */		
					sio.base_data.para0 = tp->stats.rx_packets;
				}
				break;
				
				case CM_GET_VERSION_CODE:
				{
					sio.base_data.para0 = PENTANET_VERSION;
				}
				break;
				
				case CM_SET_INITIAL_FLAG:
				{
					tp->interrupt_status= sio.base_data.para0;
				}	
				break;
				

				case CM_INIT_DMX:
				{
					PentaNetIo_Init_Dmx( (void*)sio.base_data.para0, sio.base_data.para1, sio.base_data.para2, sio.base_data.para3 );
				}
				break;

				case CM_DEINIT_DMX:
				{
					PentaNetIo_Deinit_Dmx( );
				}
				break;

				case CM_INIT_COMMON_DEVICE:
				{
					PentaNetIo_Init_Common_Device( );
				}
				break;

				case CM_GET_QUEUE_DATA:
				{
					PentaNetIo_Get_Queue_Data( );
				}
				break;

				case CM_GET_MAC:
				{
					if(sio.base_data.length > 0){
						copy_from_user((void*)sio.spec.byte_buf, (void*)&str_data->spec.byte_buf, sio.base_data.length );
					}

					for( i = 0 ; i < 6 ; i++){
						sio.spec.byte_buf[i] = g_priv->mac_addr[i];
					}

					if(sio.base_data.length > 0){
						copy_to_user((void*)&str_data->spec.byte_buf, (void*)&sio.spec.byte_buf, sio.base_data.length );
					}
				}
				break;

				case CM_GET_DATABPS:
				{
					sio.base_data.para0 = g_data_rate;
				}
				break;

				case CM_FILTER_IP:
				{
					PentaNetIo_Filter_Ip( sio.base_data.para0, sio.base_data.para1, sio.base_data.para2 );
				}
				break;

				case CM_CONTROL_QPSKIO:
				{
					if(sio.base_data.length > 0){
						copy_from_user((void*)sio.spec.dword_buf, (void*)&str_data->spec.dword_buf, sio.base_data.length );
					}

					PentaNetIo_QpskIo( sio.base_data.para0, sio.base_data.para1, sio.base_data.para2, sio.base_data.para3, sio.spec.dword_buf );

					if(sio.base_data.length > 0){
						copy_to_user((void*)&str_data->spec.dword_buf, (void*)&sio.spec.dword_buf, sio.base_data.length );
					}
				}
				break;

				case CM_CONTROL_TUNERIO:
				{
					if(sio.base_data.length > 0){
						copy_from_user((void*)sio.spec.dword_buf, (void*)&str_data->spec.dword_buf, sio.base_data.length );
					}

					PentaNetIo_TunerIo( sio.base_data.para0, sio.base_data.para1, sio.base_data.para2, sio.spec.dword_buf );

					if(sio.base_data.length > 0){
						copy_to_user((void*)&str_data->spec.dword_buf, (void*)&sio.spec.dword_buf, sio.base_data.length );
					}
				}
				break;

				case CM_CONTROL_DMXIO:
				{
					if(sio.base_data.length > 0){
						copy_from_user((void*)sio.spec.dword_buf, (void*)&str_data->spec.dword_buf, sio.base_data.length );
					}

					PentaNetIo_DmxIo( sio.base_data.para0, sio.base_data.para1, sio.base_data.para2, sio.spec.dword_buf );

					if(sio.base_data.length > 0){
						copy_to_user((void*)&str_data->spec.dword_buf, (void*)&sio.spec.dword_buf, sio.base_data.length );
					}
				}
				break;

				case CM_CONTROL_PID:
				{
					if(sio.base_data.length > 0){
						copy_from_user((void*)&sio.spec.pid_data, (void*)&str_data->spec.pid_data, sizeof (sio.spec.pid_data) );
					}

					for( i = 0 ; i < sio.base_data.length ; i++ ){
						sio.spec.pid_data.evencw[i] = str_data->spec.pid_data.evencw[i];
						sio.spec.pid_data.oddcw[i] = str_data->spec.pid_data.oddcw[i];
					}
					
					iret = PentaNetIo_Control_Pid( sio.base_data.para0, sio.base_data.para1, sio.spec.pid_data.evencw, sio.spec.pid_data.oddcw );

					/* iret -> -1  : Invalid Pid */
					sio.base_data.para0 = iret;
					
					if(sio.base_data.length > 0){
						copy_to_user((void*)&str_data->spec.pid_data, (void*)&sio.spec.pid_data, sizeof(sio.spec.pid_data) );
					}
				}
				break;

				case CM_CONTROL_ISR:
				{
					PentaNetIo_Control_Isr( sio.base_data.para0 );
				}
				break;

				case CM_CONTROL_LNB:
				{
					PentaNetIo_Control_Lnb( sio.base_data.para0);
				}
				break;

				case CM_CONTROL_RESET:
				{
					/* NIM reset */
					FpgaResetDevice( 0x20 );
				}
				break;
			}
			copy_to_user((void*)&str_data->base_data, (void*)&sio.base_data, sizeof(sio.base_data));
		}
		break;

		default:
			return -EOPNOTSUPP;
	}

	return 0;
}


/* 
 * Func : PentaNet_get_stats  
 * Context :
 */
struct net_device_stats* PentaNet_get_stats(struct net_device *dev)
{
	struct pentanet_private *tp = (struct pentanet_private*)dev->priv;
	return &tp->stats;
}


/* 
 * Func : PentaNet_rebuild_header  
 * Context :
 */
int PentaNet_rebuild_header(struct sk_buff *skb)
{
	struct net_device *dev = skb->dev;
	struct ethhdr *eth =  (struct ethhdr*)skb->data;

	memcpy( (void*)eth->h_source, (void*)dev->dev_addr, dev->addr_len);
	memcpy( (void*)eth->h_dest, (void*)dev->dev_addr, dev->addr_len);
	eth->h_dest[ETH_ALEN-1] ^= 0x01; /* dest is us xor 1 */

	return 0;
}


/* 
 * Func : PentaNet_set_rx_mode  
 * Context :
 */
void PentaNet_set_rx_mode(struct net_device *dev)
{
	struct dev_mc_list *mc_list;
	unsigned long flags;
	struct pentanet_private *tp = (struct pentanet_private*)dev->priv;

	spin_lock_irqsave( &tp->lock, flags );

	g_priv = dev->priv;
	g_index = g_priv->index;

	if(dev->flags & IFF_PROMISC){
		dbgPrintk("%s: promiscuous mode enabled\n",dev->name);
		ff_get_all_packets( );
		spin_unlock_irqrestore( &tp->lock, flags );
		return;
	}

	if((dev->flags & IFF_ALLMULTI) || (dev->mc_count > MULTICAST_FILTER_LIMIT ) ){
		dbgPrintk("%s: allmulti mode enabled\n",dev->name);
		ff_get_all_multicast_packets( );
		spin_unlock_irqrestore( &tp->lock, flags );
		return;
	}
	
	if(dev->mc_count == 0){
		ff_get_only_own_packets( );
		spin_unlock_irqrestore( &tp->lock, flags );
		return;
	}

	ff_clear_mc_list( );
	for(mc_list = dev->mc_list; mc_list ; mc_list = mc_list->next ){
		ff_store_mc_address(mc_list->dmi_addr);
	}
	ff_get_packets_in_multicast_list( );
	spin_unlock_irqrestore( &tp->lock, flags );
}


/* 
 *
 * Func : PentaNet_rx  
 * Context :
 */
void PentaNet_rx(struct net_device *dev,int len,unsigned char* buf)
{
	struct sk_buff *skb;
	unsigned char *pPtr;
	
	/* The packet has been retrievd from the transmission medium.
	 * build an skb around it,si upper layers can handle it */
	skb =  dev_alloc_skb( len + 2 );
	if(!skb){
		printk(KERN_ERR"low on memory\n");
		return;
	}
	
	skb_reserve(skb,2);
	pPtr = skb_put(skb,len);
	memcpy((void*)pPtr,(void*)buf,len);

	skb->dev = dev;
	skb->protocol = eth_type_trans(skb,dev);
#if 0
	skb->ip_summed = CHECKSUM_UNNECESSARY; /* don't check it */
#else
	skb->ip_summed = CHECKSUM_NONE; /* use S/W checksum */
#endif
	netif_rx(skb);
	
	return;
	
}

/* 
 * Func : PentaNet_rx_tx  
 * Context :
 */
void PentaNet_rx_tx(struct net_device *dev,int len,unsigned char* buf)
{
	struct sk_buff *skb;
	unsigned char *pPtr;
	int retval = 0;

	/* The packet has been retrievd from the transmission medium.
	 * build an skb around it,si upper layers can handle it */
	skb =  dev_alloc_skb( len + 2 );
	if(!skb){
		printk(KERN_ERR "low on memory\n");
		return;
	}

	skb_reserve(skb,2);
	pPtr = skb_put(skb,len);
	memcpy((void*)pPtr,(void*)buf,len);

	skb->dev = dev;
#if 0 
	skb->ip_summed = CHECKSUM_UNNECESSARY; /* don't check it */
#else
	skb->ip_summed = CHECKSUM_NONE; /* use S/W checksum */
#endif
	retval = 1;
	if(g_priv->route_dev!=NULL){
		retval = g_priv->route_dev->hard_start_xmit(skb,g_priv->route_dev);
	}
	if(retval != 0){
		dev_kfree_skb(skb);
	}
	return;
}


/* 
 * Func : PentaNet_interrupt  
 * Context : interrupt service routine
 */
static void PentaNet_interrupt( int irq, void* dev_instance,
		                struct pt_regs* reg )
{
	struct net_device *dev = (struct net_device*)dev_instance;
	struct pentanet_private *tp = (struct pentanet_private*)dev->priv;
	int old_index;
	struct pentanet_private *old_priv;

	if(!dev) return;
	
	/* set lock */
	spin_lock(&tp->lock);

	old_priv = g_priv;
	old_index = g_index;
	g_priv = dev->priv;
	g_index = g_priv->index;
	
	/* retrieve statusword : real netdevices use inb( ) or inw( ) */
	tp->status |= 0x8000;

	if( HWP_QueryIRQ( ) ){
		queue_task(&g_priv->short_task, &tq_immediate);
		mark_bh(IMMEDIATE_BH);
		g_priv->short_bh_count++; 
	}

	g_priv->interrupt_count++;

#ifdef PENTASN_DEBUG
	if((g_priv->interrupt_count%100)==0){
		dbgPrintk("interrupt:%d\n",g_priv->interrupt_count);
		dbgPrintk("timer:%d\n",g_priv->timer_count);
		dbgPrintk("bh:%d\n",g_priv->bh_count);
	}
#endif	
	tp->status &= 0x7fff;

	g_priv = old_priv;
	g_index = old_index;

	/* release lock */
	spin_unlock(&tp->lock);

	return;
}


/* 
 * Func : PentaNet_timer  
 * Context : Timer service routine
 */
static void PentaNet_timer(unsigned long data)
{
	struct net_device *dev = (struct net_device *)data;
	struct pentanet_private *tp = (struct pentanet_private*)dev->priv;
	int next_tick;
	int old_index;
	struct pentanet_private *old_priv;

	old_priv = g_priv;
	old_index = g_index;
	g_priv = dev->priv;
	g_index = g_priv->index;

	/* Set next_tick : 10ms */
	next_tick = HZ / 100;
	if( next_tick == 0 ){
		next_tick = 1;
	}
	g_priv->timer_count++;

#ifdef PENTASN_DEBUG
	if((g_priv->timer_count%100)==0){
		dbgPrintk("interrupt:%d\n",g_priv->interrupt_count);
		dbgPrintk("timer:%d\n",g_priv->timer_count);
		dbgPrintk("bh:%d\n",g_priv->bh_count);
	}
#endif

	if(!(g_priv->timer_count%100)){
		DATA_RATE(g_index) =
			tp->stats.rx_bytes - g_priv->old_data;
		g_priv->old_data =  tp->stats.rx_bytes;
#ifdef PENTASN_DEBUG
		dbgPrintk("data rate:%d\n",g_data_rate);
#endif
	}
	if(!(tp->status & 0x8000)){
		PacketProcess(dev);
	}
	g_priv->timer.expires = RUN_AT(next_tick);
	add_timer(&g_priv->timer);

	g_priv = old_priv;
	g_index = old_index;
}


/* 
 * Func : PentaNet_short_bh  
 * Context : Bottom half
 */
static void PentaNet_short_bh( void *data )
{
	struct net_device *dev = (struct net_device *)data;
	struct pentanet_private *tp = (struct pentanet_private*)dev->priv;
	int old_index;
	struct pentanet_private *old_priv;

	tp->status |= 0x8000;
	g_priv->short_bh_count = 0;

	old_priv = g_priv;
	old_index = g_index;
	g_priv = dev->priv;
	g_index = g_priv->index;

	PacketProcess(dev);

	g_priv = old_priv;
	g_index = old_index;

	g_priv->bh_count++;
	tp->status &= 0x7fff;
}
