//====================================================
//
//         DEMUX_REGISTER MAP
//
//====================================================

//////////////////////////////////////////////////////
//
// ========  RISC RAM Allocation  ================
//
// 0x000 - 0x3FF   Microcode
// 0x400 - 0x4BF   Filter Parameter Table 1   32*6
// 0x4C0 - 0x4CF   No use
// 0x4D0 - 0x4FF   CW Table 1                 3*16
// 0x500 - 0x5BF   Filter Parameter Table 2   32*6
// 0x5C0 - 0x5CF   No use
// 0x5D0 - 0x5FF   CW Table 2                 3*16
// 0x600 - 0x6BF   Filter Parameter Table 3   32*6
// 0x6C0 - 0x6CF   No use
// 0x6D0 - 0x6EF   CW Table 3                 2*16
// 0x6F0 - 0x6FF   No use
// 0x700 - 0x73F   PID parsing Tables         32*2
// 0x740 - 0x7BF   PID Parsing Control Table  32*4
// 0x7C0 - 0x7DF   Filter Definition Table    32*4
// 0x7E0 - 0x7FD   No use
// 0x7FE - 0x7FF   Version number
//
//////////////////////////////////////////////////////

#define  DMX_REGS_BASE  0x400000
#define  DMX_RISC_BASE  0x401000

#define  DMX_PID_TABLE	       ( DMX_RISC_BASE+0x700 )
#define  DMX_PID_CONTROL_TABLE ( DMX_RISC_BASE+0x740 )
#define  DMX_FILTER_DEF_TABLE  ( DMX_RISC_BASE+0x7C0 )
#define  DMX_FILTER_TABLE_1    ( DMX_RISC_BASE+0x400 )
#define  DMX_FILTER_TABLE_2    ( DMX_RISC_BASE+0x500 )
#define  DMX_FILTER_TABLE_3    ( DMX_RISC_BASE+0x600 )
#define  DMX_CW_TABLE_1        ( DMX_RISC_BASE+0x4D0 ) // size 3 X 16 bytes
#define  DMX_CW_TABLE_2        ( DMX_RISC_BASE+0x5D0 ) // size 3 X 16 bytes
#define  DMX_CW_TABLE_3        ( DMX_RISC_BASE+0x6D0 ) // size 2 X 16 bytes

/* DEMUX register definitions */

/* Graphics */
#define	 DMX_GMRH	( DMX_REGS_BASE+0x00 ) /* Graphics Mode High Register */
#define	 DMX_GMRL	( DMX_REGS_BASE+0x02 ) /* Graphics Mode Low Register */

/* Interrupt control */
#define  DMX_ISR0	( DMX_REGS_BASE+0x80 ) /* Interrupt Status Register */
#define  DMX_ISR1	( DMX_REGS_BASE+0x82 ) /* Interrupt Status Register */
#define  DMX_ISR2	( DMX_REGS_BASE+0x84 ) /* Interrupt Status Register */
#define  DMX_IMR0	( DMX_REGS_BASE+0x86 ) /* Interrupt Mask Register */
#define  DMX_IMR1	( DMX_REGS_BASE+0x88 ) /* Interrupt Mask Register */
#define  DMX_IMR2	( DMX_REGS_BASE+0x8A ) /* Interrupt Mask Register */
#define  DMX_IPRI0	( DMX_REGS_BASE+0x8C ) /* Interrupt Priority Register */
#define  DMX_IPRI1	( DMX_REGS_BASE+0x8E ) /* Interrupt Priority Register */
#define  DMX_IPRI2	( DMX_REGS_BASE+0x90 ) /* Interrupt Priority Register */

/*
 * The upper queue registers
 */
#define  DMX_ISR3	( DMX_REGS_BASE+0x92 ) /* Interrupt Status Register */
#define  DMX_IMR3	( DMX_REGS_BASE+0x94 ) /* Interrupt Mask Register */
#define  DMX_IPRI3	( DMX_REGS_BASE+0x96 ) /* Interrupt Priority Register */


#define DMX_CRCCMDH	( DMX_REGS_BASE+0xa0 )
#define DMX_CRCCMDL	( DMX_REGS_BASE+0xa2 )
#define DMX_CRCRCVH	( DMX_REGS_BASE+0xa8 )
#define DMX_CRCRCVL	( DMX_REGS_BASE+0xaa )

/* PCM Audio Registers */
#define  DMX_PCM_ADDRH	( DMX_REGS_BASE+0xE0 ) /* PCM Addr  Register upper word */
#define  DMX_PCM_ADDRL	( DMX_REGS_BASE+0xE2 ) /* PCM Addr  Register lower word */
#define  DMX_PCM_ATTRH	( DMX_REGS_BASE+0xE4 ) /* PCM Attenuation  Register upper word */
#define  DMX_PCM_ATTRL	( DMX_REGS_BASE+0xE6 ) /* PCM Attenuation  Register lower word */
#define  DMX_PCM_CTLR	( DMX_REGS_BASE+0xE8 ) /* PCM Control  Register */
#define  DMX_PCM_DMARH	( DMX_REGS_BASE+0xEC ) /* PCM DMA  Addr  Register upper word */
#define  DMX_PCM_DMARL	( DMX_REGS_BASE+0xEE ) /* PCM DMA  Addr  Register lower word */


/* Video registers */
#define  DMX_VBRL	( DMX_REGS_BASE+0xF0 ) /* Video Background  Register upper word*/
#define  DMX_VBRH	( DMX_REGS_BASE+0xF2 ) /* Video Background  Register lower word*/
#define  DMX_VCR	( DMX_REGS_BASE+0xF4 ) /* Video Control register */
#define  DMX_LCR	( DMX_REGS_BASE+0xF6 ) /* Video Line Count register */
#define  DMX_LIR1	( DMX_REGS_BASE+0xF8 ) /* Video Line Interrupt register #1 */
#define  DMX_HTR	( DMX_REGS_BASE+0xFA ) /* Video Horizontal Total register */
#define  DMX_LTR	( DMX_REGS_BASE+0xFC ) /* Video Line Total register  */
#define  DMX_LIR2	( DMX_REGS_BASE+0xFE ) /* Video Line Interrupt register #2 */


/* Reset/Configuration */
#define  DMX_RR0	( DMX_REGS_BASE+0x100 ) /* Reset Register */
#define  DMX_RR1	( DMX_REGS_BASE+0x102 ) /* Reset Register */
#define  DMX_CFR0	( DMX_REGS_BASE+0x104 ) /* Configuration Register */
#define  DMX_CFR1	( DMX_REGS_BASE+0x106 ) /* Configuration Register */
#define  DMX_ICCR	( DMX_REGS_BASE+0x10C ) /* Instruction Cache Control Register */
#define  DMX_DCCR	( DMX_REGS_BASE+0x10E ) /* Data Cache Control Register */

/* DAC Note: the DAC is a signed register */
#define  DMX_DPCR	( DMX_REGS_BASE+0x110 ) /* DAC Pulse Count Register */
#define  DMX_DPR	( DMX_REGS_BASE+0x112 ) /* DAC Pulse Count Register */

/* Framer Registers */
#define  DMX_FRMR_PCRP	( DMX_REGS_BASE+0x120 ) /* Framer's PCR PID Register */
#define  DMX_FRMR_TPCR2	( DMX_REGS_BASE+0x122 ) /* Framer's Tranport Packet PCR Register */
#define  DMX_FRMR_TPCR1	( DMX_REGS_BASE+0x124 ) /* Framer's Tranport Packet PCR Register */
#define  DMX_FRMR_TPCR0	( DMX_REGS_BASE+0x126 ) /* Framer's Tranport Packet PCR Register */

#define  DMX_FRMR_LPCR2	( DMX_REGS_BASE+0x128 ) /* Framer's Latched  PCR Register */
#define  DMX_FRMR_LPCR1	( DMX_REGS_BASE+0x12A ) /* Framer's Latched  PCR Register */
#define  DMX_FRMR_LPCR0	( DMX_REGS_BASE+0x12C ) /* Framer's Latched  PCR Register */

#define  DMX_FRMR_PCRC2	( DMX_REGS_BASE+0x12E ) /* Framer's PCR Counter  Register */
#define  DMX_FRMR_PCRC1	( DMX_REGS_BASE+0x130 ) /* Framer's PCR Counter  Register */
#define  DMX_FRMR_PCRC0	( DMX_REGS_BASE+0x132 ) /* Framer's PCR Counter  Register */

#define  DMX_FRMR_FCR	( DMX_REGS_BASE+0x134 ) /* Framer's Framer Control Register */
#define  DMX_FRMR_SHR	( DMX_REGS_BASE+0x136 ) /* Framer's Sync Hysteresis Register */
#define  DMX_FRMR_MPFDR	( DMX_REGS_BASE+0x138 ) /* Framer's  Maximum Packet FIFO Depth Register */


/* IDC interface registers */
#define  DMX_IDCCR	( DMX_REGS_BASE+0x140 ) /* IDC Main Control Register. */
#define  DMX_IDCSR	( DMX_REGS_BASE+0x142 ) /* IDC Status Register. */
#define  DMX_IDCSA	( DMX_REGS_BASE+0x144 ) /* IDC Slave Address Register. */
#define  DMX_IDCRD	( DMX_REGS_BASE+0x146 ) /* IDC Receive Data Register. */
#define  DMX_IDCMA	( DMX_REGS_BASE+0x148 ) /* IDC Master Address Register. */
#define  DMX_IDCTD	( DMX_REGS_BASE+0x14A ) /* IDC Transmit Data Register. */
#define  DMX_IDCC	( DMX_REGS_BASE+0x14C ) /* IDC Program Clock Register. */
#define  DMX_IDCFF	( DMX_REGS_BASE+0x14E ) /* IDC FIFO status/fullness register. */



/* Audio video decoder interface registers */
#define  DMX_AVICR0	( DMX_REGS_BASE+0x150 ) /* A/V decoder interface config register 0 */
#define  DMX_AVICR1	( DMX_REGS_BASE+0x152 ) /* A/V decoder interface config register 1 */

/* RISC Engine Control */
#define  DMX_RISC_REC   ( DMX_REGS_BASE+0x178 ) /*  RISC Engine Control Register */

/* Queue */
#define  DMX_QHP0L	( DMX_REGS_BASE+0x180 ) /* Queue 0 Write Pointer Low Register */
#define  DMX_QHP0H	( DMX_REGS_BASE+0x182 ) /* Queue 0 Write Pointer High Register */
#define  DMX_QHP1L	( DMX_REGS_BASE+0x184 ) /* Queue 1 Write Pointer Low Register */
#define  DMX_QHP1H	( DMX_REGS_BASE+0x186 ) /* Queue 1 Write Pointer High Register */
#define  DMX_QHP2L	( DMX_REGS_BASE+0x188 ) /* Queue 2 Write Pointer Low Register */
#define  DMX_QHP2H	( DMX_REGS_BASE+0x18A ) /* Queue 2 Write Pointer High Register */
#define  DMX_QHP3L	( DMX_REGS_BASE+0x18C ) /* Queue 3 Write Pointer Low Register */
#define  DMX_QHP3H	( DMX_REGS_BASE+0x18E ) /* Queue 3 Write Pointer High Register */
#define  DMX_QHP4L	( DMX_REGS_BASE+0x190 ) /* Queue 4 Write Pointer Low Register */
#define  DMX_QHP4H	( DMX_REGS_BASE+0x192 ) /* Queue 4 Write Pointer High Register */
#define  DMX_QHP5L	( DMX_REGS_BASE+0x194 ) /* Queue 5 Write Pointer Low Register */
#define  DMX_QHP5H	( DMX_REGS_BASE+0x196 ) /* Queue 5 Write Pointer High Register */
#define  DMX_QHP6L	( DMX_REGS_BASE+0x198 ) /* Queue 6 Write Pointer Low Register */
#define  DMX_QHP6H	( DMX_REGS_BASE+0x19A ) /* Queue 6 Write Pointer High Register */
#define  DMX_QHP7L	( DMX_REGS_BASE+0x19C ) /* Queue 7 Write Pointer Low Register */
#define  DMX_QHP7H	( DMX_REGS_BASE+0x19E ) /* Queue 7 Write Pointer High Register */
#define  DMX_QHP8L	( DMX_REGS_BASE+0x1A0 ) /* Queue 8 Write Pointer Low Register */
#define  DMX_QHP8H	( DMX_REGS_BASE+0x1A2 ) /* Queue 8 Write Pointer High Register */
#define  DMX_QHP9L	( DMX_REGS_BASE+0x1A4 ) /* Queue 9 Write Pointer Low Register */
#define  DMX_QHP9H	( DMX_REGS_BASE+0x1A6 ) /* Queue 9 Write Pointer High Register */
#define  DMX_QHPAL	( DMX_REGS_BASE+0x1A8 ) /* Queue A Write Pointer Low Register */
#define  DMX_QHPAH	( DMX_REGS_BASE+0x1AA ) /* Queue A Write Pointer High Register */
#define  DMX_QHPBL	( DMX_REGS_BASE+0x1AC ) /* Queue B Write Pointer Low Register */
#define  DMX_QHPBH	( DMX_REGS_BASE+0x1AE ) /* Queue B Write Pointer High Register */
#define  DMX_QHPCL	( DMX_REGS_BASE+0x1B0 ) /* Queue C Write Pointer Low Register */
#define  DMX_QHPCH	( DMX_REGS_BASE+0x1B2 ) /* Queue C Write Pointer High Register */
#define  DMX_QHPDL	( DMX_REGS_BASE+0x1B4 ) /* Queue D Write Pointer Low Register */
#define  DMX_QHPDH	( DMX_REGS_BASE+0x1B6 ) /* Queue D Write Pointer High Register */
#define  DMX_QHPEL	( DMX_REGS_BASE+0x1B8 ) /* Queue E Write Pointer Low Register */
#define  DMX_QHPEH	( DMX_REGS_BASE+0x1BA ) /* Queue E Write Pointer High Register */
#define  DMX_QHPFL	( DMX_REGS_BASE+0x1BC ) /* Queue F Write Pointer Low Register */
#define  DMX_QHPFH	( DMX_REGS_BASE+0x1BE ) /* Queue F Write Pointer High Register */
#define  DMX_QI0	( DMX_REGS_BASE+0x1C0 ) /* Queue Interrupt Register */
#define  DMX_QI1	( DMX_REGS_BASE+0x1C2 ) /* Queue Interrupt Register */
#define  DMX_QI2	( DMX_REGS_BASE+0x1C4 ) /* Queue Interrupt Register */
#define  DMX_QI3	( DMX_REGS_BASE+0x1C6 ) /* Queue Interrupt Register */
#define  DMX_QI4	( DMX_REGS_BASE+0x1C8 ) /* Queue Interrupt Register */
#define  DMX_QI5	( DMX_REGS_BASE+0x1CA ) /* Queue Interrupt Register */
#define  DMX_QI6	( DMX_REGS_BASE+0x1CC ) /* Queue Interrupt Register */
#define  DMX_QI7	( DMX_REGS_BASE+0x1CE ) /* Queue Interrupt Register */
#define  DMX_QI8	( DMX_REGS_BASE+0x1D0 ) /* Queue Interrupt Register */
#define  DMX_QI9	( DMX_REGS_BASE+0x1D2 ) /* Queue Interrupt Register */
#define  DMX_QIA	( DMX_REGS_BASE+0x1D4 ) /* Queue Interrupt Register */
#define  DMX_QIB	( DMX_REGS_BASE+0x1D6 ) /* Queue Interrupt Register */
#define  DMX_QIC	( DMX_REGS_BASE+0x1D8 ) /* Queue Interrupt Register */
#define  DMX_QID	( DMX_REGS_BASE+0x1DA ) /* Queue Interrupt Register */
#define  DMX_QIE	( DMX_REGS_BASE+0x1DC ) /* Queue Interrupt Register */
#define  DMX_QIF	( DMX_REGS_BASE+0x1DE ) /* Queue Interrupt Register */
#define  DMX_AQTPL	( DMX_REGS_BASE+0x1E0 ) /* Audio Queue Read Pointer Register */
#define  DMX_AQTPH	( DMX_REGS_BASE+0x1E2 ) /* Audio Queue Read Pointer Register */
#define  DMX_AQHPL	( DMX_REGS_BASE+0x1E4 ) /* Audio Queue Write Pointer Register */
#define  DMX_AQHPH	( DMX_REGS_BASE+0x1E6 ) /* Audio Queue Write Pointer Register */
#define  DMX_VQTPL	( DMX_REGS_BASE+0x1F0 ) /* Video Queue Read Pointer Register */
#define  DMX_VQTPH	( DMX_REGS_BASE+0x1F2 ) /* Video Queue Read Pointer Register */
#define  DMX_VQHPL	( DMX_REGS_BASE+0x1F4 ) /* Video Queue Write Pointer Register */
#define  DMX_VQHPH	( DMX_REGS_BASE+0x1F6 ) /* Video Queue Write Pointer Register */

#define  DMX_TQTPL	( DMX_REGS_BASE+0x1e8 ) /* Teletext Queue Read Pointer Register */
#define  DMX_TQTPH	( DMX_REGS_BASE+0x1ea ) /* Teletext Queue Read Pointer Register */
#define  DMX_TQHPL	( DMX_REGS_BASE+0x1ec ) /* Teletext Queue Write Pointer Register */
#define  DMX_TQHPH	( DMX_REGS_BASE+0x1ee ) /* Teletext Queue Write Pointer Register */

/* Teletext register TTX */
#define	 DMX_TTX_PTS0 	( DMX_REGS_BASE+0x280 ) /* */
#define	 DMX_TTX_PTS1 	( DMX_REGS_BASE+0x282 ) /* */
#define	 DMX_TTX_PTS_OFFSET ( DMX_REGS_BASE+0x284 ) /* */
#define	 DMX_TTX_TCR	( DMX_REGS_BASE+0x286 ) /* */
#define	 DMX_TTX_TSR	( DMX_REGS_BASE+0x288 ) /* */

/* Infrared Registers (IR) */
#define	 DMX_IR_CWP	( DMX_REGS_BASE+0x2A0 ) /* */
#define	 DMX_IR_CWPH	( DMX_REGS_BASE+0x2A2 ) /* */
#define	 DMX_IR_MSPR	( DMX_REGS_BASE+0x2A4 ) /* */
#define	 DMX_IR_MSPL	( DMX_REGS_BASE+0x2A6 ) /* */
#define	 DMX_IR_RTC	( DMX_REGS_BASE+0x2A8 ) /* */
#define	 DMX_IR_RTP	( DMX_REGS_BASE+0x2AA ) /* */
#define	 DMX_IR_RFR	( DMX_REGS_BASE+0x2AC ) /* */
#define	 DMX_IR_RPH	( DMX_REGS_BASE+0x2AE ) /* */
#define	 DMX_IR_IRQA	( DMX_REGS_BASE+0x2B0 ) /* */
#define	 DMX_IR_IRRE	( DMX_REGS_BASE+0x2B4 ) /* */
#define	 DMX_IR_IRTE	( DMX_REGS_BASE+0x2B6 ) /* */
#define	 DMX_IR_IRRO	( DMX_REGS_BASE+0x2B8 ) /* */
#define	 DMX_IR_IRTO	( DMX_REGS_BASE+0x2BA ) /* */


#define  DMX_HEARTBEAT_COUNT   ( DMX_RISC_BASE + 0x7e2 )


// !DMXTABLE

#define  DMX_PID_TABLE_s      32
    /* Number of parsing table entries */

// 0x700 - 0x73F   PID parsing Tables         32*2

#define  DMX_PID_TABLE_ENTRY_s   2
    /* Size in bytes of parsing table entry */



/* -------------------- */
/* Symbols for Interrupt mask bits  ISR0 */
#define DMXINT_FRMR_m			0x0100
#define DMXINT_SYNC_DROP_m		0x0080
#define DMXINT_SYNC_LOCK_m		0x0040
#define DMXINT_AD_DONE_m		0x1000

/* -------------------- */
/* Symbols for Interrupt mask bits  ISR1 */
#define DMXINT_TTX_m			0x8000
#define DMXINT_IR_m			0x0200

/* -------------------- */
/* Symbols for PCR PID Register  (bit number 13) */
#define DMX_ENABLE_PID_MATCHING_m	0x2000

/* -------------------- */
/* Symbols for configuration  mask bits  */
#define DMXCONFIG_UPQ_m			0x0010


#define  MAX_QUEUES	32

#define  DMXQ_MASK(QNUM)  (1 << (QNUM))   /* Interrupt mask for DMX Q */


/*
 * Maximum number of user-defined queues including the Tele-text queue
 */
#define  MAX_USER_QUEUES 30

#define	 FIRST_USER_QUEUE_ID	2
#define	 LAST_USER_QUEUE_ID	(FIRST_USER_QUEUE_ID + MAX_USER_QUEUES - 1)



/* -------------------- */
/* Symbols for DMX_IDCCR	(IDC Main Control Register) */

/*** master enable (b1) ***/
#define IDCCR_ME_b	0x0002	/* enable the master, and start the exchange. */

/*** interrupt enable (b3) ***/
#define IDCCR_IE_b	0x0008	/* enable the interrupt. */

/*** Flush Tx data FIFO (b4) ***/
#define IDCCR_FT_b	(1 << 4) /* flush Tx Data FIFO */

/*** Flush Rx data FIFO (b5) ***/
#define IDCCR_FR_b	(1 << 5) /* flush Rx Data FIFO */

/*** last byte (b6) ***/
#define IDCCR_LB_b	0x0040	/* generate the stop condition in both mode and the no_ack in the read mode. */

/*** master mode (b7) ***/
#define IDCCR_MM_b	0x0080 /* mode for the main control register => read. */

/*** valid data (b12) ***/
#define IDCCR_VD_b	(1 << 12)

/* -------------------- */
/* Symbols for DMX_IDCSR	(IDC Status Register) */

/*** receive FIFO not empty (Rx FIFO count is non zero) (b2) ***/
#define IDCSR_RxR_b	(1 << 2)

/*** ack have been receive (b3) ***/
#define IDCSR_AK_b	0x0008	/* a acknoledge have been receive. */

/*** no-ack have been receive (b4) ***/
#define IDCSR_NAK_b	0x0010	/* a no-acknoledge have been receive. */

/*** master mode interrupt (b6) ***/
#define IDCSR_MI_b	(1 << 6)

/*** stop condition detected/generated  (b9) ***/
#define IDCSR_SD_b	(1 << 9)

/*** transmit FIFO empty (Tx FIFO count is zero) (b10) ***/
#define IDCSR_TxE_b	(1 << 10)

/* -------------------- */
/* Symbols for DMX_IDCMA	(IDC Master Address Register) */

/* Read/Write exchange mode (Transmit/Receive) (b0) */
#define IDCMA_RW_b	0x0001	/* Set the exchange mode to read. */

/* Mask for the address (b1-b7) */
#define IDCMA_MAddr_v	0x00FE	/* clear the no-address bit. */

#define DMXINT_IDC_m	0x0200
#define IDC_100k_clk	0x66
#define IDC_39_7k_clk	0xff	/* The slower frequency. */

