#
# config.make
#
# Some settings for building PDFKit
#
# Copyright (C) 2003 Stefan Kleine Stegemann <stefan@wms-network.de>
#
# This Makefile is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
# See the GNU General Public License for more details.
#

#--------------------------------------------
# you may have to change something here
#--------------------------------------------

# Where is freetype installed (if not in a standard location)
# LIB_FREETYPE_ADD_INCLUDES can be used if your freetype2
# installation in spread among two or more directories (this
# is the case on FreeBSD systems). Otherwise, you don't need
# to touch this setting. Note that you have to include the
# -I option when specifying LIB_FREETYPE_ADD_INCLUDES.

ifeq ($(findstring freebsd, $(GNUSTEP_TARGET_OS)), freebsd)
   # On FreeBSD, we assume that freetype is installed from 
   # the ports collection or from a package. So the following
   # should work for most FreeBSD users. 
   # something here.
   LIB_FREETYPE_LIBS=/usr/local/lib
   LIB_FREETYPE_INCLUDES=/usr/local/include/freetype2
   LIB_FREETYPE_ADD_INCLUDES=-I/usr/local/include
else
   # The following should work for most linux systems. If
   # this does not work on your system, you have to set
   # LIB_FREETYPE_LIBS and LIB_FREETYPE_INCLUDES by hand.
   # You may also want to set LIB_FREETYPE_ADD_INCLUDES if
   # the freetype headers are spread among various directories
   # (see freebsd section above for an example).
   FT_PREFIX=$(shell freetype-config --prefix)
   LIB_FREETYPE_LIBS=$(FT_PREFIX)/lib
   LIB_FREETYPE_INCLUDES=$(FT_PREFIX)/include/freetype2/freetype
   LIB_FREETYPE_ADD_INCLUDES=$(shell freetype-config --cflags)
endif


#--------------------------------------------
# don't change anything from here after
#--------------------------------------------

# which xpdf sources should be used?
XPDF_SRC=xpdf-3.00

