/*
 * Copyright (c) 2002 SuSE GmbH Nuernberg, Germany.
 * Author: Thorsten Kukuk <kukuk@suse.de>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, and the entire permission notice in its entirety,
 *    including the disclaimer of warranties.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote
 *    products derived from this software without specific prior
 *    written permission.
 *
 * ALTERNATIVELY, this product may be distributed under the terms of
 * the GNU Public License, in which case the provisions of the GPL are
 * required INSTEAD OF the above restrictions.  (This clause is
 * necessary due to a potential bad interaction between the GPL and
 * the restrictions contained in a BSD-style copyright.)
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#define _GNU_SOURCE

#if defined(HAVE_CONFIG_H)
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "common.h"

int
restore_permissions (const char *tty)
{
  FILE *fp;
  char *save_perms;
  char buf[BUFSIZ];
  unsigned long int i;

  if (tty == NULL || tty[0] == '\0')
    return 1;

  save_perms = alloca (strlen (SAVE_PERMS_PATH) + strlen (tty) + 2);
  /* XXX (use stpcpy) */
  strcpy (save_perms, SAVE_PERMS_PATH);
  strcat (save_perms, tty);
  for (i = strlen (SAVE_PERMS_PATH); i < strlen (save_perms); ++i)
    if (save_perms[i] == '/')
      save_perms[i] = '_';

  fp = fopen(save_perms, "r");
  if (fp == NULL)
    return 0;

  while (fgets (buf, sizeof(buf), fp))
    {
#define WSPACE          " \t\n"
      char *device, *cp;
      int perm;
      unsigned long int uid;
      unsigned long int gid;

      if ((cp = strchr (buf, '#')) != NULL)
	*cp = 0;                            /* strip comment */
      device = buf;
      if ((cp = strchr (buf, ' ')) == 0)
	continue;                           /* empty or comment */
      *cp++ = 0;
      sscanf(cp, "%o %lu %lu", &perm, &uid, &gid);
      login_protect (device, perm, uid, gid, NULL);
    }
  fclose(fp);
  unlink (save_perms);

  return 0;
}
