/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.Header;
import org.javagroups.Message;
import org.javagroups.View;
import org.javagroups.log.Trace;
import org.javagroups.stack.AckReceiverWindow;
import org.javagroups.stack.AckSenderWindow;
import org.javagroups.stack.Protocol;
import org.javagroups.util.TimeScheduler;
import org.javagroups.util.Util;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class UNICAST
extends Protocol
implements AckSenderWindow.RetransmitCommand {
    boolean operational;
    Vector members;
    Hashtable connections;
    long[] timeout;
    Address local_addr;
    TimeScheduler timer;
    boolean use_gms;
    int window_size;
    int min_threshold;

    public String getName() {
        return "UNICAST";
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("timeout");
        if (str != null) {
            long[] tmp = Util.parseCommaDelimitedLongs(str);
            if (tmp != null && tmp.length > 0) {
                this.timeout = tmp;
            }
            props.remove("timeout");
        }
        if ((str = props.getProperty("window_size")) != null) {
            this.window_size = Integer.parseInt(str);
            props.remove("window_size");
        }
        if ((str = props.getProperty("min_threshold")) != null) {
            this.min_threshold = Integer.parseInt(str);
            props.remove("min_threshold");
        }
        if ((str = props.getProperty("use_gms")) != null) {
            this.use_gms = new Boolean(str);
            props.remove("use_gms");
        }
        if (props.size() > 0) {
            System.err.println("UNICAST.setProperties(): these properties are not recognized:");
            props.list(System.out);
            return false;
        }
        if (this.window_size > 0 && this.min_threshold <= 0 || this.window_size <= 0 && this.min_threshold > 0) {
            Trace.error("UNICAST.setProperties()", "window_size and min_threshold have to be both set if one of them is set");
            return false;
        }
        if (this.window_size > 0 && this.min_threshold > 0 && this.window_size < this.min_threshold) {
            Trace.error("UNICAST.setProperties()", "min_threshold (" + this.min_threshold + ") has to be less than window_size (" + this.window_size + ')');
            return false;
        }
        return true;
    }

    public void start() throws Exception {
        TimeScheduler timeScheduler = this.timer = this.stack != null ? this.stack.timer : null;
        if (this.timer == null) {
            throw new Exception("UNICAST.start(): timer is null");
        }
    }

    public void stop() {
        this.removeAllConnections();
        this.operational = false;
    }

    public void up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                UnicastHeader hdr;
                Message msg = (Message)evt.getArg();
                Address dst = msg.getDest();
                Address src = msg.getSrc();
                if (dst == null || dst.isMulticastAddress() || (hdr = (UnicastHeader)msg.removeHeader(this.getName())) == null) break;
                switch (hdr.type) {
                    case 0: {
                        this.sendAck(src, hdr.seqno);
                        this.handleDataReceived(src, hdr.seqno, hdr.first, msg);
                        break;
                    }
                    case 1: {
                        this.handleAckReceived(src, hdr.seqno);
                        break;
                    }
                    default: {
                        Trace.error("UNICAST.up()", "UnicastHeader type " + hdr.type + " not known !");
                        break;
                    }
                }
                return;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
        }
        this.passUp(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void down(Event evt) {
        block4 : switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                Address dst = msg.getDest();
                if (dst == null || dst.isMulticastAddress()) break;
                Entry entry = (Entry)this.connections.get(dst);
                if (entry == null) {
                    entry = new Entry();
                    this.connections.put(dst, entry);
                }
                UnicastHeader hdr = new UnicastHeader(0, entry.sent_msgs_seqno);
                if (entry.sent_msgs == null) {
                    hdr.first = true;
                    entry.sent_msgs = new AckSenderWindow(this, this.timeout, this);
                    if (this.window_size > 0) {
                        entry.sent_msgs.setWindowSize(this.window_size, this.min_threshold);
                    }
                }
                msg.putHeader(this.getName(), hdr);
                entry.sent_msgs.add(entry.sent_msgs_seqno, msg);
                ++entry.sent_msgs_seqno;
                return;
            }
            case 16: {
                this.operational = true;
                break;
            }
            case 6: {
                Vector left_members;
                Vector new_members = ((View)evt.getArg()).getMembers();
                Vector vector = this.members;
                synchronized (vector) {
                    left_members = Util.determineLeftMembers(this.members, new_members);
                    this.members.removeAllElements();
                    if (new_members != null) {
                        this.members.addAll(new_members);
                    }
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 4, 7] lbl34 : MonitorExitStatement: MONITOREXIT : var9_7
                    if (!this.use_gms || left_members.size() <= 0) break;
                }
                Hashtable hashtable = this.connections;
                synchronized (hashtable) {
                    int i = 0;
                    while (true) {
                        if (i >= left_members.size()) {
                            break block4;
                        }
                        Object mbr = left_members.elementAt(i);
                        this.removeConnection(mbr);
                        ++i;
                    }
                }
            }
        }
        this.passDown(evt);
    }

    void removeConnection(Object mbr) {
        Entry entry = (Entry)this.connections.get(mbr);
        if (entry != null) {
            entry.reset();
            if (Trace.trace) {
                Trace.info("UNICAST.removeConnection()", "removed " + mbr + " from connection table");
            }
        }
        this.connections.remove(mbr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void removeAllConnections() {
        Hashtable hashtable = this.connections;
        synchronized (hashtable) {
            Enumeration e = this.connections.elements();
            while (true) {
                if (!e.hasMoreElements()) {
                    this.connections.clear();
                    return;
                }
                Entry entry = (Entry)e.nextElement();
                entry.reset();
            }
        }
    }

    long getInitialSeqno() {
        long ret = (long)(Math.random() * 100.0 % 100.0);
        return ret;
    }

    public void retransmit(long seqno, Message msg) {
        Address dst = msg.getDest();
        this.passDown(new Event(1, msg));
    }

    void handleDataReceived(Object sender, long seqno, boolean first, Message msg) {
        Entry entry = (Entry)this.connections.get(sender);
        if (entry == null) {
            entry = new Entry();
            this.connections.put(sender, entry);
        }
        if (entry.received_msgs == null) {
            if (first) {
                entry.received_msgs = new AckReceiverWindow(seqno);
            } else if (this.operational) {
                if (Trace.trace) {
                    Trace.warn("UNICAST.handleDataReceived()", "[" + this.local_addr + "] seqno " + seqno + " from " + sender + " is not tagged as the first message sent by " + sender + "; however, the table for received messages from " + sender + " is still null ! We probably haven't received the first message from " + sender + " ! Discarding message (operational=" + this.operational + ')');
                }
                return;
            }
        }
        if (entry.received_msgs != null) {
            Message m;
            entry.received_msgs.add(seqno, msg);
            while ((m = entry.received_msgs.remove()) != null) {
                this.passUp(new Event(1, m));
            }
        }
    }

    void handleAckReceived(Object sender, long seqno) {
        Entry entry = (Entry)this.connections.get(sender);
        if (entry == null || entry.sent_msgs == null) {
            return;
        }
        AckSenderWindow win = entry.sent_msgs;
        win.ack(seqno);
    }

    void sendAck(Address dst, long seqno) {
        Message ack = new Message(dst, null, null);
        ack.putHeader(this.getName(), new UnicastHeader(1, seqno));
        this.passDown(new Event(1, ack));
    }

    private final /* synthetic */ void this() {
        this.operational = false;
        this.members = new Vector();
        this.connections = new Hashtable();
        this.timeout = new long[]{800L, 1600L, 3200L, 6400L};
        this.local_addr = null;
        this.timer = null;
        this.use_gms = true;
        this.window_size = -1;
        this.min_threshold = -1;
    }

    public UNICAST() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Entry {
        AckReceiverWindow received_msgs;
        AckSenderWindow sent_msgs;
        long sent_msgs_seqno;

        void reset() {
            if (this.sent_msgs != null) {
                this.sent_msgs.reset();
            }
            if (this.received_msgs != null) {
                this.received_msgs.reset();
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (this.sent_msgs != null) {
                sb.append("sent_msgs=" + this.sent_msgs + '\n');
            }
            if (this.received_msgs != null) {
                sb.append("received_msgs=" + this.received_msgs + '\n');
            }
            return sb.toString();
        }

        private final /* synthetic */ void this() {
            this.received_msgs = null;
            this.sent_msgs = null;
            this.sent_msgs_seqno = UNICAST.this.getInitialSeqno();
        }

        Entry() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class UnicastHeader
    extends Header {
        static final int DATA = 0;
        static final int DATA_ACK = 1;
        int type;
        long seqno;
        boolean first;

        public String toString() {
            return "[UNICAST: " + this.type2Str(this.type) + ", seqno=" + this.seqno + ']';
        }

        public String type2Str(int t) {
            switch (t) {
                case 0: {
                    return "DATA";
                }
                case 1: {
                    return "DATA_ACK";
                }
            }
            return "<unknown>";
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.type);
            out.writeLong(this.seqno);
            out.writeBoolean(this.first);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readInt();
            this.seqno = in.readLong();
            this.first = in.readBoolean();
        }

        private final /* synthetic */ void this() {
            this.type = 0;
            this.seqno = 0L;
            this.first = false;
        }

        public UnicastHeader() {
            this.this();
        }

        public UnicastHeader(int type, long seqno) {
            this.this();
            int n = 0;
            if (type == 1) {
                n = 1;
            }
            this.type = n;
            this.seqno = seqno;
        }
    }
}

