// 30 Oct 2002
// AC3D loader for models generated by the AC3D modeller (www.ac3d.org)
// part of this source code were supplied by the AC3D project (Andy Colebourne)
// eg the basic parsing of an AC3D file, values of constants in this include file..
// Conversion from AC3D scenegraph to OSG by GW Michel.
//  == Opinion: ac3d is a valuable, very easy to use 3D modeller.
//   use can be picked up in hours rather than weeks.
//  Other loaders and modellers are available for OSG.

#ifndef OSGAC3D_H
#define OSGAC3D_H

#include <osgDB/ReaderWriter>


typedef struct ACSurface_t
{
	int num_vertref;
	int flags;
	int mat;
} ACSurface;

typedef struct ACObject_t
{
	osg::Vec3 loc;
	char *name;
	char *data;
	char *url;
	int num_vert;

	int num_surf;
	float texture_repeat_x, texture_repeat_y;
	float texture_offset_x, texture_offset_y;

	int num_kids;
	struct ACObject_t **kids;
	float matrix[9];
	int type;
	osg::ref_ptr<osg::Texture2D> texture;
} ACObject;

#define OBJECT_WORLD 999
#define OBJECT_NORMAL 0
#define OBJECT_GROUP 1
#define OBJECT_LIGHT 2



#define SURFACE_SHADED (1<<4)
#define SURFACE_TWOSIDED (1<<5)

#define SURFACE_TYPE_POLYGON (0)
#define SURFACE_TYPE_CLOSEDLINE (1)
#define SURFACE_TYPE_LINE (2)



#define Prototype
#define Private static
#define Boolean int
#ifndef FALSE
#define FALSE (0)
#endif
#ifndef TRUE
#define TRUE (!FALSE)
#endif
#define STRING(s)  (char *)(strcpy((char *)myalloc(strlen(s)+1), s))
#define streq(a,b)  (!strcmp(a,b))
#define myalloc malloc
#define myfree free


Prototype osg::Group *ac_load_ac3d(const char *filename,const osgDB::ReaderWriter::Options* options);
Prototype osg::Material *ac_palette_get_material(const unsigned int index);


#endif
