# Copyright (C) 2000-2001 The OpenRPG Project
#
#    openrpg-dev@lists.sourceforge.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# --
#
# File: mapper/whiteboard_hander.py
# Author: OpenRPG Team
# Maintainer:
# Version:
#   $Id: base_handler.py,v 1.9 2003/06/05 06:48:11 snowdog_ Exp $
#
# Description: base layer handler.
#   layer handlers are responsible for the GUI elements of the layer
#
__version__ = "$Id: base_handler.py,v 1.9 2003/06/05 06:48:11 snowdog_ Exp $"


from orpg.orpg_windows import *

MOPEN_TOOL = wxNewId()
MSAVE_TOOL = wxNewId()
ZOOM_IN = wxNewId()
ZOOM_OUT = wxNewId()
PROP_TOOL = wxNewId()

TITLE_HACK = wxNewId()


class base_layer_handler(wxPanel):

    def __init__(self, parent, id, canvas):
        wxPanel.__init__(self, parent, id)
        self.canvas = canvas
        self.map_frame = self.canvas.frame
        self.top_frame = self.canvas.frame.top_frame
        self.chat = self.top_frame.myopenrpg.get_component("chat")
        self.build_ctrls()
        self.build_menu()
        EVT_SIZE(self, self.on_size)
        EVT_LEFT_DCLICK(self, self.on_left_dclick)

    def on_size(self,evt):
        s = self.GetClientSizeTuple()
        self.basesizer.SetDimension(0,0,s[0],s[1])

    def build_ctrls(self):
        self.basesizer = wxBoxSizer(wxHORIZONTAL)
        self.sizer = wxBoxSizer(wxHORIZONTAL)
        self.buttonsizer = wxBoxSizer(wxHORIZONTAL)
        
        self.zoom_in_button = createMaskedButton( self, orpg.dirpath.dir_struct["icon"]+'zoom_in.gif', "Zoom in from x1.0", ZOOM_IN )
        self.zoom_out_button = createMaskedButton( self, orpg.dirpath.dir_struct["icon"]+'zoom_out.gif', "Zoom out from x1.0", ZOOM_OUT )
        self.buttonsizer.Add( self.zoom_in_button, 0, wxEXPAND )
        self.buttonsizer.Add( self.zoom_out_button, 0, wxEXPAND )
        self.buttonsizer.Add( createMaskedButton( self, orpg.dirpath.dir_struct["icon"]+'compass.gif', 'Edit map properties', PROP_TOOL ), 0, wxEXPAND )
        self.buttonsizer.Add( createMaskedButton( self, orpg.dirpath.dir_struct["icon"]+'open.bmp', 'Load a map', MOPEN_TOOL, '#c0c0c0', wxBITMAP_TYPE_BMP ), 0, wxEXPAND )
        self.buttonsizer.Add( createMaskedButton( self, orpg.dirpath.dir_struct["icon"]+'save.bmp', 'Save the map', MSAVE_TOOL, '#c0c0c0', wxBITMAP_TYPE_BMP ), 0, wxEXPAND )
        #self.sizer.Fit(self)
        #self.SetAutoLayout(true)
        self.SetSizer(self.basesizer)
        self.basesizer.Add( self.sizer, 1, wxEXPAND)
        self.basesizer.Add( self.buttonsizer, 0, wxALIGN_RIGHT)
        EVT_BUTTON(self, ZOOM_IN, self.canvas.on_zoom_in)
        EVT_BUTTON(self, ZOOM_OUT, self.canvas.on_zoom_out)
        EVT_BUTTON(self, MOPEN_TOOL, self.map_frame.on_open)
        EVT_BUTTON(self, MSAVE_TOOL, self.map_frame.on_save)
        EVT_BUTTON(self, PROP_TOOL, self.canvas.on_prop)


    def build_menu(self,label = "Map"):
        "Menu is built based on the type of grid (rectangle or hex) we have in use."
        # do main menu
        main_menu = wxMenu()                                                       #  create a menu resource

        #  This is a hack to simulate a menu title, due to problem in Linux
        if wxPlatform == '__WXMSW__':
            main_menu.SetTitle(label)
        else:
            main_menu.Append(TITLE_HACK,label)
            main_menu.AppendSeparator()

        main_menu.Append(MOPEN_TOOL,"&Load Map")
        main_menu.Append(MSAVE_TOOL,"&Save Map")
        main_menu.AppendSeparator()
        main_menu.Append(PROP_TOOL,"&Properties")
        #main_menu.AppendSeparator()

        self.main_menu = main_menu

        EVT_MENU(self.canvas, PROP_TOOL, self.canvas.on_prop)
        EVT_MENU(self.canvas, MOPEN_TOOL, self.map_frame.on_open)
        EVT_MENU(self.canvas, MSAVE_TOOL, self.map_frame.on_save)

    def do_map_board_menu(self,pos):
        self.canvas.PopupMenu(self.main_menu,pos)

    def on_right_down(self,evt):
        self.do_map_board_menu(evt.GetPosition())

    def on_left_down(self,evt):
        pass

    def on_left_up(self,evt):
        pass

    #added to base layer by Snowdog 5/03
    def on_left_dclick(self,evt):
        pass
    
    def on_motion(self,evt):
        pass
        
    def update_info(self):
        pass
