# Copyright (C) 2000-2001 The OpenRPG Project
#
#	openrpg-dev@lists.sourceforge.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# --
#
# File: core.py
# Author: Chris Davis
# Maintainer:
# Version:
#   $Id: core.py,v 1.24 2002/10/31 20:08:55 posterboy Exp $
#
# Description: The file contains code for the core nodehanlers
#

__version__ = "$Id: core.py,v 1.24 2002/10/31 20:08:55 posterboy Exp $"

from nodehandler_version import NODEHANDLER_VERSION
from orpg.orpg_windows import *
import orpg.dirpath
from orpg.orpg_xml import *
import webbrowser
from orpg.mapper import map
import os





#html defaults
TH_BG = "#E9E9E9"
##########################
## base node handler
##########################
class node_handler:
    """ Base nodehandler with virtual functions and standard implmentations """
    def __init__(self,xml_dom,tree_node,openrpg):
        self.master_dom = xml_dom
        self.mytree_node = tree_node
        self.myopenrpg = openrpg
        self.tree = openrpg.get_component('tree')
        self.frame = openrpg.get_component('frame')
        self.chat = openrpg.get_component('chat')
        self.drag = true
        self.myeditor = None # designing
        self.myviewer = None # prett print
        self.mywindow = None # using
        # call version hook
        self.on_version(self.master_dom.getAttribute("version"))
        # set to current version
        self.master_dom.setAttribute("version",NODEHANDLER_VERSION)
        # null events

    def on_version(self,old_version):
        ## added version control code here or implement a new on_version in your derived class.
        ## always call the base class on_version !
        pass

    def on_rclick(self,evt):
        self.tree.do_std_menu(evt,self)

    def on_ldclick(self,evt):
        return 0

    def usefulness(self,text):
        if text=="useful":
            self.master_dom.setAttribute('status',"useful")
        elif text=="useless":
            self.master_dom.setAttribute('status',"useless")
        elif text=="indifferent":
            self.master_dom.setAttribute('status',"indifferent")

    def on_design(self,evt):
        if self.myeditor == None:
            del self.myeditor
            self.create_designframe()
        try:
            if self.myeditor.destroyed:
               del self.myeditor
               self.create_designframe()
        except:
            self.create_designframe()
        self.myeditor.Show(1)
        self.myeditor.Raise()

    def create_designframe(self):
        title = self.master_dom.getAttribute('name') + " Editor"
        self.myeditor = wxPFrame(self.frame,title,orpg.dirpath.dir_struct["icon"]+'grid.ico')
        self.myeditor.panel = self.get_design_panel(self.myeditor)
        self.myeditor.Show(1)
        self.myeditor.Raise()

    def on_use(self,evt):
        if self.mywindow == None:
            del self.mywindow
            self.create_useframe()
        try:
            if self.mywindow.destroyed:
                del self.mywindow
                self.create_useframe()
        except:
            self.create_useframe()
        self.mywindow.Show(1)
        self.mywindow.Raise()

    def create_useframe(self):
        caption = self.master_dom.getAttribute('name')
        self.mywindow = wxPFrame(self.frame,caption,orpg.dirpath.dir_struct["icon"]+'note.ico')
        self.mywindow.panel = self.get_use_panel(self.mywindow)
        self.mywindow.Show(1)
        self.mywindow.Raise()

    def on_html_view(self,evt):
        try:
            self.myviewer.Raise()
        except:
            caption = self.master_dom.getAttribute('name')
            self.myviewer = wxPFrame(self.frame,caption,orpg.dirpath.dir_struct["icon"]+'note.ico')
            self.myviewer.panel = self.get_html_panel(self.myviewer)
            self.myviewer.Show(1)
            
    def map_aware(self):
        return 0

    def can_clone(self):
        return 1;

    def on_del(self,evt):
        print "on del"

    def on_new_data(self,xml_dom):
        pass

    def get_scaled_bitmap(self,x,y):
        return None

 #   def is_my_parent(self,parent_node,compare_node):
 #       parent_node = self.tree.GetItemParent(parent_node)
 #       if compare_node == parent_node:
 #           return 1
 #       elif parent_node == self.tree.root:
 #           return 0
 #       else:
 #           return self.is_my_parent(compare_node,parent_node)

 #   def is_my_child(self,compare_node,parent_node):
 #       x = self.tree.GetItemParent(compare_node)
 #       while true:
 #           if self.tree.GetItemText(x) == self.tree.GetItemText(parent_node):
 #               return 1
 #           x = self.tree.GetItemParent(x)
 #           if len(self.tree.GetItemText(x)) < 1:
 #               break
 #       return 0

    def on_send_to_map(self,evt):
        pass        

    def on_send_to_chat(self,evt):
        self.chat.ParsePost(self.tohtml(),true,true)
        
    def on_drop(self,evt):
        drag_obj = self.tree.drag_obj
        if drag_obj == self or self.tree.is_parent_node(self.mytree_node,drag_obj.mytree_node):
            return
        #if self.is_my_child(self.mytree_node,drag_obj.mytree_node):
        #    return
        xml_dom = self.tree.drag_obj.delete()
        parent = self.master_dom._get_parentNode()
        xml_dom = parent.insertBefore(xml_dom,self.master_dom)
        parent_node = self.tree.GetItemParent(self.mytree_node)
        prev_sib = self.tree.GetPrevSibling(self.mytree_node)
        self.tree.load_xml(xml_dom, parent_node, prev_sib)

    def toxml(self,pretty=0):
        return toxml(self.master_dom,pretty)

    def tohtml(self):
        return self.master_dom.getAttribute("name")

    def delete(self):
        """ removes the tree_node and xml_node, and returns the removed xml_node """

        self.tree.Delete(self.mytree_node)
        parent = self.master_dom._get_parentNode()
        return parent.removeChild(self.master_dom)

    def rename(self,name):
        if len(name):
            self.tree.SetItemText(self.mytree_node,name)

    def change_icon(self,icon):
        self.master_dom.setAttribute("icon",icon)
        self.tree.SetItemImage(self.mytree_node,self.tree.icons[icon])
        self.tree.SetItemSelectedImage(self.mytree_node,self.tree.icons[icon])

    def on_save(self,evt):
        f =wxFileDialog(self.tree,"Select a file", orpg.dirpath.dir_struct["user"],"","XML files (*.xml)|*.xml",wxSAVE)
        if f.ShowModal() == wxID_OK:
            type = f.GetFilterIndex()
            file = open(f.GetPath(),"w")
            file.write(self.toxml(1))
            file.close()
        f.Destroy()   

    def get_design_panel(self,parent):
        return None            
        
    def get_use_panel(self,parent):
        return None
   
    def get_html_panel(self,parent):
        html_str = "<html><body bgcolor=\"#FFFFFF\" >"+self.tohtml()+"</body></html>"
        wnd = wxHTMLpanel(parent,-1)
        html_str = self.chat.ParseDice(html_str)
        wnd.load_text(html_str)
        return wnd        
    
    def get_size_constraint(self):
        return 0
        
    def about(self):
        html_str = "<b>"+ self.master_dom.getAttribute('class')
        html_str += " Applet</b><br>by Chris Davis<br>chris@rpgarchive.com"
        return html_str




# All the functions below are foe backward compatiablity !

def old_group_xml(xml_dom,tree_node,openrpg):
    import containers
    xml_dom.setAttribute("class","group_handler")
    xml_dom.setAttribute("module","containers")    
    return containers.group_handler(xml_dom,tree_node,openrpg)

static_handler = old_group_xml


def old_text_xml(xml_dom,tree_node,openrpg):
    old_text = safe_get_text_node(xml_dom)    
    elem = minidom.Element('text')
    elem.setAttribute("multiline","1")
    t_node = minidom.Text(old_text._get_nodeValue())
    t_node = elem.appendChild(t_node)
    text = safe_get_text_node(elem)
    xml_dom.appendChild(elem)  
    old_text._set_nodeValue("")
    xml_dom.setAttribute("class","textctrl_handler")
    xml_dom.setAttribute("module","forms")    
    import forms
    return forms.textctrl_handler(xml_dom,tree_node,openrpg)

text_handler = old_text_xml
dieroll_handler = old_text_xml

def old_macro_xml(xml_dom,tree_node,openrpg):
    old_text = safe_get_text_node(xml_dom)    
    elem = minidom.Element('text')    
    t_node = minidom.Text(old_text._get_nodeValue())
    t_node = elem.appendChild(t_node)
    text = safe_get_text_node(elem)    
    xml_dom.appendChild(elem)  
    old_text._set_nodeValue("")
    xml_dom.setAttribute("class","macro_handler")
    xml_dom.setAttribute("module","chatmacro")    
    import chatmacro
    return chatmacro.macro_handler(xml_dom,tree_node,openrpg)
    
macro_handler = old_macro_xml    

def old_link_xml(xml_dom,tree_node,openrpg):
    xml_dom.setAttribute("class","link_handler")
    xml_dom.setAttribute("module","forms")    
    import forms
    return forms.link_handler(xml_dom,tree_node,openrpg)

link_handler = old_link_xml
webbrowser_handler = old_link_xml

def old_webimg_xml(xml_dom,tree_node,openrpg):
    xml_dom.setAttribute("class","webimg_handler")
    xml_dom.setAttribute("module","forms")    
    import forms
    return forms.webimg_handler(xml_dom,tree_node,openrpg)

webimg_handler = old_webimg_xml





# ##########################
# ## link node handler
# ##########################
# class link_handler(node_handler):
#     """ A nodehandler for URLs. Will open URL in a wxHTMLFrame
#         <nodehandler name='?' module='core' class='link_handler' >
#                 <link  href='http//??.??'  />
#         </nodehandler >
#     """
#     def __init__(self,xml_dom,tree_node,openrpg):
#         node_handler.__init__(self,xml_dom,tree_node,openrpg)
#         self.link = self.master_dom._get_firstChild()
#         self.wnd = None
#         self.frame = openrpg.get_component('frame')

#     def on_use(self,evt):
#         href = self.link.getAttribute("href")
#         title = self.master_dom.getAttribute("name")
#         self.myframe = wxPFrame(self.frame,title,orpg.dirpath.dir_struct["icon"] + 'note.ico')
#         wnd = wxHTMLpanel(self.myframe,-1)
#         self.myframe.panel = wnd
#         wnd.load_url(href)
#         self.myframe.Show(1)

#     def on_design(self,evt):
#         tlist = ['Title','href']
#         vlist = [self.master_dom.getAttribute("name"),
#                   self.link.getAttribute("href")]
#         dlg = wxMultiTextEntry(self.tree.GetParent(),tlist,vlist,"Link Edit")
#         if dlg.ShowModal() == wxID_OK:
#             vlist = dlg.get_values()
#             self.link.setAttribute('href', vlist[1])
#             self.master_dom.setAttribute('name', vlist[0])
#             self.tree.SetItemText(self.mytree_node,vlist[0])
#         dlg.Destroy()

#     def get_design_panel(self,parent): 
#         return None

#     def tohtml(self):
#         href = self.link.getAttribute("href")
#         title = self.master_dom.getAttribute("name")
#         return "<a href=\""+href+"\" >"+title+"</a>"
    
        

# ##########################
# ## webimg node handler
# ##########################        
# class webimg_handler(link_handler):
#     """ A nodehandler for URLs. Will open URL in a wxHTMLFrame
#         <nodehandler name='?' module='core' class='webimg_handler' >
#                 <link  href='http//??.??'  />
#         </nodehandler >
#     """
#     def __init__(self,xml_dom,tree_node,openrpg):
#         link_handler.__init__(self,xml_dom,tree_node,openrpg)

#     def on_use(self,evt):        
#         href = self.link.getAttribute("href")
#         title = self.master_dom.getAttribute("name")
#         self.myframe = wxPFrame(self.frame,title,orpg.dirpath.dir_struct["icon"] + 'note.ico')
#         wnd = scrolled_img_panel(self.myframe,-1)
#         self.myframe.panel = wnd       
#         wnd.load_url(href)
#         self.wnd = wnd
#         self.myframe.Show(1)       

#     def tohtml(self):
#         href = self.link.getAttribute("href")
#         title = self.master_dom.getAttribute("name")
#         return "<img src=\""+href+"\" alt="+title+" >" 
 
# ##########################
# ## webbrowser node handler
# ##########################        
# class webbrowser_handler(link_handler):
#     """ A nodehandler for webbroser URLs. Will open URL in the
#         default webbrowser
#         <nodehandler name='?' module='core' class='webbrowser_handler' >
#                 <link  href='http//??.??'  />
#         </nodehandler >
#     """
#     def __init__(self,xml_dom,tree_node,openrpg):
#         link_handler.__init__(self,xml_dom,tree_node,openrpg)

#     def on_use(self,evt):                
#         href = self.link.getAttribute("href")
#         wb = webbrowser.get() 
#         wb.open(href) 
#         

#     def tohtml(self):
#         href = self.link.getAttribute("href")
#         title = self.master_dom.getAttribute("name")
#         return "<a href=\""+href+"\" >"+title+"</a>"
#        
            
# ##########################
# ## text node handler
# ##########################   
# class text_handler2(node_handler):
#     """ A nodehandler for text blocks. Will open text in a text frame
#         <nodehandler name='?' module='core' class='text_handler'>
#             some text here
#         </nodehandler >
#     """
#     def __init__(self,xml_dom,tree_node,openrpg):
#         node_handler.__init__(self,xml_dom,tree_node,openrpg)
#         self.text = safe_get_text_node(self.master_dom)
#         self.wnd = None
#         self.frame = openrpg.get_component('frame')
#         self.myeditor = None

#     def on_change(self,txt):
#         self.text._set_nodeValue(txt)
#         
#     def on_design(self,evt):
#         if self.myeditor == None or self.myeditor.destroyed:
#             title = self.master_dom.getAttribute('name') + " Editor"
#             self.myeditor = wxPFrame(self.frame,title,orpg.dirpath.dir_struct["icon"]+ 'note.ico')
#             wnd = text_edit_panel(self.myeditor,self)
#             self.myeditor.panel = wnd               
#             self.wnd = wnd
#             self.myeditor.Show(1)
#         else:
#             self.myeditor.Raise()

#     def get_design_panel(self,parent): 
#         return text_edit_panel(parent,self)
#         
#     def tohtml(self):
#         title = self.master_dom.getAttribute("name")
#         txt = self.text._get_nodeValue()
#         txt = string.replace(txt,'\n',"<br>")
#         return "<P><b>"+title+":</b><br>"+txt

P_TITLE = 10
P_BODY = 20
class text_edit_panel(wxPanel):
    def __init__(self, parent, handler):
        wxPanel.__init__(self, parent, -1)
        self.handler = handler        
        sizer = wxBoxSizer(wxVERTICAL)
        self.text = {   P_TITLE : orpgTextCtrl(self, P_TITLE, handler.master_dom.getAttribute('name')),
                        P_BODY : html_text_edit(self,P_BODY,handler.text._get_nodeValue(),self.on_text)
                      }  
        #P_BODY : wxTextCtrl(self, P_BODY,handler.text._get_nodeValue(), style=wxTE_MULTILINE)

        sizer.Add(wxStaticText(self, -1, "Title:"), 0, wxEXPAND)
        sizer.Add(self.text[P_TITLE], 0, wxEXPAND)
        sizer.Add(wxStaticText(self, -1, "Text Body:"), 0, wxEXPAND)
        sizer.Add(self.text[P_BODY], 1, wxEXPAND)
        self.sizer = sizer
        self.outline = wxStaticBox(self,-1,"Text Block")
        EVT_SIZE(self, self.on_size)
        EVT_TEXT(self, P_TITLE, self.on_text)
        #EVT_TEXT(self, P_BODY, self.on_text)

    def on_text(self,evt):
        id = evt.GetId()
        if id == P_TITLE:
            txt = self.text[id].GetValue()
            #  The following block strips out 8-bit characters
            u_txt = ""
            bad_txt_found = 0
            for c in txt:
                if ord(c) < 128:
                    u_txt += c
                else:
                    bad_txt_found = 1
            if bad_txt_found:
                wxMessageBox("Some non 7-bit ASCII characters found and stripped","Warning!")
            txt = u_txt
            if txt != "":
                self.handler.master_dom.setAttribute('name',txt)
                self.handler.rename(txt)
        elif id == P_BODY:
            txt = self.text[id].get_text()
            u_txt = ""
            bad_txt_found = 0
            for c in txt:
                if ord(c) < 128:
                    u_txt += c
                else:
                    bad_txt_found = 1

            if bad_txt_found:
                wxMessageBox("Some non 7-bit ASCII characters found and stripped","Warning!")
            txt = u_txt
            self.handler.text._set_nodeValue(txt)

    def on_size(self,evt):
        s = self.GetClientSizeTuple()
        self.sizer.SetDimension(20,20,s[0]-40,s[1]-40)
        self.outline.SetDimensions(5,5,s[0]-10,s[1]-10)

# ##########################
# ## macro node handler
# ##########################
# class macro_handler(text_handler2):
#     """ A nodehandler for text blocks. Will open text in a text frame
#         <nodehandler name='?' module='core' class='macro_handler'>
#             a line of text to be macro'ed here
#             another line of text to be macro'ed
#         </nodehandler >
#     """
#         
#     def on_ldclick(self,evt):   
#         txt = self.text._get_nodeValue()
#         actionlist = txt.split("\n")
#         for line in actionlist:
#             if(line != ""):
#                 if line[0] != "/": ## it's not a slash command
#                     action = self.chat.ParsePost(self.chat.colorize(self.chat.mytextcolor, line),true,true)
#                 else:
#                     action = self.chat.ParseDice(line)
#                     self.chat.emote.docmd(line) 
#         return 1

# ##########################
# ## dice macro node handler
# ##########################   
# class dieroll_handler(text_handler2):
#     """ A nodehandler for text blocks. Will open text in a text frame
#         <nodehandler name='?' module='core' class='dieroll_handler'>
#             attack roll [1d20+4]
#         </nodehandler >
#     """
#     def __init__(self,xml_dom,tree_node,openrpg):
#         text_handler2.__init__(self,xml_dom,tree_node,openrpg)
#         self.text = safe_get_text_node(self.master_dom)

#     def tohtml(self):
#         title = self.master_dom.getAttribute("name")
#         txt = self.text._get_nodeValue()
#         txt = string.replace(txt,'\n',"<br>")
#         return txt

##########################
## node loader
##########################
class node_loader(node_handler):
    """ clones childe node and insert it at top of tree
        <nodehandler name='?'  module='core' class='node_loader'  />
    """
    def __init__(self,xml_dom,tree_node,openrpg):
        node_handler.__init__(self,xml_dom,tree_node,openrpg)

    def on_rclick(self,evt):
        pass

    def on_ldclick(self,evt):
        title = self.master_dom.getAttribute('name')
        new_node = self.master_dom._get_firstChild()
        new_node = new_node.cloneNode(true)
        child = self.tree.master_dom._get_firstChild()
        new_node = self.tree.master_dom.insertBefore(new_node,child)
        tree_node = self.tree.load_xml(new_node,self.tree.root,self.tree.root)
        obj = self.tree.GetPyData(tree_node)
        return 1
        #obj.on_design(None)

##########################
## file loader
##########################

class file_loader(node_handler):
    """ loads file and insert into game tree
        <nodehandler name='?'  module='core' class='file_loader'  >
        <file name="file_name.xml" />
        </nodehandler>
    """
    def __init__(self,xml_dom,tree_node,openrpg):
        node_handler.__init__(self,xml_dom,tree_node,openrpg)
        self.file_node = self.master_dom._get_firstChild()
        self.frame = openrpg.get_component('frame')

    def on_ldclick(self,evt):
        file_name = self.file_node.getAttribute("name")
        self.tree.insert_xml(open(orpg.dirpath.dir_struct["addon"] + file_name,"r").read())
        return 1

    def on_design(self,evt):
        tlist = ['Title','File Name']
        vlist = [self.master_dom.getAttribute("name"),
                  self.file_node.getAttribute("name")]
        dlg = wxMultiTextEntry(self.tree.GetParent(),tlist,vlist,"File Loader Edit")
        if dlg.ShowModal() == wxID_OK:
            vlist = dlg.get_values()
            self.file_node.setAttribute('name', vlist[1])
            self.master_dom.setAttribute('name', vlist[0])
            self.tree.SetItemText(self.mytree_node,vlist[0])
        dlg.Destroy()

##########################
## URL loader
##########################

class url_loader(node_handler):
    """ loads file from url and insert into game tree
        <nodehandler name='?'  module='core' class='url_loader'  >
	<file name="http://file_name.xml" />
        </nodehandler>
    """
    def __init__(self,xml_dom,tree_node,openrpg):
        node_handler.__init__(self,xml_dom,tree_node,openrpg)
        self.file_node = self.master_dom._get_firstChild()
        self.frame = openrpg.get_component('frame')

    def on_ldclick(self,evt):
        file_name = self.file_node.getAttribute("url")
        file = urllib.urlopen(file_name)
        self.tree.insert_xml(file.read())
        return 1

    def on_design(self,evt):
        tlist = ['Title','URL']
        print "design filename",self.master_dom.getAttribute('name')
        vlist = [self.master_dom.getAttribute("name"),
                 self.file_node.getAttribute("url")]
        dlg = wxMultiTextEntry(self.tree.GetParent(),tlist,vlist,"File Loader Edit")
        if dlg.ShowModal() == wxID_OK:
            vlist = dlg.get_values()
            self.file_node.setAttribute('url', vlist[1])
            self.master_dom.setAttribute('name', vlist[0])
            self.tree.SetItemText(self.mytree_node,vlist[0])
        dlg.Destroy()


##########################
## minature map loader
##########################
class min_map(node_handler):
    """ clones childe node and insert it at top of tree
        <nodehandler name='?'  module='core' class='min_map'  />
    """
    def __init__(self,xml_dom,tree_node,openrpg):
        node_handler.__init__(self,xml_dom,tree_node,openrpg)
        self.map = openrpg.get_component('map')
        self.mapdata = self.master_dom._get_firstChild() 

    def on_ldclick(self,evt):
        self.map.new_data(toxml(self.mapdata))
        return 1
    	
