/*
 * tcpchan.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef lint
static char rcsid[] = "$Header: /usr/mash/src/repository/srmv2/net/tcpchan.cc,v 1.5 2002/02/03 03:03:19 lim Exp $ (UCB)";
#endif 

#include "config.h"
#include "tcpchan.h"

#ifndef WIN32
#   include <osfcn.h>
#   include <sys/ioctl.h>
#   include <sys/socket.h>
#else
#   include <io.h>
#endif
#include <errno.h>
#include <string.h>

#include "inet.h"

#ifdef sgi
#include <stdio.h>
#endif


SRMv2_TCPServerChannel::SRMv2_TCPServerChannel()
	   :connsock_(-1), sock_(-1), concurrent_(0)
{}


SRMv2_TCPServerChannel::~SRMv2_TCPServerChannel()
{
	handler_->unlink();
	if (sock_ > 0)
		close(sock_);
	if (connsock_ > 0)
		close(connsock_);
}


void SRMv2_TCPServerChannel::reset(void)
{
	if (concurrent_ && !parent_) 
		exit(0);
	close(connsock_);
	connsock_ = -1;
}

int SRMv2_TCPServerChannel::opensock(u_int16_t port) const
{
	int fd;
	struct sockaddr_in sin;

	fd = socket(AF_INET, SOCK_STREAM, 0);
	if (fd < 0) {
		perror("socket");
		exit(1);
	}

	memset((char *)&sin, 0, sizeof(sin));
	sin.sin_family = AF_INET;
	sin.sin_port = port;
	sin.sin_addr.s_addr = INADDR_ANY;
	if (::bind(fd, (struct sockaddr *)&sin, sizeof(sin)) < 0) {
		perror("bind");
		exit(1);
	}
	
	if (listen(fd, 5) < 0) {
		perror("listen");
		exit(1);
	}

	return (fd);
}

int SRMv2_TCPServerChannel::recv(u_char* buf, int len, u_int32_t& from, u_int16_t& port)
{
	sockaddr_in sfrom;
	int fromlen = sizeof(sfrom);
	if (connsock_ < 0) {
#if defined(_AIX)
		connsock_ = accept(sock_, (sockaddr*)&sfrom, 
				   (long unsigned int *)&fromlen);
#else
		connsock_ = accept(sock_, (sockaddr*)&sfrom, &fromlen);
#endif
		if (connsock_ < 0) {
			perror("accept");
			return (-1);
		}
		handler_->unlink();
		handler_->link(connsock_, TCL_READABLE);
		fromaddr_ = sfrom.sin_addr.s_addr;
		fromport_ = sfrom.sin_port;
		
		/* FIXME this is close but not quite work yet... */
		if (concurrent_) {
#ifndef WIN32 /* the mechanisms are quite diff. */
			if ((parent_ = fork()) < 0) {
				perror("fork");
				exit(1);
			} else if (parent_ != 0) {
				/* parent */
				reset();
				return (0);
			} else {
				/* child */
				close(sock_);
				sock_ = -1;
			}
#endif                        
		}
	}
	int cc = ::recv(connsock_, (char*)buf, len, 0);
	if (cc < 0) {
		if (errno != EWOULDBLOCK)
			perror("recv");
		return (-1);
	}
	from = fromaddr_;
	port = fromport_;
	return (cc);
}

void SRMv2_TCPServerChannel::send(const u_char* buf, int len) 
{
	if (connsock_ < 0)
		return;
	if (::send(connsock_, (const char*)buf, len, 0) < 0) {
		perror("send");
	}
}

SRMv2_TCPClientChannel::SRMv2_TCPClientChannel()
	 :sock_(-1)
{
}

void
SRMv2_TCPClientChannel::closesock() 
{
	handler_->unlink();
	if (sock_ > 0)
		close(sock_);
	sock_ = -1;
	return;
}

SRMv2_TCPClientChannel::~SRMv2_TCPClientChannel()
{
	handler_->unlink();
	if (sock_ > 0)
		close(sock_);
	sock_ = -1;
}


int SRMv2_TCPClientChannel::opensock(u_int32_t addr, u_int16_t port) const
{
	int fd = socket(AF_INET, SOCK_STREAM, 0);
	if (fd < 0) {
		perror("socket");
		exit(1);
	}

	struct sockaddr_in sin;
	memset((char *)&sin, 0, sizeof(sin));
	sin.sin_family = AF_INET;
	sin.sin_port = port;
	sin.sin_addr.s_addr = addr;
	if (connect(fd, (struct sockaddr *)&sin, sizeof(sin)) < 0) {
		perror("connect");
		exit(1);
	}
	
	return (fd);
}

int SRMv2_TCPClientChannel::recv(u_char* buf, int len)
{
	int cc = ::recv(sock_, (char*)buf, len, 0);
	if (cc < 0) {
		if (errno != EWOULDBLOCK)
			perror("recv");
		return (-1);
	}
	return (cc);
}

void SRMv2_TCPClientChannel::send(const u_char* buf, int len) 
{
	if (::send(sock_, (const char*)buf, len, 0) < 0)
		perror("send");
}

