# recorder.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1993-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#
# A simple recording facility to dump function calls to a class
#       note that this class traps all function calls to an object
#       so, it will affect performance...
#
Class Tcl_Recorder

# Review: should have caller specify log file
Tcl_Recorder instproc init {classname args} {
        $self instvar theobj_ classname_ logf_ clock_ st_
        $self next

        set st_ [gettimeofday]
        set hn [info hostname]
        set hn [lindex [split $hn .] 0]
        set logf_ [open $hn.rlog "w+"]
        set classname_ $classname
        set theobj_ [eval new $classname_ $args]        
}

Tcl_Recorder instproc unknown {m args} {
        $self instvar theobj_ classname_ clock_ st_ logf_
        puts $logf_ "[expr [gettimeofday] - $st_] $classname_ $m $args"
        set ret [eval $theobj_ $m $args]
        #    puts stderr "rec returns: ($ret)"
        return $ret
}

# Allows playback of commands send to an object that had been recorded
#       using Tcl_Recorder, from a log file
Class Tcl_Player

Tcl_Player instproc init {logfn target isRealTime} {
        $self instvar logf_ tgt_ isRealTime_
        set logf_ [open $logfn "r+"]
        set tgt_ $target
        set isRealTime_ $isRealTime
}

Tcl_Player instproc start {} {        
        $self instvar st_ now_ nextCmd_
        set now_ 0
        set next_ 0
        set nextCmd_ ""
        $self run_next
}

Tcl_Player instproc run_next {} {
        set nextCmd [$self set nextCmd_]
        if {$nextCmd!=""} {
                eval [$self set tgt_] $nextCmd
        }
        set c [gets [$self set logf_] line]
        if {$c == -1} {
                close [$self set logf_]
                delete $self
                return 
        }
        $self instvar nextCmd_ isRealTime_ now_ 
        set nextCmd_ [lrange $line 2 end]
        if $isRealTime_ {
                set currTime $now_
                set nexttime [expr int ([lindex $line 0] * 1000)]
                set now_ $nexttime
                after [expr $nexttime - $currTime] "$self run_next"
        } else {
                after idle "$self run_next"
        }
}
