/*
 * yuv_convert.h --
 *
 *      Defines generic yuv_conversion routines
 *      
 *		destWidth and destHeight specify image dimensions for dest buffer
 *		srcWidth and srcHeight specify image dimensions for src buffer
 *		dimensions are specified in terms of size of video image
 *
 * Copyright (c) 2001 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef YUV_CONVERT_H
#define YUV_CONVERT_H
bool planarYUYV422_to_planarYUYV422(char* dest, int destWidth, int destHeight,
				  char* src, int srcWidth, int srcHeight);
	// dest  width: multiple of 2  (no MMX version)
	// dest height: multiple of 1  (no MMX version)
	// src   width: multiple of 2  (no MMX version)
	// src  height: multiple of 1  (no MMX version)

bool planarYUYV422_to_planarYUYV411(char* dest, int destWidth, int destHeight,
				  char* src, int srcWidth, int srcHeight);
	// dest  width: multiple of 4  (no MMX version)
	// dest height: multiple of 1  (no MMX version)
	// src   width: multiple of 2  (no MMX version)
	// src  height: multiple of 1  (no MMX version)
	// horz padding must be multiple of 4

bool planarYUYV422_to_planarYUYV420(char* dest, int destWidth, int destHeight,
				  char* src, int srcWidth, int srcHeight);
	// dest  width: multiple of 2  (no MMX version)
	// dest height: multiple of 2  (no MMX version)
	// src   width: multiple of 2  (no MMX version)
	// src  height: multiple of 2  (no MMX version)

bool planarYUYV420_to_planarYUYV422(char* dest, int destWidth, int destHeight,
				  char* src, int srcWidth, int srcHeight);
	// dest  width: multiple of 2  (no MMX version)
	// dest height: multiple of 2  (no MMX version)
	// src   width: multiple of 2  (no MMX version)
	// src  height: multiple of 2  (no MMX version)

bool planarYUYV420_to_planarYUYV411(char* dest, int destWidth, int destHeight,
				  char* src, int srcWidth, int srcHeight);
	// dest  width: multiple of 4  (no MMX version)
	// dest height: multiple of 2  (no MMX version)
	// src   width: multiple of 2  (no MMX version)
	// src  height: multiple of 2  (no MMX version)
	// horz padding must be multiple of 4

bool planarYUYV420_to_planarYUYV420(char* dest, int destWidth, int destHeight,
				  char* src, int srcWidth, int srcHeight);
	// dest  width: multiple of 2  (no MMX version)
	// dest height: multiple of 2  (no MMX version)
	// src   width: multiple of 2  (no MMX version)
	// src  height: multiple of 2  (no MMX version)

bool packedYUYV422_to_planarYUYV422(char* dest, int destWidth, int destHeight,
				  char* src, int srcWidth, int srcHeight);
	// dest  width: multiple of 2  (16 for MMX [lower multiples okay if height*width is a multiple of 16])
	// dest height: multiple of 1  ( 1 for MMX)
	// src   width: multiple of 2  ( 2 for MMX, but must equal dest width)
	// src  height: multiple of 1  ( 1 for MMX)

bool packedYUYV422_to_planarYUYV411(char* dest, int destWidth, int destHeight,
				  char* src, int srcWidth, int srcHeight);
	// dest  width: multiple of  4 ( 16 for MMX [lower multiples okay if height*width is a multiple of 16])
	// dest height: multiple of  1 (  1 for MMX)
	// src   width: multiple of  2 (  2 for MMX, but must equal dest width)
	// src  height: multiple of  1 (  1 for MMX)
	// horz padding must be multiple of 4

bool packedYUYV422_to_planarYUYV420(char* dest, int destWidth, int destHeight,
				  char* src, int srcWidth, int srcHeight);
	// dest  width: multiple of  2 ( 16 for MMX)
	// dest height: multiple of  2 (  2 for MMX)
	// src   width: multiple of  2 ( 16 for MMX)
	// src  height: multiple of  2 (  2 for MMX)	

bool packedUYVY422_to_planarYUYV422(char* dest, int destWidth, int destHeight,
				  char* src, int srcWidth, int srcHeight);
	// dest  width: multiple of 2  (16 for MMX [lower multiples okay if height*width is a multiple of 16])
	// dest height: multiple of 1  ( 1 for MMX)
	// src   width: multiple of 2  ( 2 for MMX, but must equal dest width)
	// src  height: multiple of 1  ( 1 for MMX)

bool packedUYVY422_to_planarYUYV411(char* dest, int destWidth, int destHeight,
				  char* src, int srcWidth, int srcHeight);
	// dest  width: multiple of  4 ( 16 for MMX [lower multiples okay if height*width is a multiple of 16])
	// dest height: multiple of  1 (  1 for MMX)
	// src   width: multiple of  2 (  2 for MMX, but must equal dest width)
	// src  height: multiple of  1 (  1 for MMX)
	// horz padding must be multiple of 4

bool packedUYVY422_to_planarYUYV420(char* dest, int destWidth, int destHeight,
				  char* src, int srcWidth, int srcHeight);
	// dest  width: multiple of  2 ( 16 for MMX)
	// dest height: multiple of  2 (  2 for MMX)
	// src   width: multiple of  2 ( 16 for MMX)
	// src  height: multiple of  2 (  2 for MMX)
#endif
