/*
 * tgmb-session.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 *  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tgmb/client/tgmb-session.h,v 1.6 2002/02/03 04:17:39 lim Exp $
 */

#ifndef MASH_TGMB_SESSION_H
#define MASH_TGMB_SESSION_H


#include <Pilot.h>
#include "tgmb-conn.h"


class TGMB_Page;

class TGMB_Session {
public:
	TGMB_Session();
	void Start();
	void Stop();
	void ToForm(FormPtr frm);
	void FromForm(FormPtr frm);
	Boolean ConnectToServent(const char *host, UShort port);
	Boolean HandleEvent(EventPtr evPtr);
	Boolean IsStarted() { return as1Conn_.IsConnected(); }
	Boolean IsConnected() { return serventConn_.IsConnected(); }
	Boolean Send(Chunk *chunk) {
		if (serventConn_.Send(chunk)!=0) {
			ServentConnectionLost();
			return false;
		} else return true;
	}

	void NewPage(TGMB_Page *p) { SwitchPage(p, 1, 1); }
	void SwitchPage(SWord dir);
	void SwitchPage(TGMB_Page *p, Boolean doRefresh=1, Boolean isNew=0);
	void SwitchZoom(Word zoom, Boolean doRefresh=1);
	void ResendImage(const PageId &pid, TGMB_ObjectId id);
	const SrcId &MySrcId() { return srcId_; }
private:
	void ServentConnectionLost();
	void SendClientStatus(Boolean isNewPage=0);

	void ParseMetadata(const VoidPtr metadata, DWord metadatasize,
			   Word &contentType);
	void EvRMXChunkReceived(Chunk *chunk);

	SrcId srcId_;
	AS1_Connection as1Conn_;
	TGMB_Connection serventConn_;
	char serventIP_[TGMB_MAXADDRSPEC];
	Word serventPort_;
};


#endif /* #ifdef MASH_TGMB_SESSION_H */
