/*
 * tgmb-as1.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */


#ifndef lint
static const char *rcsid = "@(#) $Header: /usr/mash/src/repository/mash/mash-1/tgmb/client/tgmb-as1.cc,v 1.5 2002/02/03 04:17:39 lim Exp $";
#endif

#include <Pilot.h>
#include <SysEvtMgr.h>
#include "tgmb-conn.h"
#include "tgmb-app.h"


void
AS1_Connection::SessionAddr(const char *sessionAddr)
{
	StrNCopy(sessionAddr_, sessionAddr, sizeof(sessionAddr_)-1);
	sessionAddr_[sizeof(sessionAddr_)-1] = '\0';
}


Boolean
AS1_Connection::Start()
{
	TGMB_Preferences *prefs = APP->Prefs();

	// open the UDP connection to the RMX "platform"
	if (TGMB_Socket::Connect(prefs->rmxSvr_, prefs->rmxPort_,
				 netSocketTypeDatagram) == false) {
		TGMB_Application::ErrorDialog("Could not connect to RMX:\n"
					      "%s:%lu", prefs->rmxSvr_,
					      (DWord)prefs->rmxPort_);
		return false;
	}

	NetIPAddr localAddr = TG_NetworkApplication::GetLocalIP();
	GetAddress(NULL, &port_, NULL, NULL);
	NetLibAddrINToA(TG_NetworkApplication::AppNetRefnum, localAddr,
			ipAddr_);
	rmxPort_ = prefs->rmxPort_;

	// start the timer
	Timeout();
	return true;
}


void
AS1_Connection::Stop()
{
	if (IsConnected()) Disconnect();
	if (timerId_ != (Word)-1) APP->UnregisterTimer(timerId_);
	timerId_ = (Word)-1;
}


static DWord Random()
{
	static DWord seed=TimGetTicks();
	seed = (1870033718 * seed + 366850414);
	return seed;
}


void
AS1_Connection::Timeout()
{
	Send();

	ULong after=3000;
	Word r = Random();
	after = after/2 + (DWord(r) * after)/0xFFFF;
	timerId_ = APP->RegisterTimer(after, this);

	// FIXME: doing this stuff here, just so we don't have to create a
	// separate timer
	if (APP->Prefs()->dontSuspend_) EvtResetAutoOffTimer();
}


void
AS1_Connection::Receive()
{
	char buffer[256], *p, *n;
	SWord bytesRead;
	bytesRead = APP->Receive(sock_, buffer, sizeof(buffer)-1);

	if (bytesRead <= 0) {
		return;
	}
	buffer[bytesRead] = '\0';

	// check if this message is an ASCP 2.0 message
#define ASCP_STR "ASCP v2.0\n"
	if (StrNCompare(buffer, ASCP_STR, StrLen(ASCP_STR))!=0) return;
	p = buffer + StrLen(ASCP_STR);

	// check if this message originated from a servent
	n = StrChr(p, '\n');
	if (!n || StrNCompare(p, "srv", 3)!=0) return;
	p = n+1;

	// skip over the agent instance, service name and service location
	n = StrChr(p, '\n');
	if (!n) return;
	p = n+1;

	n = StrChr(p, '\n');
	if (!n) return;
	p = n+1;

	n = StrChr(p, '\n');
	if (!n) return;
	p = n+1;

	// check if this message was from our service instance
	n = StrChr(p, '\n');
	if (!n || StrNCompare(p, "MediaPad:", 9)!=0 ||
	    StrNCompare(p+9, sessionAddr_, StrLen(sessionAddr_))!=0) return;
	p = n+1;

	// skip over the ssgPort
	n = StrChr(p, '\n');
	if (!n) return;
	p = n+1;

	// extract the RMX servent's location from the agent_data
	n = StrChr(p, ':');
	if (!n) return;
	*n = '\0';
	Word port = StrAToI(n+1);

	APP->Session()->ConnectToServent(p, port);
}


void
AS1_Connection::Send()
{
	char buffer[256];
	sprintf(buffer, "ASCP v2.0\nclient\n"
		"%s:%u\n"
		"MediaPad\n"
		"urn:tgmb\n"
		"MediaPad:%s\n"
		"%u\n",
		ipAddr_, port_, sessionAddr_, port_);
	APP->Send(sock_, buffer, StrLen(buffer)+1);
}
