# client-ssac.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/ssac/client-ssac.tcl,v 1.26 2002/02/03 04:30:10 lim Exp $


import mashutils SDPParser AnnounceListenManager/AS/Client/SSAC \
		SessionCatalog SDPParser Observable

# Client side SSAC parsing
# Status: pre-alpha
# Author: Angela Schuett

Class SSAC_Client -superclass Observable -configuration {
	megaforPort 60000
}


# megactrl can be an empty string; in that case, the object will try to
# read the server's location from the catalog file
# ssg_port will be used by SSAC_Client *only* if the megactrl address
# that it ends up using is unicast; otherwise this gets reset to "-"
SSAC_Client public init { megactrl ssg_port {data_multicast 0} } {
	$self instvar session_
        $self instvar broadcast_

	set session_(state) IDLE
	#set session_(uri) ""
	set session_(first) 0

	set session_(server_name) $megactrl
	set session_(ssg_port) $ssg_port
	set session_(data_multicast) $data_multicast
}


SSAC_Client public send {method args} {
	$self instvar session_ AS_ broadcast_

	if {$session_(first) == 0} {
		# this is the first time! we should create an
		# AnnounceListenManager for this guy
		set AS_ [new AnnounceListenManager/AS/Client/SSAC $self \
				$session_(server_name) $session_(ssg_port)]
		$AS_ data_multicast $session_(data_multicast)
		$AS_ set_broadcast "[array get broadcast_]"
	}
	switch -exact -- $method {
		"PLAY" {
			set seqno [$AS_ seqno]
			incr seqno 2
			#puts "client upped seqno for PLAY"
			$AS_ set_seqno $seqno
			$AS_ set_offset [lindex $args 0]
		        $AS_ set_filename $session_(session_name)

			set dont_send_now [lindex $args 1]
		}
		"PAUSE" {
			set seqno [$AS_ seqno]
			incr seqno
			#puts "client upped seqno for PAUSE"
			$AS_ set_seqno $seqno
			$AS_ set_offset "PAUSE"

			set dont_send_now [lindex $args 0]
		}

		"CLOSE" {
			# FIXME FIX THIS

			#set seqno [$AS_ seqno]
			#incr seqno
			#$AS_ set_seqno $seqno
			#$AS_ set_offset "End"

			#set dont_send_now [lindex $args 0]
		}
	}

	#send the message

	if {$session_(first) == 0} {
		$AS_ start
		set session_(first) 1
	} elseif { $dont_send_now == {} } {
		#$AS_ change_state $msg
		$AS_ send_announcement
		# Seek, pause, close are sent immediately, without waiting
		# for timer to fire.  Keep-alive msgs are sent on timer
	}

}

SSAC_Client public notify {msg} {
	#puts "Notify: $msg"
	# set timescales

	$self parse_server_msg $msg
}

SSAC_Client public open {desc offset} {
	$self instvar session_

	#set session_(uri) $url
	set media_list [$self parse_pd $desc]

	# for now, we assume that the start time is now + 15 seconds
	#set session_(startwall) [expr [clock seconds] + 15]
	#puts "OPEN $session_(startwall)"
	$self send "PLAY" $offset
	return $media_list
}

SSAC_Client public play_or_pause { {offset {}} } {
	$self instvar session_

	if {$session_(state) == "PLAY"}  {
		$self pause
	} else {
		$self play $offset
	}
}


SSAC_Client public stop { } {
	$self pause
}


SSAC_Client public duration { } {
	$self instvar session_
	return [expr $session_(endtime) - $session_(starttime)]
}


SSAC_Client public elapsed { time } {
	$self instvar session_
	return [duration_readable $time]
}


# This procedure parses the server SSAC announcement
SSAC_Client private parse_server_msg {msg} {
	$self instvar session_ sesslist_ first_
	$self instvar rtsp_  AS_ old_offset_

	set o [split $msg "\n"]


#puts "msg = $msg"

	set seqno [lindex [split [lindex $o 0]] 1]
	if {$seqno >= [$AS_ seqno]} {
		$AS_ set_seqno $seqno
		#puts "server upped seqno"

		set duration [lindex [split [lindex $o 2]] 1]

		set session_(starttime) 0
		set session_(endtime) $duration

		set systemt [lindex [split [lindex $o 3]] 1]
		set offsett [lindex [split [lindex $o 3]] 2]
		#puts "system time=$systemt  logical time=$offsett"
		set system_offset [expr [clock seconds] - $systemt]
		set new_offset [expr $offsett + $system_offset]

		set len [llength $o]
		for {set n 4} {$n < $len} {incr n 2} {
			set sess [lindex [split [lindex $o $n]] 1]
			if {![lsearch sesslist_ $sess]} {
				puts  "Error"
			}
			##
			set tmpsession($sess) [lrange [split [lindex $o \
					[expr $n + 1]]] 1 end]
		}

		if {$session_(first) == 1} {
			$self notify_observers activate \
					$session_(starttime) $session_(endtime)
			set session_(state) "PLAY"
			$self notify_observers play_update "PAUSE"

			set session_(duration) [expr $session_(endtime) - \
					$session_(starttime)]
			$self notify_observers update_title \
					$session_(session_info1) \
					$session_(session_info2) \
					$session_(duration)

#		    puts "sesslist_ - $sesslist_"
#		    puts "session_ - [array get session_]"
#		    puts "tmpsession_ - [array get tmpsession]"

			foreach sess $sesslist_ {
				set session_($sess,Address) [lindex $tmpsession($sess) 0]
			        set session_($sess,SourceId) [lrange $tmpsession($sess) 1 end]

#puts "sess - $sess"
				$self notify_observers ssac_reset \
						$session_($sess,Media) \
						$session_($sess,Address)
			}
			set session_(first) 2
		} else {
			# Fix this
			#puts "offset changed to $new_offset"
			$self notify_observers  set_offset $new_offset
			$AS_ set_offset $new_offset

			foreach sess $sesslist_ {
				if {$tmpsession($sess) != \
						$session_($sess,Address)} {
					set session_($sess,Address) \
							$tmpsession($sess)
					$self notify_observers ssac_reset \
							$session_($sess,Media)\
							$session_($sess,Address)
				}
			}
		}
		set old_offset_ $new_offset
	} else {
		#puts "OLD SEQNO $seqno $session_(seqno)"
	}
}




# This procedure parses the presentation description, which contains the
# server mcast address, catalog file location, and catalog file.  The pd is
# passed through the -server flag, and is intended to be downloaded from
# the web.  Shouldn't be in this class, move to application.

SSAC_Client private parse_pd {pd} {
	$self instvar session_ sesslist_ broadcast_

	set ctg [new SessionCatalog]
	$ctg parse $pd
	set sdp [$ctg get_sdp]
	#puts $sdp

	set p [new SDPParser]
	set message [$p parse $sdp]

	if {$message != ""} {
		if {[$message have_field s]} {
			set session_(session_info1) [$message field_value s]
		}
		if {[$message have_field i]} {
			set session_(session_info2) [$message field_value i]
		}

		delete $message
	} else {
		set session_(session_info1) ""
		set session_(session_info2) ""
	}
	delete $p

	$self notify_observers update_title $session_(session_info1) \
			$session_(session_info2) 0

	set desc [$ctg get_desc]
	if {$desc==""} {
		error "Catalog file is missing server contact info"
	}
	set desclines [split $desc "\n"]

	if { $session_(server_name) == "" } {
		set server_name [lindex [split [lindex $desclines 1]] 1]
		regsub -all ":" $server_name "/" session_(server_name)
	}

	set s [split $session_(server_name) /]
	set addr [lindex $s 0]
	if ![regexp {^[0-9.]+$} $addr] {
		# this looks like a hostname
		set addr [gethostbyname $addr]
	}
	if { [in_multicast $addr] } {
		set session_(ssg_port) -
	} else {
		# this is unicast; append port numbers
		set port [lindex $s 1]
		if { $port == {} } { set port [$self get_option megaforPort] }
		set session_(server_name) "$addr/$port:$session_(ssg_port)/1"
	}

	set session_(session_name) [lindex [split [lindex $desclines 0]] 1]


	# ok now get the broadcast addresses for each media type and
	# put them into the table
	foreach desc $desclines {
	    if {[lindex $desc 0] != "inetBroadcastAddr:"} {
		continue
	    }

	    set info [split [lindex $desc 1] :]
	    set broadcast_([lindex $info 0]) [lindex $info 1]
	}

	foreach id [$ctg info streams] {
		lappend sessions([$ctg info session $id]) $id

	}
	set sesslist_ [array names sessions]

	foreach sess $sesslist_ {
		# FIXME hack
		set session_($sess,Media) [string trimright $sess "0123456789"]
#		puts "********* $sess  $session_($sess,Media) **********"
		set media($session_($sess,Media)) 1
	}

	delete $ctg

	# FIXME: assumes there is only one session of each mediatype
	# Yatin: I'm not sure if collaborator can handle multiple sessions
	# of the same media type. don't want to add the code to enable
	# that and test it right now
	return [array names media]
}


SSAC_Client public server_name { } {
	$self instvar session_
	return $session_(server_name)
}



SSAC_Client private play { offset } {
	$self instvar session_
	if { $session_(state) != "PLAY" } {
		set session_(state) PLAY
		$self notify_observers play_update "PAUSE"
		$self send PLAY $offset
	}
}


SSAC_Client private pause { } {
	$self instvar session_
	if { $session_(state) != "PAUSE" } {
		set session_(state) PAUSE
		$self notify_observers play_update "PLAY"
		$self send PAUSE
	}
}


# Called when the data addresses change, for example when the MARS
# server crashes and restarts.  Since mediaboard is currently started as
# an outside app, we'd have to just start a new one.
SSAC_Client private reset_tools {} {
	$self instvar session_ sesslist_ rtsp_

	foreach sess $sesslist_ {
		switch -- $session_($sess,Media) {
			video {

			    $rtsp_(application) reset_vic $session_($sess,Address)

	}
			audio {
				$rtsp_(application) reset_vat $session_($sess,Address)
			}
			mediaboard {
				puts "Not resetting Mediaboard**"
			}

		}
	}
}




SSAC_Client private start_tools {} {
	$self instvar session_ sesslist_ rtsp_
	foreach sess $sesslist_ {
		switch -- $session_($sess,Media) {
			video {
			#puts "Starting VIC..."
				$rtsp_(application) start_vic $session_($sess,Address)

			}
			audio {
				#puts "Starting VAT..."

				$rtsp_(application) start_vat $session_($sess,Address)
			}
			mediaboard {
			    global env
			    set mpid_ [eval exec mb -sa $session_($sess,Address) &]
			}

		}
	}
}

# Start the tools standalone
SSAC_Client private start_tools2 {} {
	$self instvar session_ sesslist_ rtsp_

	foreach sess $sesslist_ {
		switch -- $session_($sess,Media) {
			video {
				puts "Starting VIC $session_($sess,Address)"
				#$rtsp_(application) start_vic $session_($sess,Address)

				set vpid_ [eval exec vic -X loopback=1 $session_($sess,Address) &]

			}
			audio {
				puts "Starting VAT $session_($sess,Address)"
				#$rtsp_(application) start_vat $session_($sess,Address)
				set apid_ [eval exec vat -X loopback=1 $session_($sess,Address) &]

			}

			mediaboard {
				puts "Starting MB $session_($sess,Address)"
				set mpid_ [eval exec mb -sa $session_($sess,Address) &]
			}

		}
	}
}
