# coordbus.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/net/coordbus.tcl,v 1.7 2002/02/03 04:28:05 lim Exp $


# -- for otcldoc
#Class CoordinationBus

#FIXME
CoordinationBus set protocolId_ ""


CoordinationBus proc.invoke { } {
	$self set protocolId_ cbus/1.0
	if { [info commands mtrace]=="" } {
		proc ::mtrace { args } { }
	}
}


#
# Create a new CoordinationBus channel and open the appropriate multicast
# sockets.
# <pre>
#      new CoordinationBus ?-channel &lt;channel-number&gt;?<BR>
#                          ?-mediatype &lt;mediatype&gt;?<BR>
#                          ?-moduletype &lt;mediatype&gt;?<BR>
#                          ?-appname &lt;appname&gt;?<BR>
#                          ?-appinstance &lt;appinstance&gt;?<BR>
#                          ?-srcid &lt;mediatype&gt;/&lt;mediatype&gt;/&lt;appname&gt;/&lt;appinstance&gt;?<BR>
#                          ?-mode readwrite|readonly|writeonly?<BR>
#                          ?-ttl &lt;ttl&gt;?<BR>
# </pre>
# &lt;channel&gt; defaults to 0. &lt;srcid&gt; may contain wildcards and
# it defaults to "*/*/*/&lt;ip-addr*gt;:&lt;pid&gt;.
#
CoordinationBus public init { args } {
	eval [list $self] next
	$self set seqno_ 0

	# now check if all of the individual variables have been defined or
	# not; if not, use some default values

	$self instvar ttl_ srcid_ mediatype_ moduletype_ appname_ appinstance_\
			channel_ mode_

	foreach {key value} $args {
		if { [string index $key 0] != "-" } {
			error "invalid argument '$key'"
		}
		$self set [string range $key 1 end]_ $value
	}

	if { ![info exists ttl_]        } { set ttl_ 0 }
	if { ![info exists mediatype_]  } { set mediatype_ "*" }
	if { ![info exists moduletype_] } { set moduletype_ "*" }
	if { ![info exists appname_]    } { set appname_ "*" }
	if { ![info exists appinstance_]} { set appinstance_ [localaddr]:[pid]}
	if { ![info exists channel_]    } { set channel_ 0 }
	if { ![info exists mode_]       } { set mode_ "readwrite" }
	if { ![info exists srcid_] } {
		set srcid_ "$mediatype_/$moduletype_/$appname_/$appinstance_"
	} else {
		set tmp [split $srcid_ /]
		if { [llength $tmp] != 4 } {
			error "invalid srcid '$srcid_'"
		}
	}

	$self open $channel_ $ttl_ $mode_
}


#
# Deallocate all the resources associated with
# the CoordinationBus object. Close all associated sockets.
#
CoordinationBus public destroy { } {
	$self close
	$self next
}


#
# Register an event to listen for on the coordination bus.
# &lt;method&gt; can either be the name of a method defined
# on the coordination bus object, or it may be of the form
# "&lt;object&gt; &lt;method&gt;". When &lt;event&gt; is heard
# on the coordination bus, the associated &lt;method&gt; is
# invoked. &lt;method&gt; may accept arguments, in which case
# the corrsponding arguments that are received as part of the
# event are passed on to &lt;method&gt;
# <p>
# The first argument to &lt;method&gt; is always a list describing
# the event: key-vaue pairs -- srcid (the source id),
# destid (the destination id), event (the actual event),
# cb (the coordination bus object)
#
CoordinationBus public register { event method } {
	$self instvar dispatch_
	if { [llength $method] > 1 } {
		set dispatch_($event,object) [lindex $method 0]
		set dispatch_($event,method) [lindex $method 1]
	} else {
		set dispatch_($event,object) $self
		set dispatch_($event,method) [lindex $method 0]
	}

	set dispatch_($event,argcnt) [$self get_argcnt \
			$dispatch_($event,object) $dispatch_($event,method)]
	if { $dispatch_($event,argcnt) < 0 } {
		set object $dispatch_($event,object)
		unset dispatch_($event,object)
		unset dispatch_($event,method)
		unset dispatch_($event,argcnt)
		error "trying to register undefined method '$method' on object\
				$object"
	}
}


#
# Unregister a previously registered event
#
CoordinationBus public unregister { event } {
	$self instvar dispatch_
	if [info exists dispatch_($event,object)] {
		unset dispatch_($event,object)
		unset dispatch_($event,method)
		unset dispatch_($event,argcnt)
	}
}


#
# Send an event on the coordination bus
# <pre>
#       $cb send ?-dstid &lt;mediatype&gt;/&lt;mediatype&gt;/&lt;appname&gt;/&lt;appinstance&gt;? &lt;event&gt; ?args ...?
# </pre>
# -dstid identifies a specific target or a group of targets. Any of the
# individual elements of -dstid may be substituted by a * wildcard.
#
CoordinationBus public send { args } {
	if { [string compare [lindex $args 0] "-dstid"] == 0 } {
		set dst [lindex $args 1]
		set tmp [split $dst /]
		if { [llength $tmp] != 4 } {
			error "Invalid destination: must be of the form\
					<media-type>/<module-type>/<app-name>/<app-instance>"
		}

		set args [lrange $args 2 end]
	} else {
		set dst "*/*/*/*"
	}

	$self instvar seqno_ srcid_

	if { [llength $args]==0 } {
		error "Must specify event type: \$cb send\
				[-dstid <destination>] $event_type [args...]"
	}

	#
	# packet header consists of
	#    ProtocolID (cbus/1.0)
	#    SeqNo
	#    MessageType (R=reliable U=unreliable)
	#    SrcAddr
	#    DstAddr
	#    AckList (for now, empty)
	#
	set headers [list [CoordinationBus set protocolId_] $seqno_ \
			"U" $srcid_ $dst ""]
	$self transmit [concat $headers $args]
}


CoordinationBus private match_wildcards { d s } {
	if { [string compare $d $s]==0 || $d=="*" || $s=="*" } {
		return 1
	} else {
		return 0
	}
}


CoordinationBus private filter { destid } {
	$self instvar srcid_

	set s [split $srcid_ /]
	set d [split $destid /]

	if { [$self match_wildcards [lindex $d 0] [lindex $s 0]] && \
			[$self match_wildcards [lindex $d 1] [lindex $s 1]] &&\
			[$self match_wildcards [lindex $d 2] [lindex $s 2]] &&\
			[$self match_wildcards [lindex $d 3] [lindex $s 3]] } {
		return 1
	} else {
		return 0
	}
}


CoordinationBus private dispatch { packet } {
	set packet [split $packet]

	# ensure that you at least have the header + event type
	if { [llength $packet] < 7 } {
		# ignore this packet
		mtrace trcCB "CB: Invalid packet: only [llength $packet]\
				elements"
		return
	}

	set protocolId [lindex $packet 0]
	set seqNo [lindex $packet 1]
	set messageType [lindex $packet 2]
	set srcId [lindex $packet 3]
	set destId [lindex $packet 4]
	set ackList [lindex $packet 5]

	set event [lindex $packet 6]
	set args [lrange $packet 7 end]

	if { $protocolId != [CoordinationBus set protocolId_] } {
		mtrace trcCB "CB: Invalid protocol id '$protocolId': must be\
				[CoordinationBus set protocolId_]"
		return
	}

	# first check if it is our packet
	$self instvar srcid_
	if { [string compare $srcId $srcid_]==0 } {
		# filter out our own packets
		return
	}

	# now check if the packet is destined for us
	if { ![$self filter $destId] } {
		# this packet was not meant for us
		mtrace trcCB|trcVerbose "CB: filtering out packet meant for\
				'$destId'"
		return
	}

	# the packet seems sane. try to dispatch it
	$self instvar dispatch_
	if { ![info exists dispatch_($event,object)] } {
		mtrace trcCB|trcVerbose "CB: unknown event '$event'"
		return
	}

	if { [expr [llength $args] + 1] != $dispatch_($event,argcnt) } {
		mtrace trcCB "CB: argument mismatch: expected\
				$dispatch_($event,argcnt) arguments,\
				got [llength $args]"
		return
	}

	#
	# FIXME SECURITY ALERT: bracketed commands from external agents
	# can be executed here as a side-effect of this eval.
	# FIX THIS.
	#

	set info [list cb $self srcid $srcId dstid $destId event $event]
	eval [list $dispatch_($event,object)] \
			[list $dispatch_($event,method)] [list $info] $args
}


CoordinationBus private get_argcnt { object method } {
	if { [$object info procs $method] != "" } {
		return [llength [$object info args $method]]
	}

	set cls [$object info class]
	if { [$cls info instprocs $method] != "" } {
		return [llength [$cls info instargs $method]]
	}

	foreach c [$cls info heritage] {
		if { [$c info instprocs $method] != "" } {
			return [llength [$c info instargs $method]]
		}
	}

	return -1
}

